"""
DEMVis - Digital Elevation Model's Visualization (Build 2009-12-07)

The DEMVis (Digital Elevation Model's Visualization is a open source software to
visualization of USGS DEM files.

Created in December 2009 by Rodrigo Mologni G dos Santos
<mologni@dca.fee.unicamp.br> and Wagner Machado do Amaral
<machado@dca.fee.unicamp.br>.
"""

import sys

from PyQt4 import QtCore, QtGui
from QVTKWidget import QVTKWidget

class MainWindow(QtGui.QMainWindow):

    def __init__(self):
        QtGui.QMainWindow.__init__(self)

        self.widget = QVTKWidget(self)

        self.createActions()
        self.createMenus()
        self.createToolBars()
        self.createStatusBar()

        self.setWindowTitle(
            "DEMVis - Digital Elevation Model's Visualization " \
            "(Build 2009-12-07)")
        self.resize(800, 600)

    # Open File

    def openFile(self):
        fileName = QtGui.QFileDialog.getOpenFileName(self, "Open", "",
            "Digital Elevation Model Files (*.dem)")

        if not fileName.isEmpty():
            self.widget.setFileName(fileName)
    
            self.minimumAct.setChecked(True)
            self.landAct.setChecked(True)
            self.colorBandAct.setChecked(False)
            self.contourAct.setChecked(False)
            self.heightPlotAct.setChecked(False)
            self.clipAct.setChecked(False)
            self.anaglyphAct.setChecked(False)
                
            self.saveAct.setEnabled(True)
            self.editMenu.setEnabled(True)
            self.viewMenu.setEnabled(True)
            self.viewToolBar.setEnabled(True)
            self.cameraToolBar.setEnabled(True)
            
            self.setWindowTitle(self.tr("%1 - %2").arg(
                QtCore.QFileInfo(fileName).fileName()).arg(
                    "DEMVis (Build 2009-12-07)"))
            self.statusBar().showMessage("File loaded")

    # Save Screenshot

    def saveImage(self):
        fileName = QtGui.QFileDialog.getSaveFileName(
            self, "Save", "", "PNG Image Format (*.png)")
        
        if not fileName.isEmpty():
            self.widget.captureWindow(fileName)

    # Resampling
    
    def minimum(self): self.widget.setShrinkFactorsToMaximum()
    def medium(self) : self.widget.setShrinkFactorsToMedium()
    def maximum(self): self.widget.setShrinkFactorsToMinimum()

    # Camera

    def reset(self) : self.widget.setCameraPositionToOrigin()
    def xPlus(self) : self.widget.setCameraPositionToXPlus()
    def xMinus(self): self.widget.setCameraPositionToXMinus()
    def yPlus(self) : self.widget.setCameraPositionToYPlus()
    def yMinus(self): self.widget.setCameraPositionToYMinus()
    def zPlus(self) : self.widget.setCameraPositionToZPlus()
    def zMinus(self): self.widget.setCameraPositionToZMinus()

    # Colormap

    def luminance(self):
        self.colorBandAct.setEnabled(True)
        self.colorLegendAct.setEnabled(True)
        self.widget.setLookupTableToLuminance()

    def rainbow(self):
        self.colorBandAct.setEnabled(True)
        self.colorLegendAct.setEnabled(True)
        self.widget.setLookupTableToRainbow()
        
    def water(self):
        self.colorBandAct.setEnabled(True)
        self.colorLegendAct.setEnabled(True)
        self.widget.setLookupTableToWater()
    
    def land(self):
        self.colorBandAct.setEnabled(True)
        self.colorLegendAct.setEnabled(True)
        self.widget.setLookupTableToLand()
        
    def reality(self):
        self.colorBandAct.setEnabled(True)
        self.colorLegendAct.setEnabled(True)
        self.widget.setLookupTableToReality()

    # Texture

    def glacier(self):
        self.colorBandAct.setChecked(False)
        self.colorBandAct.setEnabled(False)
        self.widget.setColorBandToInvisible()
        
        self.colorLegendAct.setChecked(False)
        self.colorLegendAct.setEnabled(False)
        self.widget.setColorLegendToInvisible()
        
        self.clipAct.setChecked(False)
        self.clipAct.setEnabled(False)
        self.widget.setClipToInsivible()
        
        self.widget.setTextureToGlacier()

    def desert(self):
        self.colorBandAct.setChecked(False)
        self.colorBandAct.setEnabled(False)
        self.widget.setColorBandToInvisible()
        
        self.colorLegendAct.setChecked(False)
        self.colorLegendAct.setEnabled(False)
        self.widget.setColorLegendToInvisible()
        
        self.clipAct.setChecked(False)
        self.clipAct.setEnabled(False)
        self.widget.setClipToInsivible()
        
        self.widget.setTextureToDesert()
    
    def jungle(self):
        self.colorBandAct.setChecked(False)
        self.colorBandAct.setEnabled(False)
        self.widget.setColorBandToInvisible()
        
        self.colorLegendAct.setChecked(False)
        self.colorLegendAct.setEnabled(False)
        self.widget.setColorLegendToInvisible()
        
        self.clipAct.setChecked(False)
        self.clipAct.setEnabled(False)
        self.widget.setClipToInsivible()
        
        self.widget.setTextureToJungle()
        
    def concrete(self):
        self.colorBandAct.setChecked(False)
        self.colorBandAct.setEnabled(False)
        self.widget.setColorBandToInvisible()
        
        self.colorLegendAct.setChecked(False)
        self.colorLegendAct.setEnabled(False)
        self.widget.setColorLegendToInvisible()
        
        self.clipAct.setChecked(False)
        self.clipAct.setEnabled(False)
        self.widget.setClipToInsivible()
        
        self.widget.setTextureToConcrete()

    # Color Band

    def colorBand(self):
        if self.colorBandAct.isChecked() == True:
            self.clipAct.setEnabled(True)
            self.widget.setColorBandToVisible()
        else:
            self.clipAct.setChecked(False)
            self.clipAct.setEnabled(False)
            self.widget.setClipToInsivible()
            self.widget.setColorBandToInvisible()
    
    # Contour

    def contour(self):
        if self.contourAct.isChecked() == True:
            self.widget.setContourToVisible()
        else:
            self.widget.setContourToInvisible()
    
    # Height Plot

    def heightPlot(self):
        if self.heightPlotAct.isChecked() == True:
            self.widget.setWarpScalarNormalTo3D()
        else:
            self.widget.setWarpScalarNormalTo2D()
    
    # Color Legend

    def colorLegend(self):
        if self.colorLegendAct.isChecked() == True:
            self.widget.setColorLegendToVisible()
        else:
            self.widget.setColorLegendToInvisible()

    # Clip

    def clip(self):
        if self.clipAct.isChecked() == True:
            self.widget.setClipToVisible()
        else:
            self.widget.setClipToInsivible()
    
    # Anglyph Stereo View
    
    def anaglyph(self):
        if self.anaglyphAct.isChecked() == True:
            self.widget.setStereoTypeToAnaglyph()
        else:
            self.widget.setStereoTypeToCrystalEyes()

    # About DEMVis

    def about(self):
        QtGui.QMessageBox.about(self, "About",
            "<html><body><p><center><img src='../images/demvis.png' /></cente" \
            "r></p><p><h3>About DEMVis</h3></p><p>Build 2009-12-07</p><p>The " \
            "DEMVis (Digital Elevation Model's Visualization) is a open sourc" \
            "e software to visualization of USGS DEM files.</p><p>Created in " \
            "December 2009 by <a href='mailto:mologni@dca.fee.unicamp.br'>Rod" \
            "rigo Mologni G dos Santos</a> e <a href='mailto:machado@dca.fee." \
            "unicamp.br'>Wagner Machado do Amaral</a>.</p></body></html>")
    
    # About VTK
    
    def aboutVtk(self):
        QtGui.QMessageBox.about(self, "About VTK",
            "<html><body><p><center><img src='../images/vtk.png' /></center><" \
            "/p><p><h3>About VTK</h3></p><p>This program uses VTK version 5.4" \
            ".2.</p><p>The Visualization Toolkit (VTK) is an open-source, C++" \
            " toolkit used around the world in academic, research, and commer" \
            "cial applications. VTK has been used for medical imaging; to vis" \
            "ualize the results of computer simulations such as fluid flow, c" \
            "limate modeling, and stress analysis; to view terrain and geophy" \
            "sical structures; to volume render confocal, MRI, CT, and Ultras" \
            "ound datasets; and to create, edit and view models using advance" \
            "d techniques from 3D graphics. VTK supports a variety of common " \
            "data types and hundreds of algorithms. VTK's open-source code en" \
            "ables you to learn about visualization technology and to easily " \
            "extend it for your own applications.</p><p>VTK is a Kitware Inc." \
            " product. See <a href='http://www.vtk.org/'>www.vtk.org</a> for " \
            "more information.</p></body></html>")

    # About Python

    def aboutPython(self):
        QtGui.QMessageBox.about(self, "About Python",
            "<html><body><p><center><img src='../images/python.png' /></cente" \
            "r></p><p><h3>About Python</h3></p><p>This program uses Python ve" \
            "rsion 2.5.4.</p><p>Python is a remarkably powerful dynamic progr" \
            "amming language that is used in a wide variety of application do" \
            "mains. Python is often compared to Tcl, Perl, Ruby, Scheme or Ja" \
            "va. Some of its key distinguishing features include: very clear," \
            " readable syntax; strong introspection capabilities; intuitive o" \
            "bject orientation; natural expression of procedural code; full m" \
            "odularity, supporting hierarchical packages; exception-based err" \
            "or handling; very high level dynamic data types; extensive stand" \
            "ard libraries and third party modules for virtually every task; " \
            "extensions and modules easily written in C, C++ (or Java for Jyt" \
            "hon, or .NET languages for IronPython); and embeddable within ap" \
            "plications as a scripting interface.</p><p>Python is a Python So" \
            "ftware Foundation product. See <a href='http://www.python.org/'>" \
            "www.python.org</a> for more information.</p></body></html>")

    # Create Actions

    def createActions(self):
        # File Menu
        
        self.openAct = QtGui.QAction(
            QtGui.QIcon("../images/icons/open.png"), "&Open...", self)
        self.openAct.setShortcut("Ctrl+O")
        self.openAct.setStatusTip("Open a DEM file")
        self.connect(self.openAct, QtCore.SIGNAL("triggered()"), self.openFile)
        
        self.saveAct = QtGui.QAction(
            QtGui.QIcon("../images/icons/save.png"), "&Save Screenshot", self)
        self.saveAct.setEnabled(False)
        self.saveAct.setStatusTip("Save capture window")
        self.connect(self.saveAct, QtCore.SIGNAL("triggered()"), self.saveImage)
        
        self.quitAct = QtGui.QAction("&Quit", self)
        self.quitAct.setShortcut("Ctrl+Q")
        self.quitAct.setStatusTip("Quit the DEMVis")
        self.connect(
            self.quitAct, QtCore.SIGNAL("triggered()"), self,
            QtCore.SLOT("close()"))
        
        # Edit Menu

        self.minimumAct = QtGui.QAction("Minimum", self)
        self.minimumAct.setCheckable(True)
        self.minimumAct.setStatusTip("Apply minimum resampling")
        self.connect(
            self.minimumAct, QtCore.SIGNAL("triggered()"), self.minimum)
        
        self.mediumAct = QtGui.QAction("Medium", self)
        self.mediumAct.setCheckable(True)
        self.mediumAct.setStatusTip("Apply medium resampling")
        self.connect(
            self.mediumAct, QtCore.SIGNAL("triggered()"), self.medium)
        
        self.maximumAct = QtGui.QAction("Maximum", self)
        self.maximumAct.setCheckable(True)
        self.maximumAct.setStatusTip("Apply maximum resampling")
        self.connect(
            self.maximumAct, QtCore.SIGNAL("triggered()"), self.maximum)
        
        self.resamplingGroup = QtGui.QActionGroup(self)
        self.resamplingGroup.addAction(self.minimumAct)
        self.resamplingGroup.addAction(self.mediumAct)
        self.resamplingGroup.addAction(self.maximumAct)
        self.minimumAct.setChecked(True)

        # View Menu
        
        self.xPlusAct = QtGui.QAction(
            QtGui.QIcon("../images/icons/xplus.png"), "+X", self)
        self.xPlusAct.setStatusTip("Set view direction to +X")
        self.connect(self.xPlusAct, QtCore.SIGNAL("triggered()"), self.xPlus)
        
        self.xMinusAct = QtGui.QAction(
            QtGui.QIcon("../images/icons/xminus.png"), "-X", self)
        self.xMinusAct.setStatusTip("Set view direction to -X")
        self.connect(self.xMinusAct, QtCore.SIGNAL("triggered()"), self.xMinus)
        
        self.yPlusAct = QtGui.QAction(
            QtGui.QIcon("../images/icons/yplus.png"), "+Y", self)
        self.yPlusAct.setStatusTip("Set view direction to +Y")
        self.connect(self.yPlusAct, QtCore.SIGNAL("triggered()"), self.yPlus)
        
        self.yMinusAct = QtGui.QAction(
            QtGui.QIcon("../images/icons/yminus.png"), "-Y", self)
        self.yMinusAct.setStatusTip("Set view direction to -Y")
        self.connect(self.yMinusAct, QtCore.SIGNAL("triggered()"), self.yMinus)

        self.zPlusAct = QtGui.QAction(
            QtGui.QIcon("../images/icons/zplus.png"), "+Z", self)
        self.zPlusAct.setStatusTip("Set view direction to +Z")
        self.connect(self.zPlusAct, QtCore.SIGNAL("triggered()"), self.zPlus)
        
        self.zMinusAct = QtGui.QAction(
            QtGui.QIcon("../images/icons/zminus.png"), "-Z", self)
        self.zMinusAct.setStatusTip("Set view direction to -Z")
        self.connect(self.zMinusAct, QtCore.SIGNAL("triggered()"), self.zMinus)

        self.luminanceAct = QtGui.QAction("Luminance", self)
        self.luminanceAct.setCheckable(True)
        self.luminanceAct.setStatusTip("View luminance colormap")
        self.connect(
            self.luminanceAct, QtCore.SIGNAL("triggered()"), self.luminance)
        
        self.rainbowAct = QtGui.QAction("Rainbow", self)
        self.rainbowAct.setCheckable(True)
        self.rainbowAct.setStatusTip("View rainbow colormap")
        self.connect(
            self.rainbowAct, QtCore.SIGNAL("triggered()"), self.rainbow)
        
        self.waterAct = QtGui.QAction("Water", self)
        self.waterAct.setCheckable(True)
        self.waterAct.setStatusTip("View water colormap")
        self.connect(self.waterAct, QtCore.SIGNAL("triggered()"), self.water)
        
        self.landAct = QtGui.QAction("Land", self)
        self.landAct.setCheckable(True)
        self.landAct.setStatusTip("View land colormap")
        self.connect(self.landAct, QtCore.SIGNAL("triggered()"), self.land)
        
        self.realityAct = QtGui.QAction("Reality", self)
        self.realityAct.setCheckable(True)
        self.realityAct.setStatusTip("View reality colormap")
        self.connect(
            self.realityAct, QtCore.SIGNAL("triggered()"), self.reality)

        self.glacierAct = QtGui.QAction("Glacier", self)
        self.glacierAct.setCheckable(True)
        self.glacierAct.setStatusTip("View glacier texture")
        self.connect(
            self.glacierAct, QtCore.SIGNAL("triggered()"), self.glacier)
        
        self.desertAct = QtGui.QAction("Desert", self)
        self.desertAct.setCheckable(True)
        self.desertAct.setStatusTip("View desert texture")
        self.connect(self.desertAct, QtCore.SIGNAL("triggered()"), self.desert)
        
        self.jungleAct = QtGui.QAction("Jungle", self)
        self.jungleAct.setCheckable(True)
        self.jungleAct.setStatusTip("View jungle texture")
        self.connect(self.jungleAct, QtCore.SIGNAL("triggered()"), self.jungle)

        self.concreteAct = QtGui.QAction("Concrete", self)
        self.concreteAct.setCheckable(True)
        self.concreteAct.setStatusTip("View concrete texture")
        self.connect(
            self.concreteAct, QtCore.SIGNAL("triggered()"), self.concrete)

        self.colormapAndTextureGroup = QtGui.QActionGroup(self)
        self.colormapAndTextureGroup.addAction(self.luminanceAct)
        self.colormapAndTextureGroup.addAction(self.rainbowAct)
        self.colormapAndTextureGroup.addAction(self.waterAct)
        self.colormapAndTextureGroup.addAction(self.landAct)
        self.colormapAndTextureGroup.addAction(self.realityAct)
        self.colormapAndTextureGroup.addAction(self.glacierAct)
        self.colormapAndTextureGroup.addAction(self.desertAct)
        self.colormapAndTextureGroup.addAction(self.jungleAct)
        self.colormapAndTextureGroup.addAction(self.concreteAct)
        self.landAct.setChecked(True)

        self.colorBandAct = QtGui.QAction(
            QtGui.QIcon("../images/icons/colorband.png"), "Color Band", self)
        self.colorBandAct.setCheckable(True)
        self.colorBandAct.setStatusTip("Enable/disable color band")
        self.connect(
            self.colorBandAct, QtCore.SIGNAL("triggered()"), self.colorBand)

        self.contourAct = QtGui.QAction(
            QtGui.QIcon("../images/icons/contour.png"), "Countour", self)
        self.contourAct.setCheckable(True)
        self.contourAct.setStatusTip("Enable/disable countour")
        self.connect(
            self.contourAct, QtCore.SIGNAL("triggered()"), self.contour)
        
        self.heightPlotAct = QtGui.QAction(
            QtGui.QIcon("../images/icons/heightplot.png"), "Height Plot", self)
        self.heightPlotAct.setCheckable(True)
        self.heightPlotAct.setStatusTip("Enable/disable height plot")
        self.connect(
            self.heightPlotAct, QtCore.SIGNAL("triggered()"), self.heightPlot)
        
        self.colorLegendAct = QtGui.QAction(
            QtGui.QIcon("../images/icons/legend.png"), "Color Legend", self)
        self.colorLegendAct.setCheckable(True)
        self.colorLegendAct.setStatusTip("Enable/disable color legend")
        self.connect(
            self.colorLegendAct, QtCore.SIGNAL("triggered()"), self.colorLegend)

        self.clipAct = QtGui.QAction(
            QtGui.QIcon("../images/icons/clip.png"), "Clip", self)
        self.clipAct.setCheckable(True)
        self.clipAct.setStatusTip("Enable/disable clip")
        self.clipAct.setEnabled(False)
        self.connect(self.clipAct, QtCore.SIGNAL("triggered()"), self.clip)
        
        self.anaglyphAct = QtGui.QAction(
            QtGui.QIcon("../images/icons/anaglyph.png"),
            "Anaglyph Stereo", self)
        self.anaglyphAct.setCheckable(True)
        self.anaglyphAct.setStatusTip("Enable/disable anaglyph stereo")
        self.connect(
            self.anaglyphAct, QtCore.SIGNAL("triggered()"), self.anaglyph) 

        # Help Menu

        self.aboutAct = QtGui.QAction("&About", self)
        self.aboutAct.setStatusTip("Show the DEMVis's about box")
        self.connect(self.aboutAct, QtCore.SIGNAL("triggered()"), self.about)
        
        self.aboutVtkAct = QtGui.QAction("About &VTK", self)
        self.aboutVtkAct.setStatusTip("Show the VTK library's about box")
        self.connect(
            self.aboutVtkAct, QtCore.SIGNAL("triggered()"), self.aboutVtk)
        
        self.aboutQtAct = QtGui.QAction("About &Qt", self)
        self.aboutQtAct.setStatusTip("Show the Qt library's about box")
        self.connect(
            self.aboutQtAct, QtCore.SIGNAL("triggered()"), QtGui.qApp,
            QtCore.SLOT("aboutQt()"))
        
        self.aboutPythonAct = QtGui.QAction("About &Python", self)
        self.aboutPythonAct.setStatusTip(
            "Show the Python programming language's about box")
        self.connect(
            self.aboutPythonAct, QtCore.SIGNAL("triggered()"), self.aboutPython)
    
    # Create Menus
    
    def createMenus(self):
        # File Menu
        
        self.fileMenu = self.menuBar().addMenu("&File")
        self.fileMenu.addAction(self.openAct)
        self.fileMenu.addSeparator()
        self.fileMenu.addAction(self.saveAct)
        self.fileMenu.addSeparator()
        self.fileMenu.addAction(self.quitAct)
        
        # Edit Menu

        self.editMenu = self.menuBar().addMenu("&Edit")
        self.resamplingMenu = self.editMenu.addMenu("&Resampling")
        self.resamplingMenu.addAction(self.minimumAct)
        self.resamplingMenu.addAction(self.mediumAct)
        self.resamplingMenu.addAction(self.maximumAct)
        self.editMenu.setEnabled(False)

        # View Menu

        self.viewMenu = self.menuBar().addMenu("&View")
        self.cameraMenu = self.viewMenu.addMenu("&Camera")
        self.cameraMenu.addAction(self.xPlusAct)
        self.cameraMenu.addAction(self.xMinusAct)
        self.cameraMenu.addAction(self.yPlusAct)
        self.cameraMenu.addAction(self.yMinusAct)
        self.cameraMenu.addAction(self.zPlusAct)
        self.cameraMenu.addAction(self.zMinusAct)
        self.viewMenu.addSeparator()
        self.colormapMenu = self.viewMenu.addMenu("&Colormap")
        self.colormapMenu.addAction(self.luminanceAct)
        self.colormapMenu.addAction(self.rainbowAct)
        self.colormapMenu.addAction(self.waterAct)
        self.colormapMenu.addAction(self.landAct)
        self.colormapMenu.addAction(self.realityAct)
        self.textureMenu = self.viewMenu.addMenu("&Texture")
        self.textureMenu.addAction(self.glacierAct)
        self.textureMenu.addAction(self.desertAct)
        self.textureMenu.addAction(self.jungleAct)
        self.textureMenu.addAction(self.concreteAct)
        self.viewMenu.addSeparator()
        self.viewMenu.addAction(self.colorBandAct)
        self.viewMenu.addAction(self.contourAct)
        self.viewMenu.addAction(self.heightPlotAct)
        self.viewMenu.addAction(self.colorLegendAct)
        self.viewMenu.addAction(self.clipAct)
        self.viewMenu.addAction(self.anaglyphAct)
        self.viewMenu.addSeparator()
        self.viewMenu.setEnabled(False)

        # Help menu

        self.helpMenu = self.menuBar().addMenu("&Help")
        self.helpMenu.addAction(self.aboutAct)
        self.helpMenu.addSeparator()
        self.helpMenu.addAction(self.aboutVtkAct)
        self.helpMenu.addAction(self.aboutQtAct)
        self.helpMenu.addAction(self.aboutPythonAct)

    # Create Tool Bars

    def createToolBars(self):
        self.fileToolBar = self.addToolBar("File")
        self.fileToolBar.addAction(self.openAct)
        self.fileToolBar.addAction(self.saveAct)

        self.viewToolBar = self.addToolBar("View")
        self.viewToolBar.addAction(self.colorBandAct)
        self.viewToolBar.addAction(self.contourAct)
        self.viewToolBar.addAction(self.heightPlotAct)
        self.viewToolBar.addAction(self.colorLegendAct)
        self.viewToolBar.addAction(self.clipAct)
        self.viewToolBar.addAction(self.anaglyphAct)
        self.viewToolBar.setEnabled(False)
        
        self.cameraToolBar = self.addToolBar("Camera")
        self.cameraToolBar.addAction(self.xPlusAct)
        self.cameraToolBar.addAction(self.xMinusAct)
        self.cameraToolBar.addAction(self.yPlusAct)
        self.cameraToolBar.addAction(self.yMinusAct)
        self.cameraToolBar.addAction(self.zPlusAct)
        self.cameraToolBar.addAction(self.zMinusAct)
        self.cameraToolBar.setEnabled(False)

    # Create Status Bar

    def createStatusBar(self):
        self.statusBar()

# Main Menu

if __name__ == "__main__":
    app = QtGui.QApplication(sys.argv)
    win = MainWindow()
    win.show()
    sys.exit(app.exec_())
