unit cilindro;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OpenGL;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    { Private declarations }
    GLContext : HGLRC;
    glDC: HDC;
    errorcode: GLenum;
    openGLReady: boolean;
  public
    { Public declarations }
  end;
type
     HGLRC = THandle;

var
  Form1: TForm1;
  render: integer;
implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
var
   pfd: TPixelFormatDescriptor;
   FormatIndex: integer;
begin
   fillchar(pfd,SizeOf(pfd),0);
   with pfd do
   begin
     nSize      := SizeOf(pfd);
     nVersion   := 1; {The current version of the desccriptor is 1}
     dwFlags    := PFD_DRAW_TO_WINDOW or PFD_SUPPORT_OPENGL;
     iPixelType := PFD_TYPE_RGBA;
     cColorBits := 24; {support 24-bit color}
     cDepthBits := 32; {depth of z-axis}
     iLayerType := PFD_MAIN_PLANE;
   end; {with}
   glDC:=getDC(handle);
   FormatIndex := ChoosePixelFormat(Canvas.Handle,@pfd);
   SetPixelFormat(Canvas.Handle,FormatIndex,@pfd);
   if FormatIndex=0 then
      raise Exception.Create('ChoosePixelFormat failed '+
          IntToStr(GetLastError));

   if not SetPixelFormat(glDC,FormatIndex,@pfd)   then
       raise Exception.Create('SetPixelFormat failed '+
          IntToStr(GetLastError));
   GLContext:=wglCreateContext(Canvas.Handle);
   if  GLContext=0 then
       raise  Exception.Create('wglCreateContext failed '+ IntToStr(GetLastError));

   if not wglMakeCurrent(glDC,GLContext) then
      raise  Exception.Create('wglMakeCurrent failed '+
         IntToStr(GetLastError));
   OpenGLReady := true;
{--------------------}
glortho(0,200,-200,0,-7000,7000);
glrotate(10,1,0,0);
{--------------------}

end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
   wglMakeCurrent(Canvas.Handle,0);
   wglDeleteContext(GLContext);
end;

procedure logo_abas_frente(h:integer;render:integer);
begin
// primeira aba da esquerda para a direita
        glbegin(render);
        glvertex3f(23,-95,0);
        glvertex3f(67,-95,0);
        glvertex3f(68,-99,0);
        glvertex3f(33,-114,0);
        glvertex3f(27,-106,0);
        glend;
               //tampo dos lados
                glbegin(render);
                glvertex3f(67,-95,0);
                glvertex3f(67,-95,h);
                glvertex3f(23,-95,h);
                glvertex3f(23,-95,0);
                glend;

                glbegin(render);
                glvertex3f(67,-95,0);
                glvertex3f(68,-99,0);
                glvertex3f(68,-99,h);
                glvertex3f(67,-95,0);
                glend;

                glbegin(render);
                glvertex3f(68,-99,0);
                glvertex3f(33,-114,0);
                glvertex3f(33,-114,h);
                glvertex3f(68,-99,h);
                glend;

                glbegin(render);
                glvertex3f(33,-114,0);
                glvertex3f(27,-106,0);
                glvertex3f(27,-106,h);
                glvertex3f(33,-114,h);
                glend;

                glbegin(render);
                glvertex3f(27,-106,0);
                glvertex3f(23,-95,0);
                glvertex3f(23,-95,h);
                glvertex3f(27,-106,h);
                glend;

// primeira aba da esquerda para a direita (altura)
        glbegin(render);
        glvertex3f(23,-95,h);
        glvertex3f(67,-95,h);
        glvertex3f(68,-99,h);
        glvertex3f(33,-114,h);
        glvertex3f(27,-106,h);
        glend;
{--------------------------------------------------}
// segunda aba da esquerda para a direita
        glbegin(render);
        glvertex3f(21,-90,0);
        glvertex3f(19,-77,0);
        glvertex3f(20,-64,0);
        glvertex3f(67,-85,0);
        glvertex3f(67,-87,0);
        glvertex3f(67,-90,0);
        glend;
                //tampos dos lados
                glbegin(render);
                glvertex3f(21,-90,0);
                glvertex3f(19,-77,0);
                glvertex3f(19,-77,h);
                glvertex3f(21,-90,h);
                glend;

                glbegin(render);
                glvertex3f(19,-77,0);
                glvertex3f(20,-64,0);
                glvertex3f(20,-64,h);
                glvertex3f(19,-77,h);
                glend;

                glbegin(render);
                glvertex3f(20,-64,0);
                glvertex3f(67,-85,0);
                glvertex3f(67,-85,h);
                glvertex3f(20,-64,h);
                glend;

                glbegin(render);
                glvertex3f(67,-85,0);
                glvertex3f(67,-87,0);
                glvertex3f(67,-87,h);
                glvertex3f(67,-85,h);
                glend;

                glbegin(render);
                glvertex3f(67,-87,0);
                glvertex3f(67,-90,0);
                glvertex3f(67,-90,h);
                glvertex3f(67,-87,h);
                glend;

                glbegin(render);
                glvertex3f(67,-90,0);
                glvertex3f(21,-90,0);
                glvertex3f(21,-90,h);
                glvertex3f(67,-90,h);
                glend;

 // segunda aba da esquerda para a direita  (altura)
        glbegin(render);
        glvertex3f(21,-90,h);
        glvertex3f(19,-77,h);
        glvertex3f(20,-64,h);
        glvertex3f(67,-85,h);
        glvertex3f(67,-87,h);
        glvertex3f(67,-90,h);
        glend;
{------------------------------------------------------}
// terceira aba da esquerda para a direita
        glbegin(render);
        glvertex3f(68,-81,0);
        glvertex3f(21,-60,0);
        glvertex3f(24,-52,0);
        glvertex3f(28,-44,0);
        glvertex3f(34,-37,0);
        glvertex3f(70,-77,0);
        glend;
                glbegin(render);
                glvertex3f(70,-77,0);
                glvertex3f(72,-75,0);
                glvertex3f(34,-37,0);
                glend;

                        //tampo dos lados
                        glbegin(render);
                        glvertex3f(68,-81,0);
                        glvertex3f(21,-60,0);
                        glvertex3f(21,-60,h);
                        glvertex3f(68,-81,h);
                        glend;

                        glbegin(render);
                        glvertex3f(21,-60,0);
                        glvertex3f(24,-52,0);
                        glvertex3f(24,-52,h);
                        glvertex3f(21,-60,h);
                        glend;

                        glbegin(render);
                        glvertex3f(24,-52,0);
                        glvertex3f(28,-44,0);
                        glvertex3f(28,-44,h);
                        glvertex3f(24,-52,h);
                        glend;

                        glbegin(render);
                        glvertex3f(28,-44,0);
                        glvertex3f(34,-37,0);
                        glvertex3f(34,-37,h);
                        glvertex3f(28,-44,h);
                        glend;

                        glbegin(render);
                        glvertex3f(34,-37,0);
                        glvertex3f(72,-75,0);
                        glvertex3f(72,-75,h);
                        glvertex3f(34,-37,h);
                        glend;

                        glbegin(render);
                        glvertex3f(68,-81,0);
                        glvertex3f(70,-77,0);
                        glvertex3f(72,-75,0);
                        glvertex3f(72,-75,h);
                        glvertex3f(70,-77,h);                        glvertex3f(72,-75,h);
                        glvertex3f(68,-81,h);
                        glend;
// terceira aba da esquerda para a direita  (altura)
        glbegin(render);
        glvertex3f(68,-81,h);
        glvertex3f(21,-60,h);
        glvertex3f(24,-52,h);
        glvertex3f(28,-44,h);
        glvertex3f(34,-37,h);
        glvertex3f(70,-77,h);
        glend;
                glbegin(render);
                glvertex3f(70,-77,h);
                glvertex3f(72,-75,h);
                glvertex3f(34,-37,h);
                glend;

{--------------------------------------------------------}
// quarta aba da esquerda para direita
        glbegin(render);
        glvertex3f(76,-73,0);
        glvertex3f(37,-33,0);
        glvertex3f(44,-26,0);
        glvertex3f(50,-21,0);
        glvertex3f(59,-16,0);
        glvertex3f(78,-70,0);
        glend;
                glbegin(render);
                glvertex3f(78,-70,0);
                glvertex3f(81,-69,0);
                glvertex3f(59,-16,0);
                glend;

                        //tampo dos lados
                        glbegin(render);
                        glvertex3f(76,-73,0);
                        glvertex3f(37,-33,0);
                        glvertex3f(37,-33,h);
                        glvertex3f(76,-73,h);
                        glend;

                        glbegin(render);
                        glvertex3f(37,-33,0);
                        glvertex3f(44,-26,0);
                        glvertex3f(44,-26,h);
                        glvertex3f(37,-33,h);
                        glend;

                        glbegin(render);
                        glvertex3f(44,-26,0);
                        glvertex3f(50,-21,0);
                        glvertex3f(50,-21,h);
                        glvertex3f(44,-26,h);
                        glend;

                        glbegin(render);
                        glvertex3f(50,-21,0);
                        glvertex3f(59,-16,0);
                        glvertex3f(59,-16,h);
                        glvertex3f(50,-21,h);
                        glend;

                        glbegin(render);
                        glvertex3f(59,-16,0);
                        glvertex3f(81,-69,0);
                        glvertex3f(81,-69,h);
                        glvertex3f(59,-16,h);
                        glend;

                        glbegin(render);
                        glvertex3f(81,-69,0);
                        glvertex3f(78,-70,0);
                        glvertex3f(78,-70,h);
                        glvertex3f(81,-69,h);
                        glend;

                        glbegin(render);
                        glvertex3f(78,-70,0);
                        glvertex3f(76,-73,0);
                        glvertex3f(76,-73,h);
                        glvertex3f(78,-70,h);
                        glend;

// quarta aba da esquerda para direita  (altura)
        glbegin(render);
        glvertex3f(76,-73,h);
        glvertex3f(37,-33,h);
        glvertex3f(44,-26,h);
        glvertex3f(50,-21,h);
        glvertex3f(59,-16,h);
        glvertex3f(78,-70,h);
        glend;
                glbegin(render);
                glvertex3f(78,-70,h);
                glvertex3f(81,-69,h);
                glvertex3f(59,-16,h);
                glend;
{-------------------------------------------------------}
// quinta aba da esquerda para direita
        glbegin(render);
        glvertex3f(85,-67,0);
        glvertex3f(63,-14,0);
        glvertex3f(70,-11,0);
        glvertex3f(77,-9,0);
        glvertex3f(90,-8,0);
        glvertex3f(90,-66,0);
        glend;

                //tampo dos lados
                glbegin(render);
                glvertex3f(85,-67,0);
                glvertex3f(63,-14,0);
                glvertex3f(63,-14,h);
                glvertex3f(85,-67,h);
                glend;

                glbegin(render);
                glvertex3f(63,-14,0);
                glvertex3f(70,-11,0);
                glvertex3f(70,-11,h);
                glvertex3f(63,-14,h);
                glend;

                glbegin(render);
                glvertex3f(70,-11,0);
                glvertex3f(77,-9,0);
                glvertex3f(77,-9,h);
                glvertex3f(70,-11,h);
                glend;

                glbegin(render);
                glvertex3f(77,-9,0);
                glvertex3f(90,-8,0);
                glvertex3f(90,-8,h);
                glvertex3f(77,-9,h);
                glend;

                glbegin(render);
                glvertex3f(90,-8,0);
                glvertex3f(90,-66,0);
                glvertex3f(90,-66,h);
                glvertex3f(90,-8,h);
                glend;

                glbegin(render);
                glvertex3f(90,-66,0);
                glvertex3f(85,-67,0);
                glvertex3f(85,-67,h);
                glvertex3f(90,-66,h);
                glend;

// quinta aba da esquerda para direita  (altura)
        glbegin(render);
        glvertex3f(85,-67,h);
        glvertex3f(63,-14,h);
        glvertex3f(70,-11,h);
        glvertex3f(77,-9,h);
        glvertex3f(90,-8,h);
        glvertex3f(90,-66,h);
        glend;
{--------------------------------------------------------}
// sexta aba da esquerda para a direita
        glbegin(render);
        glvertex3f(96,-66,0);
        glvertex3f(96,-8,0);
        glvertex3f(111,-9,0);
        glvertex3f(117,-11,0);
        glvertex3f(116,-15,0);
        glvertex3f(118,-20,0);
        glend;
                glbegin(render);
                glvertex3f(96,-66,0);
                glvertex3f(100,-68,0);
                glvertex3f(120,-22,0);
                glvertex3f(118,-20,0);
                glend;

                        //tampo dos lados
                        glbegin(render);
                        glvertex3f(96,-66,0);
                        glvertex3f(96,-8,0);
                        glvertex3f(96,-8,h);
                        glvertex3f(96,-66,h);
                        glend;

                        glbegin(render);
                        glvertex3f(96,-8,0);
                        glvertex3f(111,-9,0);
                        glvertex3f(111,-9,h);
                        glvertex3f(96,-8,h);
                        glend;

                        glbegin(render);
                        glvertex3f(111,-9,0);
                        glvertex3f(117,-11,0);
                        glvertex3f(117,-11,h);
                        glvertex3f(111,-9,h);
                        glend;

                        glbegin(render);
                        glvertex3f(117,-11,0);
                        glvertex3f(116,-15,0);
                        glvertex3f(116,-15,h);
                        glvertex3f(117,-11,h);
                        glend;

                        glbegin(render);
                        glvertex3f(116,-15,0);
                        glvertex3f(118,-20,0);
                        glvertex3f(118,-20,h);
                        glvertex3f(116,-15,h);
                        glend;

                        glbegin(render);
                        glvertex3f(118,-20,0);
                        glvertex3f(120,-22,0);
                        glvertex3f(120,-22,h);
                        glvertex3f(118,-20,h);
                        glend;

                        glbegin(render);
                        glvertex3f(120,-22,0);
                        glvertex3f(100,-68,0);
                        glvertex3f(100,-68,h);
                        glvertex3f(120,-22,h);
                        glend;

                        glbegin(render);
                        glvertex3f(100,-68,0);
                        glvertex3f(96,-66,0);
                        glvertex3f(96,-66,h);
                        glvertex3f(100,-68,h);
                        glend;

// sexta aba da esquerda para a direita  (altura)
        glbegin(render);
        glvertex3f(96,-66,h);
        glvertex3f(96,-8,h);
        glvertex3f(111,-9,h);
        glvertex3f(117,-11,h);
        glvertex3f(116,-15,h);
        glvertex3f(118,-20,h);
        glend;
                glbegin(render);
                glvertex3f(96,-66,h);
                glvertex3f(100,-68,h);
                glvertex3f(120,-22,h);
                glvertex3f(118,-20,h);
                glend;
{----------------------------------------------------------}
// setima aba da esquerda para a direita
        glbegin(render);
        glvertex3f(109,-72,0);
        glvertex3f(149,-33,0);
        glvertex3f(146,-27,0);
        glvertex3f(140,-22,0);
        glvertex3f(134,-19,0);
        glvertex3f(132,-22,0);
        glvertex3f(128,-23,0);
        glvertex3f(108,-70,0);
        glend;
                glbegin(render);
                glvertex3f(128,-23,0);
                glvertex3f(124,-23,0);
                glvertex3f(104,-69,0);
                glvertex3f(108,-70,0);
                glend;

                        // tampo dos lados
                        glbegin(render);
                        glvertex3f(104,-69,0);
                        glvertex3f(124,-23,0);
                        glvertex3f(124,-23,h);
                        glvertex3f(104,-69,h);
                        glend;

                        glbegin(render);
                        glvertex3f(124,-23,0);
                        glvertex3f(128,-23,0);
                        glvertex3f(128,-23,h);
                        glvertex3f(124,-23,h);
                        glend;

                        glbegin(render);
                        glvertex3f(128,-23,0);
                        glvertex3f(132,-22,0);
                        glvertex3f(132,-22,0);
                        glvertex3f(132,-22,0);
                        glend;

                        glbegin(render);
                        glvertex3f(132,-22,0);
                        glvertex3f(134,-19,0);
                        glvertex3f(134,-19,h);
                        glvertex3f(132,-22,h);
                        glend;

                        glbegin(render);
                        glvertex3f(134,-19,0);
                        glvertex3f(140,-22,0);
                        glvertex3f(140,-22,h);
                        glvertex3f(134,-19,h);
                        glend;

                        glbegin(render);
                        glvertex3f(140,-22,0);
                        glvertex3f(146,-27,0);
                        glvertex3f(146,-27,h);
                        glvertex3f(140,-22,h);
                        glend;

                        glbegin(render);
                        glvertex3f(146,-27,0);
                        glvertex3f(149,-33,0);
                        glvertex3f(149,-33,h);
                        glvertex3f(146,-27,h);
                        glend;

                        glbegin(render);
                        glvertex3f(149,-33,0);
                        glvertex3f(109,-72,0);
                        glvertex3f(109,-72,h);
                        glvertex3f(149,-33,h);
                        glend;

                        glbegin(render);
                        glvertex3f(109,-72,0);
                        glvertex3f(108,-70,0);
                        glvertex3f(108,-70,h);
                        glvertex3f(109,-72,h);
                        glend;

                        glbegin(render);
                        glvertex3f(108,-70,0);
                        glvertex3f(104,-69,0);
                        glvertex3f(104,-69,h);
                        glvertex3f(108,-70,h);
                        glend;

// setima aba da esquerda para a direita (altura)
        glbegin(render);
        glvertex3f(109,-72,h);
        glvertex3f(149,-33,h);
        glvertex3f(146,-27,h);
        glvertex3f(140,-22,h);
        glvertex3f(134,-19,h);
        glvertex3f(132,-22,h);
        glvertex3f(128,-23,h);
        glvertex3f(108,-70,h);
        glend;
                glbegin(render);
                glvertex3f(128,-23,h);
                glvertex3f(124,-23,h);
                glvertex3f(104,-69,h);
                glvertex3f(108,-70,h);
                glend;
{-----------------------------------------------------------}
// oitava aba da esquerda para a direita
        glbegin(render);
        glvertex3f(112,-74,0);
        glvertex3f(152,-36,0);
        glvertex3f(157,-43,0);
        glvertex3f(161,-51,0);
        glvertex3f(164,-61,0);
        glvertex3f(115,-77,0);
        glend;
                glbegin(render);
                glvertex3f(115,-77,0);
                glvertex3f(164,-61,0);
                glvertex3f(116,-80,0);
                glend;

                        // tampo dos lados
                        glbegin(render);
                        glvertex3f(112,-74,0);
                        glvertex3f(152,-36,0);
                        glvertex3f(152,-36,h);
                        glvertex3f(112,-74,h);
                        glend;

                        glbegin(render);
                        glvertex3f(152,-36,0);
                        glvertex3f(157,-43,0);
                        glvertex3f(157,-43,h);
                        glvertex3f(152,-36,h);
                        glend;

                        glbegin(render);
                        glvertex3f(157,-43,0);
                        glvertex3f(161,-51,0);
                        glvertex3f(161,-51,h);
                        glvertex3f(157,-43,h);
                        glend;

                        glbegin(render);
                        glvertex3f(161,-51,0);
                        glvertex3f(164,-61,0);
                        glvertex3f(164,-61,h);
                        glvertex3f(161,-51,h);
                        glend;

                        glbegin(render);
                        glvertex3f(164,-61,0);
                        glvertex3f(116,-80,0);
                        glvertex3f(116,-80,h);
                        glvertex3f(164,-61,h);
                        glend;

                        glbegin(render);
                        glvertex3f(116,-80,0);
                        glvertex3f(115,-77,0);
                        glvertex3f(115,-77,h);
                        glvertex3f(116,-80,h);
                        glend;

                        glbegin(render);
                        glvertex3f(115,-77,0);
                        glvertex3f(112,-74,0);
                        glvertex3f(112,-74,h);
                        glvertex3f(115,-77,h);
                        glend;

// oitava aba da esquerda para a direita  (altura)
        glbegin(render);
        glvertex3f(112,-74,h);
        glvertex3f(152,-36,h);
        glvertex3f(157,-43,h);
        glvertex3f(161,-51,h);
        glvertex3f(164,-61,h);
        glvertex3f(115,-77,h);
        glend;
                glbegin(render);
                glvertex3f(115,-77,h);
                glvertex3f(164,-61,h);
                glvertex3f(116,-80,h);
                glend;

{----------------------------------------------------------}
// nona aba da esquerda para a direita
        glbegin(render);
        glvertex3f(117,-83,0);
        glvertex3f(165,-65,0);
        glvertex3f(169,-71,0);
        glvertex3f(171,-77,0);
        glvertex3f(172,-83,0);
        glvertex3f(169,-84,0);
        glvertex3f(168,-86,0);
        glvertex3f(119,-86,0);
        glend;
                glbegin(render);
                glvertex3f(119,-86,0);
                glvertex3f(118,-90,0);
                glvertex3f(167,-90,0);
                glvertex3f(168,-86,0);
                glend;

                        // tampo dos lados
                        glbegin(render);
                        glvertex3f(117,-83,0);
                        glvertex3f(165,-65,0);
                        glvertex3f(165,-65,h);
                        glvertex3f(117,-83,h);
                        glend;

                        glbegin(render);
                        glvertex3f(165,-65,0);
                        glvertex3f(169,-71,0);
                        glvertex3f(169,-71,h);
                        glvertex3f(165,-65,h);
                        glend;

                        glbegin(render);
                        glvertex3f(169,-71,0);
                        glvertex3f(171,-77,0);
                        glvertex3f(171,-77,h);
                        glvertex3f(169,-71,h);
                        glend;

                        glbegin(render);
                        glvertex3f(171,-77,0);
                        glvertex3f(172,-83,0);
                        glvertex3f(172,-83,h);
                        glvertex3f(171,-77,h);
                        glend;

                        glbegin(render);
                        glvertex3f(172,-83,0);
                        glvertex3f(169,-84,0);
                        glvertex3f(169,-84,h);
                        glvertex3f(172,-83,h);
                        glend;

                        glbegin(render);
                        glvertex3f(169,-84,0);
                        glvertex3f(168,-86,0);
                        glvertex3f(168,-86,h);
                        glvertex3f(169,-84,h);
                        glend;

                        glbegin(render);
                        glvertex3f(168,-86,0);
                        glvertex3f(167,-90,0);
                        glvertex3f(167,-90,h);
                        glvertex3f(168,-86,h);
                        glend;

                        glbegin(render);
                        glvertex3f(167,-90,0);
                        glvertex3f(118,-90,0);
                        glvertex3f(118,-90,h);
                        glvertex3f(167,-90,h);
                        glend;

                        glbegin(render);
                        glvertex3f(118,-90,0);
                        glvertex3f(119,-86,0);
                        glvertex3f(119,-86,h);
                        glvertex3f(118,-90,h);
                        glend;

                        glbegin(render);
                        glvertex3f(119,-86,0);
                        glvertex3f(117,-83,0);
                        glvertex3f(117,-83,h);
                        glvertex3f(119,-86,h);
                        glend;

// nona aba da esquerda para a direita
        glbegin(render);
        glvertex3f(117,-83,h);
        glvertex3f(165,-65,h);
        glvertex3f(169,-71,h);
        glvertex3f(171,-77,h);
        glvertex3f(172,-83,h);
        glvertex3f(169,-84,h);
        glvertex3f(168,-86,h);
        glvertex3f(119,-86,h);
        glend;
                glbegin(render);
                glvertex3f(119,-86,h);
                glvertex3f(118,-90,h);
                glvertex3f(167,-90,h);
                glvertex3f(168,-86,h);
                glend;
{------------------------------------------------------------}
// dcima aba da esquerda para a direita
        glbegin(render);
        glvertex3f(118,-95,0);
        glvertex3f(167,-95,0);
        glvertex3f(168,-97,0);
        glvertex3f(170,-99,0);
        glvertex3f(115,-105,0);
        glvertex3f(117,-100,0);
        glvertex3f(118,-95,0);
        glend;
                glbegin(render);
                glvertex3f(115,-105,0);
                glvertex3f(112,-110,0);
                glvertex3f(131,-128,0);
                glvertex3f(145,-120,0);
                glvertex3f(159,-110,0);
                glvertex3f(171,-101,0);
                glvertex3f(170,-99,0);
                glend;

                        // tampo dos lados
                        glbegin(render);
                        glvertex3f(118,-95,0);
                        glvertex3f(167,-95,0);
                        glvertex3f(167,-95,h);
                        glvertex3f(118,-95,h);
                        glend;

                        glbegin(render);
                        glvertex3f(167,-95,0);
                        glvertex3f(168,-97,0);
                        glvertex3f(168,-97,h);
                        glvertex3f(168,-97,h);
                        glend;

                        glbegin(render);
                        glvertex3f(168,-97,0);
                        glvertex3f(171,-101,0);
                        glvertex3f(171,-101,h);
                        glvertex3f(168,-97,h);
                        glend;

                        glbegin(render);
                        glvertex3f(171,-101,0);
                        glvertex3f(159,-110,0);
                        glvertex3f(159,-110,h);
                        glvertex3f(171,-101,h);
                        glend;

                        glbegin(render);
                        glvertex3f(159,-110,0);
                        glvertex3f(145,-120,0);
                        glvertex3f(145,-120,h);
                        glvertex3f(159,-110,h);
                        glend;

                        glbegin(render);
                        glvertex3f(145,-120,0);
                        glvertex3f(131,-128,0);
                        glvertex3f(131,-128,h);
                        glvertex3f(145,-120,h);
                        glend;

                        glbegin(render);
                        glvertex3f(131,-128,0);
                        glvertex3f(112,-110,0);
                        glvertex3f(112,-110,h);
                        glvertex3f(131,-128,h);
                        glend;

                        glbegin(render);
                        glvertex3f(112,-110,0);
                        glvertex3f(115,-105,0);
                        glvertex3f(115,-105,h);
                        glvertex3f(112,-110,h);
                        glend;

                        glbegin(render);
                        glvertex3f(115,-105,0);
                        glvertex3f(117,-100,0);
                        glvertex3f(117,-100,h);
                        glvertex3f(115,-105,h);
                        glend;

                        glbegin(render);
                        glvertex3f(117,-100,0);
                        glvertex3f(118,-95,0);
                        glvertex3f(118,-95,h);
                        glvertex3f(117,-100,h);
                        glend;

// dcima aba da esquerda para a direita  (altura)
        glbegin(render);
        glvertex3f(118,-95,h);
        glvertex3f(167,-95,h);
        glvertex3f(168,-97,h);
        glvertex3f(170,-99,h);
        glvertex3f(115,-105,h);
        glvertex3f(117,-100,h);
        glvertex3f(118,-95,h);
        glend;
                glbegin(render);
                glvertex3f(115,-105,h);
                glvertex3f(112,-110,h);
                glvertex3f(131,-128,h);
                glvertex3f(145,-120,h);
                glvertex3f(159,-110,h);
                glvertex3f(171,-101,h);
                glvertex3f(170,-99,h);
                glend;
{----------------------------------------------------------}
// dcima primeira aba da esquerda para a direita
        glbegin(render);
        glvertex3f(107,-114,0);
        glvertex3f(110,-112,0);
        glvertex3f(127,-130,0);
        glvertex3f(124,-132,0);
        glvertex3f(120,-133,0);
        glvertex3f(119,-130,0);
        glend;
                glbegin(render);
                glvertex3f(107,-114,0);
                glvertex3f(104,-116,0);
                glvertex3f(110,-128,0);
                glvertex3f(116,-129,0);
                glvertex3f(119,-130,0);
                glend;

                        // tampos dos lados
                        glbegin(render);
                        glvertex3f(104,-116,0);
                        glvertex3f(107,-114,0);
                        glvertex3f(107,-114,h);
                        glvertex3f(104,-116,h);
                        glend;

                        glbegin(render);
                        glvertex3f(107,-114,0);
                        glvertex3f(110,-112,0);
                        glvertex3f(110,-112,h);
                        glvertex3f(107,-114,h);
                        glend;

                        glbegin(render);
                        glvertex3f(110,-112,0);
                        glvertex3f(127,-130,0);
                        glvertex3f(127,-130,h);
                        glvertex3f(110,-112,h);
                        glend;

                        glbegin(render);
                        glvertex3f(127,-130,0);
                        glvertex3f(124,-132,0);
                        glvertex3f(124,-132,h);
                        glvertex3f(127,-130,h);
                        glend;

                        glbegin(render);
                        glvertex3f(124,-132,0);
                        glvertex3f(120,-133,0);
                        glvertex3f(120,-133,h);
                        glvertex3f(124,-132,h);
                        glend;

                        glbegin(render);
                        glvertex3f(120,-133,0);
                        glvertex3f(119,-130,0);
                        glvertex3f(119,-130,h);
                        glvertex3f(120,-133,h);
                        glend;

                        glbegin(render);
                        glvertex3f(119,-130,0);
                        glvertex3f(116,-129,0);
                        glvertex3f(116,-129,h);
                        glvertex3f(119,-130,h);
                        glend;

                        glbegin(render);
                        glvertex3f(116,-129,0);
                        glvertex3f(110,-128,0);
                        glvertex3f(110,-128,h);
                        glvertex3f(116,-129,h);
                        glend;

                        glbegin(render);
                        glvertex3f(110,-128,0);
                        glvertex3f(104,-116,0);
                        glvertex3f(104,-116,h);
                        glvertex3f(110,-128,h);
                        glend;

// dcima primeira aba da esquerda para a direita
        glbegin(render);
        glvertex3f(107,-114,h);
        glvertex3f(110,-112,h);
        glvertex3f(127,-130,h);
        glvertex3f(124,-132,h);
        glvertex3f(120,-133,h);
        glvertex3f(119,-130,h);
        glend;
                glbegin(render);
                glvertex3f(107,-114,h);
                glvertex3f(104,-116,h);
                glvertex3f(110,-128,h);
                glvertex3f(116,-129,h);
                glvertex3f(119,-130,h);
                glend;
{----------------------------------------------------------}
// dcima segunda aba da esquerda para a direita
        glbegin(render);
        glvertex3f(100,-117,0);
        glvertex3f(106,-130,0);
        glvertex3f(103,-132,0);
        glvertex3f(101,-135,0);
        glvertex3f(100,-140,0);
        glvertex3f(89,-142,0);
        glvertex3f(76,-140,0);
        glvertex3f(65,-137,0);
        glvertex3f(55,-133,0);
        glvertex3f(93,-118,0);
        glend;
                glbegin(render);
                glvertex3f(93,-118,0);
                glvertex3f(86,-117,0);
                glvertex3f(55,-133,0);
                glend;
                glbegin(render);
                glvertex3f(86,-117,0);
                glvertex3f(80,-115,0);
                glvertex3f(55,-133,0);
                glend;
                glbegin(render);
                glvertex3f(75,-111,0);
                glvertex3f(80,-115,0);
                glvertex3f(55,-133,0);
                glend;

                        // tampos do lado
                        glbegin(render);
                        glvertex3f(55,-133,0);
                        glvertex3f(75,-111,0);
                        glvertex3f(75,-111,h);
                        glvertex3f(55,-133,h);
                        glend;

                        glbegin(render);
                        glvertex3f(75,-111,0);
                        glvertex3f(80,-115,0);
                        glvertex3f(80,-115,h);
                        glvertex3f(80,-115,h);
                        glend;

                        glbegin(render);
                        glvertex3f(80,-115,0);
                        glvertex3f(86,-117,0);
                        glvertex3f(86,-117,h);
                        glvertex3f(80,-115,h);
                        glend;

                        glbegin(render);
                        glvertex3f(86,-117,0);
                        glvertex3f(93,-118,0);
                        glvertex3f(93,-118,h);
                        glvertex3f(86,-117,h);
                        glend;

                        glbegin(render);
                        glvertex3f(93,-118,0);
                        glvertex3f(100,-117,0);
                        glvertex3f(100,-117,h);
                        glvertex3f(93,-118,h);
                        glend;

                        glbegin(render);
                        glvertex3f(100,-117,0);
                        glvertex3f(106,-130,0);
                        glvertex3f(106,-130,h);
                        glvertex3f(100,-117,h);
                        glend;

                        glbegin(render);
                        glvertex3f(106,-130,0);
                        glvertex3f(103,-132,0);
                        glvertex3f(103,-132,h);
                        glvertex3f(106,-130,h);
                        glend;

                        glbegin(render);
                        glvertex3f(103,-132,0);
                        glvertex3f(101,-135,0);
                        glvertex3f(101,-135,h);
                        glvertex3f(103,-132,h);
                        glend;

                        glbegin(render);
                        glvertex3f(101,-135,0);
                        glvertex3f(100,-140,0);
                        glvertex3f(100,-140,h);
                        glvertex3f(101,-135,h);
                        glend;

                        glbegin(render);
                        glvertex3f(100,-140,0);
                        glvertex3f(89,-142,0);
                        glvertex3f(89,-142,h);
                        glvertex3f(100,-140,h);
                        glend;

                        glbegin(render);
                        glvertex3f(89,-142,0);
                        glvertex3f(76,-140,0);
                        glvertex3f(76,-140,h);
                        glvertex3f(89,-142,h);
                        glend;

                        glbegin(render);
                        glvertex3f(76,-140,0);
                        glvertex3f(65,-137,0);
                        glvertex3f(65,-137,h);
                        glvertex3f(76,-140,h);
                        glend;

                        glbegin(render);
                        glvertex3f(65,-137,0);
                        glvertex3f(55,-133,0);
                        glvertex3f(55,-133,h);
                        glvertex3f(65,-137,h);
                        glend;

// dcima segunda aba da esquerda para a direita
        glbegin(render);
        glvertex3f(100,-117,h);
        glvertex3f(106,-130,h);
        glvertex3f(103,-132,h);
        glvertex3f(101,-135,h);
        glvertex3f(100,-140,h);
        glvertex3f(89,-142,h);
        glvertex3f(76,-140,h);
        glvertex3f(65,-137,h);
        glvertex3f(55,-133,h);
        glvertex3f(93,-118,h);
        glend;
                glbegin(render);
                glvertex3f(93,-118,h);
                glvertex3f(86,-117,h);
                glvertex3f(55,-133,h);
                glend;
                glbegin(render);
                glvertex3f(86,-117,h);
                glvertex3f(80,-115,h);
                glvertex3f(55,-133,h);
                glend;
                glbegin(render);
                glvertex3f(75,-111,h);
                glvertex3f(80,-115,h);
                glvertex3f(55,-133,h);
                glend;
{-----------------------------------------------------------}
// dcima terceira aba da esquerda para a direita
        glbegin(render);
        glvertex3f(52,-131,0);
        glvertex3f(46,-128,0);
        glvertex3f(41,-125,0);
        glvertex3f(35,-118,0);
        glvertex3f(68,-103,0);
        glvertex3f(72,-107,0);
        glvertex3f(72,-109,0);
        glend;

                //tampo dos lados
                glbegin(render);
                glvertex3f(52,-131,0);
                glvertex3f(41,-125,0);
                glvertex3f(41,-125,h);
                glvertex3f(52,-131,h);
                glend;

                glbegin(render);
                glvertex3f(41,-125,0);
                glvertex3f(35,-118,0);
                glvertex3f(35,-118,h);
                glvertex3f(35,-118,h);
                glend;

                glbegin(render);
                glvertex3f(35,-118,0);
                glvertex3f(68,-103,0);
                glvertex3f(68,-103,h);
                glvertex3f(35,-118,h);
                glend;

                glbegin(render);
                glvertex3f(68,-103,0);
                glvertex3f(72,-107,0);
                glvertex3f(72,-107,h);
                glvertex3f(68,-103,h);
                glend;

                glbegin(render);
                glvertex3f(72,-107,0);
                glvertex3f(72,-109,0);
                glvertex3f(72,-109,h);
                glvertex3f(72,-107,h);
                glend;

                glbegin(render);
                glvertex3f(72,-109,0);
                glvertex3f(52,-131,0);
                glvertex3f(52,-131,h);
                glvertex3f(72,-109,h);
                glend;

// dcima terceira aba da esquerda para a direita
        glbegin(render);
        glvertex3f(52,-131,h);
        glvertex3f(46,-128,h);
        glvertex3f(41,-125,h);
        glvertex3f(35,-118,h);
        glvertex3f(68,-103,h);
        glvertex3f(72,-107,h);
        glvertex3f(72,-109,h);
        glend;
{----------------------------------------------------------}
end;

procedure texto_unicamp(h,render:integer);
begin
{letra U---------------------------------------------------}
        glbegin(render);
        glvertex3f(21,-175,0);
        glvertex3f(21,-189,0);
        glvertex3f(23,-191,0);
        glvertex3f(25,-191,0);
        glvertex3f(25,-175,0);
        glend;
        glbegin(render);
        glvertex3f(25,-185,0);
        glvertex3f(25,-191,0);
        glvertex3f(38,-191,0);
        glvertex3f(38,-185,0);
        glvertex3f(35,-188,0);
        glvertex3f(28,-188,0);
        glend;
        glbegin(render);
        glvertex3f(38,-175,0);
        glvertex3f(38,-191,0);
        glvertex3f(40,-191,0);
        glvertex3f(42,-189,0);
        glvertex3f(42,-175,0);
        glend;

                // tampo dos lados
                glbegin(render);
                glvertex3f(21,-175,0);
                glvertex3f(25,-175,0);
                glvertex3f(25,-175,h);
                glvertex3f(21,-175,h);
                glend;
                glbegin(render);
                glvertex3f(21,-189,0);
                glvertex3f(21,-175,0);
                glvertex3f(21,-175,h);
                glvertex3f(21,-189,h);
                glend;
                glbegin(render);
                glvertex3f(23,-191,0);
                glvertex3f(21,-189,0);
                glvertex3f(21,-189,h);
                glvertex3f(23,-191,h);
                glend;
                glbegin(render);
                glvertex3f(40,-191,0);
                glvertex3f(23,-191,0);
                glvertex3f(23,-191,h);
                glvertex3f(40,-191,h);
                glend;
                glbegin(render);
                glvertex3f(42,-189,0);
                glvertex3f(40,-191,0);
                glvertex3f(40,-191,h);
                glvertex3f(42,-189,h);
                glend;
                glbegin(render);
                glvertex3f(42,-175,0);
                glvertex3f(42,-189,0);
                glvertex3f(42,-189,h);
                glvertex3f(42,-175,h);
                glend;
                glbegin(render);
                glvertex3f(38,-175,0);
                glvertex3f(42,-175,0);
                glvertex3f(42,-175,h);
                glvertex3f(38,-175,h);
                glend;
                glbegin(render);
                glvertex3f(38,-185,0);
                glvertex3f(38,-175,0);
                glvertex3f(38,-175,h);
                glvertex3f(38,-185,h);
                glend;
                glbegin(render);
                glvertex3f(35,-188,0);
                glvertex3f(38,-185,0);
                glvertex3f(38,-185,h);
                glvertex3f(35,-188,h);
                glend;
                glbegin(render);
                glvertex3f(28,-188,0);
                glvertex3f(35,-188,0);
                glvertex3f(35,-188,h);
                glvertex3f(28,-188,h);
                glend;
                glbegin(render);
                glvertex3f(25,-185,0);
                glvertex3f(28,-188,0);
                glvertex3f(28,-188,h);
                glvertex3f(25,-185,h);
                glend;
                glbegin(render);
                glvertex3f(25,-175,0);
                glvertex3f(25,-185,0);
                glvertex3f(25,-185,h);
                glvertex3f(25,-175,h);
                glend;

// letra U (altura)
        glbegin(render);
        glvertex3f(21,-175,h);
        glvertex3f(21,-189,h);
        glvertex3f(23,-191,h);
        glvertex3f(25,-191,h);
        glvertex3f(25,-175,h);
        glend;
        glbegin(render);
        glvertex3f(25,-185,h);
        glvertex3f(25,-191,h);
        glvertex3f(38,-191,h);
        glvertex3f(38,-185,h);
        glvertex3f(35,-188,h);
        glvertex3f(28,-188,h);
        glend;
        glbegin(render);
        glvertex3f(38,-175,h);
        glvertex3f(38,-191,h);
        glvertex3f(40,-191,h);
        glvertex3f(42,-189,h);
        glvertex3f(42,-175,h);
        glend;
{----------------------------------------------------------}
{Letra N---------------------------------------------------}
        glbegin(render);
        glvertex3f(46,-175,0);
        glvertex3f(46,-191,0);
        glvertex3f(51,-191,0);
        glvertex3f(51,-175,0);
        glend;
        glbegin(render);
        glvertex3f(51,-181,0);
        glvertex3f(61,-191,0);
        glvertex3f(63,-191,0);
        glvertex3f(63,-186,0);
        glvertex3f(53,-175,0);
        glvertex3f(51,-175,0);
        glend;
        glbegin(render);
        glvertex3f(63,-175,0);
        glvertex3f(63,-191,0);
        glvertex3f(68,-191,0);
        glvertex3f(68,-175,0);
        glend;

                // tampo dos lados
                glbegin(render);
                glvertex3f(46,-175,0);
                glvertex3f(53,-175,0);
                glvertex3f(53,-175,h);
                glvertex3f(46,-175,h);
                glend;
                glbegin(render);
                glvertex3f(46,-191,0);
                glvertex3f(46,-175,0);
                glvertex3f(46,-175,h);
                glvertex3f(46,-191,h);
                glend;
                glbegin(render);
                glvertex3f(51,-191,0);
                glvertex3f(46,-191,0);
                glvertex3f(46,-191,h);
                glvertex3f(51,-191,h);
                glend;
                glbegin(render);
                glvertex3f(51,-181,0);
                glvertex3f(51,-191,0);
                glvertex3f(51,-191,h);
                glvertex3f(51,-181,h);
                glend;
                glbegin(render);
                glvertex3f(61,-191,0);
                glvertex3f(51,-181,0);
                glvertex3f(51,-181,h);
                glvertex3f(61,-191,h);
                glend;
                glbegin(render);
                glvertex3f(68,-191,0);
                glvertex3f(61,-191,0);
                glvertex3f(61,-191,h);
                glvertex3f(68,-191,h);
                glend;
                glbegin(render);
                glvertex3f(68,-175,0);
                glvertex3f(68,-191,0);
                glvertex3f(68,-191,h);
                glvertex3f(68,-175,h);
                glend;
                glbegin(render);
                glvertex3f(63,-175,0);
                glvertex3f(68,-175,0);
                glvertex3f(68,-175,h);
                glvertex3f(63,-175,h);
                glend;
                glbegin(render);
                glvertex3f(63,-186,0);
                glvertex3f(63,-175,0);
                glvertex3f(63,-175,h);
                glvertex3f(63,-186,h);
                glend;
                glbegin(render);
                glvertex3f(63,-186,0);
                glvertex3f(53,-175,0);
                glvertex3f(53,-175,h);
                glvertex3f(63,-186,h);
                glend;


// letra N (altura)
        glbegin(render);
        glvertex3f(46,-175,h);
        glvertex3f(46,-191,h);
        glvertex3f(51,-191,h);
        glvertex3f(51,-175,h);
        glend;
        glbegin(render);
        glvertex3f(51,-181,h);
        glvertex3f(61,-191,h);
        glvertex3f(63,-191,h);
        glvertex3f(63,-186,h);
        glvertex3f(53,-175,h);
        glvertex3f(51,-175,h);
        glend;
        glbegin(render);
        glvertex3f(63,-175,h);
        glvertex3f(63,-191,h);
        glvertex3f(68,-191,h);
        glvertex3f(68,-175,h);
        glend;
{----------------------------------------------------------}
{Letra I---------------------------------------------------}
        glbegin(render);
        glvertex3f(73,-175,0);
        glvertex3f(73,-191,0);
        glvertex3f(77,-191,0);
        glvertex3f(77,-175,0);
        glend;

                // Tampo dos lados
                glbegin(render);
                glvertex3f(73,-191,0);
                glvertex3f(73,-175,0);
                glvertex3f(73,-175,h);
                glvertex3f(73,-191,h);
                glend;
                glbegin(render);
                glvertex3f(77,-191,0);
                glvertex3f(73,-191,0);
                glvertex3f(73,-191,h);
                glvertex3f(77,-191,h);
                glend;
                glbegin(render);
                glvertex3f(77,-175,0);
                glvertex3f(77,-191,0);
                glvertex3f(77,-191,h);
                glvertex3f(77,-175,h);
                glend;
                glbegin(render);
                glvertex3f(73,-175,0);
                glvertex3f(77,-175,0);
                glvertex3f(77,-175,h);
                glvertex3f(73,-175,h);
                glend;

// Letra I (altura)
        glbegin(render);
        glvertex3f(73,-175,0);
        glvertex3f(73,-191,0);
        glvertex3f(77,-191,0);
        glvertex3f(77,-175,0);
        glend;
{----------------------------------------------------------}
{Letra C---------------------------------------------------}
        glbegin(render);
        glvertex3f(100,-181,0);
        glvertex3f(100,-177,0);
        glvertex3f(98,-175,0);
        glvertex3f(94,-175,0);
        glvertex3f(94,-179,0);
        glvertex3f(96,-181,0);
        glend;
        glbegin(render);
        glvertex3f(94,-175,0);
        glvertex3f(86,-175,0);
        glvertex3f(86,-182,0);
        glvertex3f(89,-179,0);
        glvertex3f(94,-179,0);
        glend;
        glbegin(render);
        glvertex3f(86,-175,0);
        glvertex3f(85,-175,0);
        glvertex3f(82,-178,0);
        glvertex3f(82,-188,0);
        glvertex3f(85,-191,0);
        glvertex3f(86,-191,0);
        glend;
        glbegin(render);
        glvertex3f(89,-187,0);
        glvertex3f(86,-184,0);
        glvertex3f(86,-191,0);
        glvertex3f(94,-191,0);
        glvertex3f(94,-187,0);
        glend;
        glbegin(render);
        glvertex3f(96,-185,0);
        glvertex3f(94,-187,0);
        glvertex3f(94,-191,0);
        glvertex3f(98,-191,0);
        glvertex3f(100,-189,0);
        glvertex3f(100,-185,0);
        glend;

                // Tampo dos lados
                glbegin(render);
                glvertex3f(100,-177,0);
                glvertex3f(100,-181,0);
                glvertex3f(100,-181,h);
                glvertex3f(100,-177,h);
                glend;
                glbegin(render);
                glvertex3f(98,-175,0);
                glvertex3f(100,-177,0);
                glvertex3f(100,-177,h);
                glvertex3f(98,-175,h);
                glend;
                glbegin(render);
                glvertex3f(85,-175,0);
                glvertex3f(98,-175,0);
                glvertex3f(98,-175,h);
                glvertex3f(85,-175,h);
                glend;
                glbegin(render);
                glvertex3f(82,-178,0);
                glvertex3f(85,-175,0);
                glvertex3f(85,-175,h);
                glvertex3f(82,-178,h);
                glend;
                glbegin(render);
                glvertex3f(82,-188,0);
                glvertex3f(82,-178,0);
                glvertex3f(82,-178,h);
                glvertex3f(82,-188,h);
                glend;
                glbegin(render);
                glvertex3f(85,-191,0);
                glvertex3f(82,-188,0);
                glvertex3f(82,-188,h);
                glvertex3f(85,-191,h);
                glend;
                glbegin(render);
                glvertex3f(98,-191,0);
                glvertex3f(85,-191,0);
                glvertex3f(85,-191,h);
                glvertex3f(98,-191,h);
                glend;
                glbegin(render);
                glvertex3f(100,-189,0);
                glvertex3f(98,-191,0);
                glvertex3f(98,-191,h);
                glvertex3f(100,-189,h);
                glend;
                glbegin(render);
                glvertex3f(100,-185,0);
                glvertex3f(100,-189,0);
                glvertex3f(100,-189,h);
                glvertex3f(100,-185,h);
                glend;
                glbegin(render);
                glvertex3f(96,-185,0);
                glvertex3f(100,-185,0);
                glvertex3f(100,-185,h);
                glvertex3f(96,-185,h);
                glend;
                glbegin(render);
                glvertex3f(94,-187,0);
                glvertex3f(96,-185,0);
                glvertex3f(96,-185,h);
                glvertex3f(94,-187,h);
                glend;
                glbegin(render);
                glvertex3f(89,-187,0);
                glvertex3f(94,-187,0);
                glvertex3f(94,-187,h);
                glvertex3f(89,-187,h);
                glend;
                glbegin(render);
                glvertex3f(86,-184,0);
                glvertex3f(89,-187,0);
                glvertex3f(89,-187,h);
                glvertex3f(86,-184,h);
                glend;
                glbegin(render);
                glvertex3f(86,-182,0);
                glvertex3f(86,-184,0);
                glvertex3f(86,-184,h);
                glvertex3f(86,-182,h);
                glend;
                glbegin(render);
                glvertex3f(89,-179,0);
                glvertex3f(86,-182,0);
                glvertex3f(86,-182,h);
                glvertex3f(89,-179,h);
                glend;
                glbegin(render);
                glvertex3f(94,-179,0);
                glvertex3f(89,-179,0);
                glvertex3f(89,-179,h);
                glvertex3f(94,-179,h);
                glend;
                glbegin(render);
                glvertex3f(96,-181,0);
                glvertex3f(94,-179,0);
                glvertex3f(94,-179,h);
                glvertex3f(96,-181,h);
                glend;
                glbegin(render);
                glvertex3f(100,-181,0);
                glvertex3f(96,-181,0);
                glvertex3f(96,-181,h);
                glvertex3f(100,-181,h);
                glend;

// Letra C (altura)
        glbegin(render);
        glvertex3f(100,-181,h);
        glvertex3f(100,-177,h);
        glvertex3f(98,-175,h);
        glvertex3f(94,-175,h);
        glvertex3f(94,-179,h);
        glvertex3f(96,-181,h);
        glend;
        glbegin(render);
        glvertex3f(94,-175,h);
        glvertex3f(86,-175,h);
        glvertex3f(86,-182,h);
        glvertex3f(89,-179,h);
        glvertex3f(94,-179,h);
        glend;
        glbegin(render);
        glvertex3f(86,-175,h);
        glvertex3f(85,-175,h);
        glvertex3f(82,-178,h);
        glvertex3f(82,-188,h);
        glvertex3f(85,-191,h);
        glvertex3f(86,-191,h);
        glend;
        glbegin(render);
        glvertex3f(89,-187,h);
        glvertex3f(86,-184,h);
        glvertex3f(86,-191,h);
        glvertex3f(94,-191,h);
        glvertex3f(94,-187,h);
        glend;
        glbegin(render);
        glvertex3f(96,-185,h);
        glvertex3f(94,-187,h);
        glvertex3f(94,-191,h);
        glvertex3f(98,-191,h);
        glvertex3f(100,-189,h);
        glvertex3f(100,-185,h);
        glend;
{----------------------------------------------------------}
{Letra A---------------------------------------------------}
        glbegin(render);
        glvertex3f(116,-175,0);
        glvertex3f(112,-175,0);
        glvertex3f(105,-190,0);
        glvertex3f(105,-191,0);
        glvertex3f(109,-191,0);
        glend;
        glbegin(render);
        glvertex3f(118,-175,0);
        glvertex3f(114,-175,0);
        glvertex3f(121,-191,0);
        glvertex3f(125,-191,0);
        glvertex3f(125,-190,0);
        glvertex3f(118,-175,0);
        glend;
        glbegin(render);
        glvertex3f(110,-185,0);
        glvertex3f(110,-188,0);
        glvertex3f(120,-188,0);
        glvertex3f(120,-185,0);
        glend;

                // Tampo dos lados
                glbegin(render);
                glvertex3f(112,-175,0);
                glvertex3f(118,-175,0);
                glvertex3f(118,-175,h);
                glvertex3f(112,-175,h);
                glend;
                glbegin(render);
                glvertex3f(105,-190,0);
                glvertex3f(112,-175,0);
                glvertex3f(112,-175,h);
                glvertex3f(105,-190,h);
                glend;
                glbegin(render);
                glvertex3f(105,-191,0);
                glvertex3f(105,-190,0);
                glvertex3f(105,-190,h);
                glvertex3f(105,-191,h);
                glend;
                glbegin(render);
                glvertex3f(109,-191,0);
                glvertex3f(105,-191,0);
                glvertex3f(105,-191,h);
                glvertex3f(109,-191,h);
                glend;
                glbegin(render);
                glvertex3f(111,-188,0);
                glvertex3f(109,-191,0);
                glvertex3f(109,-191,h);
                glvertex3f(111,-188,h);
                glend;
                glbegin(render);
                glvertex3f(119,-188,0);
                glvertex3f(111,-188,0);
                glvertex3f(111,-188,h);
                glvertex3f(119,-188,h);
                glend;
                glbegin(render);
                glvertex3f(121,-191,0);
                glvertex3f(119,-188,0);
                glvertex3f(119,-188,h);
                glvertex3f(121,-191,h);
                glend;
                glbegin(render);
                glvertex3f(125,-191,0);
                glvertex3f(121,-191,0);
                glvertex3f(121,-191,h);
                glvertex3f(125,-191,h);
                glend;
                glbegin(render);
                glvertex3f(125,-190,0);
                glvertex3f(125,-191,0);
                glvertex3f(125,-191,h);
                glvertex3f(125,-190,h);
                glend;
                glbegin(render);
                glvertex3f(118,-175,0);
                glvertex3f(125,-190,0);
                glvertex3f(125,-190,h);
                glvertex3f(118,-175,h);
                glend;

                glbegin(render);
                glvertex3f(115,-178,0);
                glvertex3f(112,-185,0);
                glvertex3f(112,-185,h);
                glvertex3f(115,-178,h);
                glend;
                glbegin(render);
                glvertex3f(118,-185,0);
                glvertex3f(115,-178,0);
                glvertex3f(115,-178,h);
                glvertex3f(118,-185,h);
                glend;
                glbegin(render);
                glvertex3f(112,-185,0);
                glvertex3f(118,-185,0);
                glvertex3f(118,-185,h);
                glvertex3f(112,-185,h);
                glend;

// letra A (altura)
        glbegin(render);
        glvertex3f(116,-175,h);
        glvertex3f(112,-175,h);
        glvertex3f(105,-190,h);
        glvertex3f(105,-191,h);
        glvertex3f(109,-191,h);
        glend;
        glbegin(render);
        glvertex3f(118,-175,h);
        glvertex3f(114,-175,h);
        glvertex3f(121,-191,h);
        glvertex3f(125,-191,h);
        glvertex3f(125,-190,h);
        glvertex3f(118,-175,h);
        glend;
        glbegin(render);
        glvertex3f(110,-185,0);
        glvertex3f(110,-188,0);
        glvertex3f(120,-188,0);
        glvertex3f(120,-185,0);
        glend;
{----------------------------------------------------------}
{Letra M---------------------------------------------------}
        glbegin(render);
        glvertex3f(135,-175,0);
        glvertex3f(130,-175,0);
        glvertex3f(130,-191,0);
        glvertex3f(134,-191,0);
        glvertex3f(134,-182,0);
        glend;
        glbegin(render);
        glvertex3f(144,-187,0);
        glvertex3f(135,-175,0);
        glvertex3f(134,-175,0);
        glvertex3f(134,-181,0);
        glvertex3f(141,-191,0);
        glvertex3f(144,-191,0);
        glend;
        glbegin(render);
        glvertex3f(153,-175,0);
        glvertex3f(144,-187,0);
        glvertex3f(144,-191,0);
        glvertex3f(146,-191,0);
        glvertex3f(153,-181,0);
        glend;
        glbegin(render);
        glvertex3f(157,-175,0);
        glvertex3f(152,-175,0);
        glvertex3f(153,-182,0);
        glvertex3f(153,-191,0);
        glvertex3f(157,-191,0);
        glend;

                // Tampo dos lados
                glbegin(render);
                glvertex3f(130,-175,0);
                glvertex3f(135,-175,0);
                glvertex3f(135,-175,h);
                glvertex3f(130,-175,h);
                glend;
                glbegin(render);
                glvertex3f(130,-191,0);
                glvertex3f(130,-175,0);
                glvertex3f(130,-175,h);
                glvertex3f(130,-191,h);
                glend;
                glbegin(render);
                glvertex3f(134,-191,0);
                glvertex3f(130,-191,0);
                glvertex3f(130,-191,h);
                glvertex3f(134,-191,h);
                glend;
                glbegin(render);
                glvertex3f(134,-182,0);
                glvertex3f(134,-191,0);
                glvertex3f(134,-191,h);
                glvertex3f(134,-182,h);
                glend;
                glbegin(render);
                glvertex3f(141,-191,0);
                glvertex3f(134,-181,0);
                glvertex3f(134,-181,h);
                glvertex3f(141,-191,h);
                glend;
                glbegin(render);
                glvertex3f(146,-191,0);
                glvertex3f(141,-191,0);
                glvertex3f(141,-191,h);
                glvertex3f(146,-191,h);
                glend;
                glbegin(render);
                glvertex3f(153,-181,0);
                glvertex3f(146,-191,0);
                glvertex3f(146,-191,h);
                glvertex3f(153,-181,h);
                glend;
                glbegin(render);
                glvertex3f(153,-191,0);
                glvertex3f(153,-181,0);
                glvertex3f(153,-181,h);
                glvertex3f(153,-191,h);
                glend;
                glbegin(render);
                glvertex3f(157,-191,0);
                glvertex3f(153,-191,0);
                glvertex3f(153,-191,h);
                glvertex3f(157,-191,h);
                glend;
                glbegin(render);
                glvertex3f(157,-175,0);
                glvertex3f(157,-191,0);
                glvertex3f(157,-191,h);
                glvertex3f(157,-175,h);
                glend;
                glbegin(render);
                glvertex3f(152,-175,0);
                glvertex3f(157,-175,0);
                glvertex3f(157,-175,h);
                glvertex3f(152,-175,h);
                glend;
                glbegin(render);
                glvertex3f(144,-187,0);
                glvertex3f(152,-175,0);
                glvertex3f(152,-175,h);
                glvertex3f(144,-187,h);
                glend;
                glbegin(render);
                glvertex3f(135,-175,0);
                glvertex3f(144,-187,0);
                glvertex3f(144,-187,h);
                glvertex3f(135,-175,h);
                glend;

//  Letra M (altura)
        glbegin(render);
        glvertex3f(135,-175,h);
        glvertex3f(130,-175,h);
        glvertex3f(130,-191,h);
        glvertex3f(134,-191,h);
        glvertex3f(134,-182,h);
        glend;
        glbegin(render);
        glvertex3f(144,-187,h);
        glvertex3f(135,-175,h);
        glvertex3f(134,-175,h);
        glvertex3f(134,-181,h);
        glvertex3f(141,-191,h);
        glvertex3f(144,-191,h);
        glend;
        glbegin(render);
        glvertex3f(153,-175,h);
        glvertex3f(144,-187,h);
        glvertex3f(144,-191,h);
        glvertex3f(146,-191,h);
        glvertex3f(153,-181,h);
        glend;
        glbegin(render);
        glvertex3f(157,-175,h);
        glvertex3f(152,-175,h);
        glvertex3f(153,-182,h);
        glvertex3f(153,-191,h);
        glvertex3f(157,-191,h);
        glend;
{----------------------------------------------------------}
{Letra P---------------------------------------------------}
        glbegin(render);
        glvertex3f(166,-175,0);
        glvertex3f(162,-175,0);
        glvertex3f(162,-191,0);
        glvertex3f(166,-191,0);
        glend;
        glbegin(render);
        glvertex3f(166,-179,0);
        glvertex3f(176,-179,0);
        glvertex3f(176,-175,0);
        glvertex3f(166,-175,0);
        glend;
        glbegin(render);
        glvertex3f(166,-187,0);
        glvertex3f(176,-187,0);
        glvertex3f(176,-183,0);
        glvertex3f(166,-183,0);
        glend;
        glbegin(render);
        glvertex3f(176,-187,0);
        glvertex3f(178,-187,0);
        glvertex3f(180,-185,0);
        glvertex3f(180,-177,0);
        glvertex3f(178,-175,0);
        glvertex3f(176,-175,0);
        glend;

                // Tampo dos lados
                glbegin(render);
                glvertex3f(162,-175,0);
                glvertex3f(178,-175,0);
                glvertex3f(178,-175,h);
                glvertex3f(162,-175,h);
                glend;
                glbegin(render);
                glvertex3f(162,-191,0);
                glvertex3f(162,-175,0);
                glvertex3f(162,-175,h);
                glvertex3f(162,-191,h);
                glend;
                glbegin(render);
                glvertex3f(166,-191,0);
                glvertex3f(162,-191,0);
                glvertex3f(162,-191,h);
                glvertex3f(166,-191,h);
                glend;
                glbegin(render);
                glvertex3f(166,-187,0);
                glvertex3f(166,-191,0);
                glvertex3f(166,-191,h);
                glvertex3f(166,-187,h);
                glend;
                glbegin(render);
                glvertex3f(178,-187,0);
                glvertex3f(166,-187,0);
                glvertex3f(166,-187,h);
                glvertex3f(178,-187,h);
                glend;
                glbegin(render);
                glvertex3f(180,-185,0);
                glvertex3f(178,-187,0);
                glvertex3f(178,-187,h);
                glvertex3f(180,-185,h);
                glend;
                glbegin(render);
                glvertex3f(180,-177,0);
                glvertex3f(180,-185,0);
                glvertex3f(180,-185,h);
                glvertex3f(180,-177,h);
                glend;
                glbegin(render);
                glvertex3f(178,-175,0);
                glvertex3f(180,-177,0);
                glvertex3f(180,-177,h);
                glvertex3f(178,-175,h);
                glend;


                glbegin(render);
                glvertex3f(166,-183,0);
                glvertex3f(176,-183,0);
                glvertex3f(176,-183,h);
                glvertex3f(166,-183,h);
                glend;
                glbegin(render);
                glvertex3f(176,-183,0);
                glvertex3f(176,-179,0);
                glvertex3f(176,-179,h);
                glvertex3f(176,-183,h);
                glend;
                glbegin(render);
                glvertex3f(176,-179,0);
                glvertex3f(166,-179,0);
                glvertex3f(166,-179,h);
                glvertex3f(176,-179,h);
                glend;
                glbegin(render);
                glvertex3f(166,-179,0);
                glvertex3f(166,-183,0);
                glvertex3f(166,-183,h);
                glvertex3f(166,-179,h);
                glend;
 

// Letra P (altura)
        glbegin(render);
        glvertex3f(166,-175,h);
        glvertex3f(162,-175,h);
        glvertex3f(162,-191,h);
        glvertex3f(166,-191,h);
        glend;
        glbegin(render);
        glvertex3f(166,-179,h);
        glvertex3f(176,-179,h);
        glvertex3f(176,-175,h);
        glvertex3f(166,-175,h);
        glend;
        glbegin(render);
        glvertex3f(166,-187,h);
        glvertex3f(176,-187,h);
        glvertex3f(176,-183,h);
        glvertex3f(166,-183,h);
        glend;
        glbegin(render);
        glvertex3f(176,-187,h);
        glvertex3f(178,-187,h);
        glvertex3f(180,-185,h);
        glvertex3f(180,-177,h);
        glvertex3f(178,-175,h);
        glvertex3f(176,-175,h);
        glend;
{----------------------------------------------------------}


end;

procedure primitiva_cilindro(x,y,raio,altura,pontos,render:integer);
var  i: integer;
     angulo: glfloat;
begin
//9 polygon  //3 lineloop

glcolor3f(1.0,0.0,0.0);
{tampa de baixo}
        glbegin(render);
        for i:=pontos downto 0 do
         begin
         angulo:=-2*pi*i/pontos;
         glvertex3f(x+raio*cos(angulo),y+raio*sin(angulo),altura);
         end;
        glend;

//abas laterais do cilindro (triangulos invertidos)
//glcolor3f(1.0,0.0,1.0);
        for i:=0 to pontos do
         begin
        glbegin(render);
         angulo:=2*3.1415*i/pontos;
         glvertex3f(x+raio*cos(angulo),y+raio*sin(angulo),0);
         glvertex3f(x+raio*cos(angulo),y+raio*sin(angulo),altura);
         angulo:=2*3.1415*(i+1)/pontos;
         glvertex3f(x+raio*cos(angulo),y+raio*sin(angulo),altura);
        glend;
         end;
//abas laterais do cilindro (triangulos posicao correta)
//glcolor3f(0.0,0.0,1.0);
        for i:=0 to pontos do
         begin
        glbegin(render);
         angulo:=2*3.1415*(i+1)/pontos;
         glvertex3f(x+raio*cos(angulo),y+raio*sin(angulo),altura);
         glvertex3f(x+raio*cos(angulo),y+raio*sin(angulo),0);
         angulo:=2*3.1415*i/pontos;
         glvertex3f(x+raio*cos(angulo),y+raio*sin(angulo),0);
        glend;
         end;


//glcolor3f(1.0,0.0,0.0);
{tampa de cima}
        glbegin(render);
        for i:=0 to pontos do
         begin
         angulo:=2*3.1415*i/pontos;
         glvertex3f(x+raio*cos(angulo),y+raio*sin(angulo),0);
         end;
        glend;
end;



procedure TForm1.FormPaint(Sender: TObject);
var extrude: integer;
begin
        if not openGLReady then exit;
        {background}
   glClearColor(1.0,1.0,1.0,0.0);
   glClear(GL_COLOR_BUFFER_BIT);
{----Coloque nesta parte o cdigo em OpenGL-----}
render:=9;
// desenha as 3 bolinhas do logo (cilindros)
extrude:=20;  // altura da extruso do cilindro
primitiva_cilindro(126,-14,6,extrude,10,render);
primitiva_cilindro(176,-91,6,extrude,10,render);
primitiva_cilindro(111,-138,6,extrude,10,render);
glcolor3f(0.0,0.0,0.0);
logo_abas_frente(extrude,render);
texto_unicamp(extrude,render);
{-----------------------------------------------}

   {error checking}
   errorCode := glGetError;
   if  errorCode<>GL_NO_ERROR then
      raise  Exception.Create('Error in Paint'#13+
         gluErrorString(errorCode));
end;


end.
