unit Logo;
{Roberto Scalco    RA 018131}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs,OpenGL, StdCtrls, ExtCtrls, Math;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormResize(Sender: TObject);

  private
    GLContext: HGLRC;  //o tipo HGLRC define o Contexto de Renderizao do OpenGL
    ErrorCode: GLenum;
    glDC: HDC;
    OpenGLReady: boolean;
    { Private declarations }
  public
    { Public declarations }
  end;

type
     HGLRC = Thandle;
     glFloat=single;
     GLenum=Cardinal;

var
  Form1: TForm1;
  rotX, rotY, rotZ, rotXo, rotYo, rotZo:real;
  mat_shininess,spot_cutoff, fat_constant, fat_linear, fat_quadratic, spot_exponent: real;

{
rotX -> Valor do estado atual do ngulo rotao em torno do eixo X
rotY -> Valor do estado atual do ngulo rotao em torno do eixo Y
rotZ -> Valor do estado atual do ngulo rotao em torno do eixo Z
rotXo -> Valor do inicial do ngulo rotao em torno do eixo X
rotYo -> Valor do inicial do ngulo rotao em torno do eixo Y
rotZo -> Valor do inicial do ngulo rotao em torno do eixo Z
}


const
  GL_NO_ERROR=0; //constante para quando nao houver erro

  np = 10; // nmero de subsivises em uma face

  // tipo de renderizao
  render = GL_POLYGON;       //renderizado
  //render = GL_LINE_STRIP;  // wireframe

  //volume de viso
  umin = -100;
  umax = 100;
  vmin = -100;
  vmax = 100;
  Front = -150;
  Back = 150;

  // valores em RGB da tonalidade de preto da tampa e dos lados
  RPtampa = 0;
  GPtampa = 0;
  BPtampa = 0;
  RPlado = 0.3;
  GPlado = 0.3;
  BPlado = 0.3;

  // valores em RGB da tonalidade de vermelho da tampa e dos lados dos cilindros
  RVtampa = 1;
  GVtampa = 0;
  BVtampa = 0;
  RVlado = 0.7;
  GVlado = 0;
  BVlado = 0.2;

// define valores das constantes
  spot_direction: array [1..3] of glFloat = (0.0, 0.0, -1.0); {vetor da direo do spot (x,y,z)}
  light_position:array [1..4] of GLFloat = (0.0, 0.0, -10.0, 0.0); {x,y,z,I}
  light_ambient: array [1..4] of glFloat = (0.2, 0.2, 0.2, 1.0); {RGBa}
  light_diffuse: array [1..4] of glFloat = (0.2, 0.2, 0.2, 1.0); {RGBa}
  light_especular: array [1..4] of glFloat = (0.8, 0.8, 0.8, 1.0); {RGBa}

  mat_ambient: array [1..4] of glFloat = (0.2, 0.2, 0.2, 1.0); {RGBa}
  mat_diffuse: array [1..4] of glFloat = (0.2, 0.2, 0.2, 1.0); {RGBa}
  mat_ambient_and_diffuse: array [1..4] of glFloat = (0.2, 0.2, 0.2, 1.0); {RGBa}
  mat_specular: array [1..4] of glFloat = (0.8, 0.8, 0.8, 1.0); {RGBa}
  mat_emission: array [1..4] of glFloat = (0.0, 0.0, 0.0, 1.0); {RGBa}

implementation

{$R *.dfm}

procedure Triangulo(x0,y0,x1,y1,x2,y2,x3,y3,h:real);
begin
glTranslatef(x0,y0,0);

  // base z=0
  glColor3f(RPtampa,GPtampa,BPtampa);
  glBegin(render);
    glVertex3f(x1,y1,0);
    glVertex3f(x2,y2,0);
    glVertex3f(x3,y3,0);
  glEnd;

  // tampa z=h
  glBegin(render);
    glVertex3f(x1,y1,h);
    glVertex3f(x2,y2,h);
    glVertex3f(x3,y3,h);
  glEnd;

  //paredes
  glColor3f(RPlado,GPlado,BPlado);
  glBegin(render);
    glVertex3f(x1,y1,0);
    glVertex3f(x2,y2,0);
    glVertex3f(x2,y2,h);
    glVertex3f(x1,y1,h);
  glEnd;

  glBegin(render);
    glVertex3f(x2,y2,0);
    glVertex3f(x3,y3,0);
    glVertex3f(x3,y3,h);
    glVertex3f(x2,y2,h);
  glEnd;

  glBegin(render);
    glVertex3f(x3,y3,0);
    glVertex3f(x1,y1,0);
    glVertex3f(x1,y1,h);
    glVertex3f(x3,y3,h);
  glEnd;

glTranslatef(-x0,-y0,0);
end;


procedure Quadrado(x0,y0,x1,y1,x2,y2,x3,y3,x4,y4,h:real);
begin
glTranslatef(x0,y0,0);

  // base z=0
  glColor3f(RPtampa,GPtampa,BPtampa);
  glBegin(render);
    glVertex3f(x1,y1,0);
    glVertex3f(x2,y2,0);
    glVertex3f(x3,y3,0);
    glVertex3f(x4,y4,0);
  glEnd;

  // tampa z=h
  glBegin(render);
    glVertex3f(x1,y1,h);
    glVertex3f(x2,y2,h);
    glVertex3f(x3,y3,h);
    glVertex3f(x4,y4,h);
  glEnd;

  //paredes
  glColor3f(RPlado,GPlado,BPlado);
  glBegin(render);
    glVertex3f(x1,y1,0);
    glVertex3f(x2,y2,0);
    glVertex3f(x2,y2,h);
    glVertex3f(x1,y1,h);
  glEnd;

  glBegin(render);
    glVertex3f(x2,y2,0);
    glVertex3f(x3,y3,0);
    glVertex3f(x3,y3,h);
    glVertex3f(x2,y2,h);
  glEnd;

  glBegin(render);
    glVertex3f(x3,y3,0);
    glVertex3f(x4,y4,0);
    glVertex3f(x4,y4,h);
    glVertex3f(x3,y3,h);
  glEnd;

  glBegin(render);
    glVertex3f(x4,y4,0);
    glVertex3f(x1,y1,0);
    glVertex3f(x1,y1,h);
    glVertex3f(x4,y4,h);
  glEnd;

glTranslatef(-x0,-y0,0);
end;


procedure Redondo(X0,Y0, X1,Y1,R1,A1,D1, X2,Y2,R2,A2,D2 ,h:real);
var i: integer;
begin
glTranslate(x0,y0,0);

  A1 := DegToRad(A1);  // ngulo interno inicial
  D1 := DegToRad(D1);  // variao do ngulo interno
  A2 := DegToRad(A2);  // ngulo externo inicial
  D2 := DegToRad(D2);  // variao do ngulo externo

  glColor3f(RVtampa,GVtampa,BVtampa);
  // desenha np quadrilteros convexos para cada superfcie
  for i := 0 to np-1 do
    begin
    //desenha a base
    glColor3f(RPtampa,GPtampa,BPtampa);
    glBegin(render);
      glVertex3f(x1+R1*cos(A1+D1*(i/np)),y1+R1*sin(A1+D1*(i/np)),0.0);
      glVertex3f(x1+R1*cos(A1+D1*((i+1)/np)),y1+R1*sin(A1+D1*((i+1)/np)),0.0);
      glVertex3f(x2+R2*cos(A2+D2*((i+1)/np)),y2+R2*sin(A2+D2*((i+1)/np)),0.0);
      glVertex3f(x2+R2*cos(A2+D2*(i/np)),y2+R2*sin(A2+D2*(i/np)),0.0);
    glEnd;

    //desenha a tampa
    glBegin(render);
      glVertex3f(x1+R1*cos(A1+D1*(i/np)),y1+R1*sin(A1+D1*(i/np)),h);
      glVertex3f(x1+R1*cos(A1+D1*((i+1)/np)),y1+R1*sin(A1+D1*((i+1)/np)),h);
      glVertex3f(x2+R2*cos(A2+D2*((i+1)/np)),y2+R2*sin(A2+D2*((i+1)/np)),h);
      glVertex3f(x2+R2*cos(A2+D2*(i/np)),y2+R2*sin(A2+D2*(i/np)),h);
    glEnd;

    //desenha a curva interna
    glColor3f(RPlado,GPlado,BPlado);
    glBegin(render);
      glVertex3f(x1+R1*cos(A1+D1*(i/np)),y1+R1*sin(A1+D1*(i/np)),0.0);
      glVertex3f(x1+R1*cos(A1+D1*((i+1)/np)),y1+R1*sin(A1+D1*((i+1)/np)),0.0);
      glVertex3f(x1+R1*cos(A1+D1*((i+1)/np)),y1+R1*sin(A1+D1*((i+1)/np)),h);
      glVertex3f(x1+R1*cos(A1+D1*(i/np)),y1+R1*sin(A1+D1*(i/np)),h);
    glEnd;

    //desenha a curva externa
    glBegin(render);
      glVertex3f(x2+R2*cos(A2+D2*(i/np)),y2+R2*sin(A2+D2*(i/np)),0.0);
      glVertex3f(x2+R2*cos(A2+D2*((i+1)/np)),y2+R2*sin(A2+D2*((i+1)/np)),0.0);
      glVertex3f(x2+R2*cos(A2+D2*((i+1)/np)),y2+R2*sin(A2+D2*((i+1)/np)),h);
      glVertex3f(x2+R2*cos(A2+D2*(i/np)),y2+R2*sin(A2+D2*(i/np)),h);
    glEnd;
    end;

glTranslate(-x0,-y0,0);
end;

procedure cilindro(r,h,x,y,z:real);
var i: integer;
begin
glTranslate(x,y,z);

  glColor3f(RVtampa,GVtampa,BVtampa);
  //desenha a base
  glBegin(render);
    for i := 0 to np-1 do
      begin
      glVertex3f(r*cos(2*pi*i/np),r*sin(2*pi*i/np),0.0);
      end;
  glEnd;

  //desenha a tampa
  glBegin(render);
    for i := 0 to np-1 do
      begin
      glVertex3f(r*cos(2*pi*i/np),r*sin(2*pi*i/np),h);
      end;
  glEnd;

  glColor3f(RVlado,GVlado,BVlado);
  // desenha a superfcie externa
  for i := 0 to np-1 do
    begin
    glBegin(render);
      glVertex3f(r*cos(2*pi*i/np),r*sin(2*pi*i/np),h);
      glVertex3f(r*cos(2*pi*(i+1)/np),r*sin(2*pi*(i+1)/np),h);
      glVertex3f(r*cos(2*pi*(i+1)/np),r*sin(2*pi*(i+1)/np),0.0);
      glVertex3f(r*cos(2*pi*i/np),r*sin(2*pi*i/np),0.0);
    glend;
    end;

glTranslate(-x,-y,-z);
end;

procedure UniPoligono(xo,yo,ang,delta,r,ang1,dlt1,ri,h:real);
var i: integer;
begin

ang := DegToRad(ang);       // ngulo externo inicial
delta := DegToRad(delta);   // variao do ngulo externo
ang1 := DegToRad(ang1);     // ngulo interno inicial
dlt1 := DegToRad(dlt1);     // variao do ngulo interno

for i := 0 to np-1 do
  begin
  //(0.0,0.0,0.8);
  glColor3f(RPtampa,GPtampa,BPtampa);
  // desenha a base
  glBegin(render);
    glVertex3f(xo+r*cos(ang+delta*i/np),yo+r*sin(ang+delta*i/np),0);
    glVertex3f(xo+r*cos(ang+delta*(i+1)/np),yo+r*sin(ang+delta*(i+1)/np),0);
    glVertex3f(ri*cos(ang1+dlt1*(i+1)/np),ri*sin(ang1+dlt1*(i+1)/np),0);
    glVertex3f(ri*cos(ang1+dlt1*i/np),ri*sin(ang1+dlt1*i/np),0);
  glend;

  // desenha a tampa
  glBegin(render);
    glVertex3f(xo+r*cos(ang+delta*i/np),yo+r*sin(ang+delta*i/np),h);
    glVertex3f(xo+r*cos(ang+delta*(i+1)/np),yo+r*sin(ang+delta*(i+1)/np),h);
    glVertex3f(ri*cos(ang1+dlt1*(i+1)/np),ri*sin(ang1+dlt1*(i+1)/np),h);
    glVertex3f(ri*cos(ang1+dlt1*i/np),ri*sin(ang1+dlt1*i/np),h);
  glend;

  //(0,0,0.2);
  glColor3f(RPlado,GPlado,BPlado);
  // desenha a face externa
  glBegin(render);
    glVertex3f(xo+r*cos(ang+delta*i/np),yo+r*sin(ang+delta*i/np),h);
    glVertex3f(xo+r*cos(ang+delta*(i+1)/np),yo+r*sin(ang+delta*(i+1)/np),h);
    glVertex3f(xo+r*cos(ang+delta*(i+1)/np),yo+r*sin(ang+delta*(i+1)/np),0);
    glVertex3f(xo+r*cos(ang+delta*i/np),yo+r*sin(ang+delta*i/np),0);
  glend;

  //(0,0,0.7);
  // desenha a face interna
  glBegin(render);
    glVertex3f(ri*cos(ang1+dlt1*i/np),ri*sin(ang1+dlt1*i/np),h);
    glVertex3f(ri*cos(ang1+dlt1*(i+1)/np),ri*sin(ang1+dlt1*(i+1)/np),h);
    glVertex3f(ri*cos(ang1+dlt1*(i+1)/np),ri*sin(ang1+dlt1*(i+1)/np),0);
    glVertex3f(ri*cos(ang1+dlt1*i/np),ri*sin(ang1+dlt1*i/np),0);
  glend;

  end;

//(0,0,0.5);
// desenha os planos verticais
glBegin(render);
  glVertex3f(xo+r*cos(ang+delta),yo+r*sin(ang+delta),0);
  glVertex3f(xo+r*cos(ang+delta),yo+r*sin(ang+delta),h);
  glVertex3f(ri*cos(ang1+dlt1),ri*sin(ang1+dlt1),h);
  glVertex3f(ri*cos(ang1+dlt1),ri*sin(ang1+dlt1),0);
glend;

//(0,0,0.1);
glBegin(render);
  glVertex3f(xo+r*cos(ang),yo+r*sin(ang),0);
  glVertex3f(xo+r*cos(ang),yo+r*sin(ang),h);
  glVertex3f(ri*cos(ang1),ri*sin(ang1),h);
  glVertex3f(ri*cos(ang1),ri*sin(ang1),0);
glend;

end;

//este cdigo prepara o windows e o Delphi para trabalhar com OpenGL
procedure TForm1.FormCreate(Sender: TObject);
var
    pfd: TpixelFormatDescriptor;
    FormatIndex: Integer;
begin
// define o tamanho do formulrio em pixels
ClientHeight := 480;
ClientWidth := 600;



// *********************  CONFIGURAES DO OPENGL  ****************************
fillchar(pfd,SizeOf(pfd),0);
with pfd do                     //parametros do descriptor
begin
   nSize:=SizeOf(pfd);          //define o tamanho da estrutura
   nVersion:=1;                 //a verso atual do descriptor  1
   dwFlags:=PFD_DRAW_TO_WINDOW or PFD_DOUBLEBUFFER;
   iPixelType:=PFD_TYPE_RGBA;
   cColorBits:=24;              //suporta 24-bit color
   cDepthBits:=32;              //profundidade do eixo Z
   iLayerType:=PFD_MAIN_PLANE;
end;
glDC:=getDC(handle);
FormatIndex:=ChoosePixelFormat(glDC,@pfd); //mapeamento
if FormatIndex=0 then
   raise Exception.Create('ChoosePixelFormat failed'+IntToStr(GetLastError));

//seta o formato do pixel para um formato a ser utilizado no OpenGL
if not SetPixelFormat(glDC,FormatIndex,@pfd) then
   raise Exception.Create('SetPixelFormat failed'+IntToStr(GetLastError));

//GLContext recebe uma das funces GL do windows para se encarregar dos contextos de renderizao necessrios na janela
GLContext:=wglCreateContext(glDC);
if GLContext=0 then
   raise Exception.Create('wglCreateContext failed'+IntToStr(GetLastError));

//faz com que o contexto definido seja usado de agora em diante
if not wglMakeCurrent(glDC,GLContext) then
   raise Exception.Create('wglMakeCurrent failed'+IntToStr(GetLastError));
OpenGLReady:=true;
// ****************  FIM DAS CONFIGURAES DO OPENGL  *************************

// define os ngulos do estado inicial
rotXo := 0;
rotYo := 0;
rotZo := 0;
rotX := rotXo;
rotY := rotYo;
rotZ := rotZo;

// define o volume de interesse
glOrtho(umin,umax,vmin,vmax,Front,Back);


spot_exponent := 0.0;     // expoente de decaimento da intensidade
spot_cutoff := 180.0;     // angulo de abrangencia da fonte spot
fat_constant := 1.0;      // coeficiente do termo constante do fator de atenuacao
fat_linear := 0.0;        // coeficiente do termo linear do fator de atenuacao
fat_quadratic := 10.0;    // coeficiente do termo quadratico do fator de atenuacao
mat_shininess :=  5.0;   // n

glEnable(GL_LIGHTING);
glEnable(GL_LIGHT0);

glDepthFunc(GL_LESS);
glEnable(GL_DEPTH_TEST);

glClearColor (0.0, 0.0, 0.0, 0.0);

glShadeModel (GL_SMOOTH);

glMaterialfv(GL_FRONT, GL_AMBIENT, @mat_ambient);
glMaterialfv(GL_FRONT, GL_DIFFUSE, @mat_diffuse);
glMaterialfv(GL_FRONT, GL_SPECULAR, @mat_specular);
glMaterialf(GL_FRONT, GL_SHININESS, mat_shininess);
glMaterialfv(GL_FRONT, GL_EMISSION, @mat_emission);

glClear (GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);

  glPushMatrix ();
  // config aclaramentos
  glLightfv (GL_LIGHT0, GL_POSITION, @light_position);

  glLightfv (GL_LIGHT0, GL_AMBIENT, @light_ambient);
  glLightfv (GL_LIGHT0, GL_DIFFUSE, @light_diffuse);
  glLightfv (GL_LIGHT0, GL_SPECULAR, @light_especular);

  glLightfv (GL_LIGHT0, GL_SPOT_DIRECTION, @spot_direction);
  glLightf (GL_LIGHT0, GL_SPOT_EXPONENT, spot_exponent);
  glLightf (GL_LIGHT0, GL_SPOT_CUTOFF, spot_cutoff);

  glLightf (GL_LIGHT0, GL_CONSTANT_ATTENUATION, fat_constant);
  glLightf (GL_LIGHT0, GL_LINEAR_ATTENUATION, fat_linear);
  glLightf (GL_LIGHT0, GL_QUADRATIC_ATTENUATION, fat_quadratic);
  glPopMatrix ();



end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
// ***************  CONFIGURAES ENCERRAMENTO DO OPENGL  *********************
wglMakeCurrent(Canvas.Handle,0);
wglDeleteContext(GLContext);
// ****************  FIM DAS CONFIGURAES DO OPENGL  *************************
end;

procedure TForm1.FormPaint(Sender: TObject);
var i: integer;
    h, ri: real;
begin
if not openGLReady then exit;   //checagem de erro

glClearColor(1.0,1.0,1.0,1.0);  //seleciona a cor do fundo dado pelos parametros RGBA
glClear(GL_COLOR_BUFFER_BIT);
glClear(GL_DEPTH_BUFFER_BIT);   //habilita visibildade de objetos que esto na frente
glEnable(GL_DEPTH_TEST);


// ************************  DESENHANDO A IMAGEM  *****************************
h := 20;    // altura da extruso
ri := 24;   // raio interno

  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

  glScalef(1,1,1);
  // rotaciona o objeto
  glRotatef (rotX, 1.0, 0.0, 0.0);
  glRotatef (rotY, 0.0, 1.0, 0.0);
  glRotatef (rotZ, 0.0, 0.0, 1.0);

  // desenha as fatias
  UniPoligono( 81.240,   0.00, 125.2552, 42.7425,  10.00,   4.6971,  0.0000, ri, h);
  UniPoligono(-179.711, -68.10,  16.545,  4.1589, 265.82,  4.6971, 12.7507, ri, h);
  UniPoligono( -66.290, -24.64,  22.2006, 10.2277, 144.00,  27.0211, 13.1703, ri, h);
  UniPoligono(   8.790,  25.45,  36.7097, 18.5996,  53.38,  49.7020, 12.7840, ri, h);
  UniPoligono( 31.670,  75.56, 258.6713, 59.4439,  10.00,  62.4860,  0.0000, ri, h);
  UniPoligono( 31.670,  75.56, 170.3292, 65.2060,  10.00,  72.0415,  0.0000, ri, h);
  UniPoligono(   0.240,  -2.53,  74.7492, 13.800,   82.58,  72.0976, 11.9556, ri, h);
  UniPoligono(   1.140,  11.55,  92.9370, 22.2837,  68.49,  96.5274, 11.0774, ri, h);
  UniPoligono(   2.970,   4.83, 117.1409, 20.6784,  75.31, 117.1229, 13.1816, ri, h);
  UniPoligono(  -4.620,  10.17, 139.8985, 22.3965,  66.11, 139.9496, 12.7084, ri, h);
  UniPoligono(  12.930,  16.28, 172.6573, 17.5114,  82.03, 162.2937, 13.0930, ri, h);
  UniPoligono(  19.600,  30.01, 201.1410, 13.0579,  91.45, 184.9244, 12.7276, ri, h);
  UniPoligono(  11.030,  41.88, 225.2233, 12.4855,  92.84, 207.1525, 12.1559, ri, h);
  UniPoligono(  -3.220,  22.72, 242.0099, 37.1856,  69.10, 229.7767, 57.4260, ri, h);
  UniPoligono( 17.720, -44.19, 122.2013, 65.0773,  10.00, 287.0306,  0.0000, ri, h);
  UniPoligono( 17.720, -44.19,  31.8347, 67.6796,  10.00, 296.7720,  0.0000, ri, h);
  UniPoligono( -48.010, 116.22, 295.5535,  2.4305, 172.01, 296.6622, 13.4981, ri, h);
  UniPoligono( -57.580, 135.10, 299.0139, 13.7509, 193.11, 319.7026, 35.5490, ri, h);
  UniPoligono( 81.240,   0.00, 187.8288, 35.1029,  10.00, 355.1336,  0.0000, ri, h);

  // desenha os cilindors
  cilindro(7,h,31.67,75.56,0);
  cilindro(7,h,81.24,0,0);
  cilindro(7,h,17.72,-44.19,0);

  //Letra U
  Quadrado(-68,-78, 0,0, 0,-12.2, 4.46,-10, 4.46,0, h);
  Redondo(-68,-78,6.64,-9.84,2.19,184.72,80.6,3.83,-12.2,3.83,179.99,90.03,h);
  Quadrado(-68,-78,3.83,-16,16.33,-16,13.7,-12,6.46,-12,h);
  Redondo(-68,-78,13.52,-9.84,2.19,274.73,80.55,16.35,-12.2,3.83,269.49,90.51,h);
  Quadrado(-68,-78,15.7,-10,20.16,-12.2,20.2,0,15.70,0,h);

  //Letra N
  Quadrado(-44,-78,0,0,0,-16,4.66,-16,4.66,-5.48,h);
  Triangulo(-44,-78,0,0,4.66,-5.48,6.81,0,h);
  Quadrado(-44,-78,4.66,-5.48,13.6,-16,16.1,-10.96,6.81,0,h);
  Triangulo(-44,-78,13.6,-16,20.84,-16,16.1,-10.96,h);
  Quadrado(-44,-78,16.1,-10.96,20.84,-16,20.84,0,16.1,0,h);

  //Letra I
  Quadrado(-19,-78,0,0,0,-16,4.46,-16,4.46,0,h);

  //Letra C
  Quadrado(-10.2057,-82.0282,0,0,0,-8,4.46,-6,4.46,-2,h);
  Redondo(-10.2057,-82.0282,6.75,-2.3,2.32,88.29,83.93,4.04,0.01,4.04,95.94,84.21,h);
  Quadrado(-10.2057,-82.0282,4.46,-12.02,14.44,-12.02,11.68,-8,6.69,-8,h);
  Redondo(-10.2057,-82.0282,6.74,-5.7,2.3,187.32,81.42,4.58,-7.38,4.62,187.59,83.9,h);
  Triangulo(-10.2057,-82.0282,13.35,-6.19,17.78,-8.32,17.78,-6.19,h);
  Triangulo(-10.2057,-82.0282,13.35,-1.85,17.78,-1.85,17.78,0.3,h);
  Redondo(-10.2057,-82.0282, 11.3,-5.97, 2.08, 278.26,75.72, 14.06,-8.32, 3.72, 276,84.11,h);
  Quadrado(-10.2057,-82.0282,6.69, 0 ,11.35,0,13.68,+4,3.62,+4,h);
  Redondo(-10.2057,-82.0282,11.3,-2.07,2.07,6,85.48,13.68,-0.15,4.16,6.21,83.82,h);

  //Letra A
  Quadrado(17.36,-78,0,0,-3.28,-7.93,0.91,-9.48,3.65,-2.735,h);
  Quadrado(17.36,-78,-3.28,-7.93,-6.56,-15.86,-0.73,-13.31,0.91,-9.48,h);
  Triangulo(17.36,-78,-6.56,-15.86,-1.82,-15.86,-0.73,-13.31,h);
  Quadrado(17.36,-78,-0.73,-13.31,8.20,-13.31,6.38,-9.48,0.91,-9.48,h);
  Triangulo(17.36,-78,8.20,-13.31,8.93,-15.86,14.03,-15.86,h);
  Quadrado(17.36,-78,8.20,-13.31,14.03,-15.86,10.66,-7.93,6.38,-9.48,h);
  Quadrado(17.36,-78,6.38,-9.48,10.66,-7.93,7.29,0,3.65,-2.735,h);
  Triangulo(17.36,-78,0,0,3.65,-2.735,7.29,0,h);

  //Letra M
  Quadrado(35.2,-78,0,0,0,-16,4.46,-16,4.46,-6.93,h);
  Triangulo(35.2,-78,0,0,4.46,-6.93,5.13,0,h);
  Quadrado(35.2,-78,4.46,-6.93,10.29,-16,13.17,-12.5,5.13,0,h);
  Triangulo(35.2,-78,10.29,-16,16.11,-16,13.17,-12.5,h);
  Quadrado(35.2,-78,13.17,-12.5,16.11,-16.03,21.26,-7.44,20.66,0,h);
  Triangulo(35.2,-78,20.66,0,21.26,-7.44,25.72,0,h);
  Quadrado(35.2,-78,21.26,-7.44,21.26,-16,25.72,-16,25.72,0,h);

  //Letra P
  Quadrado(65,-78,0,0,0,-16,4.74,-16,4.74,-4.2,h);
  Quadrado(65,-78,0,0,4.74,-4.2,11.85,-4.2,14.03,0,h);
  Redondo(65,-78,11.85,-6.2,2,0,90.09,13.78,-4.47,4.48,5.92,80.74,h);
  Triangulo(65,-78,13.85,-6.2,18.23,-8.383,18.23,-4,h);
  Redondo(65,-78,  11.85,-6.2,2,270,90.09,13.73,-8.08,4.50,273.82,82.38,h);
  Quadrado(65,-78,4.74,-12.58, 14.03,-12.58,11.85,-8.2, 4.74,-8.2,h);


SwapBuffers(glDC);
// **************************  FIM DO DESENHO  ********************************


//checagem de erros
errorCode:=glGetError;
if errorCode<>GL_NO_ERROR then
 raise Exception.Create('Erro no Paint'#13+gluErrorString(errorCode));

end;

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
// Incrementa o ngulo de rotao em torno do eixo X
if UpperCase(Key) = 'X' then
  begin
  rotx := rotx + 5;
  Form1.paint;
  end;
// Incrementa o ngulo de rotao em torno do eixo X
if UpperCase(Key) = 'Y' then
  begin
  roty := roty + 5;
  Form1.paint;
  end;
// Incrementa o ngulo de rotao em torno do eixo X
if UpperCase(Key) = 'Z' then
  begin
  rotz := rotz + 5;
  Form1.paint;
  end;
// Retorna a imagem para o estado inicial
if Key = #27 then
  begin
  rotX := rotXo;
  rotY := rotYo;
  rotZ := rotZo;
  Form1.paint;
  end;
end;

// altera as dimenses do objeto para se adequar ao tamanho da tela
procedure TForm1.FormResize(Sender: TObject);
begin
    glViewport(0, 0, width, height);
	glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    if width <= height then glOrtho(umin, umax, vmin*height/width, vmax*height/width, Front, Back)
      else glOrtho(umin*width/height, umax*width/height, vmin, vmax, Front, Back);
    Form1.paint;
end;

end.

