unit UDither;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs,OpenGL, StdCtrls, ExtCtrls, Math, Menus, Gauges, ExtDlgs;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Arquivo1: TMenuItem;
    Abrir1: TMenuItem;
    OpenDialog1: TOpenDialog;
    Ajuda1: TMenuItem;
    ManualdoUsurio1: TMenuItem;
    ComponentesdoGrupo1: TMenuItem;
    Exemplo1: TMenuItem;
    Prximo1: TMenuItem;
    N2: TMenuItem;
    Sair1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure Abrir1Click(Sender: TObject);
    procedure ManualdoUsurio1Click(Sender: TObject);
    procedure ComponentesdoGrupo1Click(Sender: TObject);
    procedure Sair1Click(Sender: TObject);
    procedure Prximo1Click(Sender: TObject);
    procedure Exemplo1Click(Sender: TObject);
    procedure FormClick(Sender: TObject);


  private
    GLContext: HGLRC;  //o tipo HGLRC define o Contexto de Renderizao do OpenGL
    ErrorCode: GLenum;
    glDC: HDC;
    OpenGLReady: boolean;
    { Private declarations }
  public
    { Public declarations }
  end;

type
     HGLRC = Thandle;
     glFloat=single;
     GLenum=Cardinal;
     TTela = array of array of Byte;
     THist = array of byte;


var
  Form1: TForm1;
  cont, ordem, W, H, Larg, Alt:integer;
  RespOrder, RespBayer, RespFloyd: TTela;
  Hist: THist;
  Img: TTela;
  media: Real;

const
  GL_NO_ERROR=0; //constante para quando nao houver erro

  //volume de viso
  umin = -2;
  umax = 2;
  vmin = -2;
  vmax = 2;
  Front = -150;
  Back = 150;


implementation

uses UProgress, UHistograma;

{$R *.dfm}


//Prepara o Windows e o Delphi para trabalhar com OpenGL
procedure TForm1.FormCreate(Sender: TObject);
var
    pfd: TpixelFormatDescriptor;
    FormatIndex: Integer;
begin
// define o tamanho do formulrio em pixels
ClientHeight := 600;
ClientWidth := 600;
Form1.Color := clWhite;

// *********************  CONFIGURAES DO OPENGL  ****************************
fillchar(pfd,SizeOf(pfd),0);
with pfd do                     //parametros do descriptor
begin
   nSize:=SizeOf(pfd);          //define o tamanho da estrutura
   nVersion:=1;                 //a verso atual do descriptor  1
   dwFlags:=PFD_DRAW_TO_WINDOW;  //ou PDF_SUPPORT_OPENGL
   iPixelType:=PFD_TYPE_RGBA;
   cColorBits:=24;              //suporta 24-bit color
   cDepthBits:=32;              //profundidade do eixo Z
   iLayerType:=PFD_MAIN_PLANE;
end;
glDC:=getDC(handle);
FormatIndex:=ChoosePixelFormat(glDC,@pfd); //mapeamento
if FormatIndex=0 then
   raise Exception.Create('ChoosePixelFormat failed'+IntToStr(GetLastError));

//seta o formato do pixel para um formato a ser utilizado no OpenGL
if not SetPixelFormat(glDC,FormatIndex,@pfd) then
   raise Exception.Create('SetPixelFormat failed'+IntToStr(GetLastError));

//GLContext recebe uma das funces GL do windows para se encarregar dos contextos de renderizao necessrios na janela
GLContext:=wglCreateContext(glDC);
if GLContext=0 then
   raise Exception.Create('wglCreateContext failed'+IntToStr(GetLastError));

//faz com que o contexto definido seja usado de agora em diante
if not wglMakeCurrent(glDC,GLContext) then
   raise Exception.Create('wglMakeCurrent failed'+IntToStr(GetLastError));
OpenGLReady:=true;
// ****************  FIM DAS CONFIGURAES DO OPENGL  *************************


// define o volume de interesse
glOrtho(umin,umax,vmin,vmax,Front,Back);

// contagem da tela
cont := 0;
Prximo1.Enabled := False;
SetLength(img,100,100);
end;


// para encerrar o software
procedure TForm1.FormDestroy(Sender: TObject);
begin
wglMakeCurrent(Canvas.Handle,0);
wglDeleteContext(GLContext);
end;


// desenha a imagem do parmetro Img na posio (x,y) do OpenGL
Procedure desenhaOpenGL(x,y:integer;Img:TTela);
var vetor: array of Byte;
    c, i, j: integer;
begin
// define o tamanho do vetor
SetLength(vetor, W*H);
Form1.ClientWidth := W;
Form1.ClientHeight := H;

// ponteiro do vetor
for i := 0 to W-1 do
  for j := 0 to H-1 do
    begin
    // transformao da estrutura bidimensional para unidimensional
    if W mod 4 = 0 then vetor[j*(w) + i] := Img[i,(H-1)-j]
      else vetor[j*(w+(4-W mod 4)) + i] := Img[i,(H-1)-j];
    end;
// desenha a imagem, sob a forma de vetor, na tela
with Form1 do
  begin
  glRasterPos2i(x, y);
  glDrawPixels(W,H,GL_LUMINANCE,GL_UNSIGNED_BYTE,vetor);
  end;
end;


// gera um vetor contendo as ocorrncias de cada intensidade de acordo com
//   a posio do vetor (0 -> n)
procedure Histograma(n: Integer; var media: real; Img: TTela; var Hist: THist);
var i,j: integer;
begin
// n -> 2^x
SetLength(hist,n);

// zera valores do Histograma
for i := 0 to n do Hist[i] := 0;
media := 0;

for i := 0 to W-1 do
  begin
  for j := 0 to H-1 do
    begin
    // incrementa as ocorrncias de cada instesidade
    Hist[Img[i,j] div (n)] := Hist[Img[i,j] div (n)] + 1;
    media := media + img[i,j];
    end;
  end;

// valor mdio das intensidades da imagem
media := media / ((W-1)*(H-1));
end;


// diviso dos nveis de cinza
procedure OrderedDither(Hist:THist; var Mascara:TTela);
var i: integer;
    ph: array [1..16] of Byte;
begin
// ordem da matriz
ordem := 4;
SetLength(Mascara,ordem,ordem);

// gera os ordem valores dos limites, igualmente espeados.
for i := 1 to ordem*ordem do ph[i] := round(255*i/(ordem*ordem));

// distribuio dos limites na mscara
Mascara[0,0] := ph[12];
Mascara[0,1] := ph[11];
Mascara[0,2] := ph[10];
Mascara[0,3] := ph[9];

Mascara[1,0] := ph[13];
Mascara[1,1] := ph[1];
Mascara[1,2] := ph[2];
Mascara[1,3] := ph[8];

Mascara[2,0] := ph[14];
Mascara[2,1] := ph[4];
Mascara[2,2] := ph[3];
Mascara[2,3] := ph[11];

Mascara[3,0] := ph[15];
Mascara[3,1] := ph[16];
Mascara[3,2] := ph[5];
Mascara[3,3] := ph[6];
end;


// diviso dos nveis de cinza
procedure Bayer(img:TTela; var Mascara:TTela);
begin
// ordem da matriz
ordem := 4;
SetLength(Mascara,ordem,ordem);

// distribuio dos limites na mscara
Mascara[0,0] :=  1 * (255 div (ordem*ordem));
Mascara[0,1] :=  9 * (255 div (ordem*ordem));
Mascara[0,2] :=  3 * (255 div (ordem*ordem));
Mascara[0,3] := 11 * (255 div (ordem*ordem));

Mascara[1,0] := 13 * (255 div (ordem*ordem));
Mascara[1,1] :=  5 * (255 div (ordem*ordem));
Mascara[1,2] := 15 * (255 div (ordem*ordem));
Mascara[1,3] :=  7 * (255 div (ordem*ordem));

Mascara[2,0] :=  4 * (255 div (ordem*ordem));
Mascara[2,1] := 12 * (255 div (ordem*ordem));
Mascara[2,2] :=  2 * (255 div (ordem*ordem));
Mascara[2,3] := 10 * (255 div (ordem*ordem));

Mascara[3,0] := 16 * (255 div (ordem*ordem));
Mascara[3,1] :=  8 * (255 div (ordem*ordem));
Mascara[3,2] := 14 * (255 div (ordem*ordem));
Mascara[3,3] :=  6 * (255 div (ordem*ordem));
end;


// faz comparao de cada grupo da matriz com a mscara
procedure Dither(Img, Mascara:TTela; var ODither:TTela);
var i,j: integer;
begin
SetLength(ODither,W,H);

for i:= 0 to W-1 do
  for j := 0 to H-1 do
   begin
   // comparao com a mscara
   if Img[i,j] >= Mascara[i mod ordem, j mod ordem]
      then ODither[i,j] := 255 //cor branca
      else ODither[i,j] := 0;  //cor preta
    end;
end;


// aplicao do mtodo Floyd-Steinberg
procedure FloydSteinberg(media:real;Img:TTela; var FS:TTela);
var i, j, cont: integer;
    Erro: real;
begin
SetLength(FS,W,H);

// ajusta a mdia para melhor efeito de visualizao da imagem
media := media;

// aplica os pesos sem considerar as bordas
for j := 1  to H-2 do
  begin
  for i := 1 to W-2 do
    begin
    // calcula o erro
    erro := img[i,j] - media;

    // verifica qual o limite (0 ou 255) mais prximo do ponto [i,j]
    if erro > 0 then FS[i,j] := 255
      else FS[i,j] := 0;

    // a condio satura a luminncia da imagem em 0 ou 255
    if Img[i+1,j] + round(7/16*Erro) > 255 then FS[i+1,j] := 255
      else
      begin
      if Img[i+1,j] + round(7/16*Erro) < 0 then FS[i+1,j] := 0
             // caso no esteja saturado, aplica a distribuio de energia
        else FS[i+1,j] := Img[i+1,j] + round(7/16*Erro);
      end;

    // a condio satura a luminncia da imagem em 0 ou 255
    if Img[i-1,j+1] + round(3/16*Erro) > 255 then FS[i-1,j+1] := 255
      else
      begin
      if Img[i-1,j+1] + round(3/16*Erro) < 0 then FS[i-1,j+1] := 0
             // caso no esteja saturado, aplica a distribuio de energia
        else FS[i-1,j+1] := Img[i-1,j+1] + round(3/16*Erro);
      end;

    // a condio satura a luminncia da imagem em 0 ou 255
    if Img[i,j+1] + round(5/16*Erro) > 255 then FS[i,j+1] := 255
      else
      begin
      if Img[i,j+1] + round(5/16*Erro) < 0 then FS[i,j+1] := 0
             // caso no esteja saturado, aplica a distribuio de energia
        else FS[i,j+1] := Img[i,j+1] + round(5/16*Erro);
      end;

    // a condio satura a luminncia da imagem em 0 ou 255
    if Img[i+1,j+1] + round(1/16*Erro) > 255 then FS[i+1,j+1] := 255
      else
      begin
      if Img[i+1,j+1] + round(1/16*Erro) < 0 then FS[i+1,j+1] := 0
             // caso no esteja saturado, aplica a distribuio de energia
        else FS[i+1,j+1] := Img[i+1,j+1] + round(1/16*Erro);
      end;
    end;
  end;
end;


// preenche o parmetro com os valores dos tons de cinza do arquivo aberto
Procedure LerArquivo;
var a,intL,cont,pgmW,pgmH,px,py,i,j,c:integer;
    arq: TextFile;
    str,spc,tamanho,linha: string;
    bmp: TBitmap;
    corR, corG, corB, corMedia: Byte;
begin

// abre o arquivo para verificar o tipo
Reset(arq,Form1.OpenDialog1.FileName);
Readln(arq,linha);

// verifica se o arquivo  pgm
if uppercase(linha) = 'P2' then
  begin

  repeat
  Readln(arq,linha);     // Tamanho
  until linha[1] <> '#'; // Retirando os comentrios

  str := '';
  i := 0;
  repeat
    Inc(i);
    str := str + linha[i];
  until linha[i+1] = ' ';
  W := StrToInt(str);      // Largura da imagem
  H := StrToInt(copy(linha,i+2,length(linha)-i));  // Altura da imagem

  Readln(arq,linha);     // Luminncia mxima

//  Finalize(Img);
  SetLength(img,W,H);    // define o tamanho da imagem
  i := 0;
  j := 0;
  c := 0;
  while not eof(arq) do  // repete at chegar ao final do arquivo
    begin
    Readln(arq,linha);   // l uma linha contendo 17 valores
    str := '';
    for a:= 0 to 16 do
      begin
        str := copy(linha,4*a+1,3);  // copia 3 dos 4 caracteres de intensidade
        if str <> '' then
          begin
          Img[i,j] := StrToInt(str); // atribui na matriz da imagem
          // ajuste dos ndices da imagem
          Inc(i);
          if i = W then
            begin
            i := 0;
            Inc(j);
            end;
        end;
    end;
  end;
  CloseFile(arq);  //fecha o arquivo PGM
  end

  else
  begin
  // Verifica se o arquivo  um bmp
  if uppercase(copy(linha,0,2)) = 'BM' then
    begin
    // cria uma varivel do tipo TBitmap
    bmp := TBitmap.Create;
    bmp.LoadFromFile (Form1.OpenDialog1.FileName);

    W := 4*(bmp.Width div 4);
    H := 4*(bmp.Height div 4);
    // ajusta o a tamanho da varivel de acordo com o tamanho da imagem
//    Finalize(Img);
    SetLength(Img,W,H);

    c:=0;
    form2.Show; //barra de progresso
    for i := 0 to W-1 do
      begin
      // barra de progresso de converso do arquivo
      Form2.Gauge1.Progress := round(100*c/((bmp.Width-1)*(bmp.Height-1)));
      for j := 0 to H-1 do
        begin
        c:=c+1;  // contador da barra
        // decompe as cores de cada pixel
        corR := GetRValue(bmp.Canvas.Pixels[i,j]);
        corG := GetGValue(bmp.Canvas.Pixels[i,j]);
        corB := GetBValue(bmp.Canvas.Pixels[i,j]);
        // gera imagem com tons de cinza
        corMedia := (corB + corG + corR) div 3;
        //corMedia := round(0.31*corR + 0.8124*corG + 0.01*corB);
        bmp.Canvas.Pixels[i,j] := corMedia shl 16 or corMedia shl 8 or corMedia;
        Img[i,j] := bmp.Canvas.Pixels[i,j];
       end;
      end;
    bmp.Destroy;
    Form2.Close;
    end

    else
    begin
    for i:= 0 to W-1 do
      for j := 0 to H-1 do
        Img[i,j] := 0;
    ShowMessage('Este no  um arquivo vlido!');
    end;
  end;
end;


// executado cada vez que a imagem  redesenhada
procedure TForm1.FormPaint(Sender: TObject);
begin
//checagem de erro
if not openGLReady then exit;

errorCode:=glGetError;
if errorCode<>GL_NO_ERROR then
 raise Exception.Create('Erro no Paint'#13+gluErrorString(errorCode));
end;

procedure Abreimagem(nome: String);
var i:integer;
    cor: TColor;
begin
    cont := 0;
    // completa a matriz IMG com a luminncia da figura do arquivo
    if nome <> 'Exemplo' then LerArquivo;
    // completa o vetor HIST com as ocorrncias das luminncias, divididas em 17 nveis
    Histograma(16,media,Img,Hist);

    Form1.Width := 600;
    Form1.Height := 600;

    // plota histograma no form3
    Form3.Series1.Clear;
    for i:= 0 to 16 do
      begin
      cor:= trunc(255*i/16) or trunc(255*i/16) shl 8 or trunc(255*i/16) shl 16;
      form3.Series1.Add(trunc(hist[i]),IntToStr(i)+#13+'('+inttostr(trunc(255*i/16))+')',cor);
      end;
    Form3.Chart1.Title.Text.Clear;
    Form3.Chart1.Title.Text.Add('Luminncia da imagem ' + ExtractFileName(Nome));
    form3.ShowModal;
    Mouse.CursorPos := Point(Form1.Left+Form1.Width+15,Form1.Top+15);
    Form1.Exemplo1.Enabled := False;
    Form1.Abrir1.Enabled := False;

    Form1.Caption := 'Quantizao da imagem ' + ExtractFileName(Nome);
    Form1.Prximo1.Enabled := True;
    Form1.Prximo1.Click;


end;

// quando o sub menu Abrir for clicado
procedure TForm1.Abrir1Click(Sender: TObject);
begin
// atualiza a tela
cont := cont - 1;
Prximo1.Click;

//seleciona a cor do fundo dado pelos parametros RGBA
glClearColor(1.0,1.0,1.0,1.0);

// verifica o diretrio onde o programa est posicionado
Form1.OpenDialog1.InitialDir := ExtractFilePath(Application.ExeName);
If Form1.OpenDialog1.Execute then
  begin
  If Form1.OpenDialog1.FileName <> '' then
    begin
    Abreimagem(Form1.OpenDialog1.FileName);
    end;
  end;
end;


// quando o sub menu Manual do Usurio for clicado
procedure TForm1.ManualdoUsurio1Click(Sender: TObject);
var texto: string;
begin
// atualiza a tela
cont := cont - 1;
Prximo1.Click;

texto := '';
texto := texto + 'Para abrir uma nova imagem:' + #13;
texto := texto + 'Arquivo -> Abrir (F2)' + #13;
texto := texto + 'Selecione uma imagem BMP ou PGM e clique em Abrir.' + #13;
texto := texto + #13;
texto := texto + 'O histograma com a distribuio dos tons de cinza  exibido.' + #13;
texto := texto + 'Para fechar o hitograma clique no X no canto superior direito.' + #13;
texto := texto + '' + #13;
texto := texto + 'Para verificar os resultados dos mtodos deve-se clicar sobre o' + #13;
texto := texto + 'menu Arquivo -> Prximo (F3).' + #13;
texto := texto + '' + #13;
texto := texto + 'Este passo deve ser repetido para a exibio dos resultados de ' + #13;
texto := texto + 'cada um dos mtodos.' + #13;
ShowMessage(texto);
// atualiza a tela
cont := cont - 1;
Prximo1.Click;
end;


// quando o sub menu Componentes do Grupo for clicado
procedure TForm1.ComponentesdoGrupo1Click(Sender: TObject);
var texto: string;
begin
// atualiza a tela
cont := cont - 1;
Prximo1.Click;

texto := 'Componentes do grupo:' + #13 + #13;
texto := texto + '026349 - Armindo Ramos da Fonte Jnior' + #13;
texto := texto + '018131 - Roberto Scalco';
ShowMessage(texto);

// atualiza a tela
cont := cont - 1;
Prximo1.Click;
end;

// encerra o aplicativo
procedure TForm1.Sair1Click(Sender: TObject);
begin

Finalize(Img);
Finalize(Hist);

Application.Terminate;
end;

// imagem exemplo
procedure TForm1.Exemplo1Click(Sender: TObject);
var i,j: integer;
    bmp: TBitmap;
begin
// determina o tamanho da imagem e da tela
Form1.ClientWidth := 600;
Form1.ClientHeight := 600;
W := Form1.ClientWidth;
H := Form1.ClientHeight;

//Finalize(Img);
SetLength(Img,W,H);

// completa a imagem
for i:= 0 to W-1 do
  begin
  for j := 0 to H-1 do
    begin
    Img[i,j] := trunc(255*i*j/((W-1)*(H-1)));
    end;
  end;
Abreimagem('Exemplo');
end;


procedure TForm1.Prximo1Click(Sender: TObject);
var Mascara: TTela;
begin
case cont of
  0: begin
     // desenha a imagem original no segundo quadrante
     desenhaOpenGL(umin, vmin,Img);
     end;
  1: begin
     // calcula a mscara
     OrderedDither(Hist,Mascara);
     // completa a matriz RESPORDER com a nova imagem processada
     Dither(Img,Mascara,RespOrder);
     // desenha a imagem no primeiro quadrante
     desenhaOpenGL(umin, vmin, RespOrder);
     Finalize(RespOrder);
     Form1.Caption := Form1.Caption + ' (Ordered Dithering)';
     end;
  2: begin
     // calcula a mscara
     Bayer(Img,Mascara);
     // completa a matriz RESPBAYER com a nova imagem processada
     Dither(Img,Mascara,RespBayer);
     // desenha a imagem no terceiro quadrante
     desenhaOpenGL(umin, vmin, RespBayer);
     Finalize(RespBayer);
     Form1.Caption := copy(Form1.Caption,1,length(Form1.Caption)-20) + ' (Bayer)';
     end;
  3: begin
     // completa a matriz RESPFLOYD com a nova imagem processada
     FloydSteinberg(media,Img,RespFloyd);
     // desenha a imagem no quarto quadrante
     desenhaOpenGL(umin, vmin, RespFloyd);
     Finalize(RespFloyd);
     Form1.Caption := copy(Form1.Caption,1,length(Form1.Caption)-8) + ' (Floyd-Steinberg)';
     end;
   end;
cont := cont + 1;
end;


procedure TForm1.FormClick(Sender: TObject);
begin
// atualiza a tela quando no escolhe nada do menu
cont := cont - 1;
Prximo1.Click;
end;

end.

