//## begin module.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module.cm

//## begin module.cp preserve=no
//## end module.cp

//## Module: Graph; Package body
//## Subsystem: Graphics
//## Source file: D:\Computao_Grfica\opengl_prog\showgeo\Graphics\Graph.cpp


//## begin module.additionalIncludes preserve=no
//## end module.additionalIncludes

//## begin module.includes preserve=yes
#include <GL/glut.h>
#include <stdlib.h>
//## end module.includes

// Mesh
#include "GeoMesh\Mesh.h"
// Dictionary
#include "Data\Dictnary.h"
// Element
#include "Elements\Element.h"
// Segment
#include "Segments\Segment.h"
// Node
#include "Nodes\Node.h"
// Graph
#include "Graphics\Graph.h"

//## begin module.declarations preserve=no
//## end module.declarations

//## begin module.additionalDeclarations preserve=yes
//## end module.additionalDeclarations


// Class Graph 







Graph::Graph()
  //## begin Graph::Graph%.hasinit preserve=no
      : numberofnodes(0), numberofelements(0), numberofsegments(0)
  //## end Graph::Graph%.hasinit
  //## begin Graph::Graph%.initialization preserve=yes
  //## end Graph::Graph%.initialization
{
  //## begin Graph::Graph%.body preserve=yes
  //## end Graph::Graph%.body
}



//## Other Operations (implementation)
void Graph::give_All_Attributes_List(Graph& theGraph, char str[80])
{
  //## begin Graph::give_All_Attributes_List%1047945987.body preserve=yes

	Dictionary theDictionary;	
	NodeList theNodeList;
	SegmentList theSegmentList;
	ElementList theElementList;
	Mesh theMesh;
  
	theDictionary.set_DictionaryName (str);
	
	char* posi=NULL;
	long int pose=0;
	int wordcode=0;
	enum dictwords {wMeshPar=1, wNodes, wSegments, wElements};

  theDictionary.add_Word("MeshPar",wMeshPar);
	theDictionary.add_Word("Nodes",wNodes);
	theDictionary.add_Word("Segments",wSegments);
	theDictionary.add_Word("Elements",wElements);
	
	while (!theDictionary.check_EndOfDictionary ()){
		theDictionary.give_NextDictionaryWordCode (wordcode);     
		
		switch (wordcode){
		case 0:
			break;

    case wMeshPar:
			Mesh::give_CurrentWordInterpretation(theDictionary, theMesh);
			break;

		case wNodes:
			Node::give_CurrentWordInterpretation(theDictionary, theNodeList);
			break;
			
		case wSegments:
			Segment::give_CurrentWordInterpretation(theDictionary,
				theNodeList, theSegmentList);
			break;

		case wElements:
			Element::give_CurrentWordInterpretation(theDictionary,
				theNodeList, theElementList);
			break;
		}
	}
	
	theGraph.set_theNodeList(theNodeList);
	theGraph.set_theSegmentList(theSegmentList);
	theGraph.set_theElementList(theElementList);

	theGraph.set_numberofnodes(theNodeList.get_numberofobjects());
	theGraph.set_numberofsegments(theSegmentList.get_numberofobjects());
	theGraph.set_numberofelements(theElementList.get_numberofobjects());


	//theGraph.set_numberofnodes(theNodeList.get_numberofobjects());
  //## end Graph::give_All_Attributes_List%1047945987.body
}

void Graph::give_Draw_Polygon(double deep, long int list_dim, Graph& theGraph)
{
  //## begin Graph::give_Draw_Polygon%1048180252.body preserve=yes

		  
	  double x, y;
  	long int i = 0;
		glColor3f(0.8, 0.8, 0.8);

    if (theGraph.get_numberofnodes()==29 )
		{
      glColor3f(0.4, 0.0, 0.0);
		}


		glBegin(GL_POLYGON);

		for ( i = 1; i <= list_dim; i++) {
    
		   x = theGraph.get_theNodeList().give_theObjectAt(i)->get_x();
			 y = theGraph.get_theNodeList().give_theObjectAt(i)->get_y();
		
	    glVertex3f(x,y,deep);
 		}
		glEnd();


  //## end Graph::give_Draw_Polygon%1048180252.body
}

void Graph::give_Draw_Side_Polygon(long int list_size, double z_value, Graph& theGraph)
{
  //## begin Graph::give_Draw_Side_Polygon%1049730929.body preserve=yes

	  double x, y, z;
  	long int i = 0;
    glColor3f(0.0, 0.0, 0.5);
		
		if (theGraph.get_numberofnodes()==29)
		{
      glColor3f(1.0, 0.0, 0.0);
		}
		
		for ( i = 1; i <= list_size; i++) {

		glBegin(GL_POLYGON);


    if(i<list_size) {

			x = theGraph.get_theNodeList().give_theObjectAt(i)->get_x();
			y = theGraph.get_theNodeList().give_theObjectAt(i)->get_y();
			z = theGraph.get_theNodeList().give_theObjectAt(i)->get_z();
		
	    glVertex3f(x,y,z);
			glVertex3f(x,y,z_value);

			x = theGraph.get_theNodeList().give_theObjectAt(i+1)->get_x();
			y = theGraph.get_theNodeList().give_theObjectAt(i+1)->get_y();
			z = theGraph.get_theNodeList().give_theObjectAt(i+1)->get_z();
		
	    glVertex3f(x,y,z_value);
			glVertex3f(x,y,z);
		}

		if(i==list_size) {

			x = theGraph.get_theNodeList().give_theObjectAt(i)->get_x();
			y = theGraph.get_theNodeList().give_theObjectAt(i)->get_y();
			z = theGraph.get_theNodeList().give_theObjectAt(i)->get_z();
		
	    glVertex3f(x,y,z);
			glVertex3f(x,y,z_value);

			x = theGraph.get_theNodeList().give_theObjectAt(1)->get_x();
			y = theGraph.get_theNodeList().give_theObjectAt(1)->get_y();
			z = theGraph.get_theNodeList().give_theObjectAt(1)->get_z();
		
	    glVertex3f(x,y,z_value);
			glVertex3f(x,y,z);
		}

		glEnd();
		}

		glColor3f(0, 0, 0);


  //## end Graph::give_Draw_Side_Polygon%1049730929.body
}

void Graph::give_Show_Mesh(Graph& theGraph)
{
  //## begin Graph::give_Show_Mesh%1055720530.body preserve=yes

		double x1, x2, x3, y1, y2, y3, z1, z2, z3;

		for ( long int i = 1; i <= theGraph.get_numberofelements(); i++) {

			
  	   x1 = theGraph.get_theElementList().give_theObjectAt(i)->
				 get_theNodeList().give_theObjectAt(1)->get_x();

			 y1 = theGraph.get_theElementList().give_theObjectAt(i)->
				 get_theNodeList().give_theObjectAt(1)->get_y();

			 z1 = theGraph.get_theElementList().give_theObjectAt(i)->
				 get_theNodeList().give_theObjectAt(1)->get_z();


			 x2 = theGraph.get_theElementList().give_theObjectAt(i)->
				 get_theNodeList().give_theObjectAt(2)->get_x();

			 y2 = theGraph.get_theElementList().give_theObjectAt(i)->
				 get_theNodeList().give_theObjectAt(2)->get_y();

			 z2 = theGraph.get_theElementList().give_theObjectAt(i)->
				 get_theNodeList().give_theObjectAt(2)->get_z();


       x3 = theGraph.get_theElementList().give_theObjectAt(i)->
				 get_theNodeList().give_theObjectAt(3)->get_x();

			 y3 = theGraph.get_theElementList().give_theObjectAt(i)->
				 get_theNodeList().give_theObjectAt(3)->get_y();

			 z3 = theGraph.get_theElementList().give_theObjectAt(i)->
				 get_theNodeList().give_theObjectAt(3)->get_z();
		
		
		  glColor3f(0, 0, 1);
		
			glBegin(GL_POLYGON);
			 
      glVertex3f(x1,y1,z1);
			glVertex3f(x2,y2,z2);
			glVertex3f(x3,y3,z3);
      
      glEnd();

			glColor3f(1, 1, 1);

			glLineWidth(1.5);
			glBegin(GL_LINE_STRIP);
			 
      glVertex3f(x1,y1,z1);
			glVertex3f(x2,y2,z2);
			glVertex3f(x3,y3,z3);
			glVertex3f(x1,y1,z1);
      
      glEnd();
		
		}



  //## end Graph::give_Show_Mesh%1055720530.body
}


// Additional Declarations
//## begin Graph.declarations preserve=yes



//## end Graph.declarations




