//## begin module.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module.cm

//## begin module.cp preserve=no
//## end module.cp

//## Module: showgeo; Main program
//## Subsystem: <Top Level>
//## Source file: D:\Computao_Grfica\opengl_prog\showgeo\showgeo.cpp


//## begin module.additionalIncludes preserve=no
//## end module.additionalIncludes

//## begin module.includes preserve=yes
#include <GL/glut.h>
#include <stdlib.h>
#include <iostream.h>
#include <math.h>
//## end module.includes

// Mesh
#include "GeoMesh\Mesh.h"
// Dictionary
#include "Data\Dictnary.h"
// Triag
#include "Elements\Triag.h"
// Element
#include "Elements\Element.h"
// Node
#include "Nodes\Node.h"
// list
#include "Lists\list.h"
// list
#include "Lists\list.cpp"
// Graph
#include "Graphics\Graph.h"
// Segment
#include "Segments\Segment.h"


//## begin module.declarations preserve=no
//## end module.declarations

//## begin module.additionalDeclarations preserve=yes

GLfloat rotX = 0.0, rotY = 0.0, rotZ = 0.0;



void init(void) 
{

  glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

	GLfloat mat_specular[] = { 1, 1, 1, 1 };
	GLfloat mat_shininess[] = { 50 };
	GLfloat light1_position[] = { 2.5, 1 , -0.25, 1};
	GLfloat light2_position[] = { 3.3, 0 , -0.2, 1};
	GLfloat white_light[] = { 1, 1, 1, 1 };
	GLfloat lmodel_ambient[] = { 0, 0, 0, 0};
	glClearColor( 0, 0, 0, 0 );
	glShadeModel(GL_SMOOTH);
	glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
  glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess);
	glLightfv(GL_LIGHT0, GL_POSITION, light1_position);
  glLightfv(GL_LIGHT0, GL_DIFFUSE, white_light);
  glLightfv(GL_LIGHT0, GL_SPECULAR, white_light);
	glLightfv(GL_LIGHT1, GL_POSITION, light2_position);
  glLightfv(GL_LIGHT1, GL_DIFFUSE, white_light);
  glLightfv(GL_LIGHT1, GL_SPECULAR, white_light);
	glLightModelfv(GL_LIGHT_MODEL_AMBIENT, lmodel_ambient);

	//glLightModeli(GL_LIGHT_MODEL_COLOR_CONTROL, GL_SEPARATE_SPECULAR_COLOR);


	glLightf(GL_LIGHT2, GL_SPOT_CUTOFF, 45);
	
	GLfloat spot_direction[] = { -1, -1, -1};
	glLightfv(GL_LIGHT2, GL_SPOT_DIRECTION, spot_direction);


	glColorMaterial(GL_FRONT_AND_BACK, GL_DIFFUSE);



	glEnable(GL_COLOR_MATERIAL);
  glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	glEnable(GL_LIGHT1);
	glEnable(GL_LIGHT2);
	glEnable(GL_DEPTH_TEST);

}


void keyboard(unsigned char key, int x, int y)
{
   switch (key) {
   /* Finalizar quando a tecla <ESC> e' apertada */
      case 27:
         exit(0);
         break;
         /* Incremento de 5 no angulo de rotacao em torno de x */
      case 'x':
         rotX += 1.0;
         break;
         /* Incremento de 5 no angulo de rotacao em torno de y */
      case 'y':
         rotY += 1.0;
         break;
         /* Incremento de 5 no angulo de rotacao em torno de z */
      case 'z':
         rotZ += 1.0;
         break;
			case 'a':
         rotX -= 1.0;
         break;
         /* Incremento de 5 no angulo de rotacao em torno de y */
      case 'b':
         rotY -= 1.0;
         break;
         /* Incremento de 5 no angulo de rotacao em torno de z */
      case 'c':
         rotZ -= 1.0;
         break;
   }
   /* Forcar a atualizacao da area de desenho */
   glutPostRedisplay();  
}

void display()
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glPushMatrix();

  //glTranslatef(-2.2, -1.0, 0.0);

  glRotatef(rotX, 1.0, 0.0, 0.0);
  glRotatef(rotY, 0.0, 1.0, 0.0);
  glRotatef(rotZ, 0.0, 0.0, 1.0);
	
	// MOSTRA O CONTORNO DA GEOMETRIA
  
	Graph theGraph;
	double deep = -0.2;
	theGraph.give_All_Attributes_List(theGraph, "logo_unicamp_geo.m");


	long int num_seg = theGraph.get_theSegmentList().get_numberofobjects();
  long int i = 0;

/*
	glLineWidth(2);
	glBegin(GL_LINES);

		double xi, yi, zi, xf, yf, zf;

		for ( i = 0; i < num_seg; i++) {
    
		   xi = theGraph.get_theSegmentList().give_theObjectAt(i+1)->get_theNodeList().give_FirstObject()->get_x();
			 yi = theGraph.get_theSegmentList().give_theObjectAt(i+1)->get_theNodeList().give_FirstObject()->get_y();
			 zi = theGraph.get_theSegmentList().give_theObjectAt(i+1)->get_theNodeList().give_FirstObject()->get_z();
			 
			 xf = theGraph.get_theSegmentList().give_theObjectAt(i+1)->get_theNodeList().give_LastObject()->get_x();
			 yf = theGraph.get_theSegmentList().give_theObjectAt(i+1)->get_theNodeList().give_LastObject()->get_y();
       zf = theGraph.get_theSegmentList().give_theObjectAt(i+1)->get_theNodeList().give_LastObject()->get_z();
		
	    glVertex3f(xi, yi, zf);
      glVertex3f(xf, yf, zf);
		}

		glEnd();
    
*/
 
    // MOSTRA A GEOMETRIA SLIDA
		
	  //Graph theGraph;		
		//glColor3f(0.0, 0.0, 1.0);
    //theGraph.give_All_Attributes_List(theGraph, "dmc_refp6_b.m");
		//theGraph.give_Show_Mesh(theGraph);
		

		//GEOMETRIA 1
		glColor3f(0.3, 0.3, 0.3);
	  theGraph.give_All_Attributes_List(theGraph, "parte1.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		glColor3f(0.8, 0.8, 0.8);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		//GEOMETRIA 2
		glColor3f(0.3, 0.3, 0.3);
		theGraph.give_All_Attributes_List(theGraph, "parte2.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		glColor3f(0.8, 0.8, 0.8);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		//GEOMETRIA 3
		glColor3f(0.3, 0.3, 0.3);
		theGraph.give_All_Attributes_List(theGraph, "parte3a.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		glColor3f(0.8, 0.8, 0.8);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte3b.m");
		glColor3f(0.3, 0.3, 0.3);
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		glColor3f(0.8, 0.8, 0.8);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte3c.m");
		glColor3f(0.3, 0.3, 0.3);
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		glColor3f(0.8, 0.8, 0.8);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte3d.m");
		glColor3f(0.3, 0.3, 0.3);
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		glColor3f(0.8, 0.8, 0.8);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte3e.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

    //GEOMETRIA 4
		theGraph.give_All_Attributes_List(theGraph, "parte4a.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte4b.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte4c.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte4d.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		
		theGraph.give_All_Attributes_List(theGraph, "parte4e.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte4f.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte4g.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
			
		theGraph.give_All_Attributes_List(theGraph, "parte4h.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte4i.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

    //GEOMETRIA 5
		theGraph.give_All_Attributes_List(theGraph, "parte5a.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte5b.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte5c.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte5d.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

    //GEOMETRIA 6
		theGraph.give_All_Attributes_List(theGraph, "parte6a.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte6b.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte6c.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte6d.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		//GEOMETRIA 7
		theGraph.give_All_Attributes_List(theGraph, "parte7a.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte7b.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte7c.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte7d.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte7e.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte7f.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte7g.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

    //GEOMETRIA 8
		theGraph.give_All_Attributes_List(theGraph, "parte8.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		//GEOMETRIA 9
		theGraph.give_All_Attributes_List(theGraph, "parte9a.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte9b.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte9c.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		
		//GEOMETRIA 10 - CIRCLE
		glColor3f(1.0, 0.0, 0.0);
		theGraph.give_All_Attributes_List(theGraph, "parte10.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		//GEOMETRIA 11 - CIRCLE
		glColor3f(1.0, 0.0, 0.0);
		theGraph.give_All_Attributes_List(theGraph, "parte11.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		//GEOMETRIA 12 - CIRCLE
		glColor3f(1.0, 0.0, 0.0);
		theGraph.give_All_Attributes_List(theGraph, "parte12.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		glColor3f(0.0, 0.0, 0.0);

		//GEOMETRIA 13
		theGraph.give_All_Attributes_List(theGraph, "parte13.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		//GEOMETRIA 14
		theGraph.give_All_Attributes_List(theGraph, "parte14.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		//GEOMETRIA 15
		theGraph.give_All_Attributes_List(theGraph, "parte15.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		//GEOMETRIA 16
		theGraph.give_All_Attributes_List(theGraph, "parte16a.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte16b.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte16c.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte16d.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		theGraph.give_All_Attributes_List(theGraph, "parte16e.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		//GEOMETRIA 17
		theGraph.give_All_Attributes_List(theGraph, "parte17.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		//GEOMETRIA 18
		theGraph.give_All_Attributes_List(theGraph, "parte18.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		//GEOMETRIA 19
		theGraph.give_All_Attributes_List(theGraph, "parte19.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		//GEOMETRIA 20
		theGraph.give_All_Attributes_List(theGraph, "parte20.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		//GEOMETRIA 21
		theGraph.give_All_Attributes_List(theGraph, "parte21.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		//GEOMETRIA 22
		theGraph.give_All_Attributes_List(theGraph, "parte22.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		//GEOMETRIA 23
		theGraph.give_All_Attributes_List(theGraph, "parte23.m");
		theGraph.give_Draw_Polygon(0,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);
		theGraph.give_Draw_Side_Polygon(
			theGraph.get_theNodeList().get_numberofobjects(), deep, theGraph);
		theGraph.give_Draw_Polygon(deep,theGraph.get_theNodeList().get_numberofobjects(),
			theGraph);

		glPopMatrix();
	  glutSwapBuffers();

}

void reshape (int w, int h)
{
  /* Definir as dimensoes da janela de saida */
   glViewport (0, 0, (GLsizei) w, (GLsizei) h);
   /* Chavear para a matriz de projecao */
   glMatrixMode (GL_PROJECTION);
   /* Carregar com a matriz identidade */
   glLoadIdentity ();
   /* Projecao Paralela */
   //glOrtho (20,0, 30, -50, 5.0, 5.0);
	 glOrtho (1.2, 2.9, 0, 1.8 , -5.0, 5.0);
   /* Chavear para a matriz de transformacoes geometricas */
   glMatrixMode (GL_MODELVIEW);

}

void main(int argc, char** argv) {

	
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB);
	glutInitWindowSize(680,720);
	glutInitWindowPosition(10,10);
	glutCreateWindow(argv[0]);
	init();
	glutDisplayFunc(display);
	glutReshapeFunc(reshape);
	glutKeyboardFunc(keyboard); 
	glutMainLoop();
  

}



//## end module.additionalDeclarations




