#include "main.h"
#include <math.h>

tActor::tActor (char *filename, CVector3& scale) 
{  
  model.load(filename);
  model.center();
  model.scale(scale.x/2,scale.y/2,scale.z/2);  
  set_size((int)ceil(scale.x),(int)ceil(scale.z));
  set_position(0,0);
}

tActor::tActor () 
{
}


tActor::~tActor () 
{
  delete &model;
  delete &cxt;
}

void tActor::moveto(tGrid* grid, float col, float row) 
{
  float x,y;

  if (sizex%2)
    x = (col-grid->ncols/2)*grid->dx + (sizex *grid->dx/2.) ;
  else{
    x = (col-grid->ncols/2)*grid->dx + (sizex/2 *grid->dx) ;
  }
  if (sizey%2)
    y = (grid->nrows/2-row)*grid->dy - (sizey *grid->dy/2.) ;
  else{
    y = (grid->nrows/2-row)*grid->dy - (sizey/2 *grid->dy) ;
  }
  glTranslatef(x,y,0);
}

void tActor::flip() 
{
  int tmp;
  tmp = sizex;
  sizex = sizey;
  sizey = tmp;
}

void tActor::render(bool isday) 
{
  // Since we know how many objects our model has, go through each of them.
  for(int i = 0; i < model.numOfObjects; i++)
      {
      // Make sure we have valid objects just in case.
        if(model.pObject.size() <= 0) break;

        // Get the current object that we are displaying
        t3DObject *pObject = &model.pObject[i];
            
        // Check to see if this object has a texture map, if so bind the texture to it.
        if(pObject->bHasTexture) {
	  
	  // Turn on texture mapping and turn off color
	  glEnable(GL_TEXTURE_2D);
	  
	  // Reset the color to normal again
	  glColor3ub(255, 255, 255);
	  
	  // Bind the texture map to the object by it's materialID
	  glBindTexture(GL_TEXTURE_2D, model.g_Texture[pObject->materialID]);
        } else {
	  
	  // Turn off texture mapping and turn on color
	  glDisable(GL_TEXTURE_2D);
	  
	  // Reset the color to normal again
	  glColor3ub(255, 255, 255);
        }
	
        // This determines if we are in wireframe or normal mode
        // Begin drawing with our selected mode (triangles or lines)
        glBegin(cxt.g_ViewMode);  
	
	// Go through all of the faces (polygons) of the object and draw them
	for(int j = 0; j < pObject->numOfFaces; j++)
	  {
	    // Go through each corner of the triangle and draw it.
	    for(int whichVertex = 0; whichVertex < 3; whichVertex++)
	      {
		// Get the index for each point of the face
		int index = pObject->pFaces[j].vertIndex[whichVertex];
		
		// Give OpenGL the normal for this vertex.
		glNormal3f(pObject->pNormals[ index ].x, pObject->pNormals[ index ].y, pObject->pNormals[ index ].z);
                
		// If the object has a texture associated with it, give it a texture coordinate.
		if(pObject->bHasTexture) {
		  
		  // Make sure there was a UVW map applied to the object or else it won't have tex coords.
		  if(pObject->pTexVerts) {
		    glTexCoord2f(pObject->pTexVerts[ index ].x, pObject->pTexVerts[ index ].y);
		  }
		} else {
		  
		  // Make sure there is a valid material/color
		  // assigned to this object.  You should always at
		  // least assign a material color to an object, but
		  // just in case we want to check the size of the
		  // material list.  if the size is at least one, and
		  // the material ID != -1, then we have a valid
		  // material.
		  if(model.pMaterials.size() && pObject->materialID >= 0) 
		    {
		      // Get and set the color that the object is, since it must not have a texture

                      if (strncmp(pObject->strName,"WINDOW",6) == 0 && !isday) {		        glColor3ub(255, 249, 64);
                        GLfloat param[] = {1.0,0.98,0.25,1.0};
                        glMaterialfv(GL_FRONT_AND_BACK,GL_EMISSION,param);
		      } else if (strncmp(pObject->strName,"LIGHT",5) == 0 && !isday){
		        glColor3ub(255, 249, 64);
                        GLfloat param[] = {1.0,0.98,0.25,1.0};
                        glMaterialfv(GL_FRONT_AND_BACK,GL_EMISSION,param);
		      } else {
		        byte *pColor = model.pMaterials[pObject->materialID].color;
                        GLfloat param[] = {0.0,0.0,0.0,1.0};
		        // Assign the current color to this model
		        glColor3ub(pColor[0], pColor[1], pColor[2]);
                        glMaterialfv(GL_FRONT_AND_BACK,GL_EMISSION,param);
		      }

		    }
                  }
		
		// Pass in the current vertex of the object (Corner of current face)
		glVertex3f(pObject->pVerts[ index ].x, pObject->pVerts[ index ].y, pObject->pVerts[ index ].z);
	      }
	  }      
        glEnd();                                // End the drawing
      }
      GLfloat param[] = {0.0,0.0,0.0,1.0};
      glMaterialfv(GL_FRONT_AND_BACK,GL_EMISSION,param);
}

