#include "main.h"
#include "3ds.h"
#include <math.h>


// This function handles the keypress events generated when the user presses a key

void HandleKeyPressEvent(SDL_keysym * keysym, tContext& g_cxt)
{
    switch(keysym -> sym) // which key have we got
    {
        case SDLK_F1 :         // if it is F1
            ToggleFullScreen();// toggle between fullscreen and windowed mode
            break;

        case SDLK_ESCAPE:      // if it is ESCAPE
            Quit(0);           // quit after cleaning up

        case SDLK_LEFT :       // If the LEFT arrow key was pressed
             g_cxt.g_RotationSpeed -= 0.05f;// Decrease the rotation speed
            break;

        case SDLK_RIGHT :      // If the RIGHT arrow key is pressed
            g_cxt.g_RotationSpeed += 0.05f;// Increase the rotation speed
            break;

        default:               // any other key
            break;             // nothing to do
    }
}
