#include "main.h"

#define BUFSIZE 512
extern camera vista;
extern int posx;
extern int posy;

void::tGrid::tessel()
{
  int x, y; /* Loop variables */
  CVector3 v;


  /* Loop Through The Y Plane */
  for ( y = 0; y < nrows + 1; y++ )
    {
      v.y = y*dy;
      /* Loop Through The X Plane */
      for ( x = 0; x < ncols + 1; x++ )
	{     
	  v.x = x*dx;
          v.z = sin(6.28*y/nrows) * sin(6.28*x/ncols) * wave_amp;
          points.push_back(v);
	}     
    }
}

void tGrid::loadTex(char *filename)
{
  /* Create The Texture */
  CreateTexture(texture,filename,0);

}

/* Here goes our drawing code */
void tGrid::draw()
{
  int x, y, i=0;                   /* Loop Variables */
  float f_x, f_y, f_xb, f_yb;
  float hold;

  /* Fill the back with the texture. The front will only be wireline */
  /* Select Our Texture */  
  glBindTexture( GL_TEXTURE_2D, texture[0] ); 
  /* Center grid */
  /* Loop Through The Y Plane */
  glNormal3f(0.0,0.0,1.0);

  for ( y = 0; y < nrows; y++ )
    {      
      /* Loop Through The X Plane */
      for ( x = 0; x < ncols; x++ )
	{
          i = x + y * (ncols +1);
          if (tag) {            
            glLoadName (i);
	  }
          if (selected != -2) {
            if (i==selected) {
              glColor4f (1.0, 0.0,0.0,.5);
	      glPolygonMode( GL_FRONT_AND_BACK, GL_FILL );
	    } else {
              glPolygonMode( GL_FRONT_AND_BACK, GL_LINE );
	    }
	  }

	  /* Create A Floating Point X Value */
	  f_x = roll;
	  /* Create A Floating Point Y Value */
	  f_y = roll;
	  /* Create A Floating Point Y Value+dx */
	  f_xb =roll + 1.0;
	  /* Create A Floating Point Y Value+dy */
	  f_yb =roll + 1.0;
          glBegin( GL_QUADS);

	  /* (Top Left) */
	  glTexCoord2f( f_x, f_yb );
	  glVertex3f( points[i].x, points[i].y+dy, points[i+ncols].z );

          /* (Bottom Left) */
	  glTexCoord2f( f_x, f_y );
	  glVertex3f( points[i].x, points[i].y, points[i].z );

	  /* (Bottom Right) */
	  glTexCoord2f( f_xb, f_y );
	  glVertex3f( points[i].x+dx, points[i].y, points[i+1].z );

	  /* (Top Right) */
	  glTexCoord2f( f_xb, f_yb );
	  glVertex3f( points[i].x+dx, points[i].y+dy, points[i+1+ncols].z );
          glColor4f (1.0, 1.0,1.0,1.0);
	  glEnd( );

	}
    }

  if (animate) {
    for (i=0, y = 0; y < nrows; y++ )
      {
	i = y * (ncols +1);
	/* Store Current Value One Left Side Of Wave */
	hold = points[i].z;
	/* Loop Through The X Plane */
	for ( x = 0; x < ncols; x++ )
	  {	
	    i = x + y * (ncols +1); 
	    /* Current Wave Value Equals Value To The Right */
	    points[i].z = points[i+1].z;
	  }
	/* Last Value Becomes The Far Left Stored Value */
	points[i+1].z = hold;
      }
    for (i=0, x = 0; x < ncols; x++ )
      {
	i = x ;
	/* Store Current Value One Left Side Of Wave */
	hold = points[i].z;
	/* Loop Through The X Plane */
	for ( y = 0; y < nrows; y++ )
	  {	
	    i = x + y * (ncols +1); 
	    /* Current Wave Value Equals Value To The Top */
	    points[i].z = points[i+ncols+1].z;
	  }
	/* Last Value Becomes The Far Left Stored Value */
	points[i+ncols+1].z = hold;
      }
    roll += 0.1f; /* Increase Our Texture Roll Variable */
    if ( roll > 1.0f )
	roll -= 1.0f;
    
  }  
}

void tGrid::processHits (GLint hits, GLuint buffer[])
{
   if(hits) {
     selected = buffer[3];
   } else {
     selected = -1;
   }

}


void tGrid::pick(int button, int state, int x, int y)
{
   GLuint selectBuf[BUFSIZE];
   GLint hits;
   GLint viewport[4];

   //   if (button != GLUT_LEFT_BUTTON || state != GLUT_DOWN)
   //   return;

   glGetIntegerv (GL_VIEWPORT, viewport);

   glSelectBuffer (BUFSIZE, selectBuf);
   (void) glRenderMode (GL_SELECT);

   glInitNames();
   glPushName(0);

   glMatrixMode (GL_PROJECTION);
   glPushMatrix ();
   glLoadIdentity ();
/*  create 1x1 pixel picking region near cursor location      */
   gluPickMatrix ((GLdouble) x, (GLdouble) (viewport[3] - y), 
                  1.0, 1.0, viewport);
   gluPerspective(45.0f, (GLfloat) (viewport[2]-viewport[0])/(GLfloat) (viewport[3]-viewport[1]), 0.1f ,4000.0f);
   tag=true;
   draw();
   tag=false;

   glMatrixMode (GL_PROJECTION);
   glPopMatrix ();
   glFlush ();
   hits = glRenderMode (GL_RENDER);
   glMatrixMode (GL_MODELVIEW);
   processHits (hits, selectBuf);
}
