#include "main.h"                                        
#include "3ds.h"
#include <SDL_thread.h>
#include <math.h>
#include <limits.h>

#define MAX(a,b) (a>b) ? a : b
#define MIN(a,b) (a<b) ? a : b

// is our job done ? not yet !
bool done = false;                                    


int VideoFlags=0;          // The Pixel Format flags
int posx=-1,posy=-1;
SDL_Surface *MainWindow=NULL;  // Our Drawable portion of the window
camera vista;

  
SDL_mutex *mutex;
SDL_Thread *threads[3];


int Play(void *scene){

       int pos=0,x,y,ncount;
       char letter = 0;

	
	tScene *scn = (tScene *) scene;
	
	while (! done){
		
// 		cout << "Enter shot position:";

// 		cout << "(1-8):";
// 		cin >> pos;
// 		if (pos < 1 || pos > 8) {
// 			done = true;
// 	  		break;
// 		}

// 		cout << "(a-h):";
// 		cin >> letter;
// 		if (letter < 'a' || letter > 'h') {
// 	  		done = true;
// 	 	 	break;
// 		}
      
// 		x = (int)letter - (int)'a';
// 		y = pos - 1;
	
      		/* Set shot in the table */
		SDL_mutexP(mutex);

		ncount = 0;
		for (int i=0;i<8;i++) {
	  	  for (int j=0;j<8;j++) {
	    	    if (scn->table[j][i] > 0)
		      ncount++;
		    }
		  pos = letter = 0;		
		}

		/* End Game */
		if (ncount == 0) {
		   cout << "YOU WIN!" <<endl;
		   done = true;
		}

		SDL_mutexV(mutex);
	}
	return 0;
}


//////////// *** NEW *** ////////// *** NEW *** ///////////// *** NEW *** ////////////////////

// This tutorial will demonstrate how to load a .3DS file.  This 3D file format
// is created from 3D Studio Max.  It can be exported and important into many
// other programs.  A great tool for converting 3D file formats is "3D Exploration".
// This is a shareware utility that can be found for download on the web.
// This 3DS loader only loads the texture names, object colors, the vertices, the faces, and the UV coordinates.
// The key frame information is ignored since we have a Key Frame Animation tutorial later.
// I didn't want to over complicate this tutorial, but just show the basics.  
//
// In this tutorial, there is a picture of a face rotating around.  It is a single object
// with a single texture.  The .3ds loader does load multiple objects though.
// The controls are: 

// Left Mouse Button - Changes the Render mode from normal to wireframe.
// Right Mouse Button - Turns lighting On/Off
// Left Arrow Key - Spins the model to the left
// Right Arrow Key - Spins the model to the right
// Escape - Quits


//  This function handles the main game loop

int MainLoop(void *scene)
{
	
  SDL_Event event;

  bool button_down = false;
  int i,j;

  tScene *scn = (tScene *)scene;
  
  // as long as our job's not done
  while(! done)                 
    {
      // look for events (like keystrokes, resizing etc.)
      while( SDL_PollEvent(&event) )
        {
	  // what kind of event have we got ?
	  switch ( event.type )     
            {
	      // if user wishes to quit
	    case SDL_QUIT : 
	      // this implies our job is done
	      done = true;             
	      break;

	      // if the user has pressed a key
	    case SDL_KEYDOWN :
	      switch (event.key.keysym.sym){
		      case SDLK_i:
			      vista.orient*=-1;
			      break;
			      
		      case SDLK_KP_PLUS:
			      vista.raio-=5.0;
			      break;

		      case SDLK_KP_MINUS:
			      vista.raio+=5.0;
			      break;
			      
		      default:
			      
			      // callback for handling keystrokes, arg is key pressed
			      for (int i=0; i< scn->actor.size(); i++)
				      HandleKeyPressEvent( & event. key.keysym, scn->actor[i]->cxt);
			      break;
			      	
	      }
	      break;
	      
	    case SDL_MOUSEMOTION:
              if (button_down) {             
	        vista.theta-=(M_PI/1000.0)*(float)event.motion.yrel;
	        vista.phi-=(M_PI/1000.0)*(float)event.motion.xrel;
	      }

              posx = (int)event.motion.x;
              posy = (int)event.motion.y;
	      break;


	    case SDL_MOUSEBUTTONDOWN:             
              if (event.button.button == SDL_BUTTON_LEFT) {
		  button_down = true;
	      if (scn->grid.selected >=0) {
		i = scn->grid.selected%(scn->grid.ncols+1);
		j = scn->grid.selected/(scn->grid.ncols+1);
		if (scn->table[i][7-j]) {
		  scn->table[i][7-j] = -1;
		  cout << "Hit!" <<endl;
		} else {
		  cout << "Miss!" <<endl;
		}
	      }
	      }
              if (event.button.button == SDL_BUTTON_RIGHT) {
		  scn->isday = !scn->isday;
	      }
	      break;

	    case SDL_MOUSEBUTTONUP:             
              if (event.button.button == SDL_BUTTON_LEFT) {
		  button_down = false;
	      }
	      break;

	      // if there is a resize event
	    case SDL_VIDEORESIZE :           
	      // request SDL to resize the window to the size and depth etc. that we specify
	      MainWindow = SDL_SetVideoMode( event.resize.w, event.resize.h, SCREEN_DEPTH, VideoFlags );
	      // now resize the OpenGL viewport
	      SizeOpenGLScreen(event.resize.w, event.resize.h);   
	      
	      // if window resize has failed
	      if(MainWindow == NULL)                          
		{
		  cerr << " Failed resizing SDL window : " << SDL_GetError() << endl;   // report error
                        exit(0); //Quit(0);
                    }
                    break;

		    // any other event
	    default:              
	      // nothing to do              
	      break;            
            } // switch
        } // while( SDL_ ...
    }

  // When we are done, we need to free all the model data
  // We do this by walking through all the objects and freeing their information
  
  // Go through all the objects in the scene
  exit(1); //Quit(1);
}

//     create the window and calling the initialization functions

int main(int argc, char **argv)
{
    int *status;
    *status = -1;
	
    // print user instructions
    cout << " Hit the F1 key to Toggle between Fullscreen and windowed mode" << endl;
    cout << " Hit ESC to quit" << endl;

    // try to initialize SDL video module
    if( SDL_Init( SDL_INIT_VIDEO ) < 0 )
    {
      // report error if it fails
      cerr << "Failed initializing SDL Video : " << SDL_GetError() << endl;
      // we use this instead of Quit because SDL isn't yet initialized
      return 1;              
    }
    // Set up the format for the pixels of the OpenGL drawing surface
    SetupPixelFormat();
    // Create our window, we pass caption for the window, the width, height and video flags required
    CreateMyWindow("Battleship", SCREEN_WIDTH, SCREEN_HEIGHT, VideoFlags);
    
    // Initializes our OpenGL drawing surface
    Init();
    char filename[128];
    char mask[128];
    CVector3 scale[4] = { {0.4, 0.2 ,0.8}, \
			  {0.3, 0.6 ,2.0}, \
			  {1.0, 1.0 ,3.0}, \
                          {0.5, 1.0 ,3.0} };
    
    tScene scn;

    cout << "Loading models..." << endl;

    cout << "boat... ";
    sprintf(filename,"boat.3ds");  
    tActor boat(filename, scale[0]);
    boat.set_size(1,1);

    cout << "submarine... ";  
    sprintf(filename,"submarine.3ds");
    tActor sub(filename, scale[1]);
    sub.set_size(2,1);

    cout << "carrier... ";
    sprintf(filename,"carrier.3ds");  
    tActor carrier(filename, scale[2]);
    carrier.set_size(3,1);

    cout << "destroyer... ";  
    sprintf(filename,"destroyer.3ds");  
    tActor destroyer(filename, scale[3]);
    destroyer.model.mirror('z');
    carrier.set_size(3,1);

    cout << "Setting grid..." << endl;
    scn.water.grid(20,20);
    scn.water.size(16,16);
    scn.water.set_amplitude(0.2);
    scn.water.tessel();
    scn.water.loadTex("water.bmp");
    scn.water.toggle_animation();
    scn.grid.tessel();
    scn.grid.tag=true;

    cout << "Loading bitmaps..." << endl;
    for (int i=0;i<5;i++) {
      sprintf(filename,"explosion%d.bmp",i+1);  
      CreateTexture(scn.texture, filename,i);
      sprintf(filename,"explosion%d_mask.bmp",i+1);  
      CreateTexture(scn.texture_mask, filename,i);
    }
    

    // Run our message loop
//     for(int i = 0; i < g_3DModel.numOfObjects; i++) {
//       cout << i << ':' << g_3DModel.pObject[i].strName << endl;
//     }
 
    scn.actor.push_back(&boat);
    scn.actor.push_back(&sub);
    scn.actor.push_back(&carrier);
    scn.actor.push_back(&destroyer);

    cout << "Placing ships";    
    scn.place_ships();

    //Inicializando a posio da camera.
    
    vista.orient = 1;
    vista.raio = 12.0f;
    vista.theta = 0.0f;
    vista.phi = 0.0f;
    
    mutex = SDL_CreateMutex();
    
    threads[0] = SDL_CreateThread(MainLoop, reinterpret_cast<void *> (&scn));
    
    if(threads[0]){
	   threads[1] = SDL_CreateThread(Play, reinterpret_cast<void *> (&scn));
	   threads[2] = SDL_CreateThread(DrawScene, reinterpret_cast<void *> (&scn));
	   SDL_WaitThread(threads[1], status);
    }

    else done = true;

   
    SDL_WaitThread(threads[0], status);

    SDL_DestroyMutex(mutex);
    

    // quit main returning success
    
    Quit(*status); //return 0;
}

//      This will shutdown SDL and quit the program

void Quit(int ret_val)
{
  // shuts down SDL stuff
    SDL_Quit();
    // quit the program
    exit(ret_val);
}

int DrawScene(void *scene)
{
  tScene *scn = (tScene *)scene;
  
  while (! done) {

  // draw our OpenGL scene
    SDL_mutexP(mutex);
    scn->render(); 
    SDL_mutexV(mutex);
  }
}

