#include "main.h"

//  This function renders the entire scene.

extern camera vista;
extern int posx;
extern int posy;


void tScene::render () 
{

  // Clear The Screen And The Depth Buffer
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  GLfloat amb_day[] = { 0.2, 0.2, 0.2, 1.0};
  GLfloat amb_night[] = { 0.0, 0.0, 0.0, 1.0};

  GLfloat dif_day[] = { 1.0, 1.0, 1.0, 1.0};
  GLfloat dif_night[] = { 0.2, 0.2, 0.2, 1.0};

  GLfloat spc_day[] = { 1.0, 1.0, 1.0, 1.0};
  GLfloat spc_night[] = { 0.0, 0.0, 0.0, 1.0};

  GLfloat position[4] = { 0.0, 0.0, 0.0, 1.0};
  GLfloat light_position[4] = { 0.0, 0.0, 3.0, 1.0};
  GLfloat light_direction[4] = { 0.0, 0.0, -1.0, 1.0};


  //Checks if is day or night
  if (isday) {
    glLightfv(GL_LIGHT0,GL_AMBIENT, amb_day);
    glLightfv(GL_LIGHT0,GL_DIFFUSE, dif_day);
    glLightfv(GL_LIGHT0,GL_SPECULAR, spc_day);
  } else {
    glLightfv(GL_LIGHT0,GL_AMBIENT, amb_night);
    glLightfv(GL_LIGHT0,GL_DIFFUSE, dif_night);
    glLightfv(GL_LIGHT0,GL_SPECULAR, spc_night);
  }

  glMatrixMode(GL_MODELVIEW);  
  glLoadIdentity();

  position[0] = -2.0f + (vista.raio)*cos(vista.theta)*sin(vista.phi);
  position[1] = -4.0f + (vista.raio)*cos(vista.theta)*sin(vista.phi);
  position[2] = (vista.raio)*cos(vista.phi);

  gluLookAt(position[0], position[1], position[2],
	    0.0f, 0.0f, 0.0f,
	    0.0f, (float)vista.orient, 0.0f);

  glPushMatrix();
  glPushMatrix();

  glEnable( GL_TEXTURE_2D ); 
  glColor3ub(255,255,255);
  glPolygonMode( GL_FRONT_AND_BACK, GL_FILL );
  glTranslatef(-water.ncols*water.dx/2.0, -water.nrows*water.dy/2.0,-1.0);
  water.draw();

  glPopMatrix();
  glDisable(GL_TEXTURE_2D);
  glColor3ub(255,255,255);
  glPolygonMode( GL_FRONT_AND_BACK, GL_LINE );
  glTranslatef(-grid.ncols*grid.dx/2.0, -grid.nrows*grid.dy/2.0,0.0);
  grid.pick(1,0,posx,posy);
  grid.draw();




  //Draw text
  glPopMatrix();
  for (int x = 0; x < grid.ncols; x++ ) { 
    text.position((x-grid.ncols/2)*grid.dx + grid.dx/2,grid.nrows/2*grid.dy + grid.dy/4);
    text.print("%c",'a'+x);
  }

  for (int y = 0; y < grid.nrows; y++ ) { 
    text.position(-grid.ncols/2*grid.dx - grid.dx/4,(grid.nrows/2-y)*grid.dy - grid.dy/2);
    text.print("%d",y+1);
  }

  // Draw actors
  glPolygonMode( GL_FRONT_AND_BACK, GL_FILL );
  for (int a=0; a<actor.size(); a++) {

    glPushMatrix();

    actor[a]->moveto(&grid,actor[a]->posx,actor[a]->posy);
  

//     if (!isday) {
//       glEnable(GL_LIGHT0+a+1);
//       glLightfv(GL_LIGHT0+a+1,GL_POSITION, light_position);
//       glLightfv(GL_LIGHT0+a+1,GL_SPOT_DIRECTION, light_direction);
//       glLightfv(GL_LIGHT0+a+1,GL_AMBIENT, amb_day);
//       glLightfv(GL_LIGHT0+a+1,GL_DIFFUSE, dif_day);
//       glLightfv(GL_LIGHT0+a+1,GL_SPECULAR, spc_day);
//       glLightf(GL_LIGHT0+a+1,GL_SPOT_CUTOFF, 15.0);
//       glLightf(GL_LIGHT0+a+1,GL_SPOT_EXPONENT, 2.0);
//     } else {
//       glDisable(GL_LIGHT0+a+1);
//     }
 

    // Increase the angle of rotation

    if (actor[a]->sizex > actor[a]->sizey)
      glRotatef(90, 0.0f, 0.0f, 1.0f);
    glRotatef(90, 1.0f, 0.0f, 0.0f);
    actor[a]->render(isday);

    glPopMatrix();
  }

  glTranslatef(-grid.ncols*grid.dx/2.0, -grid.nrows*grid.dy/2.0,0.0);
  // Draw explosions
  for (int y=0;y<8;y++) 
    for (int x=0;x<8;x++) 
      if (table[x][y] == -1){
	int a = table[x][y] - 1;
	explosion(x,y);
	frame[x][y] = (frame[x][y] +1)%5;
      }
  

  
  // Swap the backbuffers to the foreground 
  SDL_GL_SwapBuffers();                                     
}

void tScene::explosion(int col, int row) 
{
  int i = (grid.nrows-row-1) * (grid.ncols+1) + col;


  /* Disable Depth Testing */
  glDisable( GL_DEPTH_TEST );

  glEnable(GL_TEXTURE_2D);
  glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

  /* Draw mask */
  glBindTexture(GL_TEXTURE_2D, texture_mask[frame[col][row]]);
  glBlendFunc( GL_DST_COLOR, GL_ZERO );
  glNormal3f(0.0,0.0,1.0);
  glBegin(GL_QUADS);

  /* (Top Left) */
  glTexCoord2f( 0.0, 1.0 );
  glVertex3f( grid.points[i].x, grid.points[i+1+grid.ncols].y, 0.0);

  /* (Bottom Left) */
  glTexCoord2f( 0.0, 0.0 );
  glVertex3f( grid.points[i].x, grid.points[i].y, 0.0 );
  
  /* (Bottom Right) */
  glTexCoord2f( 1.0, 0.0 );
  glVertex3f( grid.points[i+1].x, grid.points[i].y, 0.0 );
  
  /* (Top Right) */
  glTexCoord2f( 1.0, 1.0 );
  glVertex3f( grid.points[i+1].x, grid.points[i+1+grid.ncols].y,0.0);
  
  glEnd( );

  /* Apply tex over mask */ 
  glBlendFunc( GL_ONE, GL_ONE );
  glBindTexture(GL_TEXTURE_2D, texture[frame[col][row]]);
  glNormal3f(0.0,0.0,1.0);
  glBegin(GL_QUADS);

  /* (Top Left) */
  glTexCoord2f( 0.0, 1.0 );
  glVertex3f( grid.points[i].x, grid.points[i+1+grid.ncols].y, 0.0);

  /* (Bottom Left) */
  glTexCoord2f( 0.0, 0.0 );
  glVertex3f( grid.points[i].x, grid.points[i].y, 0.0 );
  
  /* (Bottom Right) */
  glTexCoord2f( 1.0, 0.0 );
  glVertex3f( grid.points[i+1].x, grid.points[i].y, 0.0 );
  
  /* (Top Right) */
  glTexCoord2f( 1.0, 1.0 );
  glVertex3f( grid.points[i+1].x, grid.points[i+1+grid.ncols].y,0.0);
  
  glEnd( );

  glEnable( GL_DEPTH_TEST ); 
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);  
}


void tScene::place_ships() {

  bool loop;
  float px,py;
  int x,y;
  srand(3);

  for (int y=0;y<grid.nrows;y++)
    for (int x=0;x<grid.ncols;x++) {
      table[x][y] = 0;
      frame[x][y] = 0;
    }


	  
  for (int a=0; a<actor.size(); a++) {
    loop = true;
    while (loop) {
      px = ((float)rand()/(RAND_MAX));
      py = ((float)rand()/(RAND_MAX));
      if (rand()%2)
	actor[a]->flip();
      x = (int)(px*(grid.ncols - actor[a]->sizex));
      y = (int)(py*(grid.nrows - actor[a]->sizey)); 
      actor[a]->set_position(x,y);
      loop = false;
      //Checks if a there is no overlay between ships 
      for (int y=0;y<actor[a]->sizey;y++)
	for (int x=0;x<actor[a]->sizex;x++) 
          // If already exists a ship 
	  if(table[x+actor[a]->posx][y+actor[a]->posy])
	    loop = true;  //Try again
    }
    for (int y=0;y<actor[a]->sizey;y++)
      for (int x=0;x<actor[a]->sizex;x++) 
	table[x+actor[a]->posx][y+actor[a]->posy] = a+1;      
  }
}
