#include "main.h"
#include "3ds.h"
#include <math.h>

//  This swaps 2 elements we pass to it (swaps bytes)

static void swap(unsigned char & a, unsigned char & b)
{
    unsigned char temp;

    temp = a;
    a    = b;
    b    = temp;

    return;
}

//  This creates a texture in OpenGL that we can texture map 

void CreateTexture(unsigned int textureArray[],char *strFileName,int textureID)
{
    SDL_Surface *pBitmap[1];

    // Return from the function if no file name was passed in
    if( strFileName == NULL )                           
        return ;

    // Load the bitmap and store the data
    //pBitmap[0] = SDL_LoadBMP(strFileName);
    pBitmap[0] = IMG_Load(strFileName);

    // If we can't load the file, quit!
    if(pBitmap[0] == NULL)                                
    {
        cerr << " Failed loading " << strFileName << " : " << SDL_GetError() << endl;
        Quit(0);
    }

    // Generate a texture with the associative texture ID stored in the array
    glGenTextures(1, &textureArray[textureID]);

    // Bind the texture to the texture arrays index and init the texture
    glBindTexture(GL_TEXTURE_2D, textureArray[textureID]);

    // Rearrange the pixelData     
    int width  = pBitmap[0] -> w;
    int height = pBitmap[0] -> h;
    unsigned char * data = (unsigned char *) (pBitmap[0] -> pixels);         // the pixel data

    int BytesPerPixel = pBitmap[0] -> format -> BytesPerPixel;

    //////////// This is how we swap the rows :
    // For half the rows, we swap row 'i' with row 'height - i -1'. (if we swap all the rows
    // like this and not the first half or the last half, then we get the same texture again !
    //
    // Now these rows are not stored as 2D arrays, instead they are stored as a long 1D array.
    // So each row is concatenated after the previous one to make this long array. Our swap 
    // function swaps one byte at a time and therefore we swap BytesPerPixel (= total bits per pixel)
    // bytes succesively.
    //
    // so the three loops below are :
    // for the first half of the rows
    //   for all the width (which is width of image * BytesPerPixel, where BytesPerPixel = total bits per pixel).
    //   (Here, for each pixel, we have to increment j by total bits per pixel (to get to next pixel to swap))
    //      for(each byte in this pixel i.e k = 0 to BytesPerPixel - 1, i.e BytesPerPixel bytes.
    //        swap the byte with the corresponding byte in the 'height -i -1'th row ('i'th row from bottom)
    for( int i = 0 ; i < (height / 2) ; ++i )
        for( int j = 0 ; j < width * BytesPerPixel; j += BytesPerPixel )
            for(int k = 0; k < BytesPerPixel; ++k)
                swap( data[ (i * width * BytesPerPixel) + j + k], data[ ( (height - i - 1) * width * BytesPerPixel ) + j + k]);
    
    unsigned char *pixels = new unsigned char[width * height * 3];

    int count = 0;
    
    // the following lines extract R,G and B values from any bitmap

    for(int i = 0; i < (width * height); ++i)
    {
      // R,G and B that we will put into pImage
      byte r,g,b;                                                
      
      // 32 bit unsigned int (as dictated by SDL)
      Uint32 pixel_value = 0;                                    

      // the following loop extracts the pixel (however wide it is 8,16,24 or 32) and 
      // creates a long with all these bytes taken together.
        
      // for each byte in the pixel (from the right)
      for(int j = BytesPerPixel - 1 ; j >=0; --j)
        {
	  // left shift pixel value by 8 bits
	  pixel_value = pixel_value << 8;         
	  // then make the last 8 bits of pixel value  =
	  pixel_value = pixel_value | data[ (i * BytesPerPixel) + j ];  
	  // the byte that we extract from pBitmap's data
        }                                                                 

      // here we get r,g,b from pixel_value which is stored in the form specified by pBitmap->format
        SDL_GetRGB(pixel_value, pBitmap[0] -> format, (Uint8 *)&r, (Uint8 *)&g, (Uint8 *)&b);     

	// in our tImage classes we store r first
        pixels[count++] = r;          
	// then g
        pixels[count++] = g;
	// and finally b (for bmps - three channels only)
        pixels[count++] = b;          

	// reset pixel , else we get incorrect values of r,g,b
        pixel_value = 0;
    }
    
    // Build Mipmaps (builds different versions of the picture for distances - looks better)
    gluBuild2DMipmaps(GL_TEXTURE_2D, 3, pBitmap[0]->w, pBitmap[0]->h, GL_RGB, GL_UNSIGNED_BYTE, pixels);

    // Lastly, we need to tell OpenGL the quality of our texture map.  GL_LINEAR is the smoothest.    
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);    
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_NEAREST);
    glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
    
    // Free the texture data we dont need it anymore
    SDL_FreeSurface(pBitmap[0]);                        
}

void CreateMaskedTexture(unsigned int textureArray[],char *strFileName, char *strMaskName, int textureID)
{
    SDL_Surface *pBitmap[2];

    // Return from the function if no file name was passed in
    if( strFileName == NULL )                           
        return ;

    // Load the bitmap and store the data
    //pBitmap[0] = SDL_LoadBMP(strFileName);
    pBitmap[0] = IMG_Load(strFileName);
    pBitmap[1] = IMG_Load(strMaskName);

    // If we can't load the file, quit!
    if(pBitmap[0] == NULL)                                
    {
        cerr << " Failed loading " << strFileName << " : " << SDL_GetError() << endl;
        Quit(0);
    }

    // Generate a texture with the associative texture ID stored in the array
    glGenTextures(1, &textureArray[textureID]);

    // Bind the texture to the texture arrays index and init the texture
    glBindTexture(GL_TEXTURE_2D, textureArray[textureID]);

    // Rearrange the pixelData     
    int width  = pBitmap[0] -> w;
    int height = pBitmap[0] -> h;

    unsigned char * data = (unsigned char *) (pBitmap[0] -> pixels);         // the pixel data
    unsigned char * mask_data = (unsigned char *) (pBitmap[1] -> pixels);         // the pixel data

    int BytesPerPixel = pBitmap[0] -> format -> BytesPerPixel;
    int mask_BytesPerPixel = pBitmap[1] -> format -> BytesPerPixel;

    //////////// This is how we swap the rows : For half the rows, we
    //swap row 'i' with row 'height - i -1'. (if we swap all the rows
    //like this and not the first half or the last half, then we get
    //the same texture again !
    //
    // Now these rows are not stored as 2D arrays, instead they are
    // stored as a long 1D array.  So each row is concatenated after
    // the previous one to make this long array. Our swap function
    // swaps one byte at a time and therefore we swap BytesPerPixel (=
    // total bits per pixel) bytes succesively.  So the three loops
    // below are : for the first half of the rows for all the width
    // (which is width of image * BytesPerPixel, where BytesPerPixel =
    // total bits per pixel).  (Here, for each pixel, we have to
    // increment j by total bits per pixel (to get to next pixel to
    // swap)) for(each byte in this pixel i.e k = 0 to BytesPerPixel -
    // 1, i.e BytesPerPixel bytes.  swap the byte with the
    // corresponding byte in the 'height -i -1'th row ('i'th row from
    // bottom)
    for( int i = 0 ; i < (height / 2) ; ++i )
        for( int j = 0 ; j < width * BytesPerPixel; j += BytesPerPixel )
            for(int k = 0; k < BytesPerPixel; ++k)
                swap( data[ (i * width * BytesPerPixel) + j + k], data[ ( (height - i - 1) * width * BytesPerPixel ) + j + k]);
    
    unsigned char *pixels = new unsigned char[width * height * 4];

    int count = 0;
    
    // the following lines extract R,G and B values from any bitmap

    for(int i = 0; i < (width * height); ++i)
    {
      // R,G and B that we will put into pImage
      byte r,g,b,ar,ag,ab;                                                
      
      // 32 bit unsigned int (as dictated by SDL)
      Uint32 pixel_value = 0;
      Uint32 mask_value = 0;                                    

      // the following loop extracts the pixel (however wide it is
      // 8,16,24 or 32) and creates a long with all these bytes taken
      // together.
        
      // for each byte in the pixel (from the right)
      for(int j = BytesPerPixel - 1 ; j >=0; --j)
        {
	  // left shift pixel value by 8 bits
	  pixel_value = pixel_value << 8;         
	  // then make the last 8 bits of pixel value  =
	  pixel_value = pixel_value | data[ (i * BytesPerPixel) + j ];  
	  // the byte that we extract from pBitmap's data
        }
      for(int j = mask_BytesPerPixel - 1 ; j >=0; --j)
        {
	  // left shift pixel value by 8 bits
	  mask_value = mask_value << 8;         
	  // then make the last 8 bits of pixel value  =
	  mask_value = mask_value | mask_data[ (i * mask_BytesPerPixel) + j ];  
	  // the byte that we extract from pBitmap's data
        }                                                                 

      // here we get r,g,b from pixel_value which is stored in the form specified by pBitmap->format
        SDL_GetRGB(pixel_value, pBitmap[0] -> format, (Uint8 *)&r, (Uint8 *)&g, (Uint8 *)&b);     
        SDL_GetRGB(mask_value, pBitmap[1] -> format, (Uint8 *)&ar, (Uint8 *)&ag, (Uint8 *)&ab);

	// in our tImage classes we store r first
        pixels[count++] = r;          
	// then g
        pixels[count++] = g;
	// and finally b (for bmps - three channels only)
        pixels[count++] = b;          
	// now the alpha value from mask
        pixels[count++] = 255-(ar+ag+ab)/3;          

	// reset pixel , else we get incorrect values of r,g,b
        pixel_value = 0;
        mask_value = 0;
    }


    // Build Mipmaps (builds different versions of the picture for distances - looks better)
    gluBuild2DMipmaps(GL_TEXTURE_2D, 3, width, height, GL_RGBA, GL_UNSIGNED_BYTE, pixels);

    // Lastly, we need to tell OpenGL the quality of our texture map.  GL_LINEAR is the smoothest.    
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);    
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_NEAREST);
    glTexEnvi(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);    


    // Free the texture data we dont need it anymore
    SDL_FreeSurface(pBitmap[0]);                        
    SDL_FreeSurface(pBitmap[1]);
//     for(int i = 0; i < (width * height); i+=4) {
    
//         for (int j =0;j<4;j++)
//  	  cout << (int)pixels[i+j] << " ";
  
//  	cout << endl;
//       }

}
