import javax.swing.ImageIcon;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.nio.*;

public class TextureMap{
	private ByteBuffer buffer;
	private int width;
	private int height;
	
	
	public TextureMap(String filename) {
	
		ImageIcon icon = new ImageIcon(filename);
		width = icon.getIconWidth();
		height = icon.getIconHeight();
		
	    buffer = ByteBuffer.allocate(width * height * 4);
	    BufferedImage bImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
	    Graphics g2 = bImage.getGraphics();
	    g2.drawImage(icon.getImage(), 0, 0, null);
	    
	    int k = 0;
	    int c;
    	for( int y = 0; y < height; y++) 
    		for( int x = 0; x < width; x++) {
	    		c = bImage.getRGB(x, y);
	    		buffer.put(k + 2, (byte) (c & 0xFF));
	    		c = c >> 8;
	    		buffer.put(k + 1, (byte) (c & 0xFF));
	    		c = c >> 8;
	    		buffer.put(k, (byte) (c & 0xFF));
	    		c = c >> 8;
	    		buffer.put(k + 3, (byte) (0xFF));    		
	    		k+=4;
	    	}
	}
	
	public int getWidth() {
		return width;	
	}
	
	public int getHeight() {
		return height;
	}
	
	public ByteBuffer getMap() {
		return buffer;
	}

}
