import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.swing.JFrame;

import com.sun.opengl.util.Animator;

import java.nio.*;

public class TextureOpenGL extends JFrame implements GLEventListener, 
                                                  MouseListener,  
                                                  MouseMotionListener {
	public static final long serialVersionUID = 0;
	private float view_rotx = 0.0f, view_roty = 0.0f, view_rotz = 0.0f;
	private int prevMouseX, prevMouseY;
	private float angle = 0.0f;
	private static final Dimension PREFERRED_FRAME_SIZE = new Dimension(600, 600);
//	private static final int MAP_HEIGHT = 64;
//	private static final int MAP_WIDTH = 64;
//	private ByteBuffer chessImage = ByteBuffer.allocate(MAP_HEIGHT * MAP_WIDTH * 4);
	private ByteBuffer texImage;
	private IntBuffer texName = IntBuffer.allocate(1);
	private int plane;
	private TextureMap texMap;
	

	
	/** We'd like to be 400x400, please.
	*/
	public Dimension getPreferredSize(){
		return PREFERRED_FRAME_SIZE;
	}
	
	/*
	* METHODS DEFINED BY GLEventListener
	*/
	
	/** Called by drawable to initiate drawing. 
	*/
	public void display(GLAutoDrawable drawable) {
		angle += 1.0f;
		
		GL gl = drawable.getGL();
		
		gl.glClear(GL.GL_COLOR_BUFFER_BIT | GL.GL_DEPTH_BUFFER_BIT);
		gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
		
		gl.glPushMatrix();
		gl.glRotatef(view_rotx, 1.0f, 0.0f, 0.0f);
		gl.glRotatef(view_roty, 0.0f, 1.0f, 0.0f);
		gl.glRotatef(view_rotz, 0.0f, 0.0f, 1.0f);
		
		gl.glPushMatrix();
		gl.glRotatef(angle, 0.0f, 0.0f, 1.0f);
		gl.glCallList(plane);
		gl.glPopMatrix();
		
		gl.glPopMatrix();
		
		gl.glFlush();
	}
	
	/** Called by drawable to indicate mode or device has changed.
	*/
	public void displayChanged(GLAutoDrawable drawable, 
		boolean modeChanged, 
		boolean deviceChanged){}
		
	/** Called after OpenGL is init'ed
	*/
	public void init(GLAutoDrawable drawable) {

		GL gl = drawable.getGL();
		
		texMap = new TextureMap("./resources/sunriseq.jpg");
	
		/* Enable features */
		gl.glEnable(GL.GL_DEPTH_TEST);

		/* Select shading model */
		gl.glShadeModel(GL.GL_FLAT);

		
		gl.glGenTextures(1, texName);
		gl.glBindTexture(gl.GL_TEXTURE_2D, texName.get(0));
		
		gl.glTexParameteri(gl.GL_TEXTURE_2D, gl.GL_TEXTURE_WRAP_S, gl.GL_REPEAT);
		gl.glTexParameteri(gl.GL_TEXTURE_2D, gl.GL_TEXTURE_WRAP_T, gl.GL_REPEAT);
		gl.glTexParameteri(gl.GL_TEXTURE_2D, gl.GL_TEXTURE_MAG_FILTER, gl.GL_NEAREST);
		gl.glTexParameteri(gl.GL_TEXTURE_2D, gl.GL_TEXTURE_MIN_FILTER, gl.GL_NEAREST);
		gl.glTexImage2D(gl.GL_TEXTURE_2D, 0, gl.GL_RGBA, texMap.getWidth(), texMap.getHeight(), 0, 
				                             gl.GL_RGBA, gl.GL_UNSIGNED_BYTE,  texMap.getMap());
	
		/* Set texture and build plane */
		plane = gl.glGenLists(1);
		gl.glNewList(plane, GL.GL_COMPILE);
		gl.glColor3f(1.0f, 0.0f, 0.0f);
		gl.glEnable(gl.GL_TEXTURE_2D);
		gl.glTexEnvf(gl.GL_TEXTURE_ENV, gl.GL_TEXTURE_ENV_MODE, gl.GL_REPLACE);
		gl.glBindTexture(gl.GL_TEXTURE_2D, texName.get(0));
		buildPlane(gl, 4.0f);
		gl.glEndList();
		
		drawable.addMouseListener(this);
		drawable.addMouseMotionListener(this);
	}
	
	/** Called to indicate the drawing surface has been moved and/or resized.
	*/
	public void reshape(GLAutoDrawable drawable, 
		                int x, int y, 
		                int width, int height){
		
		GL gl = drawable.getGL();
		
		float h = (float)height / (float)width;            
		gl.glMatrixMode(GL.GL_PROJECTION);
		gl.glLoadIdentity();
		gl.glFrustum(-1.0f, 1.0f, -h, h, 1.0f, 30.0f);
		gl.glMatrixMode(GL.GL_MODELVIEW);
		gl.glLoadIdentity();
		gl.glTranslatef(0.0f, 0.0f, -3.6f);
	}
	
	
	/** Build plane 
	 */
	public static void buildPlane(GL gl, float size){
		
		gl.glBegin(gl.GL_QUADS);
		
		gl.glTexCoord2f(0.0f, 1.0f);
		gl.glVertex3f(-0.5f * size, -0.5f * size, 0.0f);

			
		gl.glTexCoord2f(0.0f, 0.0f);
		gl.glVertex3f(-0.5f * size, 0.5f * size, 0.0f);

		
		gl.glTexCoord2f(1.0f, 0.0f);
		gl.glVertex3f(0.5f * size, 0.5f * size, 0.0f);

		
		gl.glTexCoord2f(1.0f, 1.0f);
		gl.glVertex3f(0.5f * size, -0.5f * size, 0.0f);
	
		gl.glEnd();
	}
	
	
//	 Methods required for the implementation of MouseListener
	public void mouseEntered(MouseEvent e){}
	public void mouseExited(MouseEvent e){}

	public void mousePressed(MouseEvent e){
		prevMouseX = e.getX();
		prevMouseY = e.getY();
		if ((e.getModifiers() & MouseEvent.BUTTON3_MASK) != 0){
	//		mouseRButtonDown = true;
		}
	}
    
	public void mouseReleased(MouseEvent e){
		if ((e.getModifiers() & MouseEvent.BUTTON3_MASK) != 0) {
//			mouseRButtonDown = false;
		}
	}
    
	public void mouseClicked(MouseEvent e){}
    
	// Methods required for the implementation of MouseMotionListener
	public void mouseDragged(MouseEvent e){
		int x = e.getX();
		int y = e.getY();
		Dimension size = e.getComponent().getSize();

		float thetaY = 360.0f * ( (float)(x-prevMouseX)/(float)size.width);
		float thetaX = 360.0f * ( (float)(prevMouseY-y)/(float)size.height);
    
		prevMouseX = x;
		prevMouseY = y;

		view_rotx += thetaX;
		view_roty += thetaY;
	}
    
	public void mouseMoved(MouseEvent e){}
	

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		TextureOpenGL g = new TextureOpenGL();    
		// get a GLCanvas
		GLCanvas canvas = new GLCanvas(new GLCapabilities());
		// add a GLEventListener, which will get called when the
		// canvas is resized or needs a repaint
		canvas.addGLEventListener(g);
		// now add the canvas to the JFrame.  Note we use BorderLayout.CENTER
		// to make the canvas stretch to fill the container (ie, the frame)
		g.getContentPane().add(canvas, BorderLayout.CENTER);
		final Animator animator = new Animator(canvas);
		g.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				// Run this on another thread than the AWT event queue to
				// make sure the call to Animator.stop() completes before
				// exiting
				new Thread(new Runnable() {
					public void run() {
						animator.stop();
						System.exit(0);
					}
				}).start();
			}
		});
    
		animator.start(); 
		g.pack();
		g.setVisible(true);

	}

}



