#include "stdafx.h"
#include "CAux.h"


/******************************************************************************
Metodo : CAux ()
Funcao : Construtor da classe de metodos auxiliares
Paramt : N/A
Retorno: N/A
*******************************************************************************/
CAux::CAux ()
{
int x;

  iNumModelFiles = 0;

  for (x = 0; x < MAX_FILES; x++)
    pModel[x] = NULL;

}

//----------------------------------------------------------------------------------------
CAux::~CAux ()
{
  FlushMDLFiles ();
}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : LoadModelDataFile ()
Funcao : Importa arquivo 3DS com modelos
Paramt : [in]Nome do arquivo
Retorno: 0 - OK, -1 - NOK
*******************************************************************************/
int CAux::LoadModelDataFile (char *cFileName)
{
bool      ret;
t3DModel  *p;

  if (cFileName == NULL)
  {
    MessageBox (NULL, "Falta o nome do arquivo de dados", "CAux", MB_OK);
    return -1;
  }

  //Carrega o objeto model com os objetos do arquivo 3DS
  p = pModel[iNumModelFiles] = new t3DModel;
  
  ret = obj3ds.Import3DS (p, cFileName);

  if (ret)
  {
    sFileName[iNumModelFiles++] = cFileName;
    return 0;
  }
  else 
  {
    delete p;
    return -1;
  }
}


//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : FlushMDLFiles ()
Funcao : Apaga todos os modelos da estrutura interna
Paramt : N/A
Retorno: N/A
*******************************************************************************/
void CAux::FlushMDLFiles ()
{
int x = MAX_FILES;

  for (x = 0; x < MAX_FILES; x++)
  {
    if (pModel[x] != NULL)
    {
      delete pModel[x];
      pModel[x] = NULL;
    }
  }

  iNumModelFiles = 0;
} 

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : GetNbrOfObjects ()
Funcao : Retorna o numero de objetos de um determinado arquivo
Paramt : [in]Indice do arquivo
Retorno: Numero de objetos; -1 - Erro
*******************************************************************************/
int CAux::GetNbrOfObjects (int iMDLFileIndex)
{
t3DModel  *p = pModel [iMDLFileIndex];
  
  if (p)
    return p->numOfObjects;
  else
    return -1;
}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : GetMeshObj ()
Funcao : Retorna um modelo
Paramt : [out]Ptr para o modelo, [in]indice do arquivo, [in]indice do modelo
Retorno: true - OK; false - NOK
*******************************************************************************/
bool CAux::GetMeshObj (t3DObject *obj, int iMDLFileIndex, const int iIndex)
{
t3DModel  *p = pModel [iMDLFileIndex];

  if (p)
    *obj = p->pObject[iIndex];
  else
  {
    obj = NULL;
    return false;
  }

  return true;
}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : LoadBMP ()
Funcao : Faz a leitura de um bitmap
Paramt : [in] Nome do arquivo
Retorno: Estrutura com dados do bitmap
*******************************************************************************/
AUX_RGBImageRec *CAux::LoadBMP(char *Filename)
{
FILE *pFile=NULL;

  if (!Filename)
		return NULL;
	
  //Carrega e testa se o arquivo foi aberto com sucesso
  pFile=fopen(Filename,"r");

  if (pFile)
	{
		fclose(pFile);
		return auxDIBImageLoad(Filename); //Isto carrega o bitmap e retorna o ponteiro
	}

  return NULL;
}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : ShowModelData ()
Funcao : Exibe na tela dados do arquivo de modelos
Paramt : N/A
Retorno: N/A
*******************************************************************************/
void CAux::ShowModelData ()
{
t3DModel  *p = NULL;
int x, y;
  printf ("\r\n======= Dados do arquivo de modelos ========\n");

  for (x = 0; x < MAX_FILES; x++)
  {
    p = pModel [x];
    if (p)
    {
      printf ("\r\nNome do arquivo .............. %s", sFileName[x].c_str());
      printf ("\r\nNumero de objetos ............ %d\n", p->numOfObjects);
      
      for (y = 0; y < p->numOfObjects; y++)
      {
       printf ("\r\nNome do objeto %d ........... %s", y, p->pObject[y].strName);
       printf ("\r\nTextura ..................... %s", (p->pObject[y].bHasTexture) ? "Sim" : "Nao" );
       printf ("\r\nID do material............... %d", p->pObject[y].materialID);
      }
      printf ("\n\n\r========================================\n");
    }
  }

  printf ("\r\n\n=== completo ===\n\n");
}

