#ifndef __CAUX__
#define __CAUX__

#include <windows.h>			/* must include this before GL/gl.h */
#include <GL/gl.h>			/* OpenGL header file */
#include <GL/glu.h>			/* OpenGL utilities header file */
#include <gl/glaux.h>
#include <stdio.h>


#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <cmath>
using namespace std;

#include "3ds.h"

#define MAX_FILES   10  //Numero maximo de cargas de arquivos de modelos
class CAux
{
public:
  CAux ();
  ~CAux ();
  
  //Importa arquivo 3DS com modelos
  int LoadModelDataFile (char *cFileName);

  //Apaga todos os modelos da estrutura interna
  void FlushMDLFiles ();

  //Retorna o numero de objetos de um determinado arquivo
  int GetNbrOfObjects (int iMDLFileIndex);

  //Retorna o objeto indexado de um determinado arquivo indexado
  bool GetMeshObj (t3DObject *obj, int iMDLFileIndex, const int iIndex);

  //Exibe na tela dados do arquivo de modelos
  void ShowModelData ();

  //Faz a leitura de um bitmap
  AUX_RGBImageRec *LoadBMP(char *Filename);


private:
  CLoad3DS  obj3ds;
  t3DModel  *pModel[MAX_FILES];
  int iNumModelFiles;
  string    sFileName[MAX_FILES];
  
};


#endif
