#include "cglut.h"


CGlut::CGlut()
{
  printf ("\r\nCGlut()");
}

CGlut::~CGlut()
{
  printf ("\r\nCGlut()");
}

//-------------------------------------------------------------------------------------------------
/***********************************************************************************
 * Funcao: cb_redraw ()
 * Uso   : Callback de redesenho da tela
 * Param : N/A
 ***********************************************************************************/
void CGlut::cb_redraw (void)
{
  //printf ("\r\ndisplay()");

  glClearColor(0.0f, 0.0f, 0.1f, 0.0f);
  glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
  glMatrixMode( GL_MODELVIEW );
  glLoadIdentity();

  Sleep (1);

  //Desenho
  glutSwapBuffers();

}

//-------------------------------------------------------------------------------------------------
/***********************************************************************************
 * Funcao: cb_reshape ()
 * Uso   : Callback de redimensionamento da janela
 * Param : [in] largura, altura
 ***********************************************************************************/
void CGlut::cb_reshape (int w, int h)
{
  printf ("\r\nreshape(): w=%d, h=%d", w, h);

  glViewport (0, 0, (GLsizei) w, (GLsizei) h);
  //glMatrixMode (GL_PROJECTION);
  //glLoadIdentity ();
  //gluPerspective(45.0, (GLfloat) w/(GLfloat) h, 0.1, 100.0);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
}

//-------------------------------------------------------------------------------------------------
/***********************************************************************************
 * Funcao: cb_keyboard ()
 * Uso   : Callback de resposta ao teclado para teclas especiais (F1..Fn, setas, etc)
 * Param : [in] tecla, cursor do mouse x, cursor do mouse y
 ***********************************************************************************/
void CGlut::cb_special_kbd (int key, int x, int y)
{

  printf ("\r\nSpecial_keyboard(): x=%d, y=%d, key=%d", x, y, key);

  switch (key) 
  {
    case GLUT_KEY_UP :
    
     break;

    case GLUT_KEY_DOWN :
    
      break;
    case GLUT_KEY_RIGHT :

      break;

    case GLUT_KEY_LEFT :
      break;
  }

  glutPostRedisplay();
}

//-------------------------------------------------------------------------------------------------
/***********************************************************************************
 * Funcao: cb_keyboard ()
 * Uso   : Callback de resposta ao teclado
 * Param : [in] tecla, cursor do mouse x, cursor do mouse y
 ***********************************************************************************/
void CGlut::cb_keyboard (unsigned char key, int x, int y)
{
  printf ("\r\nkeyboard(): key=%d, x=%d, y=%d", key, x, y);

  switch (key) 
  {
    case 32:
      break;

    case 27:
      exit(0);
      break;
  }

  glutPostRedisplay();
}

//-------------------------------------------------------------------------------------------------
/***********************************************************************************
 * Funcao: cb_mouse ()
 * Uso   : Callback de resposta  leitura do mouse
 * Param : [in] estado do botao (1- solto, 0- pressionado), cursor do mouse x, cursor do mouse y
 ***********************************************************************************/
void CGlut::cb_mouse(int button, int state, int x, int y)
{
  printf ("\r\nmouse(): button=%d, x=%d, y=%d", state, x, y);

  switch (button) 
  {
    case GLUT_LEFT_BUTTON:
      break;

    default:
      break;
  }
}


//-------------------------------------------------------------------------------------------------
/***********************************************************************************
 * Funcao: cb_dragmouse ()
 * Uso   : Callback de resposta  leitura do mouse em operacao clicar+arrastar
 * Param : [in] cursor do mouse x, cursor do mouse y
 ***********************************************************************************/
void CGlut::cb_dragmouse( int x, int y)
{
  printf ("\r\nmotion_mouse(): x=%d, y=%d", x, y);
  glutPostRedisplay();
}

//-------------------------------------------------------------------------------------------------
void CGlut::idle_animation(void)
{
  printf ("\r\nidle_animation()");
  Sleep (1);
  //cb_idleAnimation();
  glutPostRedisplay();

}

/***********************************************************************************
 * Funcao: cb_isVisible ()
 * Uso   : Callback de status de visibilidade da janela
 * Param : [in] Status (1- visivel, 0- minimizado)
 ***********************************************************************************/
void CGlut::cb_isVisible(int status)
{
  printf ("\r\nvcb_isVisible(): status = %d", status);

  if (status == GLUT_VISIBLE) 
  {
    glutIdleFunc(idle_animation);    
  } 
  else 
  {
    glutIdleFunc(NULL);
  }

}

//-------------------------------------------------------------------------------------------------

/***********************************************************************************
 * Funcao: cb_idleAnimation ()
 * Uso   : Callback de status de visibilidade da janela
 * Param : N/A
 ***********************************************************************************/
void CGlut::cb_idleAnimation()
{
}