/******************************************************************************
 * Arquivo :   GameCore.cpp
 * Projeto :   IA725 - Computacao grafica 1
 * Modulo :    Classe principal de processamento
 * Date :      10/05/06
 * Version :   3.0
 *----------------------------------------------------------------------------*
 *----------------------------------------------------------------------------*
 *                               DESCRICAO
 *
 *            Classe responsavel pelo processamento do jogo
 *----------------------------------------------------------------------------*
 *----------------------------------------------------------------------------*
 *                               EVOLUCAO
 *----------------------------------------------------------------------------*
 * Data     | Autor      | Description
 *----------------------------------------------------------------------------*
 * 10/05/06 | Jairo Rosa | Criacao do modulo
 * 08/07/06 | Jairo Rosa | Finalizacao da versao 3.0
 *----------------------------------------------------------------------------*
 ******************************************************************************/
#include "GameCore.h"

float fTst = 0;

/******************************************************************************
Metodo : CGameCore ()
Funcao : Construtor
Paramt : N/A
Retorno: N/A
*******************************************************************************/
CGameCore::CGameCore ()
{
  pAux = new CAux ();
  bStatus = true;

  //Prepara ambiente para geracao de numeros aleatorios
  srand( (unsigned)time( NULL ) );

  //Carrega modelos 3DS
  if (pAux->LoadModelDataFile (MODEL_FILE1) != 0)
  {
    MessageBox (NULL, "Erro ao carregar arquivo de modelos 1", "CGameCore", MB_OK);
    bStatus = false;
    return;
  }

  if (pAux->LoadModelDataFile (MODEL_FILE2) != 0)
  {
    MessageBox (NULL, "Erro ao carregar arquivo de modelos 2", "CGameCore", MB_OK);
    bStatus = false;
    return;
  }
 
  //Inicia variaveis
  bHit        = false;
  iMode       = DEFAULT;
  fZoomFact   = 0;
  iTry        = 0;
  bGameOver   = false;
  bEnter      = false;
  iTipoBomba  = BOMB1;

  //Teste
  TesteX = TesteY = TesteZ = 0.0f;

}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : ~CGameCore ()
Funcao : Destrutor
Paramt : N/A
Retorno: N/A
*******************************************************************************/
CGameCore::~CGameCore ()
{
  FlushTextures ();
  delete pAux;
}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : rnd ()
Funcao : Gera numeros aleatorios
Paramt : N/A
Retorno: Retorna um valor float aleatorio entre (0 e 1)
*******************************************************************************/
float CGameCore::rnd ()
{
float fRes, f1;

  f1 = rand ();

  if (f1 < 10000)
    f1 += 10000;

  fRes = f1 / RAND_MAX;

  return (fRes);
}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : InitLighting ()
Funcao : Inicia estruturas de iluminacao e habilita tonalizacao
Paramt : Modo de iluminacao (NIGHT, DAY)
Retorno: N/A
*******************************************************************************/
void CGameCore::InitLighting (int iMode)
{

  
  glDisable(GL_LIGHT0);
  glDisable(GL_LIGHT1);
  glDisable(GL_LIGHT2);

  switch (iMode)
  {
    case NIGHT:
      LightItem[0].LightAmbient[0] = 0.1f;
      LightItem[0].LightAmbient[1] = 0.1f;
      LightItem[0].LightAmbient[2] = 0.3f;
      LightItem[0].LightAmbient[3] = 1.0f;

      LightItem[0].LightDiffuse[0] = 0.001f;
      LightItem[0].LightDiffuse[1] = 0.001f;
      LightItem[0].LightDiffuse[2] = 0.002f;
      LightItem[0].LightDiffuse[3] = 1.0f;

      LightItem[0].LightPosition[0] = 44.0f;
      LightItem[0].LightPosition[1] = 46.0f;
      LightItem[0].LightPosition[2] = -34.0f;
      LightItem[0].LightPosition[3] = 1.0f;

      glLightfv(GL_LIGHT0, GL_AMBIENT, LightItem[0].LightAmbient);
      glLightfv(GL_LIGHT0, GL_DIFFUSE, LightItem[0].LightDiffuse);
      glLightfv(GL_LIGHT0, GL_POSITION,LightItem[0].LightPosition);

      glEnable(GL_LIGHT0);

      break;

    case DAY:
      LightItem[0].LightAmbient[0] = 0.5f;
      LightItem[0].LightAmbient[1] = 0.5f;
      LightItem[0].LightAmbient[2] = 0.5f;
      LightItem[0].LightAmbient[3] = 1.0f;

      LightItem[0].LightDiffuse[0] = 0.005f;
      LightItem[0].LightDiffuse[1] = 0.005f;
      LightItem[0].LightDiffuse[2] = 0.005f;
      LightItem[0].LightDiffuse[3] = 1.0f;

      LightItem[0].LightPosition[0] = 62.0f;
      LightItem[0].LightPosition[1] = 40.0f;
      LightItem[0].LightPosition[2] = -12.0f;
      LightItem[0].LightPosition[3] = 1.0f;
    
      glLightfv(GL_LIGHT0, GL_AMBIENT, LightItem[0].LightAmbient);
      glLightfv(GL_LIGHT0, GL_DIFFUSE, LightItem[0].LightDiffuse);
      glLightfv(GL_LIGHT0, GL_POSITION,LightItem[0].LightPosition);
      
      glEnable(GL_LIGHT0);

      LightItem[1].LightAmbient[0] = 0.5f;
      LightItem[1].LightAmbient[1] = 0.5f;
      LightItem[1].LightAmbient[2] = 0.5f;
      LightItem[1].LightAmbient[3] = 1.0f;

      LightItem[1].LightDiffuse[0] = 0.005f;
      LightItem[1].LightDiffuse[1] = 0.005f;
      LightItem[1].LightDiffuse[2] = 0.005f;
      LightItem[1].LightDiffuse[3] = 1.0f;

      LightItem[1].LightPosition[0] = 58.0f;
      LightItem[1].LightPosition[1] = 48.0f;
      LightItem[1].LightPosition[2] = 28.0f;
      LightItem[1].LightPosition[3] = 1.0f;

      glLightfv(GL_LIGHT1, GL_AMBIENT, LightItem[1].LightAmbient);
      glLightfv(GL_LIGHT1, GL_DIFFUSE, LightItem[1].LightDiffuse);
      glLightfv(GL_LIGHT1, GL_POSITION,LightItem[1].LightPosition);
      
      glEnable(GL_LIGHT1);

      LightItem[2].LightAmbient[0] = 0.5f;
      LightItem[2].LightAmbient[1] = 0.5f;
      LightItem[2].LightAmbient[2] = 0.5f;
      LightItem[2].LightAmbient[3] = 1.0f;

      LightItem[2].LightDiffuse[0] = 0.005f;
      LightItem[2].LightDiffuse[1] = 0.005f;
      LightItem[2].LightDiffuse[2] = 0.005f;
      LightItem[2].LightDiffuse[3] = 1.0f;

      LightItem[2].LightPosition[0] = 280.0f;
      LightItem[2].LightPosition[1] = 120.0f;
      LightItem[2].LightPosition[2] = 120.0f;
      LightItem[2].LightPosition[3] = 1.0f;

      glLightfv(GL_LIGHT2, GL_AMBIENT, LightItem[2].LightAmbient);
      glLightfv(GL_LIGHT2, GL_DIFFUSE, LightItem[2].LightDiffuse);
      glLightfv(GL_LIGHT2, GL_POSITION,LightItem[2].LightPosition);
 
      glEnable(GL_LIGHT2);

      break;
  }


  //Habilita iluminacao em ambos os lados dos modelos
  glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE);

  //Habilita tonalizacao de Gouraud
  glShadeModel(GL_SMOOTH);

  //Ativa iluminacao
  glEnable(GL_LIGHTING);

}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : GetHitStatus()
Funcao : Retorna status de acerto da bomba
Paramt : N/A
Retorno: True/False
*******************************************************************************/
bool CGameCore::GetHitStatus()
{
  return bHit;
}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : CheckStatus()
Funcao : Retorna status de incializacao correta do objeto
Paramt : N/A
Retorno: True/False
*******************************************************************************/
bool CGameCore::CheckStatus()
{
  return bStatus;
}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : SetViewport()
Funcao : Seta um viewport especifico e gerencia zoom
Paramt : [in]Modo (DEFAULT: Perspectiva, UPVIEW: Vista superior, 
         FRONTVIEW: Vista frontal, LEFTVIEW: Vista lateral)
Retorno: N/A
*******************************************************************************/
void CGameCore::SetViewport (int iModeVar)
{

  //fZoomFact eh incrementado/decrementado pela funcao do teclado
  
  if (fZoomFact > MAXZOOM)
    fZoomFact = MAXZOOM;

  if (fZoomFact < MINZOOM)
    fZoomFact = MINZOOM;

  switch (iModeVar)
  {
    case DEFAULT:
      glTranslatef (-1.0f, -0.30f, -1.18f + fZoomFact);
      glRotatef (-37.5f, 0, 1, 0);
      glRotatef (17.0f, 1, 0, 0);
      glRotatef (-19.0, 0, 0, 1);
      break;

    case UPVIEW:    //  X/Z
      glTranslatef (-1.0f, -0.8f, -2.0f + fZoomFact);
      glRotatef (0.0f, 1, 1, 1);
      glRotatef (90.0f, 1, 0, 0);
      break;

    case FRONTVIEW: // -Z/Y
      glTranslatef (0.5f, -0.3f, -1.0f + fZoomFact);
      glRotatef (0.0f, 1, 1, 1);
      glRotatef (90.0f, 0, 1, 0);
      break;

    case LEFTVIEW:  // X/Y
      glTranslatef (-0.8f, -0.3f, -1.0f + fZoomFact);
      glRotatef (0.0f, 1, 1, 1);
      glRotatef (0.0f, 0, 0, 1);
      break;

    default:
      break;
  }

}
//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : InitOpenGL()
Funcao : Configura ambiente OpenGL
Paramt : N/A 
Retorno: true - OK; false - NOK
*******************************************************************************/
bool CGameCore::InitOpenGL()
{

  //Preenchido
  glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
  
  //Habilita teste de profundidade
  glDepthFunc(GL_LESS);
  glEnable(GL_DEPTH_TEST);

  //Carga das texturas
  if (LoadTextures () != 0)
  {
    MessageBox (NULL, "Erro na carga das texturas", "Erro", MB_OK);
    return false;
  } 


  //Habilita texturas
  glEnable(GL_TEXTURE_2D);

  //Desenha o cenario uma vez para ajustar iluminacao
  CreateScenario ();

  //Inicia ambiente de iluminacao
  SelectAmbientLight (DAY);

  return true;
}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : InitDisplay ()
Funcao : Limpa ambiente de desenho
Paramt : N/A 
Retorno: N/A
*******************************************************************************/
void CGameCore::InitDisplay ()
{
    //Esvazia transformacoes
    glLoadIdentity ();

    //Limpa a tela e o Z-Buffer
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : CreateScenario()
Funcao : Desenha o cenario
Paramt : N/A 
Retorno: N/A
*******************************************************************************/
void CGameCore::CreateScenario()
{
int iNbr, x;
t3DObject obj;
float scale = 0.004f;
CVector3 color;

  //As transformacoes aplicadas ao cenario devem ser aplicadas aos objetos
  //Por isso, nao chamaremos glPush/PopMatrix()

  //Centraliza e posiciona o cenario
  SetViewport (iMode);

  glScalef (scale, scale, scale);
  
  //Le o numero de objetos do cenario principal
  iNbr = pAux->GetNbrOfObjects (MDL_FILE2);

  //Desenha cenario
  for (x = 0; x < iNbr; x++)
  {
    pAux->GetMeshObj (&obj, MDL_FILE2, x);

    //Pinta o alvo de vermelho (se nao alvejado). Os demais, branco
    if (strcmp (obj.strName, "Predio9") == 0)
    {
      if (!bHit) //Se nao alvejado, desenha
      {
        if (iRegPer == NIGHT)
        {
          color.x = 1.0f;
          color.y = 1.0f;
          color.z = 1.0f;
          SetMaterial (color, true);

          //Habilita textura noite
          glBindTexture(GL_TEXTURE_2D, texture[ALVO_N]);
        }
        else
          //Habilita textura dia
          glBindTexture(GL_TEXTURE_2D, texture[ALVO]);

        DrawObject (&obj);  
      }
    }
    else
    {
      color.x = 0.1f;
      color.y = 0.1f;
      color.z = 0.1f;

      SetMaterial (color);

      //Atribui as respectivas texturas
      if (strcmp (obj.strName, "Terra") == 0)
        glBindTexture(GL_TEXTURE_2D, texture[TERRENO]);
      else
      if (strcmp (obj.strName, "Predio1") == 0)
        glBindTexture(GL_TEXTURE_2D, texture[PREDIO1]);
      else
      if (strcmp (obj.strName, "Predio2") == 0)
        glBindTexture(GL_TEXTURE_2D, texture[PREDIO2]);
      else
      if (strcmp (obj.strName, "Predio3") == 0)
        glBindTexture(GL_TEXTURE_2D, texture[PREDIO3]);
      else
      if (strcmp (obj.strName, "Predio4") == 0)
        glBindTexture(GL_TEXTURE_2D, texture[PREDIO4]);
      else
      if (strcmp (obj.strName, "Predio5") == 0)
        glBindTexture(GL_TEXTURE_2D, texture[PREDIO5]);
      else
      if (strcmp (obj.strName, "Predio6") == 0)
        glBindTexture(GL_TEXTURE_2D, texture[PREDIO6]);
      else
      if (strcmp (obj.strName, "Predio7") == 0)
        glBindTexture(GL_TEXTURE_2D, texture[PREDIO1]);
      else
      if (strcmp (obj.strName, "Predio8") == 0)
        glBindTexture(GL_TEXTURE_2D, texture[PREDIO2]);
      else
      if (strcmp (obj.strName, "Predio10") == 0)
        glBindTexture(GL_TEXTURE_2D, texture[PREDIO3]);
      else
      if (strcmp (obj.strName, "Predio11") == 0)
        glBindTexture(GL_TEXTURE_2D, texture[PREDIO4]);
      else
      if (strcmp (obj.strName, "Predio12") == 0)
        glBindTexture(GL_TEXTURE_2D, texture[PREDIO5]);
      else
      if (strcmp (obj.strName, "Predio13") == 0)
        glBindTexture(GL_TEXTURE_2D, texture[PREDIO6]);
      else
      if (strcmp (obj.strName, "Predio14") == 0)
        glBindTexture(GL_TEXTURE_2D, texture[PREDIO1]);
      else
      if (strcmp (obj.strName, "Banco1") == 0)
        glBindTexture(GL_TEXTURE_2D, texture[CIMENTO]);
      else
      if (strcmp (obj.strName, "Banco2") == 0)
        glBindTexture(GL_TEXTURE_2D, texture[CIMENTO]);
      else
      if (strcmp (obj.strName, "Gramado") == 0)
        glBindTexture(GL_TEXTURE_2D, texture[GRAMA]);
      else
        glBindTexture(GL_TEXTURE_2D, texture[TEXTNULL]);

      DrawObject (&obj);  
    }
  }

}
      

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : DrawPlane()
Funcao : Desenha o aviao
Paramt : [in] coord x, coord y, coord z 
Retorno: N/A
*******************************************************************************/
void CGameCore::DrawPlane(float dx, float dy, float dz)
{
t3DObject obj;
CVector3 color;
float scale = 1.0f;

  color.x = 1.0f;
  color.y = 1.0f;
  color.z = 1.0f;


  //Usa a transformacao apenas para esse modelo
  glPushMatrix();               //Inicia a pilha

  glScalef (scale, scale, scale);

  //Acerta a posicao correta do modelo
  glRotatef (180, 0, 1, 0);
 
  //Pega o modelo do aviao
  pAux->GetMeshObj (&obj, MDL_FILE1, PLANE);

  glTranslatef (-dx, dy, dz);   //Adiciona transformacao

  if (iRegPer == NIGHT)
    SetMaterial (color, true);
 
  //Atribui a respectiva textura
  glBindTexture(GL_TEXTURE_2D, texture[JATO]);

  DrawObject (&obj);           //Desenha objeto
  glPopMatrix();               //Esvazia a pilha

}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : DrawBomb()
Funcao : Desenha o projetil
Paramt : [in] coord x, coord y, coord z, 
         Tamanho (BOMB1 - pequeno, BOMB2 - medio, BOMB3 - grande),
         Inclinacao em graus
Retorno: True - acertou o alvo
*******************************************************************************/
bool CGameCore::DrawBomb(float dx, float dy, float dz, int iSize, int iIncl)
{
t3DObject obj;
float scale = 1.0f;
float fIncl = (float) iIncl;
CVector3 color;

  //Usa a transformacao apenas para esse modelo
  glPushMatrix();               //Inicia a pilha

  glScalef (scale, scale, scale);
  
  //Acerta a posicao correta do modelo
  glRotatef (180, 0, 1, 0);
  
  pAux->GetMeshObj (&obj, MDL_FILE1, iSize);

  glTranslatef (-dx, dy, dz);    //Adiciona transformacao
  glRotatef (fIncl, 0, 0, 1);

  if (iRegPer == NIGHT)
  {
    color.x = 1.0f;
    color.y = 1.0f;
    color.z = 1.0f;
    SetMaterial (color, true);
  }

  //Atribui as respectiva textura
  glBindTexture(GL_TEXTURE_2D, texture[MISSIL]);
  
  DrawObject (&obj);            //Desenha objeto
  glPopMatrix();                //Esvazia a pilha
  

  //Faz uma falsa deteccao de colisao
  if ((dx < TARGET_POSX1) && (dx > TARGET_POSX0) &&
      (dy > TARGET_POSY1) && (dy < TARGET_POSY0) &&
      (dz > TARGET_POSZ1) && (dz < TARGET_POSZ0))
  {
    return true;
  }

  return false;
}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : DrawObject()
Funcao : Desenha um objeto do arquivo de modelos (3DS)
Paramt : Ptr para estrutura com os objetos
Retorno: N/A
*******************************************************************************/
void CGameCore::DrawObject (t3DObject *object)
{
int x, y, iFace, index;
CVector3  vector;
CVector2  point2d;

  glBegin(GL_TRIANGLES);
  
  //Pega o numero de faces desse objeto
  iFace = object->numOfFaces;

  //Para cada face, obtem os triangulos
  for (x = 0; x < iFace; x++)
  {
    //Obtem o vertice de cada triangulo
    for (y = 0; y < 3; y++)
    {
      //Indice do vertice de cada triangulo
      index = object->pFaces[x].vertIndex[y];

      //Obtem a normal para esse vertice
      glNormal3f(object->pNormals[index].x, object->pNormals[index].y, object->pNormals[index].z);

      //Obtem as coordenadas desse vertice
      vector = object->pVerts[index];

      if (object->bHasTexture)
      {
        point2d = object->pTexVerts[index];

        //Habilitar o BindTexture antes de chamar DrawObject
        glTexCoord2f(point2d.x, point2d.y);
      }      

      //Desenha
      glVertex3f(vector.x, vector.y, vector.z);
    }
  }

  glEnd();  

}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : GetKbdData ()
Funcao : Trata eventos de teclado para a classe
Paramt : [in] Tecla
Retorno: N/A
Obs    : Deve ser chamada pela callback de retorno do teclado  
*******************************************************************************/
void CGameCore::GetKbdData (int Key)
{
  switch (Key)
  {
    case VK_UP:
      coord.y += COORD_OFFSET;
      break;

    case VK_DOWN:
      coord.y -= COORD_OFFSET;
      break;

    case VK_RIGHT:
      coord.x += COORD_OFFSET;
      break;

    case VK_LEFT:
      coord.x -= COORD_OFFSET;
      break;

    case VK_SPACE:
      coord.bPress = true;
      break;

    case 'S':
    case 's':
      iMode = UPVIEW;
      break;

    case 'P':
    case 'p':
      iMode = DEFAULT;
      break;

    case 'L':
    case 'l':
      iMode = LEFTVIEW;
      break;

    case 'F':
    case 'f':
      iMode = FRONTVIEW;
      break;

    case '=':
    case '+':
      fZoomFact += ZOOMFACT;
      break;

    case '-':
    case '_':
      fZoomFact -= ZOOMFACT;
      break;

#ifdef _TESTE
    //Teste
    case '8':
      TesteY += COORD_OFFSET;
      break;

    case '2':
      TesteY -= COORD_OFFSET;
      break;

    case '6':
      TesteX += COORD_OFFSET;
      break;

    case '4':
      TesteX -= COORD_OFFSET;
      break;

    case '0':
      TesteZ -= COORD_OFFSET;
      break;

    case '5':
      TesteZ += COORD_OFFSET;
      break;
#endif

    case 'D':
    case 'd':
      SelectAmbientLight (DAY);
      break;

    case 'N':
    case 'n':
      SelectAmbientLight (NIGHT);
      break;

    case 0x0D:  //Enter
      bEnter = true;
      break;

    case '1':
      if (!coord.bPress)
        iTipoBomba = BOMB1;
      break;

    case '2':
      if (!coord.bPress)
        iTipoBomba = BOMB2;
      break;

    case '3':
      if (!coord.bPress)
        iTipoBomba = BOMB3;
      break;

  }

}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : mainloop ()
Funcao : Laco principal do jogo
Paramt : [in] Tamanho do projetil
Retorno: N/A
Obs    : Deve ser chamada pelo laco principal do sistema (Win32 ou GLUT)
*******************************************************************************/
int CGameCore::mainloop ()
{
static bool bSndControl[2] = {true, true};

    //Limpa ambiente
    InitDisplay ();

    //Desenha o cenario
    CreateScenario ();

#ifdef _TESTE
    //Teste
    DrawCube (TesteX, TesteY, TesteZ);
#endif

    //Resseta coordenadas da bomba
    if (!coord.bPress)
    {
      bcoord.x = plcoord.x;
      bcoord.y = plcoord.y;
      bcoord.z = plcoord.z; 
      bSndControl[0] = true;
      bSndControl[1] = true;
    }

 
    //Limita area de trafego da nave
    if (coord.x > MAX_HORZ)
      coord.x = MAX_HORZ;
    
    if (coord.x < MIN_HORZ)
      coord.x = MIN_HORZ;

    if (coord.y > MAX_VERT)
      coord.y = MAX_VERT;
    
    if (coord.y < MIN_VERT)
      coord.y = MIN_VERT;

    //Calcula a velocidade da nave
    plcoord.x += PLANE_SPEED;
    plcoord.y = -coord.y * 2;           //Manche de aviao
    plcoord.z = coord.x * 2;


    //Faz "wrap around" da trajetoria da nave
    if (plcoord.x > MAX_X)
      plcoord.x = MIN_X;

    //Imprime coordenadas (DEBUG)
    //printf ("\r\nx=%f, y=%f, z=%f", plcoord.x, plcoord.y, plcoord.z);

    //Desenha nave
    DrawPlane (plcoord.x, plcoord.y, plcoord.z);

    //Se pressionado espaco, solta a bomba
    if (coord.bPress)
    {

      if (bSndControl[0])
      {
#ifdef _DEBUG
        PlaySound("..\\Resources\\Launch.wav",NULL,SND_FILENAME|SND_ASYNC);
#else
        PlaySound("Resources\\Launch.wav",NULL,SND_FILENAME|SND_ASYNC);
#endif
        bSndControl[0] = false;
      }

      bcoord.x += BOMB_SPEED;

      switch (iTipoBomba)
      {
        case BOMB3:
          bcoord.y -= BOMB3_SPD;
          break;

        case BOMB2:
          bcoord.y -= BOMB2_SPD;
          break;

        case BOMB1:
          bcoord.y -= BOMB1_SPD;
          break;

      }

      //Desenha a bomba e verifica se ela acertou o alvo
      if (DrawBomb (bcoord.x, bcoord.y, bcoord.z, iTipoBomba, 15))
      {
        bHit = true;
        iTry = 0;
        if (bSndControl[1])
        {
#ifdef _DEBUG
          PlaySound("..\\Resources\\Explode.wav",NULL,SND_FILENAME|SND_ASYNC);
#else
          PlaySound("Resources\\Explode.wav",NULL,SND_FILENAME|SND_ASYNC);
#endif
          bSndControl[1] = false;
        }
      }

      //Limite inferior do solo. 
      //Apos a bomba tocar o solo ou chegar ao fim do cenario
      //permite novo lancamento e devolve o alvo
      if ((bcoord.y < MIN_BOMB) || (bcoord.x > MAX_BOMB))
      {
        coord.bPress = false;
        bHit = false;

        //Conta tentativa
        if (iTry++ >= MAX_TRIES)
          bGameOver = true;

      }
    }
  return 0;
}

//----------------------------------------------------------------------------------------
/******************************************************************************
Metodo : SelectAmbientLight ()
Funcao : Muda iluminacao de acordo com o perfil
Paramt : DAY, NIGHT
Retorno: N/A
*******************************************************************************/
void CGameCore::SelectAmbientLight (int iMode)
{
  switch (iMode)
  {
    case DAY:
      glClearColor(0.3f,0.7f,1.0f,0);
      break;


    case NIGHT:
      glClearColor(0.0f,0.0f,0.0f,0);
      break;
  }

  iRegPer = iMode;

  InitLighting (iMode);
}


//----------------------------------------------------------------------------------------
/******************************************************************************
Metodo : OutText ()
Funcao : Exibe mensagens na tela
Paramt : [in] Vetor de cores (R,G,B), posicao X, posicao Y, texto
Retorno: N/A
*******************************************************************************/
void CGameCore::OutText (CVector3 color, float PosX, float PosY, float PosZ, char *cText, ...)
{
va_list		ap;					//Ptr para lista de argumentos
char cBuf[1024];
int x;

  //Lida com o texto
  if (cText == NULL)
    return;

  //Procura a string por variaveis
  va_start(ap, cText);
  //Converte simbolos em conteudos
  vsprintf(cBuf, cText, ap);
  //Resultados armazenados no buffer
  va_end(ap);

  glColor3f (color.x, color.y, color.z);
  glRasterPos3f(PosX, PosY, PosZ);
  
  for (x = 0; x < strlen (cBuf); x++)
    glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_24, cBuf[x]);
}

//----------------------------------------------------------------------------------------

#ifdef _TESTE
/******************************************************************************
Metodo : DrawCube ()
Funcao : Localizador (apenas para debug)
Paramt : Coordenadas x,y,z
Retorno: N/A
*******************************************************************************/
void CGameCore::DrawCube (float dx, float dy, float dz)
{
CVector3 color;

  color.x = 1.0f;
  color.y = 0.0f;
  color.z = 0.0f;

  SetMaterial (color, true);

  //printf ("\r\ndx=%f, dy=%f, dz=%f", dx, dy, dz);

  glPushMatrix();
  
  glScalef (5.0f, 5.0f, 5.0f);
  glTranslatef (dx, dy, dz);
  

  glBegin (GL_TRIANGLES);
  glVertex3f(0.0f, 0.0f, 0.0f);
  glVertex3f(1.0f, 0.0f, 0.0f);
  glVertex3f(1.0f, 1.0f, 0.0f);
  glVertex3f(0.0f, 1.0f, 0.0f);

  glVertex3f(0.0f, 0.0f, 1.0f);
  glVertex3f(1.0f, 0.0f, 1.0f);
  glVertex3f(1.0f, 1.0f, 1.0f);
  glVertex3f(0.0f, 1.0f, 1.0f);
  glEnd ();
  
  glPopMatrix ();

}
#endif
//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : SetMaterial ()
Funcao : Define uma cor (material) para um objeto
Paramt : Cor (R,G,B), emite luz propria (true)
Retorno: N/A
*******************************************************************************/
void CGameCore::SetMaterial(CVector3 color, bool bSelf)
{

  if (bSelf)
  {
    fvSpecular[0] = 0.8f;
    fvSpecular[1] = 0.8f;
    fvSpecular[2] = 0.8f;
    fvSpecular[3] = 1.0f;

  
    fvEmission[0] = color.x;
    fvEmission[1] = color.y;
    fvEmission[2] = color.z;
    fvEmission[3] = 1.0f;

    fShininess = 70;   

    glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR,  fvSpecular);
    glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION,  fvEmission);
    glMaterialf (GL_FRONT_AND_BACK, GL_SHININESS, fShininess);
  }
  else
  {
    fvSpecular[0] = 0.8f;
    fvSpecular[1] = 0.8f;
    fvSpecular[2] = 0.8f;
    fvSpecular[3] = 1.0f;

  
    fvEmission[0] = color.x;
    fvEmission[1] = color.y;
    fvEmission[2] = color.z;
    fvEmission[3] = 1.0f;

    fShininess = 70;   

    glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR,  fvSpecular);
    glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION,  fvEmission);
    glMaterialf (GL_FRONT_AND_BACK, GL_SHININESS, fShininess);
  }
 
}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : SelectAmbientLight ()
Funcao : Retorna status de fim de jogo
Paramt : N/A
Retorno: Status de fim de jogo (true - encerrado)
*******************************************************************************/
bool CGameCore::IsGameOver()
{
  return bGameOver;
}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : EndLoop ()
Funcao : Laco da tela de encerramento
Paramt : N/A
Retorno: N/A
*******************************************************************************/
void CGameCore::EndLoop ()
{
CVector3 color;

  //Limpa a tela e o Z-Buffer
  glClearColor(0.0f,0.0f,0.0f,0);  
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  

  color.x = 1.0f;
  color.y = 1.0f;
  color.z = 1.0f;


  OutText (color, 250.0f, 180.0f, 0.0f, "FIM DE JOGO");
  OutText (color, 255.0f, 170.0f, 0.0f, "Pressione <ESC> para sair");

}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : ShowModelData ()
Funcao : Exibe na tela dados do arquivo de modelos
Paramt : N/A
Retorno: N/A
*******************************************************************************/
void CGameCore::ShowModelData ()
{
  pAux->ShowModelData ();
}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : LoadTextures ()
Funcao : Carrega as texturas do jogo
Paramt : N/A
Retorno: 0-OK; Indice da textura que deu erro
*******************************************************************************/
int CGameCore::LoadTextures ()
{
int x;

  //Limpa vetor de dados da imagem
  for (x = 0; x < MAX_NUM_TEXTURES; x++)
    TextureImage[x] = NULL;

  //Carrega texturas
#ifdef _DEBUG
  if ((TextureImage[PREDIO1] = pAux->LoadBMP ("..\\Resources\\par-jan1.bmp")) == NULL)
    return PREDIO1;

  if ((TextureImage[PREDIO2] = pAux->LoadBMP ("..\\Resources\\par-jan2.bmp")) == NULL)
    return PREDIO2;

  if ((TextureImage[PREDIO3] = pAux->LoadBMP ("..\\Resources\\par-jan3.bmp")) == NULL)
    return PREDIO3;

  if ((TextureImage[PREDIO4] = pAux->LoadBMP ("..\\Resources\\par-jan4.bmp")) == NULL)
    return PREDIO4;

  if ((TextureImage[PREDIO5] = pAux->LoadBMP ("..\\Resources\\par-jan5.bmp")) == NULL)
    return PREDIO5;

  if ((TextureImage[PREDIO6] = pAux->LoadBMP ("..\\Resources\\par-jan6.bmp")) == NULL)
    return PREDIO6;

  if ((TextureImage[PREDIO9] = pAux->LoadBMP ("..\\Resources\\tijolos.bmp")) == NULL)
    return PREDIO9;

  if ((TextureImage[TERRENO] = pAux->LoadBMP ("..\\Resources\\solo.bmp")) == NULL)
    return TERRENO;

  if ((TextureImage[CIMENTO] = pAux->LoadBMP ("..\\Resources\\cimento.bmp")) == NULL)
    return CIMENTO;

  if ((TextureImage[GRAMA] = pAux->LoadBMP ("..\\Resources\\grama.bmp")) == NULL)
    return GRAMA;

  if ((TextureImage[MISSIL] = pAux->LoadBMP ("..\\Resources\\missil.bmp")) == NULL)
    return MISSIL;

  if ((TextureImage[JATO] = pAux->LoadBMP ("..\\Resources\\jato.bmp")) == NULL)
    return JATO;

  if ((TextureImage[ALVO] = pAux->LoadBMP ("..\\Resources\\alvo.bmp")) == NULL)
    return ALVO;

  if ((TextureImage[ALVO_N] = pAux->LoadBMP ("..\\Resources\\alvo-n.bmp")) == NULL)
    return ALVO_N;
#else
  if ((TextureImage[PREDIO1] = pAux->LoadBMP ("Resources\\par-jan1.bmp")) == NULL)
    return PREDIO1;

  if ((TextureImage[PREDIO2] = pAux->LoadBMP ("Resources\\par-jan2.bmp")) == NULL)
    return PREDIO2;

  if ((TextureImage[PREDIO3] = pAux->LoadBMP ("Resources\\par-jan3.bmp")) == NULL)
    return PREDIO3;

  if ((TextureImage[PREDIO4] = pAux->LoadBMP ("Resources\\par-jan4.bmp")) == NULL)
    return PREDIO4;

  if ((TextureImage[PREDIO5] = pAux->LoadBMP ("Resources\\par-jan5.bmp")) == NULL)
    return PREDIO5;

  if ((TextureImage[PREDIO6] = pAux->LoadBMP ("Resources\\par-jan6.bmp")) == NULL)
    return PREDIO6;

  if ((TextureImage[PREDIO9] = pAux->LoadBMP ("Resources\\tijolos.bmp")) == NULL)
    return PREDIO9;

  if ((TextureImage[TERRENO] = pAux->LoadBMP ("Resources\\solo.bmp")) == NULL)
    return TERRENO;

  if ((TextureImage[CIMENTO] = pAux->LoadBMP ("Resources\\cimento.bmp")) == NULL)
    return CIMENTO;

  if ((TextureImage[GRAMA] = pAux->LoadBMP ("Resources\\grama.bmp")) == NULL)
    return GRAMA;

  if ((TextureImage[MISSIL] = pAux->LoadBMP ("Resources\\missil.bmp")) == NULL)
    return MISSIL;

  if ((TextureImage[JATO] = pAux->LoadBMP ("Resources\\jato.bmp")) == NULL)
    return JATO;

  if ((TextureImage[ALVO] = pAux->LoadBMP ("Resources\\alvo.bmp")) == NULL)
    return ALVO;

  if ((TextureImage[ALVO_N] = pAux->LoadBMP ("Resources\\alvo-n.bmp")) == NULL)
    return ALVO_N;
#endif

  //Inicia vetor de texturas com todas as MAX_NUM_TEXTURES entradas
  glGenTextures  (MAX_NUM_TEXTURES, &texture[0]);

  //Passa os dados ao OpenGL
  AssignTextures (CIMENTO);
  AssignTextures (GRAMA);
  AssignTextures (MISSIL);
  AssignTextures (JATO);
  AssignTextures (PREDIO1);
  AssignTextures (PREDIO2);
  AssignTextures (PREDIO3);
  AssignTextures (PREDIO4);
  AssignTextures (PREDIO5);
  AssignTextures (PREDIO6);
  AssignTextures (PREDIO9);
  AssignTextures (TERRENO);
  AssignTextures (ALVO);
  AssignTextures (ALVO_N);

  return 0;
}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : AssignTexture (int ID)
Funcao : Passa os dados da textura ao OpenGL
Paramt : N/A
Retorno: N/A
*******************************************************************************/
void CGameCore::AssignTextures (int ID)
{
AUX_RGBImageRec *pTexture;

  if (ID >= MAX_NUM_TEXTURES)
  {
    MessageBox (NULL, "Excedido o numero maximo de texturas", "Erro", MB_OK);
    return;
  }

  glBindTexture(GL_TEXTURE_2D, texture[ID]);
  pTexture = TextureImage[ID];

  glTexImage2D( GL_TEXTURE_2D, 0, 3, pTexture->sizeX, pTexture->sizeY, 
                0, GL_RGB, GL_UNSIGNED_BYTE, pTexture->data);

  //Filtragem linear
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);

}

//----------------------------------------------------------------------------------------

/******************************************************************************
Metodo : FlushTextures ()
Funcao : Libera memoria usada na carga das texturas
Paramt : N/A
Retorno: N/A
*******************************************************************************/
void CGameCore::FlushTextures ()
{
int x;

  try
  {
    for (x = 0; x < MAX_NUM_TEXTURES; x++)
    {
      if (TextureImage[x])
      {
        if (TextureImage[x]->data)
        {
          free (TextureImage[x]->data);
          TextureImage[x]->data = NULL;
        }
        free (TextureImage[x]);
        TextureImage[x] = NULL;
      }
    }
  }

  catch (...)
  {
#ifdef _DEBUG
    MessageBox (NULL, "Excecao em Aux::FlushTextures()", "Debug", MB_OK);
#endif
  }
}


//----------------------------------------------------------------------------------------

