/******************************************************************************
 * Arquivo :   TiroAoAlvoGlut.cpp
 * Projeto :   IA725 - Computacao grafica 1
 * Modulo :    Principal com uso de Glut
 * Date :      10/05/06
 * Version :   0.1
 *----------------------------------------------------------------------------*
 *----------------------------------------------------------------------------*
 *                               DESCRICAO
 *
 * Modulo principal que instancia os objetos e registra callbacks Glut
 *----------------------------------------------------------------------------*
 *----------------------------------------------------------------------------*
 *                               EVOLUCAO
 *----------------------------------------------------------------------------*
 * Data     | Autor      | Description
 *----------------------------------------------------------------------------*
 * 10/05/06 | Jairo Rosa | Criacao do modulo
 *----------------------------------------------------------------------------*
 ******************************************************************************/
#include "stdafx.h"
#include <windows.h>
#include <GL/gl.h>   //biblioteca glut
#include <GL/glu.h>
#include <GL/glut.h>
#include "GameCore.h"

#define GAME_NAME       "Tiro ao Alvo"

//Objeto principal do jogo
CGameCore *pGame = NULL;


/***********************************************************************************
 * Funcao: init ()
 * Uso   : Inicializacoes gerais
 * Param : N/A
 ***********************************************************************************/
void init(void)
{
  printf ("\r\ninit()");
  
  if (!pGame->InitOpenGL ())
    exit (0);
 
}

//-------------------------------------------------------------------------------------------------
/***********************************************************************************
 * Funcao: cb_redraw ()
 * Uso   : Callback de redesenho da tela
 * Param : N/A
 ***********************************************************************************/
void cb_redraw (void)
{
static bFirstRun = true;

  if (!pGame->IsGameOver())
    pGame->mainloop ();
  else
    pGame->EndLoop ();
  
  //Desenho
  glutSwapBuffers();

}

//-------------------------------------------------------------------------------------------------
/***********************************************************************************
 * Funcao: cb_reshape ()
 * Uso   : Callback de redimensionamento da janela
 * Param : [in] largura, altura
 ***********************************************************************************/
void cb_reshape (int w, int h)
{
  
  glViewport (0, 0, (GLsizei) w, (GLsizei) h);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  gluPerspective(45.0, (GLfloat) w/(GLfloat) h, 0.1, 100.0);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
}

//-------------------------------------------------------------------------------------------------
/***********************************************************************************
 * Funcao: cb_keyboard ()
 * Uso   : Callback de resposta ao teclado para teclas especiais (F1..Fn, setas, etc)
 * Param : [in] tecla, cursor do mouse x, cursor do mouse y
 ***********************************************************************************/
void cb_special_kbd (int key, int x, int y)
{

  //printf ("\r\nSpecial_keyboard(): x=%d, y=%d, key=%d", x, y, key);

  switch (key) 
  {
    case GLUT_KEY_UP :
      pGame->GetKbdData (VK_UP);
      break;

    case GLUT_KEY_DOWN :
      pGame->GetKbdData (VK_DOWN);
      break;

    case GLUT_KEY_RIGHT :
      pGame->GetKbdData (VK_RIGHT);
      break;

    case GLUT_KEY_LEFT :
      pGame->GetKbdData (VK_LEFT);
      break;
  }

  glutPostRedisplay();
}

//-------------------------------------------------------------------------------------------------
/***********************************************************************************
 * Funcao: cb_keyboard ()
 * Uso   : Callback de resposta ao teclado
 * Param : [in] tecla, cursor do mouse x, cursor do mouse y
 ***********************************************************************************/
void cb_keyboard (unsigned char key, int x, int y)
{
  //printf ("\r\nkeyboard(): key=%d, x=%d, y=%d", key, x, y);

  switch (key) 
  {
    case 32:
      pGame->GetKbdData (VK_SPACE);
      break;

    case 27:
      exit(0);
      break;

    case 'I':
    case 'i':
      pGame->ShowModelData ();
      break;

    default:
      pGame->GetKbdData (key);
  }

  glutPostRedisplay();
}

//-------------------------------------------------------------------------------------------------
/***********************************************************************************
 * Funcao: cb_mouse ()
 * Uso   : Callback de resposta  leitura do mouse
 * Param : [in] estado do botao (1- solto, 0- pressionado), cursor do mouse x, cursor do mouse y
 ***********************************************************************************/
void cb_mouse(int button, int state, int x, int y)
{
  //printf ("\r\nmouse(): button=%d, x=%d, y=%d", state, x, y);

  switch (button) 
  {
    case GLUT_LEFT_BUTTON:
      break;

    default:
      break;
  }
}


//-------------------------------------------------------------------------------------------------
/***********************************************************************************
 * Funcao: cb_dragmouse ()
 * Uso   : Callback de resposta  leitura do mouse em operacao clicar+arrastar
 * Param : [in] cursor do mouse x, cursor do mouse y
 ***********************************************************************************/
void cb_dragmouse( int x, int y)
{
  //printf ("\r\nmotion_mouse(): x=%d, y=%d", x, y);
  glutPostRedisplay();
}

//-------------------------------------------------------------------------------------------------
static void idle_animacao(void)
{
  //printf ("\r\nidle_animacao()");
  Sleep (1);
  glutPostRedisplay();

}

/***********************************************************************************
 * Funcao: cb_isVisible ()
 * Uso   : Callback de status de visibilidade da janela
 * Param : [in] Status (1- visivel, 0- minimizado)
 ***********************************************************************************/
void cb_isVisible(int status)
{
  //printf ("\r\nvisibilidade(): status = %d", status);

  if (status == GLUT_VISIBLE) 
  {
    glutIdleFunc(idle_animacao);
  } 
  else 
  {
    glutIdleFunc(NULL);
  }

}

//-------------------------------------------------------------------------------------------------
/***********************************************************************************
 * Funcao: main ()
 * Uso   : Entry point
 * Param : [in] numero de argumentos, lista de argumentos
 ***********************************************************************************/
int main(int argc, char* argv[])
{
  //Instancia objeto do jogo
  pGame = new CGameCore ();

  if (!pGame->CheckStatus())
  {
    MessageBox (NULL, "Erro ao instanciar CGameCore", GAME_NAME, MB_OK);
    return -1;
  }

  //Inicia glut
  glutInit(&argc, argv);

  //Modo de exibicao (double buffer, RGB, habilita Z-Buffer)
  glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);

  //Tamanho da janela
  glutInitWindowSize (WSIZE_X, WSIZE_Y);

  //Posicao inicial da janela
  glutInitWindowPosition (0, 0);

  //Nome da janela
  glutCreateWindow (GAME_NAME);

  //Inicia dados
  init ();

  //************ Registra callbacks ************
  //Desenho
  glutDisplayFunc(cb_redraw); 

  //Redimensao
  glutReshapeFunc(cb_reshape);

  //Leitura de teclas especiais
  glutSpecialFunc(cb_special_kbd);

  //Leitura do teclado
  glutKeyboardFunc(cb_keyboard);

  //Leitura do mouse
  glutMouseFunc(cb_mouse);

  //Arrastar
  glutMotionFunc(cb_dragmouse);

  //Estado da janela
  glutVisibilityFunc(cb_isVisible);
  //************ Fim de registro   ************

#ifndef _DEBUG
  char cBuf[255];

  if (MessageBox (NULL, "Rodar em tela cheia ?", GAME_NAME, MB_YESNO) == IDYES)
    glutFullScreen();


  sprintf (cBuf,  "TIRO AO ALVO\r\n"
                  "IA725 - Computacao Grafica I\r\n\n"
                  "Prof. Dr. Jose Martino & Profa Dra. Wu Shin Ting\r\n\n"
                  "Jairo Rosa - RA 66259\r\n"
                  "V0.3 - julho 2006");
  
  MessageBox (NULL, cBuf, GAME_NAME, MB_OK);

  sprintf (cBuf,  "TIRO AO ALVO\r\n\n"
                  "Instrucoes:\r\n\n"
                  "<1> Projetil grande\r\n"
                  "<2> Projetil medio\r\n"
                  "<3> Projetil pequeno\r\n"
                  "<S> Vista superior\r\n"
                  "<F> Vista traseira\r\n"
                  "<L> Vista lateral\r\n"
                  "<P> Vista perspectiva\r\n"
                  "<D> Iluminacao diurna\r\n"
                  "<N> Iluminacao noturna\r\n"
                  "<+> Afasta o observador\r\n"
                  "<-> Aproxima o observador\r\n"
                  "<ESPACO> Lanca projetil\r\n"
                  "<ESC> Sai do jogo\r\n");

  MessageBox (NULL, cBuf, GAME_NAME, MB_OK);
#endif

  //Laco principal
  glutMainLoop();

  delete pGame;

	return 0;
}

//-------------------------------------------------------------------------------------------------