#include "interface\ac3dReader.h"
#include "interface\ac3dReader_gl.h"
#include "interface\glut.h"
#include <stdlib.h>
#include <time.h>

static ac3dfile_t* ac3dfile;
GLfloat cx,cy,cz;

char* textureTest;

void processNormalKeys(unsigned char key, int x, int y) 
{
	switch(key)
	{
	case 'a':
	case 'A':
		{
			cx += 1.0f;
		}
		break;
	case 'w':
	case 'W':
		{
			cz += 1.0f;
		}
		break;
	case 's':
	case 'S':
		{
			cz -= 1.0f;
		}
		break;
	case 'd':
	case 'D':
		{
			cx -= 1.0f;
		}
		break;
	}
	glLoadIdentity (); /* clear the matrix */
	gluLookAt (cx, cy, cz, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);

	setLights();
	
}


static void init(void)
{
	//glClearColor (0.0, 0.0, 0.0, 0.0);
	//glShadeModel (GL_FLAT);
	
	glClearColor(0.0f, 0.0f, 0.0f, 0.5f);				// Black Background
	glClearDepth(1.0f);	
	glClearStencil(0);
	glEnable(GL_DEPTH_TEST);							// Enables Depth Testing
	//glDepthFunc(GL_LEQUAL);	
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);

	glEnable(GL_CULL_FACE);
	glCullFace(GL_BACK);
	
	//glShadeModel (GL_SMOOTH);
	glLoadIdentity (); /* clear the matrix */
	
	gluLookAt (cx, cy, cz, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);

	setLights();
		
}

static void display(void)
{
	ac3dReader_GL_Draw(ac3dfile);
	//glutSwapBuffers();

}

static void reshape (int w, int h)
{
	glViewport (0, 0, (GLsizei) w, (GLsizei) h);
	glMatrixMode (GL_PROJECTION);
	glLoadIdentity ();
	glFrustum (-1.0, 1.0, -1.0, 1.0, 1.5, 100.0);
	glMatrixMode (GL_MODELVIEW);
}
int main(int argc, char** argv)
{
	char progrName[64];
	clock_t start, end;

	sprintf(progrName,"AC3D: %s",argv[1]);
	cx = 12;
	cy = 12;
	cz = 9.0f;

	start = clock ();
	ac3dReader_Load(argv[1],&ac3dfile);
	end = clock ();
	printf("time loading: %f\n", ((float)(end - start))/CLOCKS_PER_SEC);
	glutInit(&argc, argv);
	//glutInitDisplayMode (GLUT_DEPTH | GLUT_DOUBLE | GLUT_RGB);
	glutInitWindowSize (800, 800);
	glutInitWindowPosition (100, 100);
	glutCreateWindow (progrName);

	init ();

	autoPrepareShadow(ac3dfile);

	glutDisplayFunc(display);
	glutIdleFunc(display);

	glutKeyboardFunc(processNormalKeys); 
	glutReshapeFunc(reshape);
	glutMainLoop();
	system("pause");
	return 0;
}