#ifndef AC3DREADER_H
#define AC3DREADER_H

#include "stdio.h"

#define AC3D_BUFFER_SIZE 512

#if AC3D_DEBUG 1
static unsigned long mem=0;
#define MALL_ALLOC(x) malloc(x);  mem+=x;
#define FREE(x) free(x); 

#else
#define MALL_ALLOC(x) malloc(x);
#define FREE(x) free(x);
#endif


typedef enum{
	POLY,
} ac3dObject_type_t;

typedef struct t_material{
	char* name;
	float r,g,b;
	float amb[3];
	float emis[3];
	float spec[3];
	float diffuse[3];
	float shi;
	unsigned int trans;
	struct t_material* next;
} ac3dfile_material_t;

typedef struct{
	unsigned int numberOfVisibleLights;
	int* lightVisible;
	float** vertices; //[VisibleLight][Vertices]
} ac3dfile_shadow_t;


typedef struct{
	unsigned int numberOfRefs;
	long int* references;
	ac3dfile_material_t* material;
	ac3dfile_shadow_t* shadow;
} ac3dfile_surf_t;

typedef struct{
	char *name;
	long int numberOfVertices;
	float* vertices;
	float* verticeColors;
	float* textCoordArray;
	int texture;
	char* textureFile;
	ac3dObject_type_t objectType;
	ac3dfile_surf_t** surfaces;
	long numberOfSurfaces;
} ac3dfile_object_t;


typedef struct {
	char* filepath;
	unsigned int numberOfOjects;
	unsigned int numberOfMaterials;
	ac3dfile_object_t** objects;
	ac3dfile_object_t** materials;
	ac3dfile_material_t* materialLinkedList;
} ac3dfile_t;

typedef enum{
	AC3D_SUCCESS,
    AC3D_FAILED
} ac3dReturn_t;

ac3dReturn_t ac3dReader_Load(char* filepath, ac3dfile_t** ppAC3DFile);

void ac3dReader_Free(ac3dfile_t* ac3dfile);

void ac3dReader_Print(ac3dfile_t* ac3dfile);
#endif