#include "..\interface\ac3dReader_gl.h"
#include "..\interface\glut.h"

#define INFINITY 10

#define MIN_DISTANCE 1.001

static int sceneDisplayListCreated = 0;
static int sceneListIndex=-1;


GLfloat light0Pos[] = {22.0f,12.0f,57.0f,1.0f};
GLfloat light0PosR[] = {22.0f,12.0f,-19.0f,1.0f};
GLfloat light1Pos[] = {-13.0f,12.0f,57.0f,1.0f};
GLfloat light1PosR[] = {-13.0f,12.0f,-19.0f,1.0f};
GLfloat light2Pos[] = {22.0f,12.0f,19.0f,1.0f};
GLfloat light3Pos[] = {-13.0f,12.0f,19.0f,1.0f};

GLfloat* lights[] = {light0PosR,light1PosR,light2Pos,light3Pos};

float v[3][3];
float plane[4];

GLfloat yellow[] = {1.0f,1.0f,0.0f};
	
static void drawShadowVolume(ac3dfile_t* ac3dfile, unsigned int object);
static int isVisible(ac3dfile_t* ac3dfile, int ind, ac3dfile_surf_t* surface, float* lightPos);
void PrepareShadow(ac3dfile_t* ac3dfile,unsigned int numberOfLights,float** lightPos);

int texLoaded = 0;
GLuint texInd;

// load a 256x256 RGB .RAW file as a texture
GLuint LoadTextureRAW( const char * filename, int wrap )
{
    GLuint texture;
    int width, height;
    char * data;
    FILE * file;

    // open texture data
    file = fopen( filename, "rb" );
    if ( file == NULL ) return 0;

    // allocate buffer
    width = 1024;
    height = 1024;
    data = malloc( width * height * 3 );

    // read texture data
    fread( data, width * height * 3, 1, file );
    fclose( file );

    // allocate a texture name
    glGenTextures( 1, &texture );

    // select our current texture
    glBindTexture( GL_TEXTURE_2D, texture );

    // select modulate to mix texture with color for shading
	glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL );

    // when texture area is small, bilinear filter the closest mipmap
    glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,
                     GL_LINEAR_MIPMAP_NEAREST );
    // when texture area is large, bilinear filter the first mipmap
    glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );

    // if wrap is true, the texture wraps over at the edges (repeat)
    //       ... false, the texture ends at the edges (clamp)
    glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S,
                     wrap ? GL_REPEAT : GL_CLAMP );
    glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T,
                     wrap ? GL_REPEAT : GL_CLAMP );

    // build our texture mipmaps
    gluBuild2DMipmaps( GL_TEXTURE_2D, 3, width, height,
                       GL_RGB, GL_UNSIGNED_BYTE, data );

    // free buffer
    free( data );


    return texture;
}

// function for computing a plane equation given 3 points
static int isVisible(ac3dfile_t* ac3dfile, int ind, ac3dfile_surf_t* surface, float* lightPos){
	int i;
	float side=0;

	for (i=0;i<3;i++){
		v[i+1][0] = ac3dfile->objects[ind]->vertices[surface->references[i]*3];
		v[i+1][1] = ac3dfile->objects[ind]->vertices[surface->references[i]*3+1];
		v[i+1][2] = ac3dfile->objects[ind]->vertices[surface->references[i]*3+2];
	}
	plane[0] = v[1][1]*(v[2][2]-v[3][2]) + v[2][1]*(v[3][2]-v[1][2]) + v[3][1]*(v[1][2]-v[2][2]);
	plane[1] = v[1][2]*(v[2][0]-v[3][0]) + v[2][2]*(v[3][0]-v[1][0]) + v[3][2]*(v[1][0]-v[2][0]);
	plane[2] = v[1][0]*(v[2][1]-v[3][1]) + v[2][0]*(v[3][1]-v[1][1]) + v[3][0]*(v[1][1]-v[2][1]);
	plane[3] =-( v[1][0]*(v[2][1]*v[3][2] - v[3][1]*v[2][2]) +
					  v[2][0]*(v[3][1]*v[1][2] - v[1][1]*v[3][2]) +
					  v[3][0]*(v[1][1]*v[2][2] - v[2][1]*v[1][2]) );

	side =	plane[0]*lightPos[0]+
		plane[1]*lightPos[1]+
		plane[2]*lightPos[2]+
		plane[3]*lightPos[3];

	if (side >0) return 1;
	else return 0;
}

void setLights()
{

	GLfloat lightColor[] = {0.4f,0.4f,0.4f,1.0f};

	GLfloat nothing[] = {0.0f,0.0f,0.0f,0.0f};

	glEnable(GL_LIGHTING);

	glLightfv(GL_LIGHT0,GL_DIFFUSE,lightColor);
	glLightfv(GL_LIGHT1,GL_DIFFUSE,lightColor);
	glLightfv(GL_LIGHT2,GL_DIFFUSE,lightColor);
	glLightfv(GL_LIGHT3,GL_DIFFUSE,lightColor);

	glLightfv(GL_LIGHT0,GL_SPECULAR,nothing);
	glLightfv(GL_LIGHT1,GL_SPECULAR,nothing);
	glLightfv(GL_LIGHT2,GL_SPECULAR,nothing);
	glLightfv(GL_LIGHT3,GL_SPECULAR,nothing);


	glLightfv(GL_LIGHT0,GL_POSITION,light0Pos);
	glLightfv(GL_LIGHT1,GL_POSITION,light1Pos);
	glLightfv(GL_LIGHT2,GL_POSITION,light2Pos);
	glLightfv(GL_LIGHT3,GL_POSITION,light3Pos);


	glEnable(GL_LIGHT0);
	glEnable(GL_LIGHT1);
	glEnable(GL_LIGHT2);
	glEnable(GL_LIGHT3);

	
}

void autoPrepareShadow(ac3dfile_t* ac3dfile)
{
	PrepareShadow(ac3dfile,4,&lights[0]);
}

void PrepareShadow(ac3dfile_t* ac3dfile,unsigned int numberOfLights,float** lightPos)
{
	int i,j,k,aux;

	for(i=0;i<ac3dfile->numberOfOjects;i++)
	{
		for(j=0;j<ac3dfile->objects[i]->numberOfSurfaces;j++)
		{
			ac3dfile_surf_t* surface = ac3dfile->objects[i]->surfaces[j];

			surface->shadow = MALL_ALLOC(sizeof(ac3dfile_shadow_t));

			surface->shadow->lightVisible = MALL_ALLOC(sizeof(int)*numberOfLights);
			surface->shadow->vertices = MALL_ALLOC(sizeof(float*)*numberOfLights);

			surface->shadow->numberOfVisibleLights = 0;

			for(k=0;k<numberOfLights;k++)
			{
				aux = isVisible(ac3dfile,i,surface,lightPos[k]);
				surface->shadow->lightVisible[k]= aux;

				if(aux==1)
				{
					float* vertex;
					
					//CalculateShadowVertices
					surface->shadow->vertices[surface->shadow->numberOfVisibleLights] = MALL_ALLOC(sizeof(float)*3*6);

					vertex = surface->shadow->vertices[surface->shadow->numberOfVisibleLights];

					vertex[0] = (ac3dfile->objects[i]->vertices[3*surface->references[0]]-lightPos[k][0])*INFINITY + lightPos[k][0];
					vertex[1] = (ac3dfile->objects[i]->vertices[3*surface->references[0]+1]-lightPos[k][1])*INFINITY + lightPos[k][1];
					vertex[2] = (ac3dfile->objects[i]->vertices[3*surface->references[0]+2]-lightPos[k][2])*INFINITY + lightPos[k][2];

					vertex[3] = (ac3dfile->objects[i]->vertices[3*surface->references[1]]-lightPos[k][0])*INFINITY + lightPos[k][0];
					vertex[4] = (ac3dfile->objects[i]->vertices[3*surface->references[1]+1]-lightPos[k][1])*INFINITY + lightPos[k][1];
					vertex[5] = (ac3dfile->objects[i]->vertices[3*surface->references[1]+2]-lightPos[k][2])*INFINITY + lightPos[k][2];

					vertex[6] = (ac3dfile->objects[i]->vertices[3*surface->references[2]]-lightPos[k][0])*INFINITY + lightPos[k][0];
					vertex[7] = (ac3dfile->objects[i]->vertices[3*surface->references[2]+1]-lightPos[k][1])*INFINITY + lightPos[k][1];
					vertex[8] = (ac3dfile->objects[i]->vertices[3*surface->references[2]+2]-lightPos[k][2])*INFINITY + lightPos[k][2];

					vertex[9] = (ac3dfile->objects[i]->vertices[3*surface->references[0]]-lightPos[k][0])*MIN_DISTANCE + lightPos[k][0];
					vertex[10] = (ac3dfile->objects[i]->vertices[3*surface->references[0]+1]-lightPos[k][1])*MIN_DISTANCE + lightPos[k][1];
					vertex[11] = (ac3dfile->objects[i]->vertices[3*surface->references[0]+2]-lightPos[k][2])*MIN_DISTANCE + lightPos[k][2];

					vertex[12] = (ac3dfile->objects[i]->vertices[3*surface->references[1]]-lightPos[k][0])*MIN_DISTANCE + lightPos[k][0];
					vertex[13] = (ac3dfile->objects[i]->vertices[3*surface->references[1]+1]-lightPos[k][1])*MIN_DISTANCE + lightPos[k][1];
					vertex[14] = (ac3dfile->objects[i]->vertices[3*surface->references[1]+2]-lightPos[k][2])*MIN_DISTANCE + lightPos[k][2];

					vertex[15] = (ac3dfile->objects[i]->vertices[3*surface->references[2]]-lightPos[k][0])*MIN_DISTANCE + lightPos[k][0];
					vertex[16] = (ac3dfile->objects[i]->vertices[3*surface->references[2]+1]-lightPos[k][1])*MIN_DISTANCE + lightPos[k][1];
					vertex[17] = (ac3dfile->objects[i]->vertices[3*surface->references[2]+2]-lightPos[k][2])*MIN_DISTANCE + lightPos[k][2];

					surface->shadow->numberOfVisibleLights++;
				}
			}

		}

	}
	
}

static void  CastShadow(ac3dfile_t* ac3dfile)
{
	int i =0,j;

	glClearStencil(0);

	for(i=0;i<ac3dfile->numberOfOjects;i++)
	{
		//glPushAttrib( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_ENABLE_BIT | GL_POLYGON_BIT | GL_STENCIL_BUFFER_BIT );
		glDisable( GL_LIGHTING );					// Turn Off Lighting
		glDepthMask( GL_FALSE );					// Turn Off Writing To The Depth-Buffer
		glDepthFunc( GL_LEQUAL );


		glEnable(GL_STENCIL_TEST);
		glColorMask(0, 0, 0, 0);
		glStencilFunc(GL_ALWAYS, 1, 0xffffffff);

		// First Pass. Increase Stencil Value In The Shadow
		glFrontFace( GL_CCW );
		glStencilOp( GL_KEEP, GL_KEEP, GL_INCR );
		drawShadowVolume( ac3dfile,i);

		glFrontFace( GL_CW );
		glStencilOp( GL_KEEP, GL_KEEP, GL_DECR );
		drawShadowVolume( ac3dfile,i);


		glFrontFace(GL_CCW);
		glColorMask(1, 1, 1, 1);

		glColor4f(0.0f,0.0f, 0.0f, 0.05f);


		

		glDepthFunc(GL_LEQUAL);
		glDepthMask(GL_TRUE);
		glEnable(GL_LIGHTING);
		glDisable(GL_STENCIL_TEST);
	}

			//glPushAttrib( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_ENABLE_BIT | GL_POLYGON_BIT | GL_STENCIL_BUFFER_BIT );
		glDisable( GL_LIGHTING );					// Turn Off Lighting
		glDepthMask( GL_FALSE );					// Turn Off Writing To The Depth-Buffer
		glDepthFunc( GL_LEQUAL );


		glEnable(GL_STENCIL_TEST);

		glFrontFace(GL_CCW);
		glColorMask(1, 1, 1, 1);

		glColor4f(0.0f,0.0f, 0.0f, 0.2f);
		
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		
		for(j=1;j<10;j++)
		{
			glColor4f(0.0f,0.0f, 0.0f, j*0.15f);
			glStencilFunc(GL_EQUAL, j, 0xffffffff);
			glStencilOp(GL_KEEP, GL_KEEP, GL_KEEP);
			glPushMatrix();
			glLoadIdentity();
			glBegin(GL_TRIANGLE_STRIP);
			glVertex3f(-10.0f, +10.1f,-2.10f);
			glVertex3f(-10.0f,-10.1f,-2.10f);
			glVertex3f( +10.0f, +10.1f,-2.10f);
			glVertex3f( +10.0f,-10.1f,-2.10f);
			glEnd();
			glPopMatrix();
		}
		
		glDisable(GL_BLEND);
		glDepthFunc(GL_LEQUAL);
		glDepthMask(GL_TRUE);
		glEnable(GL_LIGHTING);
		glDisable(GL_STENCIL_TEST);



}

static void drawShadowVolume(ac3dfile_t* ac3dfile, unsigned int object)
{
	unsigned int i = object;
	int j,k;


	for(j=0;j<ac3dfile->objects[i]->numberOfSurfaces;j++)
	{
		ac3dfile_surf_t* surface = ac3dfile->objects[i]->surfaces[j];	

		for(k=0;k<surface->shadow->numberOfVisibleLights;k++)
		{

			glBegin(GL_TRIANGLE_STRIP);
			glVertex3fv(&ac3dfile->objects[i]->vertices[3*surface->references[0]]);
			glVertex3fv(&surface->shadow->vertices[k][0]);
			glVertex3fv(&ac3dfile->objects[i]->vertices[3*surface->references[1]]);
			glVertex3fv(&surface->shadow->vertices[k][3]);
			glEnd();


			glBegin(GL_TRIANGLE_STRIP);
			glVertex3fv(&ac3dfile->objects[i]->vertices[3*surface->references[1]]);
			glVertex3fv(&surface->shadow->vertices[k][3]);
			glVertex3fv(&ac3dfile->objects[i]->vertices[3*surface->references[2]]);
			glVertex3fv(&surface->shadow->vertices[k][6]);
			glEnd();


			glBegin(GL_TRIANGLE_STRIP);
			glVertex3fv(&ac3dfile->objects[i]->vertices[3*surface->references[2]]);
			glVertex3fv(&surface->shadow->vertices[k][6]);
			glVertex3fv(&ac3dfile->objects[i]->vertices[3*surface->references[0]]);
			glVertex3fv(&surface->shadow->vertices[k][0]);
			glEnd();

			glBegin(GL_TRIANGLE_STRIP);
			glVertex3fv(&surface->shadow->vertices[k][9]);
			glVertex3fv(&surface->shadow->vertices[k][12]);
			glVertex3fv(&surface->shadow->vertices[k][15]);
			glEnd();

			
			glBegin(GL_TRIANGLE_STRIP);
			glVertex3fv(&surface->shadow->vertices[k][6]);
			glVertex3fv(&surface->shadow->vertices[k][3]);
			glVertex3fv(&surface->shadow->vertices[k][0]);
			glEnd();


		}

	}



}



ac3dReturn_t ac3dReader_GL_Draw(ac3dfile_t* ac3dfile)
{
	unsigned int i = 0;
	float r,g,b;
	GLfloat noSpec[] = {0.0f,0.0f,0.0f};

	// Clear Color Buffer, Depth Buffer, Stencil Buffer
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);


	if(sceneDisplayListCreated==0)
	{
		sceneListIndex = glGenLists(1);
		glNewList(sceneListIndex, GL_COMPILE);

		for(i=0;i<ac3dfile->numberOfOjects;i++)
		{
			unsigned int j = 0;		

			glDisable(GL_TEXTURE_2D);

			glEnableClientState (GL_VERTEX_ARRAY);
			glDisableClientState(GL_TEXTURE_COORD_ARRAY);
			//GL_TEXTURE_COORD_ARRAY
			//glEnableClientState (GL_COLOR_ARRAY);

			if(ac3dfile->objects[i]->numberOfVertices > 0)
			{
				unsigned int glMode,size;
			
				glVertexPointer(3, GL_FLOAT, 0, (GLvoid *)ac3dfile->objects[i]->vertices);
				glMode = GL_TRIANGLES;
				size = 3;




				if(ac3dfile->objects[i]->texture == 1)
				{
					GLuint textId;

					glEnable(GL_TEXTURE_2D);
					
					if(texLoaded==0)
					{
						texLoaded = 1;
						textId = LoadTextureRAW("tex.raw",1);
					}
					else
						textId = texInd;

					glEnableClientState(GL_TEXTURE_COORD_ARRAY);
					glTexCoordPointer(2,GL_FLOAT,0,ac3dfile->objects[i]->textCoordArray);

				}


				//glColorPointer(3,GL_FLOAT,0,(GLvoid *)ac3dfile->objects[i]->verticeColors);

				for(j=0;j<ac3dfile->objects[i]->numberOfSurfaces;j++)
				{
					unsigned int k=0;

					glMaterialfv(GL_FRONT,GL_AMBIENT,ac3dfile->objects[i]->surfaces[j]->material->amb);
					glMaterialfv(GL_FRONT,GL_DIFFUSE,ac3dfile->objects[i]->surfaces[j]->material->diffuse);
					glMaterialfv(GL_FRONT,GL_SPECULAR,noSpec);
					glMaterialf(GL_FRONT,GL_SHININESS,ac3dfile->objects[i]->surfaces[j]->material->shi);
					glMaterialfv(GL_FRONT,GL_EMISSION,ac3dfile->objects[i]->surfaces[j]->material->emis);

					//glColor3f(ac3dfile->objects[i]->surfaces[j]->material->r,ac3dfile->objects[i]->surfaces[j]->material->g,ac3dfile->objects[i]->surfaces[j]->material->b);
					
					if(ac3dfile->objects[i]->surfaces[j]->numberOfRefs == size)
						glDrawElements(glMode, size, GL_UNSIGNED_INT, ac3dfile->objects[i]->surfaces[j]->references);	

					//glBegin(glMode);
					//
					//for(k=0;k<ac3dfile->objects[i]->surfaces[j]->numberOfRefs;k++)
					//{

					//	//printf("R: %f\n",ac3dfile->objects[i]->verticeColors[ac3dfile->objects[i]->surfaces[j]->references[k]*3]);
					//	/*glColor3f (ac3dfile->objects[i]->verticeColors[ac3dfile->objects[i]->surfaces[j]->references[k]*3],
					//		ac3dfile->objects[i]->verticeColors[ac3dfile->objects[i]->surfaces[j]->references[k]*3+1],
					//		ac3dfile->objects[i]->verticeColors[ac3dfile->objects[i]->surfaces[j]->references[k]*3+2]);*/
					//	glArrayElement(ac3dfile->objects[i]->surfaces[j]->references[k]);
					//}
					//glEnd();
				}
			}
		}

		CastShadow(ac3dfile);

		glEndList();
		sceneDisplayListCreated = 1;
	}

	glCallList(sceneListIndex);
	
	glDisable(GL_LIGHTING);

	glColor3fv(noSpec);

	//Bounding Box of the scene, if necessary

	/*glBegin(GL_TRIANGLE_STRIP);
			glVertex3f(-30.0,0.0f,30.0f);
			glVertex3f(30.0,0.0f,30.0f);
			glVertex3f(-30.0,0.0f,-30.0f);
			glVertex3f(30.0,0.0f,-30.0f);
	glEnd();

	glBegin(GL_TRIANGLE_STRIP);
			glVertex3f(-30.0,0.0f,-30.0f);
			glVertex3f(30.0,0.0f,-30.0f);
			glVertex3f(-30.0,30.0f,-30.0f);
			glVertex3f(30.0,30.0f,-30.0f);
			
	glEnd();

	glBegin(GL_TRIANGLE_STRIP);
			glVertex3f(-30.0,0.0f,-30.0f);
			glVertex3f(-30.0,30.0f,-30.0f);
			glVertex3f(-30.0,0.0f,30.0f);
			glVertex3f(-30.0,30.0f,30.0f);
			
	glEnd();

	glFrontFace(GL_CW);

	glBegin(GL_TRIANGLE_STRIP);
			glVertex3f(30.0,0.0f,-30.0f);
			glVertex3f(30.0,30.0f,-30.0f);
			glVertex3f(30.0,0.0f,30.0f);
			glVertex3f(30.0,30.0f,30.0f);
			
	glEnd();

	glBegin(GL_TRIANGLE_STRIP);
			glVertex3f(-30.0,0.0f,30.0f);
			glVertex3f(30.0,0.0f,30.0f);
			glVertex3f(-30.0,30.0f,30.0f);
			glVertex3f(30.0,30.0f,30.0f);
			
	glEnd();*/

	glFrontFace(GL_CCW);

	glEnable(GL_LIGHTING);

	glFlush();							// Flush The OpenGL Pipeline

	return AC3D_SUCCESS;

}