/* Universidade Estadual de Campinas - Unicamp
 * Faculdade de Engenharia Eltrica e de Computao - Feec
 *
 * IA725A  Computao Grfica I
 * 1o semestre de 2009
 * <http://www.dca.fee.unicamp.br/courses/IA725/1s2009/>
 *
 * Profa. Dra. Wu Shin-Ting
 * <http://www.dca.fee.unicamp.br/~ting/>
 *
 * Projeto Prtico: LEGO Creator House 3D - Gouraud Shading
 *
 * Leandro Barros de Figueiredo
 * Rodrigo Mologni Gonalves dos Santos
 * <http://www.dca.fee.unicamp.br/~mologni/>
 */

#include <stdlib.h>
#include <GL/glut.h>

#include "LegoCreatorHouse.h"

GLfloat angle, aspect;
GLfloat rx, ry, rxo, ryo;
GLfloat cx, cy, cz, cxo, cyo, czo;

int xo, yo, button;

LegoCreatorHouse lego;

// Mtodo "callback" de redesenho da janela de visualizao
void display(void) {
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glColor3f(0.0f, 0.0f, 0.0f);

	// Desenha a verso "wireframe" do Lego Creator House
    lego.drawSolidLegoCreatorHouse();
    
	glFlush();
}

// Mtodo usado para especificar a posio do observador virtual
void cam(void) {
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glTranslatef(-cx, -cy, -cz);
	glRotatef(rx, 1, 0, 0);
	glRotatef(ry, 0, 1, 0);
}

// Mtodo usado para especificar o volume de visualizao
void view(void) {
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(angle, aspect, 0.1, 1200);

	cam();
}

// Mtodo "callback" chamado quando o tamanho da janela  alterado 
void reshape(GLsizei width, GLsizei height) {
	height = (height == 0 ? 1 : height);
	aspect = (GLfloat)width / (GLfloat)height;

    glViewport(0, 0, width, height);

	view();
}

// Mtodo "callback" chamado para gerenciar eventos de teclas normais (ESC)
void keyboard(unsigned char key, int x, int y) {
	if(key == 27) {
		exit(EXIT_SUCCESS);
	}
}

// Mtodo "callback" para tratar eventos de teclas especiais
void special(int key, int x, int y) {
	switch (key) {
		case GLUT_KEY_HOME:
			if(angle >= 10) {
                angle -=5;
			}
		    break;
		case GLUT_KEY_END:
		    if(angle <= 150) {
                angle +=5;
			}
		    break;
	}
	view();
	glutPostRedisplay();
}

// Mtodo "callback" para eventos de botes do mouse
void mouse(int btn, int state, int x, int y) {
	if(state == GLUT_DOWN) {
		xo     = x;
		yo     = y;
		cxo    = cx;
		cyo    = cy;
		czo    = cz;
		rxo    = rx;
		ryo    = ry;
		button = btn;
	}
	else {
        button = -1;
	}
}

// Mtodo "callback" para eventos de movimento do mouse
void motion(int x, int y) {
	if(button == GLUT_LEFT_BUTTON) {
        // Rotao
		rx = rxo - (yo - y) / 5;
		ry = ryo - (xo - x) / 5;
	} else if(button == GLUT_RIGHT_BUTTON) {
        // Zoom
		cz = czo + (yo - y) / 15;
	} else if(button == GLUT_MIDDLE_BUTTON) {
        // Pan
		cx = cxo + (xo - x) / 30;
		cy = cyo - (yo - y) / 30;
	}
	cam();
	glutPostRedisplay();
}

// Mtodo responsvel por inicializar parmetros e variveis
void init(void) {	
	glClearColor(0.0, 0.0, 0.0, 0.0);

	// Habilita a remoo de faces
	glEnable(GL_CULL_FACE);

	// Remove faces traseiras
	glCullFace(GL_BACK);

	// Habilita o "depth-buffering"
	glEnable(GL_DEPTH_TEST);

	// Habilita o modelo de tonalizao de Gouraud
	glShadeModel(GL_SMOOTH);

	//Habilita a definio da cor do material a partir da cor corrente
	glEnable(GL_COLOR_MATERIAL);

	//Habilita o uso de iluminao
	glEnable(GL_LIGHTING);

	//Habilita a luz de nmero 0
	glEnable(GL_LIGHT0);

	// Habilita transparncia de objetos
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	// Habilita normalizao dos vetores normais
	glEnable(GL_NORMALIZE);

	angle = 60;
	cz    = 50;
	
	rx = ry = cx = cy = 0;
}

// Programa principal
int main(void) {
	glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH);
	glutInitWindowSize(800, 600); 

	glutCreateWindow("LEGO Creator House 3D - Gouraud Shading");

	glutDisplayFunc(display);
	glutReshapeFunc(reshape);
	glutMouseFunc(mouse);
	glutMotionFunc(motion);
	glutKeyboardFunc(keyboard);
	glutSpecialFunc(special);

	init();

	glutMainLoop();
 
	return EXIT_SUCCESS;
}
