// Persistence Of Vision raytracer version 3.1	sample file.
// File by Alexander Enzmann
//
// -w320 -h240
// -w800 -h600 +a0.3
global_settings { assumed_gamma 2.2 } 

//#declare clock = 1; 
//#declare CLOCK = 3.14*-0.5;
                       
//-----------------------------------------------------------------------------------//                       
// POSIO DA CMERA                                                                 
//-----------------------------------------------------------------------------------//
//camera {                                                                               
   //rotate <-90, 0, 0>
   
//   location  <25, 40, 16>
//   look_at   <25, 0, 16>   
   //location  <20, 10, -20> 
   //look_at   <20, 10, 20>   
   
//   location  <-20, 10, 20> 
//   look_at   <20, 10, 10>   
   
   //location  <20, 10, 60> 
   //look_at   <20, 10, 20>   
   
   ///location  <0, 10, 16>
   //look_at   <32, 10, 16> 
   
   //location  <50, 10, 16>
   //look_at   <32, 10, 16>     
   
   
   //direction <0, 0, -1>
   
   //right 4/3*x
   //up y
//} 

// Camera gira de acordo com clock
camera {
    location <sin(clock)*30 + 20, 10, cos(clock)*-30 + 10>     //sin(clock)*16
    look_at <20, 10, 10>

    //right x*1.280
    //up y*0.800
}

  
//-----------------------------------------------------------------------------------//                       
// TEXTURAS                                                                 
//-----------------------------------------------------------------------------------//
#declare verde_grama =
texture {
  finish {
        ambient 0.2
        diffuse 0.8  
         }
  pigment { color red 0 green 1 blue 0 }
  //pigment { image_map {gif  "grama.gif"}}

} 

#declare telha =
texture {
  finish {
        ambient 0.2
        diffuse 0.8  
         }
  pigment { color red 0 green 1 blue 0 }
  //pigment { image_map {jpeg  "telha.jpg"}}

}

#declare chao =
texture {
  finish {
        ambient 0.2
        diffuse 0.8  
         }
  pigment { color red 0 green 1 blue 0 }
  //pigment { image_map {jpeg  "chao1.jpg"}}

} 
                 
#declare mediumStoneGrey =
texture {
  finish {
        ambient 0.2
        diffuse 0.8  
         }
  pigment { color red 0.636 green 0.632 blue 0.640 }
} 

#declare darkGreen =
texture {
  finish {
        ambient 0.2
        diffuse 0.8  
         }
  pigment { color red 0.156 green 0.5 blue 0.27 }
  //pigment { image_map {gif  "grama.gif"}}
}                      

#declare reddishBrown =
texture {
  finish {
        ambient 0.2
        diffuse 0.8  
         }
  pigment { color red 0.41 green 0.25 blue 0.15 }
}                      

#declare brightRed =
texture {
  finish {
        ambient 0.2
        diffuse 0.8  
         }
   pigment { color red 0.765 green 0.156 blue 0.105 }
   //pigment { image_map {jpeg  "telha1.jpg"}}
}                   

#declare white =
texture {
  finish {
        ambient 0.2
        diffuse 0.8  
         }
   pigment { color red 0.945 green 0.949 blue 0.945 }
} 

#declare brickYellow =
texture {
  finish {
        ambient 0.2
        diffuse 0.8  
         }
   pigment { color red 0.839 green 0.769 blue 0.597 }
}

#declare brightYellow =
texture {
  finish {
        ambient 0.2
        diffuse 0.8  
         }
   pigment { color red 0.957 green 0.800 blue 0.183 }
}                      

#declare black =
texture {
  finish {
        ambient 0.2
        diffuse 0.8  
         }
   pigment { color red 0.105 green 0.164 blue 0.203 }
}  

#declare brightYellowishGreen =
texture {
  finish {
        ambient 0.2
        diffuse 0.8  
         }
   pigment { color red 0.643 green 0.741 blue 0.274 }
}
 
#declare darkStoneGrey =
texture {
  finish {
        ambient 0.2
        diffuse 0.8  
         }
   pigment { color red 0.388 green 0.372 blue 0.380 }
}  
   

//-----------------------------------------------------------------------------------//                       
// PRIMITIVAS BSICAS                                                                 
//-----------------------------------------------------------------------------------//
#macro drawSolidRound (Posx,Posz,altura,raio)
     cylinder{ <Posx, 0, Posz>, <Posx, altura, Posz>, raio}
#end

#macro drawSolidRoundBrick ()
union{
        object {drawSolidRound(0,0,0.2,0.4) translate <0, 0.0, 0>}
        object {drawSolidRound(0,0,1,0.5) translate <0, 0.2, 0>}
        object {drawSolidRound(0,0,0.2,0.3) translate <0, 1.2, 0>}
}
#end 

#macro drawSolidCube(largura, comprimento,altura, flat) 
union {   

   #if (flat = 0)
        #declare I = 0;
        #while (I < largura) 
                #declare J = 0;  
                #while (J < comprimento)    
                        drawSolidRound (I,J,0.2,0.3)
                        #declare J = J+1;
                #end
                #declare I = I+1;
        #end  
   #end
   
   //box { <-0.3, -altura, -0.45>, <largura-0.3, 0, comprimento-0.45> }
   box { <-0.5, -altura, -0.45>, <largura-0.5, 0, comprimento-0.45> }  
   
   //translate <-(largura/2), -(altura/2), -(comprimento/2)>

} 
#end 

#macro drawSolidPlate(largura, comprimento)        
        object {drawSolidCube(largura,comprimento,0.4,0) } 
#end 

#macro drawSolidFlatTile(largura, comprimento)        
        object {drawSolidCube(largura,comprimento,0.4,1) } 
#end

#macro drawSolidBrick(largura, comprimento)        
        object {drawSolidCube(largura,comprimento,1.2,0) } 
#end 

#macro drawSolidRoundPlate()    
union {    
        object {drawSolidRound(0.5,0.5,0.2,0.4)} 
        object {drawSolidRound(0.5,0.5,0.2,0.5) translate <0, 0.2, 0>}
        object {drawSolidRound(0.5,0.5,0.2,0.3) translate <0, 0.4, 0>}
        translate <-0.5, 0, -0.5>
      }
#end

#macro drawSolidCorner(altura, angulo) 
union {

   #if (angulo = 0)
        object {drawSolidCube(1,1,altura,0) }
        object {drawSolidCube(1,1,altura,0) translate <1, 0, 0>}
        object {drawSolidCube(1,1,altura,0) translate <0, 0, -1>} 
   #end   

   #if (angulo = 90)
        object {drawSolidCube(1,1,altura,0) }
        object {drawSolidCube(1,1,altura,0) translate <1, 0, 0>}
        object {drawSolidCube(1,1,altura,0) translate <0, 0, 1>}
   #end
   
   #if (angulo = 180)
        object {drawSolidCube(1,1,altura,0) }
        object {drawSolidCube(1,1,altura,0) translate <1, 0, 0>}
        object {drawSolidCube(1,1,altura,0) translate <1, 0, 1>}
   #end
   
   #if (angulo = 270)
        object {drawSolidCube(1,1,altura,0) translate <0, 0, 1> }
        object {drawSolidCube(1,1,altura,0) translate <1, 0, 1>}
        object {drawSolidCube(1,1,altura,0) translate <1, 0, 0>}
   #end
} 
#end  

#macro drawSolidCornerPlate(angulo)        
        object {drawSolidCorner(0.4,angulo)}      //translate <-0.5, 0, -0.5>
#end

#macro drawSolidCornerBrick(angulo)        
        object {drawSolidCorner(1.2,angulo)}
#end 

#macro drawSolidAngularBrick(angulo)

        #if (angulo = 0)
                object {drawSolidAngularBrick_Base() translate <0.5, 0, 0.5>}
        #end 

        #if (angulo = 90)
                object {drawSolidAngularBrick_Base() rotate<0,-90,0> translate <0.5, 0, 0.5>}
        #end             

        #if (angulo = 180)
                object {drawSolidAngularBrick_Base() rotate<0,-180,0> translate <0.5, 0, 0.5>}
        #end 

        #if (angulo = 270)
                object {drawSolidAngularBrick_Base() rotate<0,-270,0> translate <0.5, 0, 0.5>}
        #end

#end

#macro drawSolidAngularBrick_Base()
#union {
        box { <0, 0, 0>, <1, 0.2, 1> }        
        box { <0.2, 0.2, 0>, <1, 1.2, 1> }
        object {drawSolidRound(0,0,0.2,0.3) translate <0.5, 1.2, 0.5>}
        object {drawSolidRound(0,0,0.2,0.3) rotate<0,0,90> translate <0.2, 0.7, 0.5> }
        }
#end  

#macro drawSolidWindow(angulo)
#union {

   #if (angulo = 0)
        object {janela_base()}
   #end

   #if (angulo = 90)
        object {janela_base() translate <0, 0, 4>  rotate<0, angulo, 0>}
   #end  
   
   #if (angulo = 180)
        object {janela_base() translate <4, 0, 1>  rotate<0, angulo, 0>}
   #end
   
   #if (angulo = 270)
        object {janela_base() translate <1, 0, 0>  rotate<0, angulo, 0>}
   #end
   
       }
#end 


	
#macro janela_base()
#union {
        object {drawSolidPlate(4,1) texture {darkStoneGrey} translate <0, 3.2, 0>}
        object {drawSolidPlate(4,1) texture {white} translate <0, 0, 0>}
        
        box { <0, 0, 0>, <4, 0.4, 1> texture {darkStoneGrey} translate <-0.5, 0.2, -0.5>}
        box { <0, 0, 0>, <0.4, 2.8, 1> texture {darkStoneGrey} translate <-0.5, 0.2, -0.5>}
        box { <0, 0, 0>, <0.4, 2.8, 1> texture {darkStoneGrey} translate <3.2, 0.2, -0.5>}
        box { <0, 0, 0>, <0.2, 2.8, 0.2> texture {darkStoneGrey} translate <0.1, 0.2, -0.25>}
        box { <0, 0, 0>, <0.2, 2.8, 0.2> texture {darkStoneGrey} translate <1.3, 0.2, -0.25>}
        box { <0, 0, 0>, <0.2, 2.8, 0.2> texture {darkStoneGrey} translate <1.7, 0.2, -0.25>}
        box { <0, 0, 0>, <0.2, 2.8, 0.2> texture {darkStoneGrey} translate <2.9, 0.2, -0.25>}
        
        box { <0, 0, 0>, <1.2, 0.2, 0.2> texture {darkStoneGrey} translate <0.3, 0.7, -0.5>}
        box { <0, 0, 0>, <1.2, 0.2, 0.2> texture {darkStoneGrey} translate <1.9, 0.7, -0.5>}
        box { <0, 0, 0>, <1.2, 0.2, 0.2> texture {darkStoneGrey} translate <0.3, 1.6, -0.5>}
        box { <0, 0, 0>, <1.2, 0.2, 0.2> texture {darkStoneGrey} translate <1.9, 1.6, -0.5>}
        box { <0, 0, 0>, <1.2, 0.2, 0.2> texture {darkStoneGrey} translate <0.3, 2.5, -0.5>}
        box { <0, 0, 0>, <1.2, 0.2, 0.2> texture {darkStoneGrey} translate <1.9, 2.5, -0.5>}
        
        }
#end

#macro drawSolidDoor(angulo)
#union {

   #if (angulo = 0)
        object {porta_base()}
   #end

   #if (angulo = 90)
        object {porta_base() translate <0, 0, 4>  rotate<0, angulo, 0>}
   #end  
   
   #if (angulo = 180)
        object {porta_base() translate <4, 0, 1>  rotate<0, angulo, 0>}
   #end
   
   #if (angulo = 270)
        object {porta_base() translate <1, 0, 0>  rotate<0, angulo, 0>}
   #end
   
       }
#end

#macro porta_base()
#union {
        object {drawSolidRound(0,0,0.2,0.5) texture {white} translate <0, 0, 0>}
        box { <0, 0, 0>, <0.4, 5.8, 0.4> texture {white} translate <-0.5, 0, 0>}
        box { <0, 0, 0>, <0.4, 5.8, 0.4> texture {white} translate <2.9, 0, 0>}
        box { <0, 0, 0>, <3.4, 0.4, 0.4> texture {white} translate <-0.5, 0, 0>}
        box { <0, 0, 0>, <3.4, 0.4, 0.4> texture {white} translate <-0.5, 5.4, 0>}
        box { <0, 0, 0>, <0.6, 0.6, 0.2> texture {white} translate <2.3, 2.7, -0.1>}
        }
#end

#macro drawSolidRoofTile2(angulo)

#union {

   #if (angulo = 0)
        object {drawSolidRoofTile_Base() }
        object {drawSolidRoofTile_Base() translate <0, 0, 1>}
   #end

   #if (angulo = 90)
        object {drawSolidRoofTile_Base() rotate<0, angulo, 0>}
        object {drawSolidRoofTile_Base() translate <0, 0, 1>  rotate<0, angulo, 0>}
   #end  
   
   #if (angulo = 180)
        object {drawSolidRoofTile_Base() rotate<0, angulo, 0>}
        object {drawSolidRoofTile_Base() translate <0, 0, 1> rotate<0, angulo, 0>}
   #end
   
   #if (angulo = 270)
        object {drawSolidRoofTile_Base() rotate<0, angulo, 0>}
        object {drawSolidRoofTile_Base() translate <0, 0, 1> rotate<0, angulo, 0>}
   #end
   
       }
#end

#macro drawSolidRoofTile3(angulo)

#union {

   #if (angulo = 0)
        object {drawSolidRoofTile_Base() }
        object {drawSolidRoofTile_Base() translate <0, 0, 1>}
        object {drawSolidRoofTile_Base() translate <0, 0, 2>}
   #end

   #if (angulo = 90)
        object {drawSolidRoofTile_Base() rotate<0, angulo, 0>}
        object {drawSolidRoofTile_Base() translate <0, 0, 1>  rotate<0, angulo, 0>}
        object {drawSolidRoofTile_Base() translate <0, 0, 2>  rotate<0, angulo, 0>}
   #end  
   
   #if (angulo = 180)
        object {drawSolidRoofTile_Base() rotate<0, angulo, 0>}
        object {drawSolidRoofTile_Base() translate <0, 0, 1> rotate<0, angulo, 0>}
        object {drawSolidRoofTile_Base() translate <0, 0, 2> rotate<0, angulo, 0>}
   #end
   
   #if (angulo = 270)
        object {drawSolidRoofTile_Base() rotate<0, angulo, 0>}
        object {drawSolidRoofTile_Base() translate <0, 0, 1> rotate<0, angulo, 0>}
        object {drawSolidRoofTile_Base() translate <0, 0, 2> rotate<0, angulo, 0>}
   #end
   
       }
#end 

#macro drawSolidRoofTile4(angulo)

#union {

   #if (angulo = 0)
        object {drawSolidRoofTile_Base() }
        object {drawSolidRoofTile_Base() translate <0, 0, 1>}
        object {drawSolidRoofTile_Base() translate <0, 0, 2>}
        object {drawSolidRoofTile_Base() translate <0, 0, 3>}
   #end

   #if (angulo = 90)
        object {drawSolidRoofTile_Base() rotate<0, angulo, 0>}
        object {drawSolidRoofTile_Base() translate <0, 0, 1>  rotate<0, angulo, 0>}
        object {drawSolidRoofTile_Base() translate <0, 0, 2>  rotate<0, angulo, 0>}
        object {drawSolidRoofTile_Base() translate <0, 0, 3>  rotate<0, angulo, 0>}
   #end  
   
   #if (angulo = 180)
        object {drawSolidRoofTile_Base() rotate<0, angulo, 0>}
        object {drawSolidRoofTile_Base() translate <0, 0, 1> rotate<0, angulo, 0>}
        object {drawSolidRoofTile_Base() translate <0, 0, 2> rotate<0, angulo, 0>}
        object {drawSolidRoofTile_Base() translate <0, 0, 3> rotate<0, angulo, 0>}
   #end
   
   #if (angulo = 270)
        object {drawSolidRoofTile_Base() rotate<0, angulo, 0>}
        object {drawSolidRoofTile_Base() translate <0, 0, 1> rotate<0, angulo, 0>}
        object {drawSolidRoofTile_Base() translate <0, 0, 2> rotate<0, angulo, 0>}
        object {drawSolidRoofTile_Base() translate <0, 0, 3> rotate<0, angulo, 0>}
   #end
   
       }
#end

#macro drawSolidRoofTileInverted(angulo)
#union {
   #if (angulo = 0)  
        object {drawSolidRoofTileInverted_Base() }          
   #end

   #if (angulo = 90)
        object {drawSolidRoofTileInverted_Base() translate <0, 0, 2>  rotate<0, angulo, 0>}
   #end  
   
   #if (angulo = 180)
        object {drawSolidRoofTileInverted_Base() translate <2, 0, 0>  rotate<0, angulo, 0>}
   #end
   
   #if (angulo = 270)
        object {drawSolidRoofTileInverted_Base() translate <0, 0, 0>  rotate<0, angulo, 0>}
   #end
   
       }
#end

#macro drawSolidRoofTileInverted_Base()
#union {
        #intersection  {        
                box { <0, 0, 0>, <1.0, 1.0, 1.0> }
                box { <0, 0, 0>, <2, 2, 2> rotate<0,0,45> translate <1, 0, 0>}        
                       }
       object {drawSolidBrick(1,1) translate <1.5, 1, 0.45>}
       }
#end 

#macro drawSolidRoofTile_Base()
#union {
        #intersection  {         //intersection
                box { <0, 0, 0>, <1.2, 1.2, 1.0> }
                box { <0, 0, 0>, <2, 2, 2> rotate<0,0,45> translate <1.2, -1.6,0>}        
                }
       object {drawSolidBrick(1,1) translate <1.7, 1.2, 0.45>}
       }
#end 

#macro drawSolidRidgedTile()
#union {
        #intersection  {         //intersection
                box { <0, 0, 0>, <2, 2, 2> }
                box { <0, 0, 0>, <2, 2, 2> rotate<0,0,45> translate <1, -1.7,0>}        
                }       
       }
#end


	
//-----------------------------------------------------------------------------------//                       
// FUNES PARA CONSTRUIR A IMAGEM                                                                 
//-----------------------------------------------------------------------------------//	
    
#macro drawSolidMap1()  
union {      
        object {drawSolidPlate(6,4) texture {chao} translate <0, 0.4, 1>}   
        object {drawSolidPlate(8,4) texture {chao} translate <6, 0.4, 1>}
        object {drawSolidPlate(6,4) texture {chao} translate <14, 0.4, 1>}
        object {drawSolidPlate(8,4) texture {chao} translate <20, 0.4, 1>}   
        object {drawSolidPlate(4,4) texture {chao} translate <28, 0.4, 1>}        
        
        #declare I = 0;
        #while (I < 25)   
                object {drawSolidFlatTile(8,1) texture {chao} translate <I, 0.4, 0>}       
                #declare I = I+8;                                                               
        #end
      }
#end  

#macro drawSolidMap2()  
union {      
        object {drawSolidPlate(4,1) texture {mediumStoneGrey} translate <23, 0.4, 11>}       
        
        #declare K = 10;
        #while (K > 4)   
                object {drawSolidFlatTile(4,1) texture {mediumStoneGrey} translate <23, 0.4, K>}       
                #declare K = K-1;                                                               
        #end
      }
#end 

#macro drawSolidMap3()  
union {      
        object {drawSolidBrick(8,1) texture {mediumStoneGrey} translate <19, 1.2, 20>}   
        object {drawSolidBrick(4,1) texture {mediumStoneGrey} translate <27, 1.2, 20>}
        object {drawSolidBrick(1,8) texture {mediumStoneGrey} translate <19, 1.2, 12>}
        object {drawSolidBrick(1,8) texture {mediumStoneGrey} translate <30, 1.2, 12>}
        object {drawSolidBrick(4,1) texture {mediumStoneGrey} translate <19, 1.2, 11>}
        object {drawSolidBrick(4,1) texture {mediumStoneGrey} translate <27, 1.2, 11>}
        object {drawSolidBrick(2,2) texture {mediumStoneGrey} translate <21, 1.2, 06>}
        object {drawSolidPlate(1,1) texture {mediumStoneGrey} translate <20, 0.4, 06>}        
      }
#end

#macro drawSolidMap4()  
union {        
        // Planta
        object {drawSolidPlate(2,6) texture {reddishBrown} translate <27, 0.4, 5>}
        object {drawSolidRoundPlate() texture {reddishBrown} translate <28, 0.4, 10>}
        object {drawSolidRoundPlate() texture {reddishBrown} translate <28, 0.8, 10>}                    
        object {drawSolidRoundPlate() texture {reddishBrown} translate <28, 0.4, 08>}
        object {drawSolidRoundPlate() texture {reddishBrown} translate <27, 0.4, 07>}
        object {drawSolidRoundPlate() texture {reddishBrown} translate <28, 0.4, 06>}
        object {drawSolidRoundPlate() texture {reddishBrown} translate <28, 0.4, 05>}
        object {drawSolidRoundPlate() texture {darkGreen} translate <28, 1.0, 10>} 
        object {drawSolidRoundPlate() texture {darkGreen} translate <28, 0.4, 9>}
        object {drawSolidRoundPlate() texture {darkGreen} translate <27, 0.4, 8>}
        object {drawSolidRoundPlate() texture {darkGreen} translate <27, 1.0, 7>}
        object {drawSolidRoundPlate() texture {darkGreen} translate <28, 1.0, 5>}
        object {drawSolidRoundPlate() texture {brightRed} translate <27, 0.4, 9>}
        object {drawSolidRoundPlate() texture {brightRed} translate <28, 1.0, 6>}
        
        //object {drawSolidPlate(4,1) texture {white} translate <16, 0.4, 6>}       
        //object {drawSolidPlate(1,6) texture {white} translate <16, 0.4, 7>}
        //object {drawSolidPlate(1,8) texture {white} translate <16, 0.4, 11>}
        
        
        object {drawSolidCornerPlate(90) texture {mediumStoneGrey} translate <18, 0.4, 11>}
        
      }
#end 

#macro drawSolidMap5()  
union {      
        object {drawSolidBrick(4,1) texture {white} translate <2, 1.2, 30>}    
        object {drawSolidBrick(8,1) texture {white} translate <6, 1.2, 30>}       
        object {drawSolidBrick(1,8) texture {white} translate <13, 1.2, 22>}
        object {drawSolidBrick(1,8) texture {white} translate <2, 1.2, 22>} 
        object {drawSolidBrick(4,1) texture {white} translate <2, 1.2, 21>} 
        object {drawSolidBrick(3,1) texture {white} translate <6, 1.2, 21>}
        object {drawSolidPlate(4,1) texture {white} translate <9, 0.4, 21>}
        object {drawSolidBrick(3,1) texture {white} translate <13, 1.2, 21>}
      }
#end 

#macro drawSolidMap6()  
union {      
        object {drawSolidPlate(1,6) texture {white} translate <16, 0.4, 20>}
        object {drawSolidPlate(1,1) texture {white} translate <12, 0.4, 19>}
        
        #declare i = 9;
        #while (i < 12)   
                #declare k = 17;
                #while (k < 20)   
                        #if (mod(i+k,2) = 0)
                                object {drawSolidPlate(1,1) texture {mediumStoneGrey} translate <i, 0.4, k>}
                        #else
                                object {drawSolidPlate(1,1) texture {darkStoneGrey} translate <i, 0.4, k>}
                        #end
                #declare k = k + 1;        
                #end         
        
        #declare i = i + 1;                                                                       
        #end 
        
        #declare i = 8;
        #while (i < 11)   
                #declare k = 14;
                #while (k < 17)   
                        #if (mod(i+k,2) = 0)
                                object {drawSolidPlate(1,1) texture {mediumStoneGrey} translate <i, 0.4, k>}
                        #else
                                object {drawSolidPlate(1,1) texture {darkStoneGrey} translate <i, 0.4, k>}
                        #end
                #declare k = k + 1;        
                #end         
        
        #declare i = i + 1;                                                                       
        #end
        
        #declare i = 7;
        #while (i < 10)   
                #declare k = 11;
                #while (k < 14)   
                        #if (mod(i+k,2) = 0)
                                object {drawSolidPlate(1,1) texture {mediumStoneGrey} translate <i, 0.4, k>}
                        #else
                                object {drawSolidPlate(1,1) texture {darkStoneGrey} translate <i, 0.4, k>}
                        #end
                #declare k = k + 1;        
                #end         
        
        #declare i = i + 1;                                                                       
        #end 
        
        #declare i = 6;
        #while (i < 9)   
                #declare k = 8;
                #while (k < 11)   
                        #if (mod(i+k,2) = 0)
                                object {drawSolidPlate(1,1) texture {mediumStoneGrey} translate <i, 0.4, k>}
                        #else
                                object {drawSolidPlate(1,1) texture {darkStoneGrey} translate <i, 0.4, k>}
                        #end
                #declare k = k + 1;        
                #end         
        
        #declare i = i + 1;                                                                       
        #end 
        
        #declare i = 5;
        #while (i < 8)   
                #declare k = 5;
                #while (k < 8)   
                        #if (mod(i+k,2) = 0)
                                object {drawSolidPlate(1,1) texture {mediumStoneGrey} translate <i, 0.4, k>}
                        #else
                                object {drawSolidPlate(1,1) texture {darkStoneGrey} translate <i, 0.4, k>}
                        #end
                #declare k = k + 1;        
                #end         
        
        #declare i = i + 1;                                                                       
        #end
        
      }
#end

#macro drawSolidMap7()  
union {
        object {drawSolidCornerBrick(90) texture {white} translate <19, 2.4, 11>}
        object {drawSolidBrick(2,1) texture {white} translate <21, 2.4, 11>}
        object {drawSolidAngularBrick(0) texture {white} translate <18, 1.4, 17>}
        object {drawSolidRoundPlate() texture {darkGreen} rotate <0, 0, 90> translate <18.7, 2.3, 18> }
        object {drawSolidBrick(1,1) texture {white} translate <19, 2.4, 17>}
        object {drawSolidBrick(1,4) texture {white} translate <19, 2.4, 13>}     
        object {drawSolidCornerBrick(0) texture {white} translate <19, 2.4, 20>}
        object {drawSolidBrick(2,1) texture {white} translate <21, 2.4, 20>} 
        object {drawSolidBrick(8,1) texture {white} translate <23, 2.4, 20>}
        object {drawSolidCornerBrick(270) texture {white} translate <29, 2.4, 19>}
        object {drawSolidBrick(1,6) texture {white} translate <30, 2.4, 13>} 
        object {drawSolidCornerBrick(180) texture {white} translate <29, 2.4, 11>}
        object {drawSolidBrick(2,1) texture {white} translate <27, 2.4, 11>}
        
        object {drawSolidRoundBrick() texture {mediumStoneGrey} translate <18, 0.4, 11>}
      }
#end 

#macro drawSolidMap9()  
union {      
        object {drawSolidPlate(8,1) texture {white} translate <19, 2.8, 20>}
        object {drawSolidPlate(4,1) texture {white} translate <27, 2.8, 20>}
        object {drawSolidPlate(1,8) texture {white} translate <30, 2.8, 12>}    
        object {drawSolidPlate(4,1) texture {white} translate <27, 2.8, 11>} 
        object {drawSolidPlate(4,1) texture {white} translate <19, 2.8, 11>}
        object {drawSolidPlate(1,8) texture {white} translate <19, 2.8, 12>} 
        object {drawSolidRoundBrick() texture {mediumStoneGrey} translate <18, 1.6, 11>}
      }
#end

#macro drawSolidMap10()  
union {      
        object {drawSolidCornerBrick(0) texture {white} translate <19, 4.0, 20>}
        object {drawSolidBrick(8,1) texture {white} translate <21, 4.0, 20>}
        object {drawSolidCornerBrick(270) texture {white} translate <29, 4.0, 19>}
        object {drawSolidBrick(1,1) texture {white} translate <30, 4.0, 18>}
        object {drawSolidBrick(1,1) texture {white} translate <30, 4.0, 13>} 
        object {drawSolidCornerBrick(180) texture {white} translate <29, 4.0, 11>}
        object {drawSolidBrick(2,1) texture {white} translate <27, 4.0, 11>}
        object {drawSolidBrick(3,1) texture {white} translate <20, 4.0, 11>}
        object {drawSolidBrick(1,8) texture {white} translate <19, 4.0, 11>}
        object {drawSolidRoundBrick() texture {mediumStoneGrey} translate <18, 2.8, 11>}
      }
#end                     

#macro drawSolidMap11()  
union {   
        object {drawSolidBrick(8,1) texture {white} translate <19, 5.2, 20>}
        object {drawSolidBrick(4,1) texture {white} translate <27, 5.2, 20>}
        object {drawSolidBrick(1,2) texture {white} translate <30, 5.2, 18>}
        object {drawSolidBrick(1,2) texture {white} translate <30, 5.2, 12>}
        object {drawSolidBrick(3,1) texture {white} translate <28, 5.2, 11>}
        object {drawSolidAngularBrick(90) texture {white} translate <27, 4, 10>}
        object {drawSolidAngularBrick(90) texture {white} translate <22, 4, 10>}
        object {drawSolidAngularBrick(90) texture {white} translate <21, 4, 10>}
        object {drawSolidBrick(2,1) texture {white} translate <19, 5.2, 11>}
        object {drawSolidBrick(1,8) texture {white} translate <19, 5.2, 12>}
        object {drawSolidFlatTile(2,1) texture {mediumStoneGrey} rotate <90, 0, 0> translate <21, 4.6, 11> }       
        object {drawSolidRoundPlate() texture {black} rotate <90, 0, 0> translate <27, 4.8, 10.3>}
        object {drawSolidRoundBrick() texture {mediumStoneGrey} translate <18, 4, 11>}
      }
#end

#macro drawSolidMap13()  
union {      
        object {drawSolidCornerBrick(0) texture {white} translate <19, 6.4, 20>}
        object {drawSolidBrick(8,1) texture {white} translate <21, 6.4, 20>}
        object {drawSolidCornerBrick(270) texture {white} translate <29, 6.4, 19>}
        object {drawSolidBrick(1,1) texture {white} translate <30, 6.4, 18>}
        object {drawSolidBrick(1,1) texture {white} translate <30, 6.4, 13>} 
        object {drawSolidCornerBrick(180) texture {white} translate <29, 6.4, 11>}
        object {drawSolidBrick(2,1) texture {white} translate <27, 6.4, 11>}
        object {drawSolidBrick(3,1) texture {white} translate <20, 6.4, 11>}
        object {drawSolidBrick(1,8) texture {white} translate <19, 6.4, 11>}
        object {drawSolidRoundBrick() texture {mediumStoneGrey} translate <18, 5.2, 11>}
      }
#end

#macro drawSolidMap14()  
union {      
        object {drawSolidWindow(270) texture {white} translate <30, 3.2, 13>}
        object {drawSolidDoor(0) texture {white} translate <23, 0.5, 10.5>}
      }
#end

#macro drawSolidMap15()  
union {      
        object {drawSolidPlate(10,1) texture {mediumStoneGrey} translate <20, 6.8, 20>}
        object {drawSolidPlate(1,10) texture {mediumStoneGrey} translate <30, 6.8, 11>}
        object {drawSolidPlate(10,1) texture {mediumStoneGrey} translate <20, 6.8, 11>}
        object {drawSolidPlate(1,10) texture {mediumStoneGrey} translate <19, 6.8, 11>}        
      }
#end 

#macro drawSolidMap16()  
union { 
        object {drawSolidBrick(12,1) texture {white} translate <19, 7.6, 20>}
        object {drawSolidBrick(1,8) texture {white} translate <19, 7.6, 12>}          
        object {drawSolidBrick(1,8) texture {white} translate <30, 7.6, 12>}
        object {drawSolidBrick(4,1) texture {white} translate <19, 7.6, 11>}
        object {drawSolidBrick(4,1) texture {white} translate <27, 7.6, 11>}
        object {drawSolidBrick(2,1) texture {white} translate <24, 7.6, 11>}
        
        object {drawSolidRoofTileInverted(270) texture {mediumStoneGrey} translate <23.5, 6.6, 9.5> }
        object {drawSolidRoofTileInverted(270) texture {mediumStoneGrey} translate <26.5, 6.6, 9.5> }
        
        object {drawSolidRoundBrick() texture {mediumStoneGrey} translate <18, 6.4, 11>}
      }
#end

#macro drawSolidMap17()  
union {      
        object {drawSolidCornerBrick(0) texture {white} translate <19, 8.8, 20>}
        object {drawSolidBrick(8,1) texture {white} translate <21, 8.8, 20>}
        object {drawSolidCornerBrick(270) texture {white} translate <29, 8.8, 19>}
        object {drawSolidBrick(1,8) texture {white} translate <30, 8.8, 11>} 
        object {drawSolidBrick(3,1) texture {white} translate <27, 8.8, 11>}
        object {drawSolidBrick(3,1) texture {white} translate <20, 8.8, 11>}
        object {drawSolidBrick(1,8) texture {white} translate <19, 8.8, 11>}
        object {drawSolidRoundBrick() texture {mediumStoneGrey} translate <18, 7.6, 11>}       
      }
#end 

#macro drawSolidMap18()  
union {      
        object {drawSolidBrick(12,1) texture {white} translate <19, 10, 20>} 
        object {drawSolidBrick(1,8) texture {white} translate <30, 10, 12>} 
        object {drawSolidBrick(4,1) texture {white} translate <19, 10, 11>}
        object {drawSolidBrick(4,1) texture {white} translate <27, 10, 11>}
        object {drawSolidBrick(1,2) texture {white} translate <19, 10, 18>}
        
        object {drawSolidRoofTileInverted(0) texture {mediumStoneGrey} translate <17.5, 9, 16.5> }
        
        object {drawSolidBrick(1,3) texture {white} translate <19, 10, 14>}
        
        object {drawSolidAngularBrick(0) texture {white} translate <18, 9, 12>}
        object {drawSolidPlate(1,1) texture {mediumStoneGrey} rotate<0,0,90> translate <18.3, 9.5, 13>}
        object {drawSolidRoundPlate() texture {darkGreen} rotate<0,0,90>translate <18.2, 9.5, 13>}
        
        
      }
#end

#macro drawSolidMap19()  
union {      
        object {drawSolidBrick(8,1) texture {white} translate <21, 11.2, 20>}
        object {drawSolidBrick(2,8) texture {white} translate <29, 11.2, 13>}
        object {drawSolidBrick(2,2) texture {white} translate <29, 11.2, 11>}
        object {drawSolidBrick(2,1) texture {white} translate <27, 11.2, 11>}                  
        object {drawSolidBrick(2,1) texture {white} translate <21, 11.2, 11>}
        object {drawSolidBrick(2,2) texture {white} translate <19, 11.2, 11>}
        object {drawSolidBrick(2,8) texture {white} translate <19, 11.2, 13>}
        object {drawSolidWindow(180) texture {white} translate <30, 8.0, 12>}
        
      }
#end 

#macro drawSolidMap20()  
union {      
       object {drawSolidPlate(4,1) texture {mediumStoneGrey} translate <20, 11.6, 11>}
       object {drawSolidPlate(2,1) texture {mediumStoneGrey} translate <24, 11.6, 11>}
       object {drawSolidPlate(4,1) texture {mediumStoneGrey} translate <26, 11.6, 11>}
       object {drawSolidPlate(4,1) texture {mediumStoneGrey} translate <20, 11.6, 20>}
       object {drawSolidPlate(2,1) texture {mediumStoneGrey} translate <24, 11.6, 20>}
       object {drawSolidPlate(4,1) texture {mediumStoneGrey} translate <26, 11.6, 20>}
       
       object {drawSolidFlatTile(4,1) texture {mediumStoneGrey} translate <23, 8, 10>}
       
       object {drawSolidFlatTile(1,1) texture {mediumStoneGrey} translate <18, 10.4, 17>}              
       object {drawSolidPlate(1,1) texture {mediumStoneGrey} translate <18, 10.8, 17>}
       object {drawSolidPlate(1,1) texture {mediumStoneGrey} translate <18, 11.2, 17>}
       
       object {drawSolidRoofTileInverted(90) texture {mediumStoneGrey} translate <15.5, 9.8, 12.5> }
        
      }
#end


#macro drawSolidMap21()  
union {      
        object {drawSolidPlate(8,1) texture {white} translate <20, 12.0, 20>}
        object {drawSolidPlate(2,1) texture {white} translate <28, 12.0, 20>}
        object {drawSolidPlate(8,1) texture {white} translate <20, 12.0, 11>}
        object {drawSolidPlate(2,1) texture {white} translate <28, 12.0, 11>}
        object {drawSolidBrick(2,6) texture {white} translate <20, 12.4, 13>}
        object {drawSolidBrick(2,6) texture {white} translate <28, 12.4, 13>}
      }
#end

#macro drawSolidMap22()  
union {      
        object {drawSolidRoofTile4(0) texture {brightRed} translate <17.5, 11.2, 17.5> }
        object {drawSolidRoofTile4(180) texture {brightRed} translate <31.5, 11.2, 21.5> }
        
        object {drawSolidPlate(2,1) texture {white} translate <20, 12.4, 20>}
        object {drawSolidPlate(8,1) texture {white} translate <22, 12.4, 20>} 
        object {drawSolidPlate(2,1) texture {white} translate <20, 12.4, 11>}
        object {drawSolidPlate(8,1) texture {white} translate <22, 12.4, 11>}
      }
#end

#macro drawSolidMap23()  
union {
        object {drawSolidRoofTile4(0) texture {brightRed} translate <17.5, 11.2, 13.5> }
        object {drawSolidRoofTile4(0) texture {brightRed} translate <17.5, 11.2, 9.5> } 
        object {drawSolidRoofTile4(180) texture {brightRed} translate <31.5, 11.2, 17.5> }
        object {drawSolidRoofTile4(180) texture {brightRed} translate <31.5, 11.2, 13.5> }
      }
#end 

#macro drawSolidMap24()  
union { 
        object {drawSolidRoofTile2(0) texture {brightRed} translate <18.5, 12.4, 19.5> }
        object {drawSolidRoofTile4(0) texture {brightRed} translate <18.5, 12.4, 15.5> }
        object {drawSolidRoofTile4(0) texture {brightRed} translate <18.5, 12.4, 11.5> }
        object {drawSolidRoofTile2(0) texture {brightRed} translate <18.5, 12.4, 9.5> }
        
        object {drawSolidRoofTile2(180) texture {brightRed} translate <30.5, 12.4, 21.5> }
        object {drawSolidRoofTile4(180) texture {brightRed} translate <30.5, 12.4, 19.5> }
        object {drawSolidRoofTile4(180) texture {brightRed} translate <30.5, 12.4, 15.5> }
        object {drawSolidRoofTile2(180) texture {brightRed} translate <30.5, 12.4, 11.5> }                                                                                                                                
      }
#end

#macro drawSolidMap25()  
union { 
        object {drawSolidBrick(8,1) texture {white} translate <21, 13.2, 20>}
        object {drawSolidBrick(8,2) texture {white} translate <21, 13.2, 17>}
        object {drawSolidBrick(8,2) texture {white} translate <21, 13.2, 13>}
        object {drawSolidBrick(2,1) texture {white} translate <21, 13.6, 11>}
        object {drawSolidBrick(2,1) texture {white} translate <27, 13.6, 11>}
        object {drawSolidRoundBrick() texture {mediumStoneGrey} translate <24, 12.2, 11>}
        object {drawSolidRoundBrick() texture {mediumStoneGrey} translate <25, 12.2, 11>}
      }
#end

#macro drawSolidMap26()  
union { 
        object {drawSolidBrick(6,1) texture {white} translate <22, 14.8, 20>}
        object {drawSolidBrick(6,2) texture {white} translate <22, 14.8, 17>}
        object {drawSolidBrick(6,2) texture {white} translate <22, 14.8, 13>}
        object {drawSolidBrick(6,1) texture {white} translate <22, 14.8, 11>}
        
      }
#end

#macro drawSolidMap27()  
union { 
        object {drawSolidRoofTile4(0) texture {brightRed} translate <19.5, 13.6, 17.5> }
        object {drawSolidBrick(2,2) texture {white} translate <20, 14.8, 15.9>}         
        object {drawSolidRoofTile2(0) texture {brightRed} translate <19.5, 13.6, 13.5> }
        object {drawSolidRoofTile4(0) texture {brightRed} translate <19.5, 13.6, 9.5> }
        
        object {drawSolidRoofTile4(180) texture {brightRed} translate <29.5, 13.6, 21.5> }        
        object {drawSolidRoofTile4(180) texture {brightRed} translate <29.5, 13.6, 17.5> }        
        object {drawSolidRoofTile4(180) texture {brightRed} translate <29.5, 13.6, 13.5> }                
      }
#end 

#macro drawSolidMap28()  
union {        
        object {drawSolidBrick(4,1) texture {white} translate <23, 16, 20>}
        object {drawSolidBrick(4,1) texture {black} translate <23, 16, 17>}                         
        object {drawSolidBrick(4,1) texture {black} translate <23, 16, 13>}                         
        object {drawSolidBrick(4,1) texture {white} translate <23, 16, 10>}                                                  
      }
#end

#macro drawSolidMap29()  
union {        
        object {drawSolidRoofTile4(0) texture {brightRed} translate <20.5, 14.8, 17.5> }                                                  
        object {drawSolidBrick(2,2) texture {white} translate <20, 16, 15.9>}         
        object {drawSolidRoofTile2(0) texture {brightRed} translate <20.5, 14.8, 13.5> }
        object {drawSolidRoofTile4(0) texture {brightRed} translate <20.5, 14.8, 9.5> }
        
        object {drawSolidRoofTile2(180) texture {brightRed} translate <28.5, 14.8, 21.5> }        
        object {drawSolidRoofTile4(180) texture {brightRed} translate <28.5, 14.8, 19.5> }        
        object {drawSolidRoofTile4(180) texture {brightRed} translate <28.5, 14.8, 15.5> }
        object {drawSolidRoofTile2(180) texture {brightRed} translate <28.5, 14.8, 11.5> }                        
      }
#end

#macro drawSolidMap30()  
union { 
        object {drawSolidBrick(2,2) texture {white} translate <20, 17.2, 15.9>}                                   
        object {drawSolidBrick(2,8) texture {white} translate <24, 17.2, 11>}                 
        object {drawSolidBrick(2,2) texture {white} translate <24, 17.2, 19>}
        
        object {drawSolidRoofTile4(0) texture {brightRed} translate <21.5, 16, 17.5> }                                                          
        object {drawSolidRoofTile4(0) texture {brightRed} translate <21.5, 16, 13.5> }
        object {drawSolidRoofTile4(0) texture {brightRed} translate <21.5, 16, 9.5> }
        
        object {drawSolidRoofTile4(180) texture {brightRed} translate <27.5, 16, 21.5> }        
        object {drawSolidRoofTile4(180) texture {brightRed} translate <27.5, 16, 17.5> }        
        object {drawSolidRoofTile4(180) texture {brightRed} translate <27.5, 16, 13.5> }
      }
#end

#macro drawSolidMap31()  
union { 
        object {drawSolidRoofTile2(0) texture {brightRed} translate <22.5, 17.2, 19.5> }                                                          
        object {drawSolidRoofTile4(0) texture {brightRed} translate <22.5, 17.2, 15.5> }
        object {drawSolidRoofTile4(0) texture {brightRed} translate <22.5, 17.2, 11.5> }
        object {drawSolidRoofTile2(0) texture {brightRed} translate <22.5, 17.2, 9.5> }
        
        object {drawSolidRoofTile2(180) texture {brightRed} translate <26.5, 17.2, 21.5> }        
        object {drawSolidRoofTile4(180) texture {brightRed} translate <26.5, 17.2, 19.5> }        
        object {drawSolidRoofTile4(180) texture {brightRed} translate <26.5, 17.2, 15.5> }
        object {drawSolidRoofTile2(180) texture {brightRed} translate <26.5, 17.2, 11.5> }
        
        object {drawSolidBrick(2,2) texture {white} translate <20, 18.4, 15.9>}                                   
      }
#end

#macro drawSolidMap32()  
union {        
        object {drawSolidBrick(2,2) texture {white} translate <20, 19.6, 15.9>}                                   
        
        object {drawSolidRidgedTile() texture {brightRed} translate <23.5, 18.4, 9.5>}
        object {drawSolidRidgedTile() texture {brightRed} translate <23.5, 18.4, 11.5>}
        object {drawSolidRidgedTile() texture {brightRed} translate <23.5, 18.4, 13.5>}
        object {drawSolidRidgedTile() texture {brightRed} translate <23.5, 18.4, 15.5>}                
        object {drawSolidRidgedTile() texture {brightRed} translate <23.5, 18.4, 17.5>}
        object {drawSolidRidgedTile() texture {brightRed} translate <23.5, 18.4, 19.5>}        
        
      }
#end

 


// Desenha a base verde
object {drawSolidPlate(32,32) texture {verde_grama} }    

object {drawSolidMap1()}
object {drawSolidMap2()}
object {drawSolidMap3()}
object {drawSolidMap4()}
//object {drawSolidMap5()}
//object {drawSolidMap6()}
object {drawSolidMap7()}
object {drawSolidMap9()}
object {drawSolidMap10()}
object {drawSolidMap11()}
object {drawSolidMap13()}
object {drawSolidMap14()}
object {drawSolidMap15()}
object {drawSolidMap16()} 
object {drawSolidMap17()}
object {drawSolidMap18()}
object {drawSolidMap19()}
object {drawSolidMap20()}
object {drawSolidMap21()}
object {drawSolidMap22()}
object {drawSolidMap23()}
object {drawSolidMap24()}
object {drawSolidMap25()}
object {drawSolidMap26()}
object {drawSolidMap27()}
object {drawSolidMap28()}
object {drawSolidMap29()}
object {drawSolidMap30()}
object {drawSolidMap31()}
object {drawSolidMap32()}  

light_source { <-15, 30, -20> color red 1 green 1 blue 1 }