/* Universidade Estadual de Campinas - Unicamp
 * Faculdade de Engenharia Eltrica e de Computao - Feec
 *
 * IA725A  Computao Grfica I
 * 1o semestre de 2009
 * <http://www.dca.fee.unicamp.br/courses/IA725/1s2009/>
 *
 * Profa. Dra. Wu Shin-Ting
 * <http://www.dca.fee.unicamp.br/~ting/>
 *
 * Projeto Prtico: LEGO Creator House 3D - Shadow Mapping
 *
 * Leandro Barros de Figueiredo
 * Rodrigo Mologni Gonalves dos Santos
 * <http://www.dca.fee.unicamp.br/~mologni/>
 */

#include <stdlib.h>
#include <math.h>
#include <GL/glut.h>

#include "LegoCreatorHouse.h"
#include "Point.h"
#include "Vector.h"

LegoCreatorHouse::LegoCreatorHouse() {
	this->white.setColor(242, 243, 242);
	this->brickYellow.setColor(215, 197, 153);
	this->brightRed.setColor(196, 40, 27);
	this->brightYellow.setColor(245, 205, 47);
	this->black.setColor(27, 42, 52);
	this->darkGreen.setColor(40, 127, 70);
	this->brightYellowishGreen.setColor(164, 189, 70);
	this->reddishBrown.setColor(105, 64, 39);
	this->mediumStoneGrey.setColor(163, 162, 164);
	this->darkStoneGrey.setColor(99, 95, 97);
}

LegoCreatorHouse::~LegoCreatorHouse() {

}

void LegoCreatorHouse::drawSolidLegoCreatorHouse() {
    glPushMatrix();
	glTranslated(-16, 0, -16);
	drawSolidBasePlate(32, 32, this->darkGreen);
	drawSolidMap1();
	drawSolidMap2();
	drawSolidMap3();
	drawSolidMap4();
	drawSolidMap5();
	drawSolidMap6();
	drawSolidMap7();
	drawSolidMap8();
	drawSolidMap9();
	drawSolidMap10();
	drawSolidMap11();
	drawSolidMap12();
	drawSolidMap13();
	drawSolidMap14();
	drawSolidMap15();
	drawSolidMap16();
	drawSolidMap17();
	drawSolidMap18();
	drawSolidMap19();
	drawSolidMap20();
	drawSolidMap21();
	drawSolidMap22();
	drawSolidMap23();
	drawSolidMap24();
	drawSolidMap25();
	drawSolidMap26();
	drawSolidMap27();
	drawSolidMap28();
	drawSolidMap29();
	drawSolidMap30();
	drawSolidMap31();
	drawSolidMap32();
	drawSolidMap33();
	drawSolidMap34();
	drawSolidMap35();
	drawSolidMap36();
	drawSolidMap37();
	drawSolidMap38();
	drawSolidMap39();
	drawSolidMap40();
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap1() {
    glPushMatrix();
    glTranslated(0, 0.4, 27);
    drawSolidPlate(6, 4, this->mediumStoneGrey);
    glPopMatrix();

	glPushMatrix();
    glTranslated(6, 0.4, 27);
    drawSolidPlate(8, 4, this->mediumStoneGrey);
    glPopMatrix();

	glPushMatrix();
    glTranslated(14, 0.4, 27);
    drawSolidPlate(6, 4, this->mediumStoneGrey);
    glPopMatrix();

	glPushMatrix();
    glTranslated(20, 0.4, 27);
    drawSolidPlate(8, 4, this->mediumStoneGrey);
    glPopMatrix();

	glPushMatrix();
    glTranslated(28, 0.4, 27);
    drawSolidPlate(4, 4, this->mediumStoneGrey);
    glPopMatrix();

	for(int x = 0; x < 25; x += 8) {
		glPushMatrix();
		glTranslated(x, 0.4, 31);
		drawSolidFlatTile(8, 1, this->mediumStoneGrey);
		glPopMatrix();
	}
}

void LegoCreatorHouse::drawSolidMap2() {
	glPushMatrix();
	glTranslated(23, 0.4, 20);
	drawSolidPlate(4, 1, this->mediumStoneGrey);
	glPopMatrix();

	for(int z = 21; z < 27; z++) {
		glPushMatrix();
		glTranslated(23, 0.4, z);
		drawSolidFlatTile(4, 1, this->mediumStoneGrey);
		glPopMatrix();
	}
}

void LegoCreatorHouse::drawSolidMap3() {
	glPushMatrix();
	glTranslated(19, 0.4, 11);
	drawSolidBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 0.4, 11);
	drawSolidBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 0.4, 12);
	drawSolidBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 0.4, 12);
	drawSolidBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 0.4, 20);
	drawSolidBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 0.4, 20);
	drawSolidBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 0.4, 25);
	drawSolidBrick(2, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 0.4, 26);
	drawSolidPlate(1, 1, this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap4() {
	glPushMatrix();
	glTranslated(27, 0.4, 21);
	drawSolidPlate(2, 6, this->reddishBrown);
		glPushMatrix();
		glTranslated(1, 0.4, 0);
		drawSolidRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.8, 0);
		drawSolidRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.4, 2);
		drawSolidRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0, 0.4, 3);
		drawSolidRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.4, 4);
		drawSolidRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.4, 5);
		drawSolidRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 1, 0);
		drawSolidRoundPlate(this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.4, 1);
		drawSolidRoundPlate(this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0, 0.4, 2);
		drawSolidRoundPlate(this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0, 0.8, 3);
		drawSolidRoundPlate(this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.8, 5);
		drawSolidRoundPlate(this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0, 0.4, 1);
		drawSolidRoundPlate(this->brightRed);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.8, 4);
		drawSolidRoundPlate(this->brightRed);
		glPopMatrix();
	glPopMatrix();

	glPushMatrix();
	glTranslated(16, 0.4, 26);
	drawSolidPlate(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(16, 0.4, 20);
	drawSolidPlate(1, 6, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(16, 0.4, 12);
	drawSolidPlate(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 0.4, 20);
	drawSolidCornerPlate(90, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 0.4, 22);
	drawSolidRadiatorGrile(90, this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap5() {
	glPushMatrix();
	glTranslated(2, 0.4, 2);
	drawSolidBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(6, 0.4, 2);
	drawSolidBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 0.4, 3);
	drawSolidBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 0.4, 3);
	drawSolidBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 0.4, 11);
	drawSolidBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(6, 0.4, 11);
	drawSolidBrick(3, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(9, 0.4, 11);
	drawSolidPlate(4, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 0.4, 11);
	drawSolidBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 0.4, 10);
	drawSolidRadiatorGrile(0, this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap6() {
	glPushMatrix();
	glTranslated(16, 0.4, 6);
	drawSolidPlate(1, 6, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 0.4, 12);
	drawSolidPlate(1, 1, this->mediumStoneGrey);
	glPopMatrix();

	for(int x = 9; x < 12; x++) {
		for(int z = 12; z < 15; z++) {
			glPushMatrix();
			glTranslated(x, 0.4, z);
			if((x + z) % 2 == 0) {
				drawSolidPlate(1, 1, this->mediumStoneGrey);
			} else {
				drawSolidPlate(1, 1, this->darkStoneGrey);
			}
			glPopMatrix();
		}
	}

	for(int x = 8; x < 11; x++) {
		for(int z = 15; z < 18; z++) {
			glPushMatrix();
			glTranslated(x, 0.4, z);
			if((x + z) % 2 == 0) {
				drawSolidPlate(1, 1, this->mediumStoneGrey);
			} else {
				drawSolidPlate(1, 1, this->darkStoneGrey);
			}
			glPopMatrix();
		}
	}

	for(int x = 7; x < 10; x++) {
		for(int z = 18; z < 21; z++) {
			glPushMatrix();
			glTranslated(x, 0.4, z);
			if((x + z) % 2 == 0) {
				drawSolidPlate(1, 1, this->mediumStoneGrey);
			} else {
				drawSolidPlate(1, 1, this->darkStoneGrey);
			}
			glPopMatrix();
		}
	}

	for(int x = 6; x < 9; x++) {
		for(int z = 21; z < 24; z++) {
			glPushMatrix();
			glTranslated(x, 0.4, z);
			if((x + z) % 2 == 0) {
				drawSolidPlate(1, 1, this->mediumStoneGrey);
			} else {
				drawSolidPlate(1, 1, this->darkStoneGrey);
			}
			glPopMatrix();
		}
	}

	for(int x = 5; x < 8; x++) {
		for(int z = 24; z < 27; z++) {
			glPushMatrix();
			glTranslated(x, 0.4, z);
			if((x + z) % 2 == 0) {
				drawSolidPlate(1, 1, this->mediumStoneGrey);
			} else {
				drawSolidPlate(1, 1, this->darkStoneGrey);
			}
			glPopMatrix();
		}
	}
}

void LegoCreatorHouse::drawSolidMap7() {
	glPushMatrix();
	glTranslated(19, 1.6, 11);
	drawSolidCornerBrick(0, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 1.6, 13);
	drawSolidAngularBrick(0, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19.2, 1.8, 13);
	glRotated(90, 0, 0, 1);
	drawSolidRoundPlate(this->darkGreen);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 1.6, 14);
	drawSolidBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 1.6, 15);
	drawSolidBrick(1, 4, this->white);
	glPopMatrix();
	
	glPushMatrix();
	glTranslated(19, 1.6, 19);
	drawSolidCornerBrick(90, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 1.6, 20);
	drawSolidBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 1.6, 11);
	drawSolidBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 1.6, 11);
	drawSolidCornerBrick(270, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 1.6, 13);
	drawSolidBrick(1, 6, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 1.6, 19);
	drawSolidCornerBrick(180, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 1.6, 20);
	drawSolidBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 0.8, 20);
	drawSolidRoundBrick(this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap8() {
	glPushMatrix();
	glTranslated(3, 0.4, 12);
	drawSolidPlate(6, 2, this->reddishBrown);
		glPushMatrix();
		glTranslated(0, 0.4, 0);
		drawSolidRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(2, 0.4, 0);
		drawSolidRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(3, 0.4, 0);
		drawSolidRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(5, 0.4, 0);
		drawSolidRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.4, 1);
		drawSolidRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0, 0.4, 1);
		drawSolidRoundPlate(this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(2, 0.8, 0);
		drawSolidRoundPlate(this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(4, 0.4, 1);
		drawSolidRoundPlate(this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(5, 0.8, 0);
		drawSolidRoundPlate(this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.8, 1);
		drawSolidRoundPlate(this->brightRed);
		glPopMatrix();

		glPushMatrix();
		glTranslated(3, 0.4, 1);
		drawSolidRoundPlate(this->brightRed);
		glPopMatrix();

		glPushMatrix();
		glTranslated(4, 0.4, 0);
		drawSolidRoundPlate(this->brightRed);
		glPopMatrix();
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 1.6, 2);
	drawSolidBrick(1, 4, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 1.6, 6);
	drawSolidBrick(1, 6, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(3, 1.6, 11);
	drawSolidBrick(6, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(3, 1.6, 2);
	drawSolidBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 1.6, 2);
	drawSolidBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 1.6, 2);
	drawSolidBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 1.6, 10);
	drawSolidBrick(1, 2, this->white);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap9() {
	glPushMatrix();
	glTranslated(2, 2.8, 2);
	drawSolidPlate(10, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 2.8, 2);
	drawSolidPlate(1, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 2.8, 2);
	drawSolidPlate(1, 10, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(8, 2.8, 11);
	drawSolidPlate(1, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 2.8, 11);
	drawSolidPlate(4, 2, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 2.8, 11);
	drawSolidPlate(2, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 2.8, 9);
	drawSolidPlate(1, 2, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 2.8, 5);
	drawSolidPlate(2, 4, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 2.8, 3);
	drawSolidPlate(1, 2, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 2.8, 11);
	drawSolidPlate(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 2.8, 11);
	drawSolidPlate(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 2.8, 12);
	drawSolidPlate(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 2.8, 20);
	drawSolidPlate(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 2.8, 20);
	drawSolidPlate(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 2.8, 12);
	drawSolidPlate(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 2, 20);
	drawSolidRoundBrick(this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap10() {
	glPushMatrix();
	glTranslated(3, 3.2, 2);
	drawSolidBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 3.2, 2);
	drawSolidBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 3.2, 2);
	drawSolidBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 3.2, 10);
	drawSolidBrick(1, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(8, 3.2, 11);
	drawSolidBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(3, 3.2, 11);
	drawSolidBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 3.2, 9);
	drawSolidBrick(1, 3, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 3.2, 2);
	drawSolidBrick(1, 3, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 3.2, 11);
	drawSolidCornerBrick(0, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 3.2, 11);
	drawSolidBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 3.2, 11);
	drawSolidCornerBrick(270, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 3.2, 13);
	drawSolidBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 3.2, 18);
	drawSolidBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 3.2, 19);
	drawSolidCornerBrick(180, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 3.2, 20);
	drawSolidBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 3.2, 20);
	drawSolidBrick(3, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 3.2, 13);
	drawSolidBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 3.2, 20);
	drawSolidRoundBrick(this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap11() {
	glPushMatrix();
	glTranslated(19, 4.4, 11);
	drawSolidBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 4.4, 11);
	drawSolidBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 4.4, 12);
	drawSolidBrick(1, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 4.4, 18);
	drawSolidBrick(1, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(28, 4.4, 20);
	drawSolidBrick(3, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 4.4, 20);
	drawSolidAngularBrick(90, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 4.4, 20);
	drawSolidAngularBrick(90, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 4.4, 20);
	drawSolidAngularBrick(90, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 4.4, 20);
	drawSolidBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 4.4, 12);
	drawSolidBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 5.6, 20.8);
	glRotated(90, 1, 0, 0);
	drawSolidFlatTile(2, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 5.6, 20.8);
	glRotated(90, 1, 0, 0);
	drawSolidRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 4.4, 20);
	drawSolidRoundBrick(this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap12() {
	glPushMatrix();
	glTranslated(2, 4.4, 2);
	drawSolidBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(6, 4.4, 2);
	drawSolidBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 4.4, 3);
	drawSolidBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 4.4, 11);
	drawSolidBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(8, 4.4, 11);
	drawSolidAngularBrick(90, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(8, 5.6, 11.5);
	glRotated(90, 1, 0, 0);
	drawSolidRoundPlate(this->brightYellow);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 4.4, 10);
	drawSolidCornerBrick(90, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 4.4, 9);
	drawSolidBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 4.4, 3);
	drawSolidBrick(1, 2, this->white);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap13() {
	glPushMatrix();
	glTranslated(3, 5.6, 2);
	drawSolidBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 5.6, 2);
	drawSolidBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 5.6, 2);
	drawSolidBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 5.6, 10);
	drawSolidBrick(1, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(8, 5.6, 11);
	drawSolidBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(3, 5.6, 11);
	drawSolidBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 5.6, 9);
	drawSolidBrick(1, 3, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 5.6, 2);
	drawSolidBrick(1, 3, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 5.6, 11);
	drawSolidCornerBrick(0, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 5.6, 11);
	drawSolidBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 5.6, 11);
	drawSolidCornerBrick(270, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 5.6, 13);
	drawSolidBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 5.6, 18);
	drawSolidBrick(1, 3, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 5.6, 20);
	drawSolidBrick(3, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 5.6, 20);
	drawSolidBrick(3, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 5.6, 13);
	drawSolidBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 5.6, 20);
	drawSolidRoundBrick(this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap14() {
	glPushMatrix();
	glTranslated(2, 3.2, 5);
	drawSolidWindow(90);
	glPopMatrix();
	
	glPushMatrix();
	glTranslated(4, 3.2, 11);
	drawSolidWindow(180);
	glPopMatrix();
	
	glPushMatrix();
	glTranslated(30, 3.2, 14);
	drawSolidWindow(270);
	glPopMatrix();

	glPushMatrix();
	glTranslated(9, 0.8, 11);
	drawSolidDoor(180);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 0.8, 20);
	drawSolidDoor(0);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap15() {
	glPushMatrix();
	glTranslated(2, 6.8, 2);
	drawSolidBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(6, 6.8, 2);
	drawSolidBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 6.8, 3);
	drawSolidBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 6.8, 11);
	drawSolidBrick(12, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 6.8, 3);
	drawSolidBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 6.8, 11);
	drawSolidPlate(10, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 6.8, 11);
	drawSolidPlate(1, 10, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 6.8, 20);
	drawSolidPlate(10, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 6.8, 11);
	drawSolidPlate(1, 10, this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap16() {
	glPushMatrix();
	glTranslated(2, 8, 2);
	drawSolidPlate(12, 2, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 8, 10);
	drawSolidPlate(12, 2, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 8, 4);
	drawSolidPlate(1, 2, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 8, 4);
	drawSolidPlate(1, 2, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 8, 6);
	drawSolidPlate(1, 4, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 8, 6);
	drawSolidPlate(1, 4, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 7.2, 11);
	drawSolidBrick(12, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 7.2, 12);
	drawSolidBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 7.2, 12);
	drawSolidBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 7.2, 20);
	drawSolidBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 7.2, 20);
	drawSolidBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 7.2, 20);
	drawSolidBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 7.2, 20);
	drawSolidRoofTileInverted(1, 90, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(26, 7.2, 20);
	drawSolidRoofTileInverted(1, 90, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 6.8, 20);
	drawSolidRoundBrick(this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap17() {
	glPushMatrix();
	glTranslated(19, 8.4, 11);
	drawSolidCornerBrick(0, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 8.4, 11);
	drawSolidBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 8.4, 11);
	drawSolidCornerBrick(270, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 8.4, 13);
	drawSolidBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 8.4, 20);
	drawSolidBrick(3, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 8.4, 20);
	drawSolidBrick(3, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 8.4, 13);
	drawSolidBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 8, 20);
	drawSolidRoundBrick(this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap18() {
	glPushMatrix();
	glTranslated(19, 9.6, 11);
	drawSolidBrick(12, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 9.6, 12);
	drawSolidBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 9.6, 20);
	drawSolidBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 9.6, 20);
	drawSolidBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 9.6, 12);
	drawSolidBrick(1, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 9.6, 14);
	drawSolidRoofTileInverted(1, 0, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 9.6, 15);
	drawSolidBrick(1, 3, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 9.6, 18);
	drawSolidAngularBrick(0, this->white);
		glPushMatrix();
		glTranslated(0.2, 0.2, 0);
		glRotated(90, 0, 0, 1);
		drawSolidPlate(1, 1, this->mediumStoneGrey);
		glPopMatrix();

		glPushMatrix();
		glTranslated(-0.2, 0.2, 0);
		glRotated(90, 0, 0, 1);
		drawSolidRoundPlate(this->darkGreen);
		glPopMatrix();
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 9.6, 19);
	drawSolidBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 9.2, 20);
	drawSolidRoundBrick(this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap19() {
	glPushMatrix();
	glTranslated(21, 10.8, 11);
	drawSolidBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 10.8, 11);
	drawSolidBrick(2, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 10.8, 19);
	drawSolidBrick(2, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 10.8, 20);
	drawSolidBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 10.8, 20);
	drawSolidBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 10.8, 19);
	drawSolidBrick(2, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 10.8, 11);
	drawSolidBrick(2, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 8.4, 20);
	drawSolidWindow(180);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap20() {
	glPushMatrix();
	glTranslated(20, 12, 11);
	drawSolidPlate(4, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 12, 11);
	drawSolidPlate(2, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(26, 12, 11);
	drawSolidPlate(4, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 12, 20);
	drawSolidPlate(4, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 12, 20);
	drawSolidPlate(2, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(26, 12, 20);
	drawSolidPlate(4, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 8.4, 21);
	drawSolidFlatTile(4, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 10.8, 14);
	drawSolidPlate(1, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 11.2, 14);
	drawSolidPlate(1, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 10.4, 19);
	drawSolidRoofTileInverted(1, 270, this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap21() {
	glPushMatrix();
	glTranslated(4, 8.4, 3);
	drawSolidBrick(8, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 8.4, 9);
	drawSolidBrick(8, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 12.4, 11);
	drawSolidPlate(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(28, 12.4, 11);
	drawSolidPlate(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 12.4, 20);
	drawSolidPlate(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(28, 12.4, 20);
	drawSolidPlate(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 12, 13);
	drawSolidBrick(2, 6, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(28, 12, 13);
	drawSolidBrick(2, 6, this->white);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap22() {
	glPushMatrix();
	glTranslated(18, 12, 10);
	drawSolidRoofTile(4, 0, this->brightRed);
		glPushMatrix();
		glTranslated(-0.45, -0.4, 0);
		drawSolidPlateWithSlide(0, 2, this->mediumStoneGrey);
		glPopMatrix();

		glPushMatrix();
		glTranslated(-0.45, -0.4, 2);
		drawSolidPlateWithSlide(0, 2, this->mediumStoneGrey);
		glPopMatrix();
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 12, 10);
	drawSolidRoofTile(4, 180, this->brightRed);
		glPushMatrix();
		glTranslated(1, -0.4, 0);
		drawSolidPlateWithSlide(180, 2, this->mediumStoneGrey);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, -0.4, 2);
		drawSolidPlateWithSlide(180, 2, this->mediumStoneGrey);
		glPopMatrix();
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 12.8, 11);
	drawSolidPlate(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 12.8, 11);
	drawSolidPlate(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 12.8, 20);
	drawSolidPlate(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 12.8, 20);
	drawSolidPlate(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 8.4, 3);
	drawSolidBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 8.4, 3);
	drawSolidBrick(1, 8, this->white);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap23() {
	glPushMatrix();
	glTranslated(17.55, 11.6, 14);
	drawSolidPlateWithSlide(0, 8, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 12, 14);
	drawSolidRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 12, 18);
	drawSolidRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(31, 11.6, 14);
	drawSolidPlateWithSlide(180, 8, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 12, 14);
	drawSolidRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 12, 18);
	drawSolidRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 8.4, 1);
	drawSolidRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(5, 8.4, 1);
	drawSolidRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(9, 8.4, 1);
	drawSolidRoofTile(3, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 8.4, 1);
	drawSolidRoofTile(3, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 8.4, 11);
	drawSolidRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(5, 8.4, 11);
	drawSolidRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(9, 8.4, 11);
	drawSolidRoofTile(3, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 8.4, 11);
	drawSolidRoofTile(3, 90, this->brightRed);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap24() {
	glPushMatrix();
	glTranslated(1, 9.6, 2);
	drawSolidRoofTile(3, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 9.6, 2);
	drawSolidRoofTile(3, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(7, 9.6, 2);
	drawSolidRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 9.6, 2);
	drawSolidRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 9.6, 10);
	drawSolidRoofTile(3, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 9.6, 10);
	drawSolidRoofTile(3, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(7, 9.6, 10);
	drawSolidRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 9.6, 10);
	drawSolidRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 13.2, 10);
	drawSolidRoofTile(2, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 13.2, 12);
	drawSolidRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 13.2, 16);
	drawSolidRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 13.2, 20);
	drawSolidRoofTile(2, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 13.2, 10);
	drawSolidRoofTile(2, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 13.2, 12);
	drawSolidRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 13.2, 16);
	drawSolidRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 13.2, 20);
	drawSolidRoofTile(2, 180, this->brightRed);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap25() {
	glPushMatrix();
	glTranslated(2, 9.6, 4);
	drawSolidBrick(1, 6, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 9.6, 4);
	drawSolidBrick(1, 6, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(5, 9.6, 4);
	drawSolidBrick(2, 6, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(9, 9.6, 4);
	drawSolidBrick(2, 6, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 13.2, 11);
	drawSolidBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 13.2, 13);
	drawSolidBrick(8, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 13.2, 17);
	drawSolidBrick(8, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 13.2, 20);
	drawSolidBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 13.2, 20);
	drawSolidBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(25, 13.2, 20);
	drawSolidRoundBrick(this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 13.2, 20);
	drawSolidRoundBrick(this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(26, 13.2, 20);
	drawSolidWallCorner(270, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 13.2, 20);
	drawSolidWallCorner(0, this->white);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap26() {
	glPushMatrix();
	glTranslated(2, 10.8, 5);
	drawSolidBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 10.8, 6);
	drawSolidPlate(1, 2, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 11.2, 6);
	drawSolidPlate(1, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 10.8, 8);
	drawSolidBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(5, 10.8, 5);
	drawSolidBrick(2, 4, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(9, 10.8, 5);
	drawSolidBrick(2, 4, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 10.8, 5);
	drawSolidBrick(1, 4, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 14.4, 11);
	drawSolidBrick(6, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 14.4, 13);
	drawSolidBrick(6, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 14.4, 17);
	drawSolidBrick(6, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 14.4, 20);
	drawSolidBrick(6, 1, this->white);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap27() {
	glPushMatrix();
	glTranslated(1.6, 10, 6);
	drawSolidAnglePlate(0, this->white);
		glPushMatrix();
		glTranslated(0, 1, 0);
		glRotated(90, 0, 0, 1);
		drawSolidRadiatorGrile(0, this->mediumStoneGrey);
		glPopMatrix();

		glPushMatrix();
		glRotated(90, 0, 0, 1);
		drawSolidRadiatorGrile(0, this->mediumStoneGrey);
		glPopMatrix();
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 10.8, 3);
	drawSolidRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(5, 10.8, 3);
	drawSolidRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(9, 10.8, 3);
	drawSolidRoofTile(3, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 10.8, 3);
	drawSolidRoofTile(3, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 10.8, 9);
	drawSolidRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(5, 10.8, 9);
	drawSolidRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(9, 10.8, 9);
	drawSolidRoofTile(3, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 10.8, 9);
	drawSolidRoofTile(3, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 10.8, 9);
	drawSolidRoofTile(3, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 14.4, 10);
	drawSolidRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 14.4, 14);
	drawSolidBrick(2, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 14.4, 16);
	drawSolidRoofTile(2, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 14.4, 18);
	drawSolidRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(28, 14.4, 10);
	drawSolidRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(28, 14.4, 14);
	drawSolidRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(28, 14.4, 18);
	drawSolidRoofTile(4, 180, this->brightRed);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap28() {
	glPushMatrix();
	glTranslated(2, 12, 6);
	drawSolidBrick(6, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(8, 12, 6);
	drawSolidBrick(6, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 15.6, 11);
	drawSolidBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 15.6, 14);
	drawSolidBrick(4, 1, this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 15.6, 17);
	drawSolidBrick(4, 1, this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 15.6, 20);
	drawSolidBrick(4, 1, this->white);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap29() {
	glPushMatrix();
	glTranslated(1, 12, 4);
	drawSolidRoofTile(3, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 12, 4);
	drawSolidRoofTile(3, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(7, 12, 4);
	drawSolidRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 12, 4);
	drawSolidRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 12, 8);
	drawSolidRoofTile(3, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 12, 8);
	drawSolidRoofTile(3, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(7, 12, 8);
	drawSolidRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 12, 8);
	drawSolidRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 15.6, 10);
	drawSolidRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 15.6, 14);
	drawSolidBrick(2, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 15.6, 16);
	drawSolidRoofTile(2, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 15.6, 18);
	drawSolidRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 15.6, 10);
	drawSolidRoofTile(2, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 15.6, 12);
	drawSolidRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 15.6, 16);
	drawSolidRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 15.6, 20);
	drawSolidRoofTile(2, 180, this->brightRed);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap30() {
	glPushMatrix();
	glTranslated(1, 13.2, 5);
	drawSolidRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(5, 13.2, 5);
	drawSolidRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(9, 13.2, 5);
	drawSolidRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 13.2, 5);
	drawSolidRoofTile(2, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 13.2, 7);
	drawSolidRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(5, 13.2, 7);
	drawSolidRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(9, 13.2, 7);
	drawSolidRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 13.2, 7);
	drawSolidRoofTile(2, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 16.8, 11);
	drawSolidBrick(2, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 16.8, 14);
	drawSolidBrick(2, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 16.8, 19);
	drawSolidBrick(2, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 16.8, 10);
	drawSolidRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 16.8, 14);
	drawSolidRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 16.8, 18);
	drawSolidRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(26, 16.8, 10);
	drawSolidRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(26, 16.8, 14);
	drawSolidRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(26, 16.8, 18);
	drawSolidRoofTile(4, 180, this->brightRed);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap31() {
	glPushMatrix();
	glTranslated(12, 14.4, 6);
	drawSolidBrick(2, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 15.6, 6);
	drawSolidPlate(2, 1, this->mediumStoneGrey);
		glPushMatrix();
		glTranslated(1, 0.4, 0);
		drawSolidRoundPlate(this->black);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.8, 0);
		drawSolidRoundPlate(this->black);
		glPopMatrix();
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 18, 10);
	drawSolidRoofTile(2, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 18, 12);
	drawSolidRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 18, 16);
	drawSolidRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 18, 20);
	drawSolidRoofTile(2, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(25, 18, 10);
	drawSolidRoofTile(2, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(25, 18, 12);
	drawSolidRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(25, 18, 16);
	drawSolidRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(25, 18, 20);
	drawSolidRoofTile(2, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 18, 14);
	drawSolidBrick(2, 2, this->white);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap32() {
	glPushMatrix();
	glTranslated(20, 19.2, 14);
	drawSolidBrick(2, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 19.2, 10);
	drawSolidEndRidgedTile(0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 19.2, 11);
	drawSolidRidgedTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 19.2, 15);
	drawSolidRidgedTile(2, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 19.2, 17);
	drawSolidRidgedTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 19.2, 21);
	drawSolidEndRidgedTile(180, this->brightRed);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap33() {
	glPushMatrix();
	glTranslated(20, 20.4, 14);
	drawSolidRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 20.8, 14);
	drawSolidRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 20.4, 14);
	drawSolidRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 20.8, 14);
	drawSolidRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 20.4, 15);
	drawSolidRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 20.8, 15);
	drawSolidRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 20.4, 15);
	drawSolidRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 20.8, 15);
	drawSolidRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 1.6, 25);
	drawSolidBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(16, 0.8, 26);
	drawSolidBrick(1, 1, this->white);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap34() {
	glPushMatrix();
	glTranslated(21, 1.6, 26);
	drawSolidWallCorner(0, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 1.6, 26);
	drawSolidWallCorner(270, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(16, 2, 26);
	drawSolidBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(17, 0.8, 26);
	drawSolidFence(0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(16, 0.8, 22);
	drawSolidFence(90);
	glPopMatrix();

	glPushMatrix();
	glTranslated(16, 0.8, 18);
	drawSolidFence(90);
	glPopMatrix();

	glPushMatrix();
	glTranslated(16, 0.8, 14);
	drawSolidFence(90);
	glPopMatrix();

	glPushMatrix();
	glTranslated(16, 0.8, 10);
	drawSolidFence(90);
	glPopMatrix();

	glPushMatrix();
	glTranslated(16, 0.8, 6);
	drawSolidFence(90);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap35() {
	glPushMatrix();
	glTranslated(12, 0.4, 19);
	drawSolidPlate(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 0.4, 20);
	drawSolidPlate(2, 4, this->brickYellow);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 0.4, 23);
	drawSolidPlate(2, 3, this->reddishBrown);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 0.4, 17);
	drawSolidRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 0.4, 18);
	drawSolidRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 0.4, 17);
	drawSolidRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 0.4, 18);
	drawSolidRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 0.4, 20);
	drawSolidRoundBrick(this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 0.4, 20);
	drawSolidRoundBrick(this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 2.8, 25);
	drawSolidMailBox(0);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap36() {
	glPushMatrix();
	glTranslated(1, 0.8, 17);
	drawSolidCornerPlate(0, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(3, 0.8, 17);
	drawSolidCornerPlate(270, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 0.4, 18);
	drawSolidBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 0.4, 19);
	drawSolidBrick(1, 4, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(14, 0.4, 19);
	drawSolidBrick(1, 4, this->white);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap37() {
	glPushMatrix();
	glTranslated(1, 1.2, 17);
	drawSolidPlate(4, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 1.2, 18);
	drawSolidPlate(4, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 1.6, 18);
	drawSolidBrick(4, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 1.6, 20);
	drawSolidBrick(1, 3, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(14, 1.6, 20);
	drawSolidBrick(1, 3, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 0.8, 24);
	drawSolidRoundPlate(this->reddishBrown);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 1.2, 24);
	drawSolidRoundPlate(this->darkGreen);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap38() {
	glPushMatrix();
	glTranslated(1, 1.6, 17);
	drawSolidRoundBrick(this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 1.6, 17);
	drawSolidRoundBrick(this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 1.6, 19.5);
	drawSolidFlatTile(1, 2, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 1.6, 19.5);
	drawSolidFlatTile(1, 2, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 2, 19.5);
	drawSolidFlatTile(4, 1, this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 2, 20.5);
	drawSolidFlatTile(4, 1, this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 2.8, 18);
	drawSolidRoofTile(1, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 2.8, 18);
	drawSolidRoofTile(1, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 2.8, 19);
	drawSolidRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 2.8, 19);
	drawSolidRoofTile(4, 180, this->brightRed);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap39() {
	glPushMatrix();
	glTranslated(1, 2.8, 17);
	drawSolidPlate(4, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 4, 18);
	drawSolidEndRidgedTile(0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 4, 19);
	drawSolidRidgedTile(4, 0, this->brightRed);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidMap40() {
	glTranslated(0.5, 0.8, 21.5);
	glPushMatrix();
		glTranslated(1, 3.6, 1);

		glPushMatrix();
		glTranslated(0.5, -1.2, 0.5);
		drawSolidRoundBrick(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.5, -2.4, 0.5);
		drawSolidRoundBrick(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.5, -3.6, 0.5);
		drawSolidRoundBrick(this->reddishBrown);
		glPopMatrix();

		drawSolidPlate(2, 2, this->darkGreen);
			
		glPushMatrix();
		glTranslated(-1, 0.4, 0);
		drawSolidRoofTileInverted(2, 0, this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.4, 0);
		drawSolidRoofTileInverted(2, 180, this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0, 1.6, -1);
		drawSolidBrick(2, 4, this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(-1, 1.6, 0);
		drawSolidBrick(1, 2, this->brightYellowishGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(2, 1.6, 0);
		drawSolidBrick(1, 2, this->brightYellowishGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(-1, 2.8, 1);
		drawSolidRoofTile(1, 0, this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 2.8, 1);
		drawSolidRoofTile(1, 90, this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 2.8, 0);
		drawSolidRoofTile(1, 180, this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0, 2.8, -1);
		drawSolidRoofTile(1, 270, this->darkGreen);
		glPopMatrix();
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidRound(GLdouble height, GLdouble radius) {
	GLdouble pi = 3.14159265;
	GLdouble h  = height;
    GLdouble r  = radius;
    GLdouble k  = 2 * pi / 10;
	
	Point  A, B, C, D;
	Vector P, Q, N;

    for(GLdouble a = 0.0; a < 2 * pi; a += k) {
		// Superfcie lateral retngular

		A = Point(r * cos(a)  , h, r * sin(a)  );
		B = Point(r * cos(a+k), h, r * sin(a+k));
		C = Point(r * cos(a+k), 0, r * sin(a+k));
		D = Point(r * cos(a)  , 0, r * sin(a)  );

		P = Vector(A, B);
		Q = Vector(A, C);
		N = Vector().getNormal(P, Q);

		glNormal3d(N.getX(), N.getY(), N.getZ());

        glBegin(GL_POLYGON);
		glVertex3d(A.getX(), A.getY(), A.getZ());
        glVertex3d(B.getX(), B.getY(), B.getZ());
        glVertex3d(C.getX(), C.getY(), C.getZ());
        glVertex3d(D.getX(), D.getY(), D.getZ());
        glEnd();
        
		// Superfcie circular inferior

		A = Point(r * cos(a)  , 0, r * sin(a)  );
		B = Point(r * cos(a+k), 0, r * sin(a+k));
		C = Point(0           , 0, 0           );

		P = Vector(A, B);
		Q = Vector(A, C);
		N = Vector().getNormal(P, Q);

		glNormal3d(N.getX(), N.getY(), N.getZ());

        glBegin(GL_POLYGON);
        glVertex3d(A.getX(), A.getY(), A.getZ());
        glVertex3d(B.getX(), B.getY(), B.getZ());
        glVertex3d(C.getX(), C.getY(), C.getZ());
        glEnd();

		// Superfcie circular superior

		A = Point(r * cos(a+k), h, r * sin(a+k));
		B = Point(r * cos(a)  , h, r * sin(a)  );
		C = Point(0           , h, 0           );

		P = Vector(A, B);
		Q = Vector(A, C);
		N = Vector().getNormal(P, Q);

		glNormal3d(N.getX(), N.getY(), N.getZ());
        
        glBegin(GL_POLYGON);
        glVertex3d(A.getX(), A.getY(), A.getZ());
        glVertex3d(B.getX(), B.getY(), B.getZ());
        glVertex3d(C.getX(), C.getY(), C.getZ());
        glEnd();
    }
}

void LegoCreatorHouse::drawSolidBasePlate(GLint width, GLint length, LegoColor color) {
	drawSolidPlate(width, length, color);
}

void LegoCreatorHouse::drawSolidPlate(GLint width, GLint length, LegoColor color) {
	drawSolidCube(width, length, 0.4, color, GL_FALSE);
}

void LegoCreatorHouse::drawSolidFlatTile(GLint width, GLint length, LegoColor color) {
	drawSolidCube(width, length, 0.4, color, GL_TRUE);
}

void LegoCreatorHouse::drawSolidBrick(GLint width, GLint length, LegoColor color) {
	drawSolidCube(width, length, 1.2, color, GL_FALSE);
}

void LegoCreatorHouse::drawSolidCube(GLdouble width, GLdouble length, GLdouble height, LegoColor color, GLboolean isFlat) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	glColor3d(r, g, b);

	glPushMatrix();
	if(isFlat == GL_FALSE) {
		for(int x = 0; x < width; x++) {
			for(int y = 0; y < length; y++) {
				glPushMatrix();
				glTranslated(0.5 + x, height, 0.5 + y);
				drawSolidRound(0.2, 0.3);
				glPopMatrix();
			}
		}
	}
    glTranslated(width / 2, height / 2, length / 2);
    glScaled(width, height, length);
    glutSolidCube(1.0);
    glPopMatrix();
}

void LegoCreatorHouse::drawSolidCornerPlate(GLint angle, LegoColor color) {
	drawSolidCorner(0.4, angle, color);
}

void LegoCreatorHouse::drawSolidCornerBrick(GLint angle, LegoColor color) {
	drawSolidCorner(1.2, angle, color);
}

void LegoCreatorHouse::drawSolidCorner(GLdouble height, GLdouble angle, LegoColor color) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	glColor3d(r, g, b);

    GLdouble vert[12][3] = {
        { 0,      0, 0 }, // 0
        { 2,      0, 0 }, // 1
        { 2,      0, 1 }, // 2
        { 1,      0, 1 }, // 3
        { 1,      0, 2 }, // 4
        { 0,      0, 2 }, // 5
        { 0, height, 2 }, // 6
        { 1, height, 2 }, // 7
        { 1, height, 1 }, // 8
        { 2, height, 1 }, // 9
        { 2, height, 0 }, // 10
        { 0, height, 0 }  // 11
    };
    
    GLint face[8][6] = {
        {  0, 1,  2,  3,  4,  5 }, // 0-1-2-3-4
        { 11, 6,  7,  8,  9, 10 }, // 11-6-7-8-9-10
        {  0, 5,  6, 11, -1, -1 }, // 0-5-6-11
        {  5, 4,  7,  6, -1, -1 }, // 5-4-7-6
        {  4, 3,  8,  7, -1, -1 }, // 4-3-8-7
        {  3, 2,  9,  8, -1, -1 }, // 3-2-9-8
        {  2, 1, 10,  9, -1, -1 }, // 2-1-10-9
        {  1, 0, 11, 10, -1, -1 }  // 1-0-11-10
    };
    
    glPushMatrix();
    if(angle == 90) {
        glTranslated(0, 0, 2);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 180) {
        glTranslated(2, 0, 2);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 270) {
        glTranslated(2, 0, 0);
        glRotated(angle, 0, 1, 0);
    }
    
    glPushMatrix();
    glTranslated(0.5, height, 0.5);
    drawSolidRound(0.2, 0.3);
    glPopMatrix();
    
    glPushMatrix();
    glTranslated(1.5, height, 0.5);
    drawSolidRound(0.2, 0.3);
    glPopMatrix();
    
    glPushMatrix();
    glTranslated(0.5, height, 1.5);
    drawSolidRound(0.2, 0.3);
    glPopMatrix();
    
    for(int i = 0; i < 8; i++) {
        glBegin(GL_POLYGON);

		Point A = Point(
			vert[face[i][0]][0],
			vert[face[i][0]][1],
			vert[face[i][0]][2]
		);

		Point B = Point(
			vert[face[i][1]][0],
			vert[face[i][1]][1],
			vert[face[i][1]][2]
		);

		Point C = Point(
			vert[face[i][2]][0],
			vert[face[i][2]][1],
			vert[face[i][2]][2]
		);

		Vector P = Vector(A, B);
		Vector Q = Vector(A, C);

		Vector N = Vector().getNormal(P, Q);

		glNormal3d(N.getX(), N.getY(), N.getZ());

        for(int j = 0; j < 6; j++) {
            GLint v = face[i][j];
            if(v >= 0) {
                GLdouble x = vert[v][0];
                GLdouble y = vert[v][1];
                GLdouble z = vert[v][2];
                glVertex3d(x, y, z);
            }
        }
        glEnd();
    }
    glPopMatrix();
}

void LegoCreatorHouse::drawSolidRoundPlate(LegoColor color) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	glColor3d(r, g, b);

	glPushMatrix();
    glTranslated(0.5, 0.0, 0.5);
	drawSolidRound(0.2, 0.4);
	glTranslated(0.0, 0.2, 0.0);
	drawSolidRound(0.2, 0.5);
	glTranslated(0.0, 0.2, 0.0);
	drawSolidRound(0.2, 0.3);
    glPopMatrix();
}

void LegoCreatorHouse::drawSolidRoundBrick(LegoColor color) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	glColor3d(r, g, b);

	glPushMatrix();
    glTranslated(0.5, 0.0, 0.5);
	drawSolidRound(0.2, 0.4);
	glTranslated(0.0, 0.2, 0.0);
	drawSolidRound(1.0, 0.5);
	glTranslated(0.0, 1.0, 0.0);
	drawSolidRound(0.2, 0.3);
    glPopMatrix();
}

void LegoCreatorHouse::drawSolidRadiatorGrile(GLdouble angle, LegoColor color) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	GLdouble w = 1;
	GLdouble l = 2;
	GLdouble h = 0.4;

	glColor3d(r, g, b);

	if(angle == 90) {
        glTranslated(0, 0, 1);
        glRotated(angle, 0, 1, 0);
    }

	glPushMatrix();
	glTranslated(0.1, h / 2, l / 2);
	glScaled(0.2, h, l);
	glutSolidCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(0.5, h - 0.1, l / 2);
	glScaled(0.2, 0.2, l);
	glutSolidCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(0.9, h / 2, l / 2);
	glScaled(0.2, h, l);
	glutSolidCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(w / 2, (h - 0.2) / 2, 0.1);
	glScaled(w - 0.4, h - 0.2, 0.2);
	glutSolidCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(w / 2, (h - 0.2) / 2, l - 0.1);
	glScaled(w - 0.4, h - 0.2, 0.2);
	glutSolidCube(1.0);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidAngularBrick(GLdouble angle, LegoColor color) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	glColor3d(r, g, b);

	if(angle == 90) {
        glTranslated(0, 0, 1);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 180) {
        glTranslated(1, 0, 1);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 270) {
        glTranslated(1, 0, 0);
        glRotated(angle, 0, 1, 0);
    }

	glPushMatrix();
	glTranslated(0.5, 0.1, 0.5);
	glScaled(1, 0.2, 1);
	glutSolidCube(1.0);
    glPopMatrix();

	glPushMatrix();
	glTranslated(0.6, 0.7, 0.5);
	glScaled(0.8, 1, 1);
	glutSolidCube(1.0);
    glPopMatrix();

	glPushMatrix();
	glTranslated(0.5, 1.2, 0.5);
	drawSolidRound(0.2, 0.3);
	glPopMatrix();

	glPushMatrix();
	glTranslated(0.2, 0.7, 0.5);
	glRotated(90, 0, 0, 1);
	drawSolidRound(0.2, 0.3);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidRoofTileInverted(GLint width, GLdouble angle, LegoColor color) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	glColor3d(r, g, b);
	
	GLdouble z = (GLdouble) width;

    GLdouble vert[10][3] = {
        { 2,   0, z }, // 0
        { 2, 1.2, z }, // 1
        { 1, 1.2, z }, // 2
        { 0, 0.2, z }, // 3
        { 0,   0, z }, // 4
        { 0,   0, 0 }, // 5
        { 0, 0.2, 0 }, // 6
        { 1, 1.2, 0 }, // 7
        { 2, 1.2, 0 }, // 8
        { 2,   0, 0 }  // 9
    };

    GLint face[7][5] = {
        { 4, 0, 1, 2,  3 }, // 4-0-1-2-3
        { 5, 4, 3, 6, -1 }, // 5-4-3-6
        { 9, 5, 6, 7,  8 }, // 9-5-6-7-8
        { 0, 9, 8, 1, -1 }, // 0-9-8-1
        { 7, 2, 1, 8, -1 }, // 7-2-1-8
        { 6, 3, 2, 7, -1 }, // 6-3-2-7
        { 4, 5, 9, 0, -1 }  // 4-5-9-0
    };

    glPushMatrix();
    if(angle == 90) {
        glTranslated(0, 0, 2);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 180) {
        glTranslated(2, 0, z);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 270) {
        glTranslated(z, 0, 0);
        glRotated(angle, 0, 1, 0);
    }

	for(int z = 0; z < width; z++) {
		glPushMatrix();
		glTranslated(1.5, 1.2, 0.5 + z);
		drawSolidRound(0.2, 0.3);
		glPopMatrix();
	}

		glPushMatrix();
		glTranslated(0, 1.2, z);
		glRotated(180, 1, 0, 0);
		for(int i = 0; i < 7; i++) {
			glBegin(GL_POLYGON);

			Point A = Point(
				vert[face[i][0]][0],
				vert[face[i][0]][1],
				vert[face[i][0]][2]
			);

			Point B = Point(
				vert[face[i][1]][0],
				vert[face[i][1]][1],
				vert[face[i][1]][2]
			);

			Point C = Point(
				vert[face[i][2]][0],
				vert[face[i][2]][1],
				vert[face[i][2]][2]
			);

			Vector P = Vector(A, B);
			Vector Q = Vector(A, C);

			Vector N = Vector().getNormal(P, Q);

			glNormal3d(N.getX(), N.getY(), N.getZ());

			for(int j = 0; j < 5; j++) {
				GLint v = face[i][j];
				if(v >= 0) {
					GLdouble x = vert[v][0];
					GLdouble y = vert[v][1];
					GLdouble z = vert[v][2];
					glVertex3d(x, y, z);
				}
			}
			glEnd();
		}
		glPopMatrix();
    glPopMatrix();
}

void LegoCreatorHouse::drawSolidRoofTile(GLint width, GLdouble angle, LegoColor color) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	glColor3d(r, g, b);

	GLdouble z = (GLdouble) width;

    GLdouble vert[10][3] = {
        { 2,   0, z }, // 0
        { 2, 1.2, z }, // 1
        { 1, 1.2, z }, // 2
        { 0, 0.2, z }, // 3
        { 0,   0, z }, // 4
        { 0,   0, 0 }, // 5
        { 0, 0.2, 0 }, // 6
        { 1, 1.2, 0 }, // 7
        { 2, 1.2, 0 }, // 8
        { 2,   0, 0 }  // 9
    };

    GLint face[7][5] = {
        { 4, 0, 1, 2,  3 }, // 4-0-1-2-3
        { 5, 4, 3, 6, -1 }, // 5-4-3-6
        { 9, 5, 6, 7,  8 }, // 9-5-6-7-8
        { 0, 9, 8, 1, -1 }, // 0-9-8-1
        { 7, 2, 1, 8, -1 }, // 7-2-1-8
        { 6, 3, 2, 7, -1 }, // 6-3-2-7
        { 4, 5, 9, 0, -1 }  // 4-5-9-0
    };

    glPushMatrix();
    if(angle == 90) {
        glTranslated(0, 0, 2);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 180) {
        glTranslated(2, 0, z);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 270) {
        glTranslated(z, 0, 0);
        glRotated(angle, 0, 1, 0);
    }

	for(int z = 0; z < width; z++) {
		glPushMatrix();
		glTranslated(1.5, 1.2, 0.5 + z);
		drawSolidRound(0.2, 0.3);
		glPopMatrix();
	}

    for(int i = 0; i < 7; i++) {
        glBegin(GL_POLYGON);

		Point A = Point(
			vert[face[i][0]][0],
			vert[face[i][0]][1],
			vert[face[i][0]][2]
		);

		Point B = Point(
			vert[face[i][1]][0],
			vert[face[i][1]][1],
			vert[face[i][1]][2]
		);

		Point C = Point(
			vert[face[i][2]][0],
			vert[face[i][2]][1],
			vert[face[i][2]][2]
		);

		Vector P = Vector(A, B);
		Vector Q = Vector(A, C);

		Vector N = Vector().getNormal(P, Q);

		glNormal3d(N.getX(), N.getY(), N.getZ());

        for(int j = 0; j < 5; j++) {
            GLint v = face[i][j];
            if(v >= 0) {
                GLdouble x = vert[v][0];
                GLdouble y = vert[v][1];
                GLdouble z = vert[v][2];
                glVertex3d(x, y, z);
            }
        }
        glEnd();
    }
    glPopMatrix();
}

void LegoCreatorHouse::drawSolidPlateWithSlide(GLint angle, GLint length, LegoColor color) {
	glPushMatrix();
	if(angle == 90) {
        glTranslated(0, 0, 1.45);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 180) {
        glTranslated(1.45, 0, length);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 270) {
        glTranslated(length, 0, 0);
        glRotated(angle, 0, 1, 0);
    }
		glPushMatrix();
		glTranslated(0.45, 0, 0);
		drawSolidPlate(1, length, color);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.3, 0.2, length / 2);
		glScaled(0.3, 0.1, length);
		glutSolidCube(1.0);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.075, 0.2, length / 2);
		glScaled(0.15, 0.4, length);
		glutSolidCube(1.0);
		glPopMatrix();
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidWallCorner(GLint angle, LegoColor color) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	glColor3d(r, g, b);

	glPushMatrix();
	if(angle == 90) {
        glTranslated(0, 0, 1);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 180) {
        glTranslated(1, 0, 1);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 270) {
        glTranslated(1, 0, 0);
        glRotated(angle, 0, 1, 0);
    }
		glPushMatrix();
		glTranslated(0.5, 0.2, 0.5);
		glScaled(1, 0.4, 1);
		glutSolidCube(1.0);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.1, 0.8, 0.5);
		glScaled(0.2, 0.8, 1);
		glutSolidCube(1.0);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.6, 0.8, 0.1);
		glScaled(0.8, 0.8, 0.2);
		glutSolidCube(1.0);
		glPopMatrix();
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidAnglePlate(GLint angle, LegoColor color) {
	glPushMatrix();
	if(angle == 90) {
        glTranslated(0, 0, 1.4);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 180) {
        glTranslated(1.4, 0, 1.4);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 270) {
        glTranslated(2, 0, 0);
        glRotated(angle, 0, 1, 0);
    }

		glPushMatrix();
		glTranslated(0.4, 1.6, 0);
		drawSolidPlate(1, 2, color);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.4, 0, 0);
		glRotated(90, 0, 0, 1);
		drawSolidPlate(2, 2, color);
		glPopMatrix();
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidRidgedTile(GLint width, GLint angle, LegoColor color) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	glColor3d(r, g, b);

	GLint z = width;

    GLdouble vert[10][3] = {
        { 2,   0, z }, // 0
        { 2, 0.2, z }, // 1
        { 1, 1.2, z }, // 2
		{ 0, 0.2, z }, // 3
		{ 0,   0, z }, // 4
		{ 0,   0, 0 }, // 5
		{ 0, 0.2, 0 }, // 6
		{ 1, 1.2, 0 }, // 7
		{ 2, 0.2, 0 }, // 8
		{ 2,   0, 0 }  // 9
    };

    GLint face[7][5] = {
        { 4, 0, 1, 2,  3 }, // 4-0-1-2-3
		{ 5, 4, 3, 6, -1 }, // 5-4-3-6
		{ 9, 5, 6, 7,  8 }, // 9-5-6-7-8
		{ 0, 9, 8, 1, -1 }, // 0-9-8-1
		{ 6, 3, 2, 7, -1 }, // 6-3-2-7
		{ 1, 8, 7, 2, -1 }, // 1-8-7-2
		{ 4, 5, 9, 0, -1 }  // 4-5-9-0
    };

    glPushMatrix();
    if(angle == 90) {
        glTranslated(0, 0, 2);
        glRotated(angle, 0, 1, 0);
    }

    for(int i = 0; i < 7; i++) {
        glBegin(GL_POLYGON);

		Point A = Point(
			vert[face[i][0]][0],
			vert[face[i][0]][1],
			vert[face[i][0]][2]
		);

		Point B = Point(
			vert[face[i][1]][0],
			vert[face[i][1]][1],
			vert[face[i][1]][2]
		);

		Point C = Point(
			vert[face[i][2]][0],
			vert[face[i][2]][1],
			vert[face[i][2]][2]
		);

		Vector P = Vector(A, B);
		Vector Q = Vector(A, C);

		Vector N = Vector().getNormal(P, Q);

		glNormal3d(N.getX(), N.getY(), N.getZ());

        for(int j = 0; j < 5; j++) {
            GLint v = face[i][j];
            if(v >= 0) {
                GLdouble x = vert[v][0];
                GLdouble y = vert[v][1];
                GLdouble z = vert[v][2];
                glVertex3d(x, y, z);
            }
        }
        glEnd();
    }
    glPopMatrix();
}

void LegoCreatorHouse::drawSolidEndRidgedTile(GLint angle, LegoColor color) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	glColor3d(r, g, b);

    GLdouble vert[10][3] = {
        { 2,   0, 1 }, // 0
        { 2, 0.2, 1 }, // 1
        { 1, 1.2, 1 }, // 2
		{ 0, 0.2, 1 }, // 3
		{ 0,   0, 1 }, // 4
		{ 0,   0, 0 }, // 5
		{ 0, 0.2, 0 }, // 6
		{ 2, 0.2, 0 }, // 7
		{ 2,   0, 0 }  // 8
    };

    GLint face[8][5] = {
        { 4, 0, 1,  2,  3 }, // 4-0-1-2-3
		{ 8, 5, 6,  7, -1 }, // 8-5-6-7
		{ 5, 4, 3,  6, -1 }, // 5-4-3-6
		{ 0, 8, 7,  1, -1 }, // 0-8-7-1
		{ 2, 7, 6, -1, -1 }, // 6-2-7
		{ 2, 6, 3, -1, -1 }, // 3-6-2
		{ 2, 1, 7, -1, -1 }, // 7-1-2
		{ 0, 4, 5,  8, -1 }  // 0-4-5-8
    };

    glPushMatrix();
    if(angle == 90) {
        glTranslated(0, 0, 2);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 180) {
        glTranslated(2, 0, 1);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 270) {
        glTranslated(1, 0, 0);
        glRotated(angle, 0, 1, 0);
    }

    for(int i = 0; i < 8; i++) {
        glBegin(GL_POLYGON);

		Point A = Point(
			vert[face[i][0]][0],
			vert[face[i][0]][1],
			vert[face[i][0]][2]
		);

		Point B = Point(
			vert[face[i][1]][0],
			vert[face[i][1]][1],
			vert[face[i][1]][2]
		);

		Point C = Point(
			vert[face[i][2]][0],
			vert[face[i][2]][1],
			vert[face[i][2]][2]
		);

		Vector P = Vector(A, B);
		Vector Q = Vector(A, C);

		Vector N = Vector().getNormal(P, Q);

		glNormal3d(N.getX(), N.getY(), N.getZ());

        for(int j = 0; j < 5; j++) {
            GLint v = face[i][j];
            if(v >= 0) {
                GLdouble x = vert[v][0];
                GLdouble y = vert[v][1];
                GLdouble z = vert[v][2];
                glVertex3d(x, y, z);
            }
        }
        glEnd();
    }
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidWindow(GLint angle) {
	GLdouble r = (GLdouble) white.getColorRed()   / 255;
	GLdouble g = (GLdouble) white.getColorGreen() / 255;
	GLdouble b = (GLdouble) white.getColorBlue()  / 255;
	
	if(angle == 90) {
		glTranslated(0, 0, 4);
		glRotated(angle, 0, 1, 0);
	} else if(angle == 180) {
		glTranslated(4, 0, 1);
		glRotated(angle, 0, 1, 0);
	} else if(angle == 270) {
		glTranslated(1, 0, 0);
		glRotated(angle, 0, 1, 0);
	}
	
	glPushMatrix();
	glTranslated(0, 3.2, 0);
	drawSolidPlate(4, 1, darkStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 0.2, 0.5);
	glScaled(4, 0.4, 1);
	glutSolidCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(0.2, 1.8, 0.5);
	glScaled(0.4, 2.8, 1);
	glutSolidCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(3.8, 1.8, 0.5);
	glScaled(0.4, 2.8, 1);
	glutSolidCube(1.0);
	glPopMatrix();

	glColor3d(r, g, b);

	glTranslated(0.4, 0.4, 0);
	glPushMatrix();
		glPushMatrix();
		glTranslated(0.1, 1.4, 0.1);
		glScaled(0.2, 2.8, 0.2);
		glutSolidCube(1.0);
		glPopMatrix();
		
		glPushMatrix();
		glTranslated(1.5, 1.4, 0.1);
		glScaled(0.2, 2.8, 0.2);
		glutSolidCube(1.0);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.8, 0.1, 0.1);
		glScaled(1.2, 0.2, 0.2);
		glutSolidCube(1.0);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.8, 1.4, 0.1);
		glScaled(1.2, 0.2, 0.2);
		glutSolidCube(1.0);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.8, 2.7, 0.1);
		glScaled(1.2, 0.2, 0.2);
		glutSolidCube(1.0);
		glPopMatrix();
	glPopMatrix();

	glTranslated(1.6, 0, 0);
	glPushMatrix();
		glPushMatrix();
		glTranslated(0.1, 1.4, 0.1);
		glScaled(0.2, 2.8, 0.2);
		glutSolidCube(1.0);
		glPopMatrix();
		
		glPushMatrix();
		glTranslated(1.5, 1.4, 0.1);
		glScaled(0.2, 2.8, 0.2);
		glutSolidCube(1.0);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.8, 0.1, 0.1);
		glScaled(1.2, 0.2, 0.2);
		glutSolidCube(1.0);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.8, 1.4, 0.1);
		glScaled(1.2, 0.2, 0.2);
		glutSolidCube(1.0);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.8, 2.7, 0.1);
		glScaled(1.2, 0.2, 0.2);
		glutSolidCube(1.0);
		glPopMatrix();
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidDoor(GLint angle) {
	GLdouble r = (GLdouble) mediumStoneGrey.getColorRed()   / 255;
	GLdouble g = (GLdouble) mediumStoneGrey.getColorGreen() / 255;
	GLdouble b = (GLdouble) mediumStoneGrey.getColorBlue()  / 255;
	
	if(angle == 90) {
		glTranslated(0, 0, 4);
		glRotated(angle, 0, 1, 0);
	} else if(angle == 180) {
		glTranslated(4, 0, 1);
		glRotated(angle, 0, 1, 0);
	} else if(angle == 270) {
		glTranslated(1, 0, 0);
		glRotated(angle, 0, 1, 0);
	}

	glColor3d(r, g, b);

	glPushMatrix();
	glTranslated(0.5, 0, 0.5);
	drawSolidRound(0.2, 0.5);
	glPopMatrix();

	glPushMatrix();
	glTranslated(0.2, 3.1, 0.5);
	glScaled(0.4, 5.8, 0.4);
	glutSolidCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(3.8, 3.1, 0.5);
	glScaled(0.4, 5.8, 0.4);
	glutSolidCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 0.4, 0.5);
	glScaled(3.2, 0.4, 0.4);
	glutSolidCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 5.8, 0.5);
	glScaled(3.2, 0.4, 0.4);
	glutSolidCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(3.5, 3.1, 0.8);
	glScaled(0.6, 0.6, 0.2);
	glutSolidCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(3.5, 3.1, 0.2);
	glScaled(0.6, 0.6, 0.2);
	glutSolidCube(1.0);
	glPopMatrix();

	glColor4d(0.89, 0.97, 1, 0.6);

	glPushMatrix();
	glTranslated(2, 3.1, 0.5);
	glScaled(3.2, 5, 0.2);
	glutSolidCube(1.0);
	glPopMatrix();
}

void LegoCreatorHouse::drawSolidFence(GLint angle) {
	GLdouble r = (GLdouble) black.getColorRed()   / 255;
	GLdouble g = (GLdouble) black.getColorGreen() / 255;
	GLdouble b = (GLdouble) black.getColorBlue()  / 255;

	if(angle == 90) {
		glTranslated(0, 0, 4);
		glRotated(angle, 0, 1, 0);
	}

	glColor3d(r, g, b);

	glPushMatrix();
	glTranslated(2, 0.2, 0.5);
	glScaled(4, 0.4, 1);
	glutSolidCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 0.5, 0.5);
	glScaled(4, 0.2, 0.4);
	glutSolidCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 2.3, 0.5);
	glScaled(4, 0.2, 0.4);
	glutSolidCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(0.1, 1.4, 0.5);
	glScaled(0.2, 1.6, 0.4);
	glutSolidCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(3.9, 1.4, 0.5);
	glScaled(0.2, 1.6, 0.4);
	glutSolidCube(1.0);
	glPopMatrix();

	glTranslated(0.2, 0.6, 0.3);

	for(double x = 0.45; x < 3.6; x += 0.45) {
		glPushMatrix();
		glTranslated(x, 0.8, 0.2);
		glScaled(0.05, 1.6, 0.4);
		glutSolidCube(1.0);
		glPopMatrix();
	}
}

void LegoCreatorHouse::drawSolidMailBox(GLint angle) {
	GLdouble pi = 3.14159265;
    GLdouble k  = pi / 15;

	GLdouble r = (GLdouble) brightYellow.getColorRed()   / 255;
	GLdouble g = (GLdouble) brightYellow.getColorGreen() / 255;
	GLdouble b = (GLdouble) brightYellow.getColorBlue()  / 255;

	Point  A, B, C, D;
	Vector P, Q, N;

	glColor3d(r, g, b);

	if(angle == 90) {
		glTranslated(0, 0, 2);
		glRotated(angle, 0, 1, 0);
	}

	glPushMatrix();
	glTranslated(1, 1, 0.5);
	drawSolidRound(0.2, 0.3);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 0, 0);
    for(GLdouble a = 0.0; a < pi; a += k) {
		// Superfcie lateral retngular

		A = Point(cos(a)  , sin(a)  , 0);
		B = Point(cos(a+k), sin(a+k), 0);
		C = Point(cos(a+k), sin(a+k), 2);
		D = Point(cos(a)  , sin(a)  , 2);

		P = Vector(A, B);
		Q = Vector(A, C);
		N = Vector().getNormal(P, Q);

		glNormal3d(N.getX(), N.getY(), N.getZ());

        glBegin(GL_POLYGON);
		glVertex3d(A.getX(), A.getY(), A.getZ());
        glVertex3d(B.getX(), B.getY(), B.getZ());
        glVertex3d(C.getX(), C.getY(), C.getZ());
        glVertex3d(D.getX(), D.getY(), D.getZ());
        glEnd();
        
		// Superfcie circular inferior

		A = Point(0       , 0       , 0);
		B = Point(cos(a+k), sin(a+k), 0);
		C = Point(cos(a)  , sin(a)  , 0);

		P = Vector(A, B);
		Q = Vector(A, C);
		N = Vector().getNormal(P, Q);

		glNormal3d(N.getX(), N.getY(), N.getZ());

        glBegin(GL_POLYGON);
        glVertex3d(A.getX(), A.getY(), A.getZ());
        glVertex3d(B.getX(), B.getY(), B.getZ());
        glVertex3d(C.getX(), C.getY(), C.getZ());
        glEnd();

		// Superfcie circular superior

		A = Point(0       , 0       , 2);
		B = Point(cos(a)  , sin(a)  , 2);
		C = Point(cos(a+k), sin(a+k), 2);

		P = Vector(A, B);
		Q = Vector(A, C);
		N = Vector().getNormal(P, Q);

		glNormal3d(N.getX(), N.getY(), N.getZ());
        
        glBegin(GL_POLYGON);
        glVertex3d(A.getX(), A.getY(), A.getZ());
        glVertex3d(B.getX(), B.getY(), B.getZ());
        glVertex3d(C.getX(), C.getY(), C.getZ());
        glEnd();
    }
	glPopMatrix();

    GLdouble vert[8][3] = {
        { 1,   0, 1 }, // 0
        { 1, 0.2, 1 }, // 1
        { 1, 0.6, 0 }, // 2
		{ 1,   0, 0 }, // 3
		{ 0,   0, 0 }, // 4
		{ 0, 0.6, 0 }, // 5
		{ 0, 0.2, 1 }, // 6
		{ 0,   0, 1 }  // 7
    };

    GLint face[6][4] = {
        { 0, 3, 2, 1 }, // 0-3-2-1
		{ 3, 4, 5, 2 }, // 3-4-5-2
		{ 4, 7, 6, 5 }, // 4-7-6-5
		{ 7, 0, 1, 6 }, // 7-0-1-6
		{ 6, 1, 2, 5 }, // 6-1-2-5
		{ 0, 7, 4, 3 }  // 0-7-4-3
    };

	glPushMatrix();
	glTranslated(0.5, 1, 1);
    for(int i = 0; i < 6; i++) {
        glBegin(GL_POLYGON);

		Point A = Point(
			vert[face[i][0]][0],
			vert[face[i][0]][1],
			vert[face[i][0]][2]
		);

		Point B = Point(
			vert[face[i][1]][0],
			vert[face[i][1]][1],
			vert[face[i][1]][2]
		);

		Point C = Point(
			vert[face[i][2]][0],
			vert[face[i][2]][1],
			vert[face[i][2]][2]
		);

		Vector P = Vector(A, B);
		Vector Q = Vector(A, C);

		Vector N = Vector().getNormal(P, Q);

		glNormal3d(N.getX(), N.getY(), N.getZ());

        for(int j = 0; j < 4; j++) {
            GLint v = face[i][j];
            if(v >= 0) {
                GLdouble x = vert[v][0];
                GLdouble y = vert[v][1];
                GLdouble z = vert[v][2];
                glVertex3d(x, y, z);
            }
        }
        glEnd();
    }
	glPopMatrix();
}
