/* Universidade Estadual de Campinas - Unicamp
 * Faculdade de Engenharia Eltrica e de Computao - Feec
 *
 * IA725A  Computao Grfica I
 * 1o semestre de 2009
 * <http://www.dca.fee.unicamp.br/courses/IA725/1s2009/>
 *
 * Profa. Dra. Wu Shin-Ting
 * <http://www.dca.fee.unicamp.br/~ting/>
 *
 * Projeto Prtico: LEGO Creator House 3D - Wireframe
 *
 * Leandro Barros de Figueiredo
 * Rodrigo Mologni Gonalves dos Santos
 * <http://www.dca.fee.unicamp.br/~mologni/>
 */

#include <stdlib.h>
#include <math.h>
#include <GL/glut.h>

#include "LegoCreatorHouse.h"

LegoCreatorHouse::LegoCreatorHouse() {
	this->white.setColor(242, 243, 242);
	this->brickYellow.setColor(215, 197, 153);
	this->brightRed.setColor(196, 40, 27);
	this->brightYellow.setColor(245, 205, 47);
	this->black.setColor(27, 42, 52);
	this->darkGreen.setColor(40, 127, 70);
	this->brightYellowishGreen.setColor(164, 189, 70);
	this->reddishBrown.setColor(105, 64, 39);
	this->mediumStoneGrey.setColor(163, 162, 164);
	this->darkStoneGrey.setColor(99, 95, 97);
}

LegoCreatorHouse::~LegoCreatorHouse() {

}

void LegoCreatorHouse::drawWireLegoCreatorHouse() {
    glPushMatrix();
	glTranslated(-16, 0, -16);
	drawWireBasePlate(32, 32, this->darkGreen);
    drawWireMap1();
	drawWireMap2();
	drawWireMap3();
	drawWireMap4();
	drawWireMap5();
	drawWireMap6();
	drawWireMap7();
	drawWireMap8();
	drawWireMap9();
	drawWireMap10();
	drawWireMap11();
	drawWireMap12();
	drawWireMap13();
	drawWireMap14();
	drawWireMap15();
	drawWireMap16();
	drawWireMap17();
	drawWireMap18();
	drawWireMap19();
	drawWireMap20();
	drawWireMap21();
	drawWireMap22();
	drawWireMap23();
	drawWireMap24();
	drawWireMap25();
	drawWireMap26();
	drawWireMap27();
	drawWireMap28();
	drawWireMap29();
	drawWireMap30();
	drawWireMap31();
	drawWireMap32();
	drawWireMap33();
	drawWireMap34();
	drawWireMap35();
	drawWireMap36();
	drawWireMap37();
	drawWireMap38();
	drawWireMap39();
	drawWireMap40();
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap1() {
    glPushMatrix();
    glTranslated(0, 0.4, 27);
    drawWirePlate(6, 4, this->mediumStoneGrey);
    glPopMatrix();

	glPushMatrix();
    glTranslated(6, 0.4, 27);
    drawWirePlate(8, 4, this->mediumStoneGrey);
    glPopMatrix();

	glPushMatrix();
    glTranslated(14, 0.4, 27);
    drawWirePlate(6, 4, this->mediumStoneGrey);
    glPopMatrix();

	glPushMatrix();
    glTranslated(20, 0.4, 27);
    drawWirePlate(8, 4, this->mediumStoneGrey);
    glPopMatrix();

	glPushMatrix();
    glTranslated(28, 0.4, 27);
    drawWirePlate(4, 4, this->mediumStoneGrey);
    glPopMatrix();

	for(int x = 0; x < 25; x += 8) {
		glPushMatrix();
		glTranslated(x, 0.4, 31);
		drawWireFlatTile(8, 1, this->mediumStoneGrey);
		glPopMatrix();
	}
}

void LegoCreatorHouse::drawWireMap2() {
	glPushMatrix();
	glTranslated(23, 0.4, 20);
	drawWirePlate(4, 1, this->mediumStoneGrey);
	glPopMatrix();

	for(int z = 21; z < 27; z++) {
		glPushMatrix();
		glTranslated(23, 0.4, z);
		drawWireFlatTile(4, 1, this->mediumStoneGrey);
		glPopMatrix();
	}
}

void LegoCreatorHouse::drawWireMap3() {
	glPushMatrix();
	glTranslated(19, 0.4, 11);
	drawWireBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 0.4, 11);
	drawWireBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 0.4, 12);
	drawWireBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 0.4, 12);
	drawWireBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 0.4, 20);
	drawWireBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 0.4, 20);
	drawWireBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 0.4, 25);
	drawWireBrick(2, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 0.4, 26);
	drawWirePlate(1, 1, this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap4() {
	glPushMatrix();
	glTranslated(27, 0.4, 21);
	drawWirePlate(2, 6, this->reddishBrown);
		glPushMatrix();
		glTranslated(1, 0.4, 0);
		drawWireRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.8, 0);
		drawWireRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.4, 2);
		drawWireRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0, 0.4, 3);
		drawWireRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.4, 4);
		drawWireRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.4, 5);
		drawWireRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 1, 0);
		drawWireRoundPlate(this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.4, 1);
		drawWireRoundPlate(this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0, 0.4, 2);
		drawWireRoundPlate(this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0, 0.8, 3);
		drawWireRoundPlate(this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.8, 5);
		drawWireRoundPlate(this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0, 0.4, 1);
		drawWireRoundPlate(this->brightRed);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.8, 4);
		drawWireRoundPlate(this->brightRed);
		glPopMatrix();
	glPopMatrix();

	glPushMatrix();
	glTranslated(16, 0.4, 26);
	drawWirePlate(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(16, 0.4, 20);
	drawWirePlate(1, 6, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(16, 0.4, 12);
	drawWirePlate(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 0.4, 20);
	drawWireCornerPlate(90, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 0.4, 22);
	drawWireRadiatorGrile(90, this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap5() {
	glPushMatrix();
	glTranslated(2, 0.4, 2);
	drawWireBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(6, 0.4, 2);
	drawWireBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 0.4, 3);
	drawWireBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 0.4, 3);
	drawWireBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 0.4, 11);
	drawWireBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(6, 0.4, 11);
	drawWireBrick(3, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(9, 0.4, 11);
	drawWirePlate(4, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 0.4, 11);
	drawWireBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 0.4, 10);
	drawWireRadiatorGrile(0, this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap6() {
	glPushMatrix();
	glTranslated(16, 0.4, 6);
	drawWirePlate(1, 6, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 0.4, 12);
	drawWirePlate(1, 1, this->mediumStoneGrey);
	glPopMatrix();

	for(int x = 9; x < 12; x++) {
		for(int z = 12; z < 15; z++) {
			glPushMatrix();
			glTranslated(x, 0.4, z);
			if((x + z) % 2 == 0) {
				drawWirePlate(1, 1, this->mediumStoneGrey);
			} else {
				drawWirePlate(1, 1, this->darkStoneGrey);
			}
			glPopMatrix();
		}
	}

	for(int x = 8; x < 11; x++) {
		for(int z = 15; z < 18; z++) {
			glPushMatrix();
			glTranslated(x, 0.4, z);
			if((x + z) % 2 == 0) {
				drawWirePlate(1, 1, this->mediumStoneGrey);
			} else {
				drawWirePlate(1, 1, this->darkStoneGrey);
			}
			glPopMatrix();
		}
	}

	for(int x = 7; x < 10; x++) {
		for(int z = 18; z < 21; z++) {
			glPushMatrix();
			glTranslated(x, 0.4, z);
			if((x + z) % 2 == 0) {
				drawWirePlate(1, 1, this->mediumStoneGrey);
			} else {
				drawWirePlate(1, 1, this->darkStoneGrey);
			}
			glPopMatrix();
		}
	}

	for(int x = 6; x < 9; x++) {
		for(int z = 21; z < 24; z++) {
			glPushMatrix();
			glTranslated(x, 0.4, z);
			if((x + z) % 2 == 0) {
				drawWirePlate(1, 1, this->mediumStoneGrey);
			} else {
				drawWirePlate(1, 1, this->darkStoneGrey);
			}
			glPopMatrix();
		}
	}

	for(int x = 5; x < 8; x++) {
		for(int z = 24; z < 27; z++) {
			glPushMatrix();
			glTranslated(x, 0.4, z);
			if((x + z) % 2 == 0) {
				drawWirePlate(1, 1, this->mediumStoneGrey);
			} else {
				drawWirePlate(1, 1, this->darkStoneGrey);
			}
			glPopMatrix();
		}
	}
}

void LegoCreatorHouse::drawWireMap7() {
	glPushMatrix();
	glTranslated(19, 1.6, 11);
	drawWireCornerBrick(0, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 1.6, 13);
	drawWireAngularBrick(0, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19.2, 1.8, 13);
	glRotated(90, 0, 0, 1);
	drawWireRoundPlate(this->darkGreen);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 1.6, 14);
	drawWireBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 1.6, 15);
	drawWireBrick(1, 4, this->white);
	glPopMatrix();
	
	glPushMatrix();
	glTranslated(19, 1.6, 19);
	drawWireCornerBrick(90, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 1.6, 20);
	drawWireBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 1.6, 11);
	drawWireBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 1.6, 11);
	drawWireCornerBrick(270, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 1.6, 13);
	drawWireBrick(1, 6, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 1.6, 19);
	drawWireCornerBrick(180, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 1.6, 20);
	drawWireBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 0.8, 20);
	drawWireRoundBrick(this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap8() {
	glPushMatrix();
	glTranslated(3, 0.4, 12);
	drawWirePlate(6, 2, this->reddishBrown);
		glPushMatrix();
		glTranslated(0, 0.4, 0);
		drawWireRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(2, 0.4, 0);
		drawWireRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(3, 0.4, 0);
		drawWireRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(5, 0.4, 0);
		drawWireRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.4, 1);
		drawWireRoundPlate(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0, 0.4, 1);
		drawWireRoundPlate(this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(2, 0.8, 0);
		drawWireRoundPlate(this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(4, 0.4, 1);
		drawWireRoundPlate(this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(5, 0.8, 0);
		drawWireRoundPlate(this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.8, 1);
		drawWireRoundPlate(this->brightRed);
		glPopMatrix();

		glPushMatrix();
		glTranslated(3, 0.4, 1);
		drawWireRoundPlate(this->brightRed);
		glPopMatrix();

		glPushMatrix();
		glTranslated(4, 0.4, 0);
		drawWireRoundPlate(this->brightRed);
		glPopMatrix();
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 1.6, 2);
	drawWireBrick(1, 4, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 1.6, 6);
	drawWireBrick(1, 6, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(3, 1.6, 11);
	drawWireBrick(6, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(3, 1.6, 2);
	drawWireBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 1.6, 2);
	drawWireBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 1.6, 2);
	drawWireBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 1.6, 10);
	drawWireBrick(1, 2, this->white);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap9() {
	glPushMatrix();
	glTranslated(2, 2.8, 2);
	drawWirePlate(10, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 2.8, 2);
	drawWirePlate(1, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 2.8, 2);
	drawWirePlate(1, 10, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(8, 2.8, 11);
	drawWirePlate(1, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 2.8, 11);
	drawWirePlate(4, 2, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 2.8, 11);
	drawWirePlate(2, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 2.8, 9);
	drawWirePlate(1, 2, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 2.8, 5);
	drawWirePlate(2, 4, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 2.8, 3);
	drawWirePlate(1, 2, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 2.8, 11);
	drawWirePlate(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 2.8, 11);
	drawWirePlate(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 2.8, 12);
	drawWirePlate(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 2.8, 20);
	drawWirePlate(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 2.8, 20);
	drawWirePlate(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 2.8, 12);
	drawWirePlate(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 2, 20);
	drawWireRoundBrick(this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap10() {
	glPushMatrix();
	glTranslated(3, 3.2, 2);
	drawWireBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 3.2, 2);
	drawWireBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 3.2, 2);
	drawWireBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 3.2, 10);
	drawWireBrick(1, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(8, 3.2, 11);
	drawWireBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(3, 3.2, 11);
	drawWireBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 3.2, 9);
	drawWireBrick(1, 3, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 3.2, 2);
	drawWireBrick(1, 3, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 3.2, 11);
	drawWireCornerBrick(0, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 3.2, 11);
	drawWireBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 3.2, 11);
	drawWireCornerBrick(270, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 3.2, 13);
	drawWireBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 3.2, 18);
	drawWireBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 3.2, 19);
	drawWireCornerBrick(180, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 3.2, 20);
	drawWireBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 3.2, 20);
	drawWireBrick(3, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 3.2, 13);
	drawWireBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 3.2, 20);
	drawWireRoundBrick(this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap11() {
	glPushMatrix();
	glTranslated(19, 4.4, 11);
	drawWireBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 4.4, 11);
	drawWireBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 4.4, 12);
	drawWireBrick(1, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 4.4, 18);
	drawWireBrick(1, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(28, 4.4, 20);
	drawWireBrick(3, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 4.4, 20);
	drawWireAngularBrick(90, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 4.4, 20);
	drawWireAngularBrick(90, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 4.4, 20);
	drawWireAngularBrick(90, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 4.4, 20);
	drawWireBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 4.4, 12);
	drawWireBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 5.6, 20.8);
	glRotated(90, 1, 0, 0);
	drawWireFlatTile(2, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 5.6, 20.8);
	glRotated(90, 1, 0, 0);
	drawWireRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 4.4, 20);
	drawWireRoundBrick(this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap12() {
	glPushMatrix();
	glTranslated(2, 4.4, 2);
	drawWireBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(6, 4.4, 2);
	drawWireBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 4.4, 3);
	drawWireBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 4.4, 11);
	drawWireBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(8, 4.4, 11);
	drawWireAngularBrick(90, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(8, 5.6, 11.5);
	glRotated(90, 1, 0, 0);
	drawWireRoundPlate(this->brightYellow);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 4.4, 10);
	drawWireCornerBrick(90, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 4.4, 9);
	drawWireBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 4.4, 3);
	drawWireBrick(1, 2, this->white);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap13() {
	glPushMatrix();
	glTranslated(3, 5.6, 2);
	drawWireBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 5.6, 2);
	drawWireBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 5.6, 2);
	drawWireBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 5.6, 10);
	drawWireBrick(1, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(8, 5.6, 11);
	drawWireBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(3, 5.6, 11);
	drawWireBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 5.6, 9);
	drawWireBrick(1, 3, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 5.6, 2);
	drawWireBrick(1, 3, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 5.6, 11);
	drawWireCornerBrick(0, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 5.6, 11);
	drawWireBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 5.6, 11);
	drawWireCornerBrick(270, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 5.6, 13);
	drawWireBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 5.6, 18);
	drawWireBrick(1, 3, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 5.6, 20);
	drawWireBrick(3, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 5.6, 20);
	drawWireBrick(3, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 5.6, 13);
	drawWireBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 5.6, 20);
	drawWireRoundBrick(this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap14() {
	glPushMatrix();
	glTranslated(2, 3.2, 5);
	drawWireWindow(90);
	glPopMatrix();
	
	glPushMatrix();
	glTranslated(4, 3.2, 11);
	drawWireWindow(180);
	glPopMatrix();
	
	glPushMatrix();
	glTranslated(30, 3.2, 14);
	drawWireWindow(270);
	glPopMatrix();

	glPushMatrix();
	glTranslated(9, 0.8, 11);
	drawWireDoor(180);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 0.8, 20);
	drawWireDoor(0);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap15() {
	glPushMatrix();
	glTranslated(2, 6.8, 2);
	drawWireBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(6, 6.8, 2);
	drawWireBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 6.8, 3);
	drawWireBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 6.8, 11);
	drawWireBrick(12, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 6.8, 3);
	drawWireBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 6.8, 11);
	drawWirePlate(10, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 6.8, 11);
	drawWirePlate(1, 10, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 6.8, 20);
	drawWirePlate(10, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 6.8, 11);
	drawWirePlate(1, 10, this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap16() {
	glPushMatrix();
	glTranslated(2, 8, 2);
	drawWirePlate(12, 2, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 8, 10);
	drawWirePlate(12, 2, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 8, 4);
	drawWirePlate(1, 2, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 8, 4);
	drawWirePlate(1, 2, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 8, 6);
	drawWirePlate(1, 4, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 8, 6);
	drawWirePlate(1, 4, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 7.2, 11);
	drawWireBrick(12, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 7.2, 12);
	drawWireBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 7.2, 12);
	drawWireBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 7.2, 20);
	drawWireBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 7.2, 20);
	drawWireBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 7.2, 20);
	drawWireBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 7.2, 20);
	drawWireRoofTileInverted(1, 90, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(26, 7.2, 20);
	drawWireRoofTileInverted(1, 90, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 6.8, 20);
	drawWireRoundBrick(this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap17() {
	glPushMatrix();
	glTranslated(19, 8.4, 11);
	drawWireCornerBrick(0, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 8.4, 11);
	drawWireBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 8.4, 11);
	drawWireCornerBrick(270, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 8.4, 13);
	drawWireBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 8.4, 20);
	drawWireBrick(3, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 8.4, 20);
	drawWireBrick(3, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 8.4, 13);
	drawWireBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 8, 20);
	drawWireRoundBrick(this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap18() {
	glPushMatrix();
	glTranslated(19, 9.6, 11);
	drawWireBrick(12, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 9.6, 12);
	drawWireBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 9.6, 20);
	drawWireBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 9.6, 20);
	drawWireBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 9.6, 12);
	drawWireBrick(1, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 9.6, 14);
	drawWireRoofTileInverted(1, 0, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 9.6, 15);
	drawWireBrick(1, 3, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 9.6, 18);
	drawWireAngularBrick(0, this->white);
		glPushMatrix();
		glTranslated(0.2, 0.2, 0);
		glRotated(90, 0, 0, 1);
		drawWirePlate(1, 1, this->mediumStoneGrey);
		glPopMatrix();

		glPushMatrix();
		glTranslated(-0.2, 0.2, 0);
		glRotated(90, 0, 0, 1);
		drawWireRoundPlate(this->darkGreen);
		glPopMatrix();
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 9.6, 19);
	drawWireBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 9.2, 20);
	drawWireRoundBrick(this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap19() {
	glPushMatrix();
	glTranslated(21, 10.8, 11);
	drawWireBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 10.8, 11);
	drawWireBrick(2, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 10.8, 19);
	drawWireBrick(2, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 10.8, 20);
	drawWireBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 10.8, 20);
	drawWireBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 10.8, 19);
	drawWireBrick(2, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 10.8, 11);
	drawWireBrick(2, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 8.4, 20);
	drawWireWindow(180);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap20() {
	glPushMatrix();
	glTranslated(20, 12, 11);
	drawWirePlate(4, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 12, 11);
	drawWirePlate(2, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(26, 12, 11);
	drawWirePlate(4, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 12, 20);
	drawWirePlate(4, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 12, 20);
	drawWirePlate(2, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(26, 12, 20);
	drawWirePlate(4, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 8.4, 21);
	drawWireFlatTile(4, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 10.8, 14);
	drawWirePlate(1, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 11.2, 14);
	drawWirePlate(1, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 10.4, 19);
	drawWireRoofTileInverted(1, 270, this->mediumStoneGrey);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap21() {
	glPushMatrix();
	glTranslated(4, 8.4, 3);
	drawWireBrick(8, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 8.4, 9);
	drawWireBrick(8, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 12.4, 11);
	drawWirePlate(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(28, 12.4, 11);
	drawWirePlate(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 12.4, 20);
	drawWirePlate(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(28, 12.4, 20);
	drawWirePlate(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 12, 13);
	drawWireBrick(2, 6, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(28, 12, 13);
	drawWireBrick(2, 6, this->white);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap22() {
	glPushMatrix();
	glTranslated(18, 12, 10);
	drawWireRoofTile(4, 0, this->brightRed);
		glPushMatrix();
		glTranslated(-0.45, -0.4, 0);
		drawWirePlateWithSlide(0, 2, this->mediumStoneGrey);
		glPopMatrix();

		glPushMatrix();
		glTranslated(-0.45, -0.4, 2);
		drawWirePlateWithSlide(0, 2, this->mediumStoneGrey);
		glPopMatrix();
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 12, 10);
	drawWireRoofTile(4, 180, this->brightRed);
		glPushMatrix();
		glTranslated(1, -0.4, 0);
		drawWirePlateWithSlide(180, 2, this->mediumStoneGrey);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, -0.4, 2);
		drawWirePlateWithSlide(180, 2, this->mediumStoneGrey);
		glPopMatrix();
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 12.8, 11);
	drawWirePlate(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 12.8, 11);
	drawWirePlate(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 12.8, 20);
	drawWirePlate(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 12.8, 20);
	drawWirePlate(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 8.4, 3);
	drawWireBrick(1, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 8.4, 3);
	drawWireBrick(1, 8, this->white);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap23() {
	glPushMatrix();
	glTranslated(17.55, 11.6, 14);
	drawWirePlateWithSlide(0, 8, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 12, 14);
	drawWireRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(18, 12, 18);
	drawWireRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(31, 11.6, 14);
	drawWirePlateWithSlide(180, 8, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 12, 14);
	drawWireRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(30, 12, 18);
	drawWireRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 8.4, 1);
	drawWireRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(5, 8.4, 1);
	drawWireRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(9, 8.4, 1);
	drawWireRoofTile(3, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 8.4, 1);
	drawWireRoofTile(3, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 8.4, 11);
	drawWireRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(5, 8.4, 11);
	drawWireRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(9, 8.4, 11);
	drawWireRoofTile(3, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 8.4, 11);
	drawWireRoofTile(3, 90, this->brightRed);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap24() {
	glPushMatrix();
	glTranslated(1, 9.6, 2);
	drawWireRoofTile(3, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 9.6, 2);
	drawWireRoofTile(3, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(7, 9.6, 2);
	drawWireRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 9.6, 2);
	drawWireRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 9.6, 10);
	drawWireRoofTile(3, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 9.6, 10);
	drawWireRoofTile(3, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(7, 9.6, 10);
	drawWireRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 9.6, 10);
	drawWireRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 13.2, 10);
	drawWireRoofTile(2, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 13.2, 12);
	drawWireRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 13.2, 16);
	drawWireRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(19, 13.2, 20);
	drawWireRoofTile(2, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 13.2, 10);
	drawWireRoofTile(2, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 13.2, 12);
	drawWireRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 13.2, 16);
	drawWireRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(29, 13.2, 20);
	drawWireRoofTile(2, 180, this->brightRed);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap25() {
	glPushMatrix();
	glTranslated(2, 9.6, 4);
	drawWireBrick(1, 6, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 9.6, 4);
	drawWireBrick(1, 6, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(5, 9.6, 4);
	drawWireBrick(2, 6, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(9, 9.6, 4);
	drawWireBrick(2, 6, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 13.2, 11);
	drawWireBrick(8, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 13.2, 13);
	drawWireBrick(8, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 13.2, 17);
	drawWireBrick(8, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 13.2, 20);
	drawWireBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 13.2, 20);
	drawWireBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(25, 13.2, 20);
	drawWireRoundBrick(this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 13.2, 20);
	drawWireRoundBrick(this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(26, 13.2, 20);
	drawWireWallCorner(270, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 13.2, 20);
	drawWireWallCorner(0, this->white);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap26() {
	glPushMatrix();
	glTranslated(2, 10.8, 5);
	drawWireBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 10.8, 6);
	drawWirePlate(1, 2, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 11.2, 6);
	drawWirePlate(1, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 10.8, 8);
	drawWireBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(5, 10.8, 5);
	drawWireBrick(2, 4, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(9, 10.8, 5);
	drawWireBrick(2, 4, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 10.8, 5);
	drawWireBrick(1, 4, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 14.4, 11);
	drawWireBrick(6, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 14.4, 13);
	drawWireBrick(6, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 14.4, 17);
	drawWireBrick(6, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 14.4, 20);
	drawWireBrick(6, 1, this->white);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap27() {
	glPushMatrix();
	glTranslated(1.6, 10, 6);
	drawWireAnglePlate(0, this->white);
		glPushMatrix();
		glTranslated(0, 1, 0);
		glRotated(90, 0, 0, 1);
		drawWireRadiatorGrile(0, this->mediumStoneGrey);
		glPopMatrix();

		glPushMatrix();
		glRotated(90, 0, 0, 1);
		drawWireRadiatorGrile(0, this->mediumStoneGrey);
		glPopMatrix();
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 10.8, 3);
	drawWireRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(5, 10.8, 3);
	drawWireRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(9, 10.8, 3);
	drawWireRoofTile(3, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 10.8, 3);
	drawWireRoofTile(3, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 10.8, 9);
	drawWireRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(5, 10.8, 9);
	drawWireRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(9, 10.8, 9);
	drawWireRoofTile(3, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 10.8, 9);
	drawWireRoofTile(3, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 10.8, 9);
	drawWireRoofTile(3, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 14.4, 10);
	drawWireRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 14.4, 14);
	drawWireBrick(2, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 14.4, 16);
	drawWireRoofTile(2, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 14.4, 18);
	drawWireRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(28, 14.4, 10);
	drawWireRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(28, 14.4, 14);
	drawWireRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(28, 14.4, 18);
	drawWireRoofTile(4, 180, this->brightRed);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap28() {
	glPushMatrix();
	glTranslated(2, 12, 6);
	drawWireBrick(6, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(8, 12, 6);
	drawWireBrick(6, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 15.6, 11);
	drawWireBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 15.6, 14);
	drawWireBrick(4, 1, this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 15.6, 17);
	drawWireBrick(4, 1, this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 15.6, 20);
	drawWireBrick(4, 1, this->white);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap29() {
	glPushMatrix();
	glTranslated(1, 12, 4);
	drawWireRoofTile(3, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 12, 4);
	drawWireRoofTile(3, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(7, 12, 4);
	drawWireRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 12, 4);
	drawWireRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 12, 8);
	drawWireRoofTile(3, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 12, 8);
	drawWireRoofTile(3, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(7, 12, 8);
	drawWireRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 12, 8);
	drawWireRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 15.6, 10);
	drawWireRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 15.6, 14);
	drawWireBrick(2, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 15.6, 16);
	drawWireRoofTile(2, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 15.6, 18);
	drawWireRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 15.6, 10);
	drawWireRoofTile(2, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 15.6, 12);
	drawWireRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 15.6, 16);
	drawWireRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(27, 15.6, 20);
	drawWireRoofTile(2, 180, this->brightRed);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap30() {
	glPushMatrix();
	glTranslated(1, 13.2, 5);
	drawWireRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(5, 13.2, 5);
	drawWireRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(9, 13.2, 5);
	drawWireRoofTile(4, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 13.2, 5);
	drawWireRoofTile(2, 270, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 13.2, 7);
	drawWireRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(5, 13.2, 7);
	drawWireRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(9, 13.2, 7);
	drawWireRoofTile(4, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 13.2, 7);
	drawWireRoofTile(2, 90, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 16.8, 11);
	drawWireBrick(2, 8, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 16.8, 14);
	drawWireBrick(2, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 16.8, 19);
	drawWireBrick(2, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 16.8, 10);
	drawWireRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 16.8, 14);
	drawWireRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 16.8, 18);
	drawWireRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(26, 16.8, 10);
	drawWireRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(26, 16.8, 14);
	drawWireRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(26, 16.8, 18);
	drawWireRoofTile(4, 180, this->brightRed);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap31() {
	glPushMatrix();
	glTranslated(12, 14.4, 6);
	drawWireBrick(2, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 15.6, 6);
	drawWirePlate(2, 1, this->mediumStoneGrey);
		glPushMatrix();
		glTranslated(1, 0.4, 0);
		drawWireRoundPlate(this->black);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.8, 0);
		drawWireRoundPlate(this->black);
		glPopMatrix();
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 18, 10);
	drawWireRoofTile(2, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 18, 12);
	drawWireRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 18, 16);
	drawWireRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(23, 18, 20);
	drawWireRoofTile(2, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(25, 18, 10);
	drawWireRoofTile(2, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(25, 18, 12);
	drawWireRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(25, 18, 16);
	drawWireRoofTile(4, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(25, 18, 20);
	drawWireRoofTile(2, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 18, 14);
	drawWireBrick(2, 2, this->white);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap32() {
	glPushMatrix();
	glTranslated(20, 19.2, 14);
	drawWireBrick(2, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 19.2, 10);
	drawWireEndRidgedTile(0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 19.2, 11);
	drawWireRidgedTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 19.2, 15);
	drawWireRidgedTile(2, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 19.2, 17);
	drawWireRidgedTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(24, 19.2, 21);
	drawWireEndRidgedTile(180, this->brightRed);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap33() {
	glPushMatrix();
	glTranslated(20, 20.4, 14);
	drawWireRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 20.8, 14);
	drawWireRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 20.4, 14);
	drawWireRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 20.8, 14);
	drawWireRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 20.4, 15);
	drawWireRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(20, 20.8, 15);
	drawWireRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 20.4, 15);
	drawWireRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 20.8, 15);
	drawWireRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 1.6, 25);
	drawWireBrick(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(16, 0.8, 26);
	drawWireBrick(1, 1, this->white);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap34() {
	glPushMatrix();
	glTranslated(21, 1.6, 26);
	drawWireWallCorner(0, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(22, 1.6, 26);
	drawWireWallCorner(270, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(16, 2, 26);
	drawWireBrick(1, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(17, 0.8, 26);
	drawWireFence(0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(16, 0.8, 22);
	drawWireFence(90);
	glPopMatrix();

	glPushMatrix();
	glTranslated(16, 0.8, 18);
	drawWireFence(90);
	glPopMatrix();

	glPushMatrix();
	glTranslated(16, 0.8, 14);
	drawWireFence(90);
	glPopMatrix();

	glPushMatrix();
	glTranslated(16, 0.8, 10);
	drawWireFence(90);
	glPopMatrix();

	glPushMatrix();
	glTranslated(16, 0.8, 6);
	drawWireFence(90);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap35() {
	glPushMatrix();
	glTranslated(12, 0.4, 19);
	drawWirePlate(2, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 0.4, 20);
	drawWirePlate(2, 4, this->brickYellow);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 0.4, 23);
	drawWirePlate(2, 3, this->reddishBrown);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 0.4, 17);
	drawWireRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 0.4, 18);
	drawWireRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 0.4, 17);
	drawWireRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 0.4, 18);
	drawWireRoundPlate(this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 0.4, 20);
	drawWireRoundBrick(this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 0.4, 20);
	drawWireRoundBrick(this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(21, 2.8, 25);
	drawWireMailBox(0);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap36() {
	glPushMatrix();
	glTranslated(1, 0.8, 17);
	drawWireCornerPlate(0, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(3, 0.8, 17);
	drawWireCornerPlate(270, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 0.4, 18);
	drawWireBrick(4, 1, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 0.4, 19);
	drawWireBrick(1, 4, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(14, 0.4, 19);
	drawWireBrick(1, 4, this->white);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap37() {
	glPushMatrix();
	glTranslated(1, 1.2, 17);
	drawWirePlate(4, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 1.2, 18);
	drawWirePlate(4, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 1.6, 18);
	drawWireBrick(4, 2, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 1.6, 20);
	drawWireBrick(1, 3, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(14, 1.6, 20);
	drawWireBrick(1, 3, this->white);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 0.8, 24);
	drawWireRoundPlate(this->reddishBrown);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 1.2, 24);
	drawWireRoundPlate(this->darkGreen);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap38() {
	glPushMatrix();
	glTranslated(1, 1.6, 17);
	drawWireRoundBrick(this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 1.6, 17);
	drawWireRoundBrick(this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(4, 1.6, 19.5);
	drawWireFlatTile(1, 2, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 1.6, 19.5);
	drawWireFlatTile(1, 2, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 2, 19.5);
	drawWireFlatTile(4, 1, this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 2, 20.5);
	drawWireFlatTile(4, 1, this->black);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 2.8, 18);
	drawWireRoofTile(1, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 2.8, 18);
	drawWireRoofTile(1, 180, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(11, 2.8, 19);
	drawWireRoofTile(4, 0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(13, 2.8, 19);
	drawWireRoofTile(4, 180, this->brightRed);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap39() {
	glPushMatrix();
	glTranslated(1, 2.8, 17);
	drawWirePlate(4, 1, this->mediumStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 4, 18);
	drawWireEndRidgedTile(0, this->brightRed);
	glPopMatrix();

	glPushMatrix();
	glTranslated(12, 4, 19);
	drawWireRidgedTile(4, 0, this->brightRed);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireMap40() {
	glTranslated(0.5, 0.8, 21.5);
	glPushMatrix();
		glTranslated(1, 3.6, 1);

		glPushMatrix();
		glTranslated(0.5, -1.2, 0.5);
		drawWireRoundBrick(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.5, -2.4, 0.5);
		drawWireRoundBrick(this->reddishBrown);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.5, -3.6, 0.5);
		drawWireRoundBrick(this->reddishBrown);
		glPopMatrix();

		drawWirePlate(2, 2, this->darkGreen);
			
		glPushMatrix();
		glTranslated(-1, 0.4, 0);
		drawWireRoofTileInverted(2, 0, this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 0.4, 0);
		drawWireRoofTileInverted(2, 180, this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0, 1.6, -1);
		drawWireBrick(2, 4, this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(-1, 1.6, 0);
		drawWireBrick(1, 2, this->brightYellowishGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(2, 1.6, 0);
		drawWireBrick(1, 2, this->brightYellowishGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(-1, 2.8, 1);
		drawWireRoofTile(1, 0, this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 2.8, 1);
		drawWireRoofTile(1, 90, this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(1, 2.8, 0);
		drawWireRoofTile(1, 180, this->darkGreen);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0, 2.8, -1);
		drawWireRoofTile(1, 270, this->darkGreen);
		glPopMatrix();
	glPopMatrix();
}

void LegoCreatorHouse::drawWireRound(GLdouble height, GLdouble radius) {
	GLdouble pi = 3.14159265;
	GLdouble h  = height;
    GLdouble r  = radius;
    GLdouble k  = 2 * pi / 10;

    for(GLdouble a = 0.0; a < 2 * pi; a += k) {
        glBegin(GL_LINE_LOOP);
        glVertex3d(r * cos(a)  , 0, r * sin(a)  );
        glVertex3d(r * cos(a+k), 0, r * sin(a+k));
        glVertex3d(r * cos(a+k), h, r * sin(a+k));
        glVertex3d(r * cos(a)  , h, r * sin(a)  );
        glEnd();
        
        glBegin(GL_LINE_LOOP);
        glVertex3d(0           , 0, 0           );
        glVertex3d(r * cos(a+k), 0, r * sin(a+k));
        glVertex3d(r * cos(a)  , 0, r * sin(a)  );
        glEnd();
        
        glBegin(GL_LINE_LOOP);
        glVertex3d(0           , h, 0           );
        glVertex3d(r * cos(a)  , h, r * sin(a)  );
        glVertex3d(r * cos(a+k), h, r * sin(a+k));
        glEnd();
    }
}

void LegoCreatorHouse::drawWireBasePlate(GLint width, GLint length, Color color) {
	drawWirePlate(width, length, color);
}

void LegoCreatorHouse::drawWirePlate(GLint width, GLint length, Color color) {
	drawWireCube(width, length, 0.4, color, GL_FALSE);
}

void LegoCreatorHouse::drawWireFlatTile(GLint width, GLint length, Color color) {
	drawWireCube(width, length, 0.4, color, GL_TRUE);
}

void LegoCreatorHouse::drawWireBrick(GLint width, GLint length, Color color) {
	drawWireCube(width, length, 1.2, color, GL_FALSE);
}

void LegoCreatorHouse::drawWireCube(GLdouble width, GLdouble length, GLdouble height, Color color, GLboolean isFlat) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	glColor3d(r, g, b);

	glPushMatrix();
	if(isFlat == GL_FALSE) {
		for(int x = 0; x < width; x++) {
			for(int y = 0; y < length; y++) {
				glPushMatrix();
				glTranslated(0.5 + x, height, 0.5 + y);
				drawWireRound(0.2, 0.3);
				glPopMatrix();
			}
		}
	}
    glTranslated(width / 2, height / 2, length / 2);
    glScaled(width, height, length);
    glutWireCube(1.0);
    glPopMatrix();
}

void LegoCreatorHouse::drawWireCornerPlate(GLint angle, Color color) {
	drawWireCorner(0.4, angle, color);
}

void LegoCreatorHouse::drawWireCornerBrick(GLint angle, Color color) {
	drawWireCorner(1.2, angle, color);
}

void LegoCreatorHouse::drawWireCorner(GLdouble height, GLdouble angle, Color color) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	glColor3d(r, g, b);

    GLdouble vert[12][3] = {
        { 0,      0, 0 }, // 0
        { 2,      0, 0 }, // 1
        { 2,      0, 1 }, // 2
        { 1,      0, 1 }, // 3
        { 1,      0, 2 }, // 4
        { 0,      0, 2 }, // 5
        { 0, height, 2 }, // 6
        { 1, height, 2 }, // 7
        { 1, height, 1 }, // 8
        { 2, height, 1 }, // 9
        { 2, height, 0 }, // 10
        { 0, height, 0 }  // 11
    };
    
    GLint face[8][6] = {
        { 0, 1,  2,  3,  4,  5 }, // 0-1-2-3-4
        { 6, 7,  8,  9, 10, 11 }, // 6-7-8-9-10-11
        { 0, 5,  6, 11, -1, -1 }, // 0-5-6-11
        { 5, 4,  7,  6, -1, -1 }, // 5-4-7-6
        { 4, 3,  8,  7, -1, -1 }, // 4-3-8-7
        { 3, 2,  9,  8, -1, -1 }, // 3-2-9-8
        { 2, 1, 10,  9, -1, -1 }, // 2-1-10-9
        { 1, 0, 11, 10, -1, -1 }  // 1-0-11-10
    };
    
    glPushMatrix();
    if(angle == 90) {
        glTranslated(0, 0, 2);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 180) {
        glTranslated(2, 0, 2);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 270) {
        glTranslated(2, 0, 0);
        glRotated(angle, 0, 1, 0);
    }
    
    glPushMatrix();
    glTranslated(0.5, height, 0.5);
    drawWireRound(0.2, 0.3);
    glPopMatrix();
    
    glPushMatrix();
    glTranslated(1.5, height, 0.5);
    drawWireRound(0.2, 0.3);
    glPopMatrix();
    
    glPushMatrix();
    glTranslated(0.5, height, 1.5);
    drawWireRound(0.2, 0.3);
    glPopMatrix();
    
    for(int i = 0; i < 8; i++) {
        glBegin(GL_LINE_LOOP);
        for(int j = 0; j < 6; j++) {
            GLint v = face[i][j];
            if(v >= 0) {
                GLdouble x = vert[v][0];
                GLdouble y = vert[v][1];
                GLdouble z = vert[v][2];
                glVertex3d(x, y, z);
            }
        }
        glEnd();
    }
    glPopMatrix();
}

void LegoCreatorHouse::drawWireRoundPlate(Color color) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	glColor3d(r, g, b);

	glPushMatrix();
    glTranslated(0.5, 0.0, 0.5);
	drawWireRound(0.2, 0.4);
	glTranslated(0.0, 0.2, 0.0);
	drawWireRound(0.2, 0.5);
	glTranslated(0.0, 0.2, 0.0);
	drawWireRound(0.2, 0.3);
    glPopMatrix();
}

void LegoCreatorHouse::drawWireRoundBrick(Color color) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	glColor3d(r, g, b);

	glPushMatrix();
    glTranslated(0.5, 0.0, 0.5);
	drawWireRound(0.2, 0.4);
	glTranslated(0.0, 0.2, 0.0);
	drawWireRound(1.0, 0.5);
	glTranslated(0.0, 1.0, 0.0);
	drawWireRound(0.2, 0.3);
    glPopMatrix();
}

void LegoCreatorHouse::drawWireRadiatorGrile(GLdouble angle, Color color) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	GLdouble w = 1;
	GLdouble l = 2;
	GLdouble h = 0.4;

	glColor3d(r, g, b);

	if(angle == 90) {
        glTranslated(0, 0, 1);
        glRotated(angle, 0, 1, 0);
    }

	glPushMatrix();
	glTranslated(0.1, h / 2, l / 2);
	glScaled(0.2, h, l);
	glutWireCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(0.5, h - 0.1, l / 2);
	glScaled(0.2, 0.2, l);
	glutWireCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(0.9, h / 2, l / 2);
	glScaled(0.2, h, l);
	glutWireCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(w / 2, (h - 0.2) / 2, 0.1);
	glScaled(w - 0.4, h - 0.2, 0.2);
	glutWireCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(w / 2, (h - 0.2) / 2, l - 0.1);
	glScaled(w - 0.4, h - 0.2, 0.2);
	glutWireCube(1.0);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireAngularBrick(GLdouble angle, Color color) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	glColor3d(r, g, b);

	if(angle == 90) {
        glTranslated(0, 0, 1);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 180) {
        glTranslated(1, 0, 1);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 270) {
        glTranslated(1, 0, 0);
        glRotated(angle, 0, 1, 0);
    }

	glPushMatrix();
	glTranslated(0.5, 0.1, 0.5);
	glScaled(1, 0.2, 1);
	glutWireCube(1.0);
    glPopMatrix();

	glPushMatrix();
	glTranslated(0.6, 0.7, 0.5);
	glScaled(0.8, 1, 1);
	glutWireCube(1.0);
    glPopMatrix();

	glPushMatrix();
	glTranslated(0.5, 1.2, 0.5);
	drawWireRound(0.2, 0.3);
	glPopMatrix();

	glPushMatrix();
	glTranslated(0.2, 0.7, 0.5);
	glRotated(90, 0, 0, 1);
	drawWireRound(0.2, 0.3);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireRoofTileInverted(GLint width, GLdouble angle, Color color) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	glColor3d(r, g, b);
	
	GLdouble z = (GLdouble) width;

    GLdouble vert[10][3] = {
        { 2,   0, z }, // 0
        { 2, 1.2, z }, // 1
        { 1, 1.2, z }, // 2
        { 0, 0.2, z }, // 3
        { 0,   0, z }, // 4
        { 0,   0, 0 }, // 5
        { 0, 0.2, 0 }, // 6
        { 1, 1.2, 0 }, // 7
        { 2, 1.2, 0 }, // 8
        { 2,   0, 0 }  // 9
    };

    GLint face[7][5] = {
        { 4, 0, 1, 2,  3 }, // 4-0-1-2-3
        { 5, 4, 3, 6, -1 }, // 5-4-3-6
        { 9, 5, 6, 7,  8 }, // 9-5-6-7-8
        { 0, 9, 8, 1, -1 }, // 0-9-8-1
        { 7, 2, 1, 8, -1 }, // 7-2-1-8
        { 6, 3, 2, 7, -1 }, // 6-3-2-7
        { 4, 5, 9, 0, -1 }  // 4-5-9-0
    };

    glPushMatrix();
    if(angle == 90) {
        glTranslated(0, 0, 2);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 180) {
        glTranslated(2, 0, z);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 270) {
        glTranslated(z, 0, 0);
        glRotated(angle, 0, 1, 0);
    }

	for(int z = 0; z < width; z++) {
		glPushMatrix();
		glTranslated(1.5, 1.2, 0.5 + z);
		drawWireRound(0.2, 0.3);
		glPopMatrix();
	}

		glPushMatrix();
		glTranslated(0, 1.2, z);
		glRotated(180, 1, 0, 0);
		for(int i = 0; i < 7; i++) {
			glBegin(GL_LINE_LOOP);
			for(int j = 0; j < 5; j++) {
				GLint v = face[i][j];
				if(v >= 0) {
					GLdouble x = vert[v][0];
					GLdouble y = vert[v][1];
					GLdouble z = vert[v][2];
					glVertex3d(x, y, z);
				}
			}
			glEnd();
		}
		glPopMatrix();
    glPopMatrix();
}

void LegoCreatorHouse::drawWireRoofTile(GLint width, GLdouble angle, Color color) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	glColor3d(r, g, b);

	GLdouble z = (GLdouble) width;

    GLdouble vert[10][3] = {
        { 2,   0, z }, // 0
        { 2, 1.2, z }, // 1
        { 1, 1.2, z }, // 2
        { 0, 0.2, z }, // 3
        { 0,   0, z }, // 4
        { 0,   0, 0 }, // 5
        { 0, 0.2, 0 }, // 6
        { 1, 1.2, 0 }, // 7
        { 2, 1.2, 0 }, // 8
        { 2,   0, 0 }  // 9
    };

    GLint face[7][5] = {
        { 4, 0, 1, 2,  3 }, // 4-0-1-2-3
        { 5, 4, 3, 6, -1 }, // 5-4-3-6
        { 9, 5, 6, 7,  8 }, // 9-5-6-7-8
        { 0, 9, 8, 1, -1 }, // 0-9-8-1
        { 7, 2, 1, 8, -1 }, // 7-2-1-8
        { 6, 3, 2, 7, -1 }, // 6-3-2-7
        { 4, 5, 9, 0, -1 }  // 4-5-9-0
    };

    glPushMatrix();
    if(angle == 90) {
        glTranslated(0, 0, 2);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 180) {
        glTranslated(2, 0, z);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 270) {
        glTranslated(z, 0, 0);
        glRotated(angle, 0, 1, 0);
    }

	for(int z = 0; z < width; z++) {
		glPushMatrix();
		glTranslated(1.5, 1.2, 0.5 + z);
		drawWireRound(0.2, 0.3);
		glPopMatrix();
	}

    for(int i = 0; i < 7; i++) {
        glBegin(GL_LINE_LOOP);
        for(int j = 0; j < 5; j++) {
            GLint v = face[i][j];
            if(v >= 0) {
                GLdouble x = vert[v][0];
                GLdouble y = vert[v][1];
                GLdouble z = vert[v][2];
                glVertex3d(x, y, z);
            }
        }
        glEnd();
    }
    glPopMatrix();
}

void LegoCreatorHouse::drawWirePlateWithSlide(GLint angle, GLint length, Color color) {
	glPushMatrix();
	if(angle == 90) {
        glTranslated(0, 0, 1.45);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 180) {
        glTranslated(1.45, 0, length);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 270) {
        glTranslated(length, 0, 0);
        glRotated(angle, 0, 1, 0);
    }
		glPushMatrix();
		glTranslated(0.45, 0, 0);
		drawWirePlate(1, length, color);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.3, 0.2, length / 2);
		glScaled(0.3, 0.1, length);
		glutWireCube(1.0);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.075, 0.2, length / 2);
		glScaled(0.15, 0.4, length);
		glutWireCube(1.0);
		glPopMatrix();
	glPopMatrix();
}

void LegoCreatorHouse::drawWireWallCorner(GLint angle, Color color) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	glColor3d(r, g, b);

	glPushMatrix();
	if(angle == 90) {
        glTranslated(0, 0, 1);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 180) {
        glTranslated(1, 0, 1);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 270) {
        glTranslated(1, 0, 0);
        glRotated(angle, 0, 1, 0);
    }
		glPushMatrix();
		glTranslated(0.5, 0.2, 0.5);
		glScaled(1, 0.4, 1);
		glutWireCube(1.0);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.1, 0.8, 0.5);
		glScaled(0.2, 0.8, 1);
		glutWireCube(1.0);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.6, 0.8, 0.1);
		glScaled(0.8, 0.8, 0.2);
		glutWireCube(1.0);
		glPopMatrix();
	glPopMatrix();
}

void LegoCreatorHouse::drawWireAnglePlate(GLint angle, Color color) {
	glPushMatrix();
	if(angle == 90) {
        glTranslated(0, 0, 1.4);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 180) {
        glTranslated(1.4, 0, 1.4);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 270) {
        glTranslated(2, 0, 0);
        glRotated(angle, 0, 1, 0);
    }

		glPushMatrix();
		glTranslated(0.4, 1.6, 0);
		drawWirePlate(1, 2, color);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.4, 0, 0);
		glRotated(90, 0, 0, 1);
		drawWirePlate(2, 2, color);
		glPopMatrix();
	glPopMatrix();
}

void LegoCreatorHouse::drawWireRidgedTile(GLint width, GLint angle, Color color) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	glColor3d(r, g, b);

	GLint z = width;

    GLdouble vert[10][3] = {
        { 2,   0, z }, // 0
        { 2, 0.2, z }, // 1
        { 1, 1.2, z }, // 2
		{ 0, 0.2, z }, // 3
		{ 0,   0, z }, // 4
		{ 0,   0, 0 }, // 5
		{ 0, 0.2, 0 }, // 6
		{ 1, 1.2, 0 }, // 7
		{ 2, 0.2, 0 }, // 8
		{ 2,   0, 0 }  // 9
    };

    GLint face[7][5] = {
        { 4, 0, 1, 2,  3 }, // 4-0-1-2-3
		{ 5, 4, 3, 6, -1 }, // 5-4-3-6
		{ 9, 5, 6, 7,  8 }, // 9-5-6-7-8
		{ 0, 9, 8, 1, -1 }, // 0-9-8-1
		{ 6, 3, 2, 7, -1 }, // 6-3-2-7
		{ 1, 8, 7, 2, -1 }, // 1-8-7-2
		{ 4, 5, 9, 0, -1 }  // 4-5-9-0
    };

    glPushMatrix();
    if(angle == 90) {
        glTranslated(0, 0, 2);
        glRotated(angle, 0, 1, 0);
    }

    for(int i = 0; i < 7; i++) {
        glBegin(GL_LINE_LOOP);
        for(int j = 0; j < 5; j++) {
            GLint v = face[i][j];
            if(v >= 0) {
                GLdouble x = vert[v][0];
                GLdouble y = vert[v][1];
                GLdouble z = vert[v][2];
                glVertex3d(x, y, z);
            }
        }
        glEnd();
    }
    glPopMatrix();
}

void LegoCreatorHouse::drawWireEndRidgedTile(GLint angle, Color color) {
	GLdouble r = (GLdouble) color.getColorRed()   / 255;
	GLdouble g = (GLdouble) color.getColorGreen() / 255;
	GLdouble b = (GLdouble) color.getColorBlue()  / 255;

	glColor3d(r, g, b);

    GLdouble vert[10][3] = {
        { 2,   0, 1 }, // 0
        { 2, 0.2, 1 }, // 1
        { 1, 1.2, 1 }, // 2
		{ 0, 0.2, 1 }, // 3
		{ 0,   0, 1 }, // 4
		{ 0,   0, 0 }, // 5
		{ 0, 0.2, 0 }, // 6
		{ 2, 0.2, 0 }, // 7
		{ 2,   0, 0 }  // 8
    };

    GLint face[8][5] = {
        { 4, 0, 1,  2,  3 }, // 4-0-1-2-3
		{ 8, 5, 6,  7, -1 }, // 8-5-6-7
		{ 5, 4, 3,  6, -1 }, // 5-4-3-6
		{ 0, 8, 7,  1, -1 }, // 0-8-7-1
		{ 6, 7, 2, -1, -1 }, // 6-7-2
		{ 3, 6, 2, -1, -1 }, // 3-6-2
		{ 7, 1, 2, -1, -1 }, // 7-1-2
		{ 4, 0, 8,  5, -1 }  // 4-0-8-5
    };

    glPushMatrix();
    if(angle == 90) {
        glTranslated(0, 0, 2);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 180) {
        glTranslated(2, 0, 1);
        glRotated(angle, 0, 1, 0);
    } else if(angle == 270) {
        glTranslated(1, 0, 0);
        glRotated(angle, 0, 1, 0);
    }

    for(int i = 0; i < 8; i++) {
        glBegin(GL_LINE_LOOP);
        for(int j = 0; j < 5; j++) {
            GLint v = face[i][j];
            if(v >= 0) {
                GLdouble x = vert[v][0];
                GLdouble y = vert[v][1];
                GLdouble z = vert[v][2];
                glVertex3d(x, y, z);
            }
        }
        glEnd();
    }
	glPopMatrix();
}

void LegoCreatorHouse::drawWireWindow(GLint angle) {
	GLdouble r = (GLdouble) white.getColorRed()   / 255;
	GLdouble g = (GLdouble) white.getColorGreen() / 255;
	GLdouble b = (GLdouble) white.getColorBlue()  / 255;
	
	if(angle == 90) {
		glTranslated(0, 0, 4);
		glRotated(angle, 0, 1, 0);
	} else if(angle == 180) {
		glTranslated(4, 0, 1);
		glRotated(angle, 0, 1, 0);
	} else if(angle == 270) {
		glTranslated(1, 0, 0);
		glRotated(angle, 0, 1, 0);
	}
	
	glPushMatrix();
	glTranslated(0, 3.2, 0);
	drawWirePlate(4, 1, darkStoneGrey);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 0.2, 0.5);
	glScaled(4, 0.4, 1);
	glutWireCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(0.2, 1.8, 0.5);
	glScaled(0.4, 2.8, 1);
	glutWireCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(3.8, 1.8, 0.5);
	glScaled(0.4, 2.8, 1);
	glutWireCube(1.0);
	glPopMatrix();

	glColor3d(r, g, b);

	glTranslated(0.4, 0.4, 0);
	glPushMatrix();
		glPushMatrix();
		glTranslated(0.1, 1.4, 0.1);
		glScaled(0.2, 2.8, 0.2);
		glutWireCube(1.0);
		glPopMatrix();
		
		glPushMatrix();
		glTranslated(1.5, 1.4, 0.1);
		glScaled(0.2, 2.8, 0.2);
		glutWireCube(1.0);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.8, 0.1, 0.1);
		glScaled(1.2, 0.2, 0.2);
		glutWireCube(1.0);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.8, 1.4, 0.1);
		glScaled(1.2, 0.2, 0.2);
		glutWireCube(1.0);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.8, 2.7, 0.1);
		glScaled(1.2, 0.2, 0.2);
		glutWireCube(1.0);
		glPopMatrix();
	glPopMatrix();

	glTranslated(1.6, 0, 0);
	glPushMatrix();
		glPushMatrix();
		glTranslated(0.1, 1.4, 0.1);
		glScaled(0.2, 2.8, 0.2);
		glutWireCube(1.0);
		glPopMatrix();
		
		glPushMatrix();
		glTranslated(1.5, 1.4, 0.1);
		glScaled(0.2, 2.8, 0.2);
		glutWireCube(1.0);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.8, 0.1, 0.1);
		glScaled(1.2, 0.2, 0.2);
		glutWireCube(1.0);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.8, 1.4, 0.1);
		glScaled(1.2, 0.2, 0.2);
		glutWireCube(1.0);
		glPopMatrix();

		glPushMatrix();
		glTranslated(0.8, 2.7, 0.1);
		glScaled(1.2, 0.2, 0.2);
		glutWireCube(1.0);
		glPopMatrix();
	glPopMatrix();
}

void LegoCreatorHouse::drawWireDoor(GLint angle) {
	GLdouble r = (GLdouble) mediumStoneGrey.getColorRed()   / 255;
	GLdouble g = (GLdouble) mediumStoneGrey.getColorGreen() / 255;
	GLdouble b = (GLdouble) mediumStoneGrey.getColorBlue()  / 255;
	
	if(angle == 90) {
		glTranslated(0, 0, 4);
		glRotated(angle, 0, 1, 0);
	} else if(angle == 180) {
		glTranslated(4, 0, 1);
		glRotated(angle, 0, 1, 0);
	} else if(angle == 270) {
		glTranslated(1, 0, 0);
		glRotated(angle, 0, 1, 0);
	}

	glColor3d(r, g, b);

	glPushMatrix();
	glTranslated(0.5, 0, 0.5);
	drawWireRound(0.2, 0.5);
	glPopMatrix();

	glPushMatrix();
	glTranslated(0.2, 3.1, 0.5);
	glScaled(0.4, 5.8, 0.4);
	glutWireCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(3.8, 3.1, 0.5);
	glScaled(0.4, 5.8, 0.4);
	glutWireCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 0.4, 0.5);
	glScaled(3.2, 0.4, 0.4);
	glutWireCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 5.8, 0.5);
	glScaled(3.2, 0.4, 0.4);
	glutWireCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(3.5, 3.1, 0.8);
	glScaled(0.6, 0.6, 0.2);
	glutWireCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(3.5, 3.1, 0.2);
	glScaled(0.6, 0.6, 0.2);
	glutWireCube(1.0);
	glPopMatrix();

	glColor4d(0.89, 0.97, 1, 0.85);

	glPushMatrix();
	glTranslated(2, 3.1, 0.5);
	glScaled(3.2, 5, 0.2);
	glutWireCube(1.0);
	glPopMatrix();
}

void LegoCreatorHouse::drawWireFence(GLint angle) {
	GLdouble r = (GLdouble) black.getColorRed()   / 255;
	GLdouble g = (GLdouble) black.getColorGreen() / 255;
	GLdouble b = (GLdouble) black.getColorBlue()  / 255;

	if(angle == 90) {
		glTranslated(0, 0, 4);
		glRotated(angle, 0, 1, 0);
	}

	glColor3d(r, g, b);

	glPushMatrix();
	glTranslated(2, 0.2, 0.5);
	glScaled(4, 0.4, 1);
	glutWireCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 0.5, 0.5);
	glScaled(4, 0.2, 0.4);
	glutWireCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(2, 2.3, 0.5);
	glScaled(4, 0.2, 0.4);
	glutWireCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(0.1, 1.4, 0.5);
	glScaled(0.2, 1.6, 0.4);
	glutWireCube(1.0);
	glPopMatrix();

	glPushMatrix();
	glTranslated(3.9, 1.4, 0.5);
	glScaled(0.2, 1.6, 0.4);
	glutWireCube(1.0);
	glPopMatrix();

	glTranslated(0.2, 0.6, 0.3);

	for(double x = 0.45; x < 3.6; x += 0.45) {
		glPushMatrix();
		glTranslated(x, 0.8, 0.2);
		glScaled(0.05, 1.6, 0.4);
		glutWireCube(1.0);
		glPopMatrix();
	}
}

void LegoCreatorHouse::drawWireMailBox(GLint angle) {
	GLdouble pi = 3.14159265;
    GLdouble k  = pi / 15;

	GLdouble r = (GLdouble) brightYellow.getColorRed()   / 255;
	GLdouble g = (GLdouble) brightYellow.getColorGreen() / 255;
	GLdouble b = (GLdouble) brightYellow.getColorBlue()  / 255;

	glColor3d(r, g, b);

	if(angle == 90) {
		glTranslated(0, 0, 2);
		glRotated(angle, 0, 1, 0);
	}

	glPushMatrix();
	glTranslated(1, 1, 0.5);
	drawWireRound(0.2, 0.3);
	glPopMatrix();

	glPushMatrix();
	glTranslated(1, 0, 0);
    for(GLdouble a = 0.0; a < pi; a += k) {
        glBegin(GL_LINE_LOOP);
        glVertex3d(cos(a)  , sin(a)  , 0);
        glVertex3d(cos(a+k), sin(a+k), 0);
        glVertex3d(cos(a+k), sin(a+k), 2);
        glVertex3d(cos(a)  , sin(a)  , 2);
        glEnd();

        glBegin(GL_LINE_LOOP);
        glVertex3d(0       , 0       , 0);
        glVertex3d(cos(a+k), sin(a+k), 0);
        glVertex3d(cos(a)  , sin(a)  , 0);
        glEnd();
        
        glBegin(GL_LINE_LOOP);
        glVertex3d(0       , 0       , 2);
        glVertex3d(cos(a)  , sin(a)  , 2);
        glVertex3d(cos(a+k), sin(a+k), 2);
        glEnd();
    }
	glPopMatrix();

    GLdouble vert[8][3] = {
        { 1,   0, 1 }, // 0
        { 1, 0.2, 1 }, // 1
        { 1, 0.6, 0 }, // 2
		{ 1,   0, 0 }, // 3
		{ 0,   0, 0 }, // 4
		{ 0, 0.6, 0 }, // 5
		{ 0, 0.2, 1 }, // 6
		{ 0,   0, 1 }  // 7
    };

    GLint face[6][4] = {
        { 0, 3, 2, 1 }, // 0-3-2-1
		{ 3, 4, 5, 2 }, // 3-4-5-2
		{ 4, 7, 6, 5 }, // 4-7-6-5
		{ 7, 0, 1, 6 }, // 7-0-1-6
		{ 6, 1, 2, 5 }, // 6-1-2-5
		{ 0, 7, 4, 3 }  // 0-7-4-3
    };

	glPushMatrix();
	glTranslated(0.5, 1, 1);
    for(int i = 0; i < 6; i++) {
        glBegin(GL_LINE_LOOP);
        for(int j = 0; j < 4; j++) {
            GLint v = face[i][j];
            if(v >= 0) {
                GLdouble x = vert[v][0];
                GLdouble y = vert[v][1];
                GLdouble z = vert[v][2];
                glVertex3d(x, y, z);
            }
        }
        glEnd();
    }
	glPopMatrix();
}
