#include <GL/glut.h>
#include <matrix2.h>
#include "simulator.h"

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//===================CONSTANTS DEFINITION========================//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
extern int horario;

extern GLint bus_num;
extern GLint branch_num;

extern BRANCH branch[BRANCH_NUM];
extern BUS_DSP bus_dsp[BUS_NUM];
extern BRANCH_DSP branch_dsp[BRANCH_NUM];

//Carregamento Total das Linhas, a cada hora
extern GLfloat carregamento[24];
//Percentagem m�ia do carregamento das linhas, a cada hora
extern GLfloat carregamento_perc[24];
//Percentagem maxima de carregamento (individual) de uma linha, a cada hora
extern GLfloat max_carregamento_perc[24];

extern GLfloat max_demanda_L, max_carregamento, carregamento_perc_lim;

/*=============================================*/
/*  FUNCTION FOR ACTIVE POWER MATRIX HANDLING  */
/*=============================================*/
void simulator(void) { 
    
    //Matriz Unidimensional de Potencia Ativa Total dos Barramentos (Pot = Pgeracao - Pcarga)
    //e matriz B (bus_num X bus_num)
    MAT *B, *Pot_bus, *delta;
    
    MAT *B_inv;
    int i,j;
    
    Pot_bus = m_get(bus_num, 1);
    B = m_get(bus_num, bus_num);
    delta = m_get(bus_num, 1);
    B_inv = m_get(bus_num, bus_num);
    
    /* Initialize the matrix B and Pot_bus with zeros */ 
    m_zero(Pot_bus);
    m_zero(B);
    
    // Builds the Pot_bus matrix */
    for (i=0; i<bus_num; i++){
 Pot_bus->me[i][0] = bus_dsp[i].pot_G[horario] - bus_dsp[i].pot_L[horario];
    }
    
    //    printf("===MATRIX POT_BUS===\n");
    //    m_output(Pot_bus);
    
    // Builds the B matrix
    for (i=0; i<branch_num; i++){
 B->me[branch[i].tap_bus-1][branch[i].z_bus-1] = -(1.0/branch[i].reactance);
 B->me[branch[i].z_bus-1][branch[i].tap_bus-1] = -(1.0/branch[i].reactance);
    }
    
    for (i=0; i<bus_num; i++) {
 for (j=0; j<bus_num; j++) {
     if (i != j) {
  B->me[i][i] += -(B->me[i][j]);
     }
 }
    }
    
    // Approximation made: B[0][0] = 1.0e+6
    B->me[0][0] = 1.0e+6;
    
    //    printf("===MATRIX B===\n");
    //    m_output(B);
    
    //Inverts the B matrix
    m_inverse(B, B_inv);
    
    //    printf("===MATRIX B_inv===\n");
    //    m_output(B_inv);
    
    //Finds the delta matrix by multiplying the inverse of B and Pot
    m_mlt(B_inv, Pot_bus, delta);
    
    //printf("===MATRIX DELTA===\n");
    //m_output(delta);
    
    for(i=0; i<branch_num; i++){
 if(delta->me[branch[i].tap_bus-1][0] > delta->me[branch[i].z_bus-1][0])
     branch_dsp[i].pot[horario] = (delta->me[branch[i].tap_bus-1][0] - delta->me[branch[i].z_bus-1][0])/branch[i].reactance;
 else
     branch_dsp[i].pot[horario] = (delta->me[branch[i].z_bus-1][0] - delta->me[branch[i].tap_bus-1][0])/branch[i].reactance;
    }
    
    carregamento[horario] = 0.0;
    carregamento_perc[horario] = 0.0;
    max_carregamento_perc[horario] = 0.0;
    
    //Forma o vetor com os carregamentos totais das linhas em cada horario (valores absoluto e percentagens)
    for (i=0; i<branch_num; i++){
 if (branch_dsp[i].max_pot != 0.0) 
     //{   if (((branch_dsp[i].pot[horario]/branch_dsp[i].max_pot)*100.0) < 100.0)
     branch_dsp[i].pot_perc[horario] = (branch_dsp[i].pot[horario]/branch_dsp[i].max_pot)*100.0;
 //}
 else
     branch_dsp[i].pot_perc[horario] = 0.0;
 
 carregamento[horario] += branch_dsp[i].pot[horario];
 carregamento_perc[horario] += branch_dsp[i].pot_perc[horario];
 
 if (branch_dsp[i].pot_perc[horario]>max_carregamento_perc[horario]) {
     max_carregamento_perc[horario]=branch_dsp[i].pot_perc[horario];
     
 //printf("||||max = %f, BRANCH %i at %i oclock  -----  %f || %f\n", max_carregamento_perc[horario], i, horario, branch_dsp[i].pot[horario], branch_dsp[i].max_pot);
     
 }
    }
    
    //Calculo do carregamento percentual medio na hora
    carregamento_perc[horario] = carregamento_perc[horario]/branch_num;
    
    //Estabelece a maior dos carregamentos horarios, em valores absolutos e percentagens (para auxiliar na constru�o do grafico)
    max_carregamento = carregamento[0];
    for (i=0; i<24; i++){
 if (carregamento[i]>max_carregamento) max_carregamento=carregamento[i];
    }
    
//        printf("Potencias(MW) nos branches as %i horas:\n", horario);
//        for(i=0; i<branch_num; i++){
//     printf("%f\n", branch_dsp[i].pot_perc[horario]);
//        }
    
    //for (i=0; i<24; i++){
    //  printf("%f\n", max_carregamento_perc[i]);
    //}
    
    M_FREE(B);
    M_FREE(Pot_bus);
    M_FREE(B_inv);
    M_FREE(delta);   
    
    
}
