////////////////////////////////////////////////////////////////////////////
//            Arquivo Cabeçalho para "simulator.c"               //
////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//====================DEFINE SECTION============================//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define BUS_NUM 500
#define BRANCH_NUM 1000

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//==================STRUCTURE SECTION===========================//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
typedef struct branch BRANCH;
typedef struct bus_dsp BUS_DSP;
typedef struct branch_dsp BRANCH_DSP;

struct branch {
    GLint tap_bus;
    GLint z_bus;
    GLint load_flow_area;
    GLint loss_zone;
    GLint circuit;
    GLint type;
    GLfloat resistance;
    GLfloat reactance;
    GLfloat charging;
    GLint MVA_1;
    GLint MVA_2;
    GLint MVA_3;
    GLint control_bus;
    GLint side;
    GLfloat turns_ratio;
    GLfloat angle;
    GLfloat min_tap;
    GLfloat max_tap;
    GLfloat step;
    GLfloat min_voltage;
    GLfloat max_voltage;
    GLfloat color[3];
};

//Dispatch Information for the Buses
struct bus_dsp {
    GLfloat pot_L[24]; // Potência de Carga
    GLfloat pot_G[24]; // Potência de Geração
};

//Dispatch Information for the Branches
struct branch_dsp {
    GLfloat max_pot;
    GLfloat pot[24];
    GLfloat pot_perc[24];
};


//====FUNCTIONS PROTOTYPES====//
//void processMouse3(int button, int state, int x, int y);
//extern void simulator(void);
