/*============================================================================================================*/
/*||==========================================================================================================||*/
/*||==================================          UNICAMP - Universidade Estadual de Campinas         ====================================||*/
/*||==================================    FEEC - Faculdade de Engenharia Eletrica e Computacao     ==================================||*/
/*||==================================          DCA - Departamento de Computacao e Automacao        ===================================||*/
/*||==========================================================================================================||*/
/*||=======================================                       Tese de Mestrado                       =========================================||*/
/*||==========================================================================================================||*/
/*||=======================================             AUTOR: Celio Flores Siqueira Junior              ===================================||*/
/*||========================================                           RA: 022602                         =========================================||*/
/*||==========================================================================================================||*/
/*============================================================================================================*/

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//====================INCLUDE SECTION===========================//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include <GL/glut.h>
#include <glui.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <matrix2.h>
#include <mysql.h>
#include "tese.h"

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//==================AUXILIARY FUNCTIONS==========================//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*==========================*/
/*             TEXT LABELING FUNCTION           */
/*==========================*/
void OutputString ( float x, float y, char *string, void *font )
{
    int length, i;
    
    length = strlen ( string );
    glRasterPos2f ( x, y );
    for (i = 0; i < length; i++ )
	glutBitmapCharacter (font, string[i] );
}

/*===================================*/
/*                VERTICAL TEXT LABELING FUNCTION               */
/*===================================*/
void OutputVerticalString ( float x, float y, float bitmapHeight, char *string, void *font )
{
    int length, i;
    
    length = strlen ( string );
    for (i = 0; i < length; i++ ) {
	glRasterPos2f(x, y-bitmapHeight*i);
	glutBitmapCharacter (font, string[i] );
    }
}

/*=========================================================*/
/*     Plots a circunference(fill=0) or a circle(fill=1) of radius r, centered at co-ordinates (x, y)     */
/*=========================================================*/
void circunference(double r, double x, double y, int fill)
{
    double angle;
    double x1,y1;
    
    if (fill == 0)
	glBegin(GL_LINE_LOOP);
    else
	glBegin(GL_POLYGON);
    for(angle=0;angle<=360.0;angle+=0.5)
    {
	x1=x+r*cos(angle*M_PI/180);
	y1=y+r*sin(angle*M_PI/180);
	glVertex2f(x1,y1);
    }
    glEnd();
}



/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//==================DATABASE READING FUNCTION====================//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Database_Read(){
    
    char *query;
    int i, t, r;
    
    mysql= mysql_init(NULL);
    
    if (! mysql_real_connect(mysql, "localhost", "celiojr", "celiojr", "viscipower", 0, NULL, 0))      /*UNCOMMENT AT LCA*/
	//if (! mysql_real_connect(mysql, "localhost", "", "", "viscipower", 0, NULL, 0))
    {
	printf( "Error connectin ot database: %s\n",mysql_error(mysql));
    }
    else printf("Connected to MySQL...\n");
    
    query="USE viscipower";
    t= mysql_real_query(mysql, query, (unsigned int) strlen(query));
    if (t)
    {
	printf("Error using viscipower database: %s\n",
	       mysql_error(mysql));
    }
    else printf("Query for using viscipower made...\n");    
    
    /////////////////////////BUS DATA SECTION
    query="SELECT * FROM 176_BUS";
    t=mysql_real_query(mysql,query,(unsigned int) strlen(query));
    if (t)
    {
	printf("Error making Bus Data Query: %s\n",
	       mysql_error(mysql));
    }
    else printf("Bus Data Query made...\n");
    
    res=mysql_use_result(mysql);
    
    r=0;
    while ((row=mysql_fetch_row(res))!=NULL) {
	//IEEE Electrical Information 
	bus[r].number=atoi(row[0]);
	for (t=0; t<=strlen(row[1]); t++){
	    bus[r].name[t]=row[1][t];
	}
	bus[r].load_flow_area=atoi(row[2]);
	bus[r].loss_zone = atoi(row[3]);
	bus[r].type = atoi(row[4]);
 bus[r].voltage = atof(row[5]);
 bus[r].angle = atof(row[6]);
 bus[r].load_MW = atof(row[7]);
 bus[r].load_MVAR = atof(row[8]);
 bus[r].gen_MW = atof(row[9]);
 bus[r].gen_MVAR = atof(row[10]);
 bus[r].base_KV = atof(row[11]);
 bus[r].des_volts = atof(row[12]);
 bus[r].max_voltage = atof(row[13]);
 bus[r].min_voltage = atof(row[14]);
 bus[r].conductance = atof(row[15]);
 bus[r].susceptance = atof(row[16]);
 bus[r].remote = atoi(row[17]);
 //Bus Dispatch Information
 t=0;
 for (i=9; i<33; i++){
     bus_dsp[r].pot_L[t] = atof(row[2*i]);
     bus_dsp[r].pot_G[t] = atof(row[(2*i)+1]);
     t++;
 }
 //Bus Graphical Information
 Gbus[r].xi = atof(row[66]);
 Gbus[r].yi = atof(row[67]);
 Gbus[r].xf = atof(row[68]);
 Gbus[r].yf = atof(row[69]);
 Gbus[r].Gen_dir = atoi(row[70]);
 Gbus[r].Gen_x = atof(row[71]);
 Gbus[r].Gen_y = atof(row[72]);
 Gbus[r].Load_dir = atoi(row[73]);
 Gbus[r].Load_x = atof(row[74]);
 Gbus[r].Load_y = atof(row[75]);
 Gbus[r].Suscep_dir = atoi(row[76]);
 Gbus[r].Suscep_x = atof(row[77]);
 Gbus[r].Suscep_y = atof(row[78]);
 r++;
    }
    bus_num = r;
    printf("%i BUSES, QUERY IS OK!\n", bus_num);
    
    /////////////////////////BRANCH DATA SECTION
    query="SELECT * FROM 176_BRANCH";
    t=mysql_real_query(mysql,query,(unsigned int) strlen(query));
    if (t)
    {
 printf("Error making Branch Data Query: %s\n",
        mysql_error(mysql));
    }
    else printf("Branch Data Query made...\n");
    
    res=mysql_use_result(mysql);
    
    r=0;
    while ((row=mysql_fetch_row(res))!=NULL)  {
 branch[r].tap_bus = atoi(row[0]);
 branch[r].z_bus = atoi(row[1]);
 branch[r].load_flow_area=atoi(row[2]);
 branch[r].loss_zone = atoi(row[3]);
 branch[r].circuit = atoi(row[4]);
 branch[r].type = atoi(row[5]);
 branch[r].resistance = atof(row[6]);
 branch[r].reactance = atof(row[7]);
 branch[r].charging = atof(row[8]);
 branch[r].MVA_1 = atoi(row[9]);
 branch[r].MVA_2 = atoi(row[10]);
 branch[r].MVA_3 = atoi(row[11]);
 branch[r].control_bus = atoi(row[12]);
 branch[r].side = atoi(row[13]);
 branch[r].turns_ratio = atof(row[14]);
 branch[r].angle = atof(row[15]);
 branch[r].min_tap = atof(row[16]);
 branch[r].max_tap = atof(row[17]);
 branch[r].step = atof(row[18]);
 branch[r].min_voltage = atof(row[19]);
 branch[r].max_voltage = atof(row[20]);
 //Branch Dispatch Information
 branch_dsp[r].max_pot = atof(row[21]);
 t=0;
	for(i=21; i<45; i++){
	    branch_dsp[r].pot[t] = atof(row[i+1]);
	    t++;
	}
	//Branch Graphical Information
	i=46;
	t=0;
	while (row[i]!=NULL) {
	    Gbranch[r].pts_coords[t] = atof(row[i]);
	    i++;
	    t++;
	}
	Gbranch[r].no_points = (i-46)/2;
	Gbranch[r].center[0] = atof(row[66]);
	Gbranch[r].center[1] = atof(row[67]);
	r++;
    }
    branch_num = r;
    printf("%i BRANCHES, QUERY IS OK!\n", branch_num);
    
    mysql_close(mysql);
    
    //Forma o vetor com as demandas totais de carga em cada horario
    for (i=0; i<timeframe; i++){
	for (t=0; t<bus_num; t++){
	    demanda_L[i] += bus_dsp[t].pot_L[i];
	}
    }
    //Estabelece a maior das demandas horarias (para auxiliar na constru�o do grafico)
    max_demanda_L = demanda_L[0];
    for (i=0; i<timeframe; i++){
	if (demanda_L[i]>max_demanda_L)
	    max_demanda_L=demanda_L[i];
    }
    
    maior_max_pot = branch_dsp[0].max_pot;
    //Forma o vetor com os carregamentos totais das linhas em cada horario (valores absoluto e percentagens)
    for (i=0; i<timeframe; i++){
	for (t=0; t<branch_num; t++){
	    if (branch_dsp[t].max_pot != 0.0) {
		branch_dsp[t].pot_perc[i] = (branch_dsp[t].pot[i]/branch_dsp[t].max_pot)*100.0;
	    }
	    else {
		branch_dsp[t].pot_perc[i] = 0.0;
	    }
	    carregamento[i] += branch_dsp[t].pot[i];
	    carregamento_perc[i] += branch_dsp[t].pot_perc[i];
	    if (branch_dsp[t].pot_perc[i]>max_carregamento_perc[i]) {
		max_carregamento_perc[i]=branch_dsp[t].pot_perc[i];
		//  if (i==0) {
		//      printf("max = %f, BRANCH %i at %i oclock  -----  %f || %f\n", max_carregamento_perc[i], t, i, branch_dsp[t].pot[i], branch_dsp[t].max_pot);
		//  }
	    }
	    if (branch_dsp[t].max_pot > maior_max_pot  ) maior_max_pot = branch_dsp[t].max_pot;
	}
    }
    //Calculo do carregamento percentual medio na hora
    for (i=0; i<timeframe; i++){
	carregamento_perc[i] = carregamento_perc[i]/branch_num;
    }
    //Estabelece a maior dos carregamentos horarios, em valores absolutos e percentagens (para auxiliar na constru�o do grafico)
    max_carregamento = carregamento[0];
    for (i=0; i<timeframe; i++){
	if (carregamento[i]>max_carregamento) max_carregamento=carregamento[i];
    }    
}



/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void start_data(void)
{
    int i, j;
    
    for (i=0; i<bus_num; i++){
	for (j=0; j<24; j++) {
	    
	    if (j==0) {
		//bus_dsp[i].pot_L[j] = 1.0*bus[i].load_MW;
		//bus_dsp[i].pot_G[j] = 1.0*bus[i].gen_MW ;
		bus_dsp[i].pot_L[j] = 0.33*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.37*bus[i].gen_MW ;
		//printf("BUS %i:\n pot_L0 = %f\n pot_G0 = %f\n", i, bus_dsp[i].pot_L[j], bus_dsp[i].pot_G[j]);
	    } 
	    if (j==1) {
		bus_dsp[i].pot_L[j] = 0.4*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.42*bus[i].gen_MW ;
	    } 
	    if (j==2) {
		bus_dsp[i].pot_L[j] = 0.35*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.4*bus[i].gen_MW ;
	    } 
	    if (j==3) {
		bus_dsp[i].pot_L[j] = 0.32*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.37*bus[i].gen_MW ;
	    } 
	    if (j==4) {
		bus_dsp[i].pot_L[j] = 0.33*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.39*bus[i].gen_MW ;
	    } 
	    if (j==5) {
		bus_dsp[i].pot_L[j] = 0.45*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.55*bus[i].gen_MW ;
	    } 
	    if (j==6) {
		bus_dsp[i].pot_L[j] = 0.57*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.65*bus[i].gen_MW ;
	    } 
	    if (j==7) {
		bus_dsp[i].pot_L[j] = 0.60*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.67*bus[i].gen_MW ;
	    } 
	    if (j==8) {
		bus_dsp[i].pot_L[j] = 0.63*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.68*bus[i].gen_MW ;
	    } 
	    if (j==9) {
		bus_dsp[i].pot_L[j] = 0.64*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.68*bus[i].gen_MW ;
	    } 
	    if (j==10) {
		bus_dsp[i].pot_L[j] = 0.68*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.70*bus[i].gen_MW ;
	    } 
	    if (j==11) {
		bus_dsp[i].pot_L[j] = 0.66*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.70*bus[i].gen_MW ;
	    } 
	    if (j==12) {
		bus_dsp[i].pot_L[j] = 0.73*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.75*bus[i].gen_MW ;
	    } 
	    if (j==13) {
		bus_dsp[i].pot_L[j] = 0.75*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.77*bus[i].gen_MW ;
	    } 
	    if (j==14) {
		bus_dsp[i].pot_L[j] = 0.72*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.74*bus[i].gen_MW ;
	    } 
	    if (j==15) {
		bus_dsp[i].pot_L[j] = 0.69*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.72*bus[i].gen_MW ;
	    } 
	    if (j==16) {
		bus_dsp[i].pot_L[j] = 0.65*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.7*bus[i].gen_MW ;
	    } 
	    if (j==17) {
		bus_dsp[i].pot_L[j] = 0.72*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.76*bus[i].gen_MW ;
	    } 
	    if (j==18) {
		bus_dsp[i].pot_L[j] = 0.77*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.79*bus[i].gen_MW ;
	    } 
	    if (j==19) {
		bus_dsp[i].pot_L[j] = 0.84*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.87*bus[i].gen_MW ;
	    } 
	    if (j==20) {
		bus_dsp[i].pot_L[j] = 0.89*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.91*bus[i].gen_MW ;
	    } 
	    if (j==21) {
		bus_dsp[i].pot_L[j] = 0.86*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.87*bus[i].gen_MW ;
	    } 
	    if (j==22) {
		bus_dsp[i].pot_L[j] = 0.75*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.82*bus[i].gen_MW ;
	    } 
	    if (j==23) {
		bus_dsp[i].pot_L[j] = 0.68*bus[i].load_MW;
		bus_dsp[i].pot_G[j] = 0.73*bus[i].gen_MW ;
	    }
	    
	}
    }
    
    bus_dsp[9].pot_G[0] = 425.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 10
    bus_dsp[41].pot_G[0] = -18.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 42
    bus_dsp[88].pot_G[0] = 252.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 89
    
    bus_dsp[86].pot_G[5] = 0.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 87
    bus_dsp[88].pot_G[5] = 350.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 89
    bus_dsp[115].pot_G[5] = -70.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 116
    
    bus_dsp[33].pot_G[7] = 14.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 34
    bus_dsp[61].pot_G[7] = 20.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 62
    bus_dsp[98].pot_G[7] = -39.2; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 99
    
    bus_dsp[99].pot_G[12] = 200.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 100
    bus_dsp[104].pot_G[12] = 10.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 105
    
    bus_dsp[31].pot_G[13] = 34.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 32
    bus_dsp[76].pot_G[13] = 48.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 77
    
    bus_dsp[104].pot_G[18] = 15.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 105
    bus_dsp[103].pot_G[18] = 30.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 104
    bus_dsp[102].pot_G[18] = 5.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 103
    bus_dsp[99].pot_G[18] = 201.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 100
    
    bus_dsp[48].pot_G[20] = 260.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 49
    bus_dsp[26].pot_G[20] = 2.1; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 27
    bus_dsp[35].pot_G[20] = 2.1; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 36
    bus_dsp[79].pot_G[20] = 485.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 80
    
    bus_dsp[30].pot_G[21] = -6.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 31
    bus_dsp[26].pot_G[21] = 1.6; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 27
    bus_dsp[15].pot_G[21] = -50.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 16
    bus_dsp[5].pot_G[21] = 65.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 6
    bus_dsp[99].pot_G[21] = 235.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 100
    
    bus_dsp[9].pot_G[22] = 540.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 10
    bus_dsp[5].pot_G[22] = 7.0; //MUDANÇA DA POTÊNCIA DE GERAÇÃO DO BARRAMENTO 6
    
    
    for (horario=0; horario<24; horario++) simulator();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//===================PLOTING FUNCTIONS==========================//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*=======================*/
/*  PIE_CHART DRAWING FUNCTION  */
/*=======================*/
void pie_chart(GLfloat center_x, GLfloat center_y, GLfloat radius, GLfloat color_1, GLfloat color_2, GLfloat color_3, GLfloat percentage, GLint num_points)
{
    
    int aux;
    GLfloat angle, comp_angle;
    char pcnt[6];  
    GLUquadricObj *qobj;
    
    angle = (percentage/100.0) * 360;
    comp_angle = 360.0 - angle; 
    
    aux = percentage;
    gcvt(aux, 6, pcnt);
    
    glColor3f (color_1, color_2, color_3);
    glTranslatef(center_x, center_y, 0.0);
    qobj = gluNewQuadric();
    gluQuadricDrawStyle(qobj, GLU_SILHOUETTE);
    gluQuadricNormals(qobj, GLU_NONE);
    gluPartialDisk(qobj, 0.0, radius, num_points, 1, 90.0, comp_angle);
    gluQuadricDrawStyle(qobj, GLU_FILL);
    gluPartialDisk(qobj, 0.0, radius, num_points, 1, 90.0, -angle);
    gluDeleteQuadric(qobj);
    glTranslatef(-center_x, -center_y, 0.0);
    glFlush();
    glColor3f (0.0, 0.0, 0.0);
    OutputString(center_x-2.0, center_y-1.0, strcat(pcnt, "%"), GLUT_BITMAP_HELVETICA_10);
    glFlush();
}

/*===============================*/
/*  GENERATOR DRAWING AUXILIARY FUNCTION  */
/*===============================*/
void Plot_Generator(GLint dir, GLfloat x, GLfloat y, char *gen_MW, char *gen_MVAR)
{
    
    GLfloat ctrlpoints[4][3];
    int i;
    GLfloat aux;
    
    glPushMatrix();
    glTranslatef(x, y, 0.0);
    
    switch (dir) {
    case 2: //Direction is equal to 2 (Generator is downwards)
	glRotatef(180.0,0.0,0.0,1.0) ;
	break;
    case 3: //Direction is equal to 3 (Generator is headed right)
	glRotatef(-90.0,0.0,0.0,1.0) ;
	break;
    case 4: //Direction is equal to 4 (Generator is headed left)
	glRotatef(90.0,0.0,0.0,1.0) ;
	break;
    }
    
    //Plot the first line
    glBegin(GL_LINES);
    glVertex2f(0.0, 0.0);
    glVertex2f(0.0, 15.0);
    glEnd();
    
    //Plot the circunference(radius, center_x, center_y)
    circunference(5.5, 0.0, 20.5, 0);
    
    //Plot the ~
    ctrlpoints[0][0] = -4.0;
    ctrlpoints[0][1] = 20.5;
    ctrlpoints[0][2] = 0.0;
    ctrlpoints[1][0] = 0.0;
    ctrlpoints[1][1] = 29.0;
    ctrlpoints[1][2] = 0.0;
    ctrlpoints[2][0] = 0.0;
    ctrlpoints[2][1] = 12.0;
    ctrlpoints[2][2] = 0.0;
    ctrlpoints[3][0] = 4.0;
    ctrlpoints[3][1] = 20.5;
    ctrlpoints[3][2] = 0.0;
    glMap1f(GL_MAP1_VERTEX_3, 0.0, 1.0, 3, 4,&ctrlpoints[0][0]);
    glEnable(GL_MAP1_VERTEX_3);
    glBegin(GL_LINE_STRIP);
    for (i = 0; i <= 30; i++) 
	glEvalCoord1f((GLfloat) i/30.0);
    glEnd();
    
    //Plot the second line
    glBegin(GL_LINES);
    glVertex2f(0.0, 26.0);
    glVertex2f(0.0, 32.0);
    glEnd();
    
    //Plot the ground symbol
    glBegin(GL_LINES);
    glVertex2f(-5.0, 32.0);
    glVertex2f(5.0, 32.0);
    glEnd();
    aux = -6.5;
    for (i=0; i<10.0; i++){
	glBegin(GL_LINES);
	glVertex2f(aux, 34.5);
	glVertex2f(aux+2.0, 32.0);
	glEnd();
	aux++;
    }
    
    //    if (info) {
    // switch (dir) {
    // case 1: //Direction is equal to 1 (Generator is upwards)
    //     OutputString(-150.0/zf, 7.0/zf + zf*3, gen_MW, (void *)fonte1);
    //     OutputString(-150.0/zf, 3.0/zf + zf*3, gen_MVAR, (void *)fonte1);
    //     break;
    // case 2: //Direction is equal to 2 (Generator is downwards)
    //     OutputString(150.0/zf, 3.0/zf, gen_MW, (void *)fonte1);
    //     OutputString(150.0/zf, 7.0/zf, gen_MVAR, (void *)fonte1);
    //     break;
    // case 3: //Direction is equal to 3 (Generator is headed right)
    //     OutputString(100.0/zf, 5.0, gen_MW, (void *)fonte1);
    //     OutputString(150.0/zf, 5.0, gen_MVAR, (void *)fonte1);
    //     break;
    // case 4: //Direction is equal to 4 (Generator is headed left)
    //     OutputString(-100.0/zf, 10.0, gen_MW, (void *)fonte1);
    //     OutputString(-150.0/zf, 10.0, gen_MVAR, (void *)fonte1);
    //     break;
    // }
    //    }
    
    glPopMatrix();
}

/*========================*/
/*  GENERATOR DRAWING FUNCTION  */
/*========================*/
void Plot_Bus_Generator(int i)
{
    int j, aux;
    char gen_MW[9];
    char gen_MVAR[9];
    
    //If Bus has a Generator - Field "type"= 2 or 3 in the Bus structure
    if ((bus[i].type == 2)||(bus[i].type == 3)) {
	aux = bus[i].gen_MW;
	gcvt(aux, 7, gen_MW);
	aux = bus[i].gen_MVAR;
	gcvt(aux, 7, gen_MVAR);
	//Sets 2 digits after the dot
	for (j=0; j<strlen(gen_MW); j++){
	    if (gen_MW[j] == '.')
		gen_MW[j+3] = 0;
	}
	for (j=0; j<strlen(gen_MVAR); j++){
	    if (gen_MVAR[j] == '.')
		gen_MVAR[j+3] = 0;
	}
	strcat(gen_MW, " MW");
	strcat(gen_MVAR, " MVAR");
	Plot_Generator(Gbus[i].Gen_dir, Gbus[i].Gen_x, Gbus[i].Gen_y, gen_MW, gen_MVAR);
    }    
}

/*===========================*/
/*  LOAD DRAWING AUXILIARY FUNCTION  */
/*===========================*/
void Plot_Load(GLint dir, GLfloat x, GLfloat y)
{
    glPushMatrix();
    glTranslatef(x, y, 0.0);
    
    switch (dir) {
    case 2: //Direction is equal to 2 (Load is downwards)
	glRotatef(180.0,0.0,0.0,1.0) ;
	break;
    case 3: //Direction is equal to 3 (Load is headed right)
	glRotatef(-90.0,0.0,0.0,1.0) ;
	break;
    case 4: //Direction is equal to 4 (Load is headed left)
	glRotatef(90.0,0.0,0.0,1.0) ;
	break;
    }
    
    //Plot a straight line
    glBegin(GL_LINES);
    glVertex2f(0.0, 0.0);
    glVertex2f(0.0, 20.0);
    glEnd();
    
    //Plot the "head" of the arrow
    glBegin(GL_POLYGON);
    glVertex2f(0.0, 20.0);
    glVertex2f(-1.5, 14.0);
    glVertex2f(1.5, 14.0);
    glEnd();
    
    glPopMatrix();
    
}

/*===================*/
/*  LOAD DRAWING FUNCTION  */
/*===================*/
void Plot_Bus_Load(int i)
{    
    //If Bus has a Load - Field "load_MW" in the Bus structure
    if (bus[i].load_MW > 0.0) {
	Plot_Load(Gbus[i].Load_dir, Gbus[i].Load_x, Gbus[i].Load_y);
    }
}

/*=================================*/
/*  SUSCEPTANCE DRAWING AUXILIARY FUNCTION  */
/*=================================*/
void Plot_Suscep(GLint dir, GLfloat x, GLfloat y)
{
    glPushMatrix();
    glTranslatef(x, y, 0.0);
    
    switch (dir) {
    case 2: //Direction is equal to 2 (Susceptance is downwards)
	glRotatef(180.0,0.0,0.0,1.0) ;
	break;
    case 3: //Direction is equal to 3 (Susceptance is headed right)
	glRotatef(-90.0,0.0,0.0,1.0) ;
	break;
    case 4: //Direction is equal to 4 (Susceptance is headed left)
	glRotatef(90.0,0.0,0.0,1.0) ;
	break;
    }
    
    //Plot a straight line
    glBegin(GL_LINES);
    glVertex2f(0.0, 0.0);
    glVertex2f(0.0, 20.0);
    glEnd();
    
    //Plot the top symbol of Susceptance
    glBegin(GL_LINE_STRIP);
    glVertex2f(-1.5, 14.0);
    glVertex2f(-1.5, 21.5);
    glVertex2f(1.5, 21.5);
    glVertex2f(1.5, 14.0);
    glEnd();
    
    glPopMatrix();
}

/*==========================*/
/*   SUSCEPTANCE DRAWING FUNCTION   */
/*==========================*/
void Plot_Bus_Suscep(int i)
{
    //If Bus has Susceptance - Field "susceptance" in the Bus structure
    if (bus[i].susceptance > 0.0) {
	Plot_Suscep(Gbus[i].Suscep_dir, Gbus[i].Suscep_x, Gbus[i].Suscep_y);
    }
}

/*======================*/
/*  MAIN BUS DRAWING FUNCTION  */
/*======================*/
void Plot_Bus(int k)
{
    int j;
    
    char number[3];
    
    glLineWidth(3.0*zf);
    glPointSize(2.0*zf);
    glColor3f(bus_color[0], bus_color[1], bus_color[2]);
    
    j = bus[k].number;  
    gcvt(j, 3, number); 
    
    if ((Gbus[k].xi == Gbus[k].xf)&&(Gbus[k].yi == Gbus[k].yf)) {
	glEnable(GL_POINT_SMOOTH);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
	glBegin(GL_POINTS);
	glVertex2f(Gbus[k].xi, Gbus[k].yi);
	glEnd();
	glDisable(GL_POINT_SMOOTH);
    }
    else {
	glBegin(GL_LINES);
	glVertex2f(Gbus[k].xi, Gbus[k].yi);
	glVertex2f(Gbus[k].xf, Gbus[k].yf);
	glEnd();
    }
    
    if (info) {
	glColor3f(text_color[0], text_color[1], text_color[2]);
	OutputString(Gbus[k].xi-60.0/zf, Gbus[k].yi-2, number, (void *)fonte1);
	glColor3f(bus_color[0], bus_color[1], bus_color[2]);
    }
    
    glLineWidth(1.0);
    glPointSize(1.0);
    
} 

/*===============================*/
/*  BUS DRAWING FUNCTION FOR SUBWINDOW 3 */
/*===============================*/
void Plot_Bus1(int k)
{
    int j;
    
    char number[3];
    
    glLineWidth(3.0);
    glPointSize(2.5);
    glColor3f(bus_color[0], bus_color[1], bus_color[2]);
    
    j = bus[k].number;
    gcvt(j, 3, number);
    
    if ((Gbus[k].xi == Gbus[k].xf)&&(Gbus[k].yi == Gbus[k].yf)) {  
	glEnable(GL_POINT_SMOOTH);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
	glBegin(GL_POINTS);
	glVertex2f(Gbus[k].xi, Gbus[k].yi);
	glEnd();
	glDisable(GL_POINT_SMOOTH);
    }
    else {
	glBegin(GL_LINES);
	glVertex2f(Gbus[k].xi, Gbus[k].yi);
	glVertex2f(Gbus[k].xf, Gbus[k].yf);
	glEnd();
    }
    if (info) {
 glColor3f(text_color[0], text_color[1], text_color[2]);
 OutputString(Gbus[k].xi-5.0/zf, Gbus[k].yi-2, number, (void *)fonte1);
 glColor3f(bus_color[0], bus_color[1], bus_color[2]);
    }
    
    glLineWidth(1.0);
    glPointSize(1.0);
    
}

/*=======================================*/
/*                          PLOT_CARREGAMENTO_ARROWS                         */
/*=======================================*/
void Plot_Carregamento_Arrows(void)
{
    int i, j, arrow_num;
    GLfloat dist = 15.0, points_dist = 0.0;
    GLfloat x1, x2, y1, y2;
    
    glColor3f(arrow_color[0], arrow_color[1], arrow_color[2]);
    
    for (i=0; i<branch_num; i++) {
 for (j=0; j<(Gbranch[i].no_points*2)-2; j+=2){
     if (branch[i].type == 0){
  x1 = Gbranch[i].pts_coords[j];
  y1 = Gbranch[i].pts_coords[j+1];
  x2 = Gbranch[i].pts_coords[j+2];
  y2 = Gbranch[i].pts_coords[j+3];
  points_dist += sqrt(pow((x2-x1),2.0) + pow((y2-y1),2.0));
     }
 }
 arrow_num = points_dist/dist;
 points_dist = 0.0;
    }
}

/*=========================*/
/*  MAIN BRANCH DRAWING FUNCTION  */
/*=========================*/
void Branch_Color(int branch_number)
{
    int i, c1=0, c2=0;
    
    if (branch_number==selected_branch) {
 branch[branch_number].color[0] = 0.0;
 branch[branch_number].color[1] = 1.0;
 branch[branch_number].color[2] = 0.0;
    }
    else if (show_interval == 0) {
 for (i=0; i<timeframe; i++) {
     if (branch_dsp[branch_number].pot_perc[i] >= carregamento_overload) {
  branch[branch_number].color[0] = 1.0;
  branch[branch_number].color[1] = 0.0;
  branch[branch_number].color[2] = 0.0;
  break;
     }
     else {
  branch[branch_number].color[0] = 0.0;
  branch[branch_number].color[1] = 0.0;
  branch[branch_number].color[2] = 1.0;
     }
 }
    }
    else {
 branch[branch_number].color[0] = branch_color[0];
 branch[branch_number].color[1] = branch_color[1];
 branch[branch_number].color[2] = branch_color[2];
    }
    
    glColor3f(branch[branch_number].color[0], branch[branch_number].color[1], branch[branch_number].color[2]);
    
}



/*==============================================*/
/*=GETS THE REAL COORDINATES OF THE CURRENT VISIBLE WINDOW=*/
/*==============================================*/
GLfloat* GetVisibleArea(void) {
    
    GLint viewport[4]; //viewport[0]=x ; viewport[1]=y ; viewport[2]=width ; viewport[3]=height
    GLdouble mvmatrix[16], projmatrix[16];
    GLdouble wx, wy, wz; /* returned world x, y, z coords */
    GLdouble wxf, wyf, wzf; /* returned world x, y, z coords */
    GLfloat visible_coords[4]; // visible_coords = (xi_world, yi_world, xf_world, yf_world)
    
    glGetIntegerv (GL_VIEWPORT, viewport);
    glGetDoublev (GL_MODELVIEW_MATRIX, mvmatrix);
    glGetDoublev (GL_PROJECTION_MATRIX, projmatrix);
    
    //gluUnProject((GLdouble) x, (GLdouble) realy, 0.0, mvmatrix, projmatrix, viewport, &wx, &wy, &wz);
    gluUnProject(0.0, 0.0, 0.0, mvmatrix, projmatrix, viewport, &wx, &wy, &wz);
    //printf("The real world coordinates of this window: Pi=(%f, %f) and ", wx, wy);
    
    gluUnProject(viewport[2], viewport[3], 0.0, mvmatrix, projmatrix, viewport, &wxf, &wyf, &wzf);
    //printf("Pf=(%f, %f).\n", wxf, wyf);
    
    visible_coords[0] = ((GLfloat)wx);
    visible_coords[1] = ((GLfloat)wy);
    visible_coords[2] = ((GLfloat)wxf);
    visible_coords[3] = ((GLfloat)wyf);
    
    return visible_coords;// (visible_coords[0], visible_coords[1], visible_coords[2], visible_coords[3]);
}



/*=========================================*/
/*  FUNCTION TO TEST IF FIRST AND LAST ELEMENTS  OF coords  */
/*             ARE WITHIN THE LIMITS ESTABLISHED BY vis_win              */
/*=========================================*/
bool IsWithin (GLfloat *vis_win, GLfloat *coords, GLint no_points) {
    if (
     (
      (  (coords[0] >= vis_win[0])  &&  (coords[1] >= vis_win[1])  )
      && 
      (  (coords[0] <= vis_win[2])  &&  (coords[1] <= vis_win[3])  )
      )
     ||
     (
      (  (coords[2*no_points-2] >= vis_win[0])  &&  (coords[2*no_points-1] >= vis_win[1])  ) 
      && 
      (  (coords[2*no_points-2] <= vis_win[2])  &&  (coords[2*no_points-1] <= vis_win[3])  )
      )
     )
 return TRUE;
    else return FALSE;
}


/*=========================*/
/*  MAIN BRANCH DRAWING FUNCTION  */
/*=========================*/
void Plot_Detail(GLenum mode)
{
    int i, j;
    GLfloat x, y;
    
    /* Plot Branches */
    for (i=0; i<branch_num ; i++) {
 
 if ((branch_dsp[i].pot_perc[horario] > carregamento_overload) && (branch[i].circuit > current_circuit) && (show_interval == 1)) {
     glColor3f(problem_branch_color[0], problem_branch_color[1], problem_branch_color[2]);
     
     circunference(15.0, Gbranch[i].center[0], Gbranch[i].center[1], 1);
     
 }
 
 //if (branch[i].circuit <= current_circuit)
 if  ((branch[i].circuit <= current_circuit) && ( IsWithin(detail_visible_coords, Gbranch[i].pts_coords, Gbranch[i].no_points) ) )
 {
     
     Branch_Color(i);
      
     if ((branch_dsp[i].pot_perc[horario] > carregamento_overload) && (show_interval == 1)) {
  glColor3f(problem_branch_color[0], problem_branch_color[1], problem_branch_color[2]);
  pie_chart(Gbranch[i].center[0], Gbranch[i].center[1], 10.0, problem_branch_color[0], problem_branch_color[1], problem_branch_color[2],(int)branch_dsp[i].pot_perc[horario], 500);  
  glColor3f(problem_branch_color[0], problem_branch_color[1], problem_branch_color[2]);
  
     }
     
     if (!show_interval) {
  if (mode == GL_SELECT) {
      glPushName(i);
      //printf("Branch number %i - BUS %i TO BUS %i\n", i, branch[i].tap_bus, branch[i].z_bus);
  }
     }
     //Normal transmission line
     if (branch[i].type == 0){
  glBegin(GL_LINE_STRIP);
  for (j=0; j<Gbranch[i].no_points*2; j+=2) {
      glVertex2f(Gbranch[i].pts_coords[j], Gbranch[i].pts_coords[j+1]);
  }
  glEnd();
     }
     //It's a transformer!
     else {
  glBegin(GL_LINE_STRIP);
  for (j=0; j<Gbranch[i].no_points*2; j+=2) {
      if (Gbranch[i].pts_coords[j]>0.0) {
   glVertex2f(Gbranch[i].pts_coords[j], Gbranch[i].pts_coords[j+1]);
      }
      else {
   glEnd();
   x = Gbranch[i].pts_coords[j-2];
   y = Gbranch[i].pts_coords[j-1];
   //begins drawing the transformer, according to the direction
   glBegin(GL_LINE_STRIP);
   switch ((int)(Gbranch[i].pts_coords[j])) {
   case -1: //Direction is equal to -1 (Transformer is drawn upwards)
       glVertex2f(x - 6.0, y + 4.0);
       glVertex2f(x - 4.0, y);
       glVertex2f(x - 2.0, y + 4.0);
       glVertex2f(x, y);
       glVertex2f(x + 2.0, y + 4.0);
       glVertex2f(x + 4.0, y);
       glVertex2f(x + 6.0, y + 4.0);
       glEnd();
       glBegin(GL_LINE_STRIP);
       glVertex2f(x - 6.0, y + 6.0);
       glVertex2f(x - 4.0, y + 10.0);
       glVertex2f(x - 2.0, y + 6.0);
       glVertex2f(x, y + 10.0);
       glVertex2f(x + 2.0, y + 6.0);
       glVertex2f(x + 4.0, y + 10.0);
       glVertex2f(x + 6.0, y + 6.0);
       glEnd();
       glBegin(GL_LINE_STRIP);
       glVertex2f(x, y + 10.0);
       break;
   case -2: //Direction is equal to -2 (Transformer is drawn downwards)
       glVertex2f(x - 6.0, y - 4.0);
       glVertex2f(x - 4.0, y);
       glVertex2f(x - 2.0, y - 4.0);
       glVertex2f(x, y);
       glVertex2f(x + 2.0, y - 4.0);
       glVertex2f(x + 4.0, y);
       glVertex2f(x + 6.0, y - 4.0);
       glEnd();
       glBegin(GL_LINE_STRIP);
       glVertex2f(x - 6.0, y - 6.0);
       glVertex2f(x - 4.0, y - 10.0);
       glVertex2f(x - 2.0, y - 6.0);
       glVertex2f(x, y - 10.0);
       glVertex2f(x + 2.0, y - 6.0);
       glVertex2f(x + 4.0, y - 10.0);
       glVertex2f(x + 6.0, y - 6.0);
       glEnd();
       glBegin(GL_LINE_STRIP);
       glVertex2f(x, y - 10.0);
       break;
   case -3: //Direction is equal to -3 (Transformer is drawn towards right)
       glVertex2f(x + 4.0, y + 6.0);
       glVertex2f(x, y + 4.0);
       glVertex2f(x + 4.0, y + 2.0);
       glVertex2f(x, y);
       glVertex2f(x + 4.0, y - 2.0);
       glVertex2f(x, y - 4.0);
       glVertex2f(x + 4.0, y - 6.0);
       glEnd();
       glBegin(GL_LINE_STRIP);
       glVertex2f(x + 6.0, y + 6.0);
       glVertex2f(x + 10.0, y + 4.0);
       glVertex2f(x + 6.0, y + 2.0);
       glVertex2f(x + 10.0, y);
       glVertex2f(x + 6.0, y - 2.0);
       glVertex2f(x + 10.0, y - 4.0);
       glVertex2f(x + 6.0, y - 6.0);
       glEnd();
       glBegin(GL_LINE_STRIP);
       glVertex2f(x + 10.0, y);
       break;
   case -4: //Direction is equal to -4 (Transformer is drawn towards left)
       glVertex2f(x - 4.0, y + 6.0);
       glVertex2f(x, y + 4.0);
       glVertex2f(x - 4.0, y + 2.0);
       glVertex2f(x, y);
       glVertex2f(x - 4.0, y - 2.0);
       glVertex2f(x, y - 4.0);
       glVertex2f(x - 4.0, y - 6.0);
       glEnd();
       glBegin(GL_LINE_STRIP);
       glVertex2f(x - 6.0, y + 6.0);
       glVertex2f(x - 10.0, y + 4.0);
       glVertex2f(x - 6.0, y + 2.0);
       glVertex2f(x - 10.0, y);
       glVertex2f(x - 6.0, y - 2.0);
       glVertex2f(x - 10.0, y - 4.0);
       glVertex2f(x - 6.0, y - 6.0);
       glEnd();
       glBegin(GL_LINE_STRIP);
       glVertex2f(x - 10.0, y);
       break;
   }
      }
  }
  glEnd();
     }
     if (mode == GL_SELECT) {
  glPopName ();
     }
     
     Plot_Bus(branch[i].tap_bus - 1);
     Plot_Bus(branch[i].z_bus - 1);  
     Plot_Bus_Generator(branch[i].tap_bus - 1);
     Plot_Bus_Generator(branch[i].z_bus - 1);
     Plot_Bus_Load(branch[i].tap_bus - 1);
     Plot_Bus_Load(branch[i].z_bus - 1);
     Plot_Bus_Suscep(branch[i].tap_bus - 1);
     Plot_Bus_Suscep(branch[i].z_bus - 1);
    
 }
    }
}



/*=========================*/
/*  MAIN BRANCH DRAWING FUNCTION  */
/*=========================*/
void Plot_Main(GLenum mode)
{
    int i, j;
    GLfloat x, y;
    GLfloat *visible_coords;
    
    glPushMatrix();
    
    visible_coords = GetVisibleArea();
    
    /* Plot Branches */
    for (i=0; i<branch_num ; i++) {
 
 if ((branch_dsp[i].pot_perc[horario] > carregamento_overload) && (branch[i].circuit > current_circuit) && (show_interval == 1)) {
     glColor3f(problem_branch_color[0], problem_branch_color[1], problem_branch_color[2]);
     
     circunference(15.0, Gbranch[i].center[0], Gbranch[i].center[1], 1);
     
 }
 
 if ((branch[i].circuit <= current_circuit) && (
		(((Gbranch[i].pts_coords[0] >= visible_coords[0]) && (Gbranch[i].pts_coords[1] >= visible_coords[1])) &&
		 ((Gbranch[i].pts_coords[0] <= visible_coords[2]) && (Gbranch[i].pts_coords[1] <= visible_coords[3])))
		||
		(((Gbranch[i].pts_coords[2*Gbranch[i].no_points-2] >= visible_coords[0]) && (Gbranch[i].pts_coords[2*Gbranch[i].no_points-1] >= visible_coords[1])) &&
		 ((Gbranch[i].pts_coords[2*Gbranch[i].no_points-2] <= visible_coords[2]) && (Gbranch[i].pts_coords[2*Gbranch[i].no_points-1] <= visible_coords[3])))
		
		)) 
	{     
	    Plot_Bus1(branch[i].tap_bus - 1);
	    Plot_Bus1(branch[i].z_bus - 1);  
	    Plot_Bus_Generator(branch[i].tap_bus - 1);
	    Plot_Bus_Generator(branch[i].z_bus - 1);
	    Plot_Bus_Load(branch[i].tap_bus - 1);
	    Plot_Bus_Load(branch[i].z_bus - 1);
	    Plot_Bus_Suscep(branch[i].tap_bus - 1);
	    Plot_Bus_Suscep(branch[i].z_bus - 1);
	    
	    //Change back to the original branch color
	    glColor3f(branch_color[0], branch_color[1], branch_color[2]);
	    
	    if ((branch_dsp[i].pot_perc[horario] > carregamento_overload) && (show_interval==1)) {
		glColor3f(problem_branch_color[0], problem_branch_color[1], problem_branch_color[2]);
		circunference(15.0, Gbranch[i].center[0], Gbranch[i].center[1], 1);
	    }
	    
	    if (!show_interval) {
		Branch_Color(i);
	    }
	    
	    //Normal transmission line
	    if (branch[i].type == 0){
		glBegin(GL_LINE_STRIP);
		for (j=0; j<Gbranch[i].no_points*2; j+=2) {
		    glVertex2f(Gbranch[i].pts_coords[j], Gbranch[i].pts_coords[j+1]);
		}
		glEnd();
	    }
	    //It's a transformer!
	    else {
		glBegin(GL_LINE_STRIP);
		for (j=0; j<Gbranch[i].no_points*2; j+=2) {
		    if (Gbranch[i].pts_coords[j]>0.0) {
			glVertex2f(Gbranch[i].pts_coords[j], Gbranch[i].pts_coords[j+1]);
		    }
		    else {
			glEnd();
			x = Gbranch[i].pts_coords[j-2];
			y = Gbranch[i].pts_coords[j-1];
			//begins drawing the transformer, according to the direction
			glBegin(GL_LINE_STRIP);
			switch ((int)(Gbranch[i].pts_coords[j])) {
			case -1: //Direction is equal to -1 (Transformer is drawn upwards)
			    glVertex2f(x - 6.0, y + 4.0);
			    glVertex2f(x - 4.0, y);
			    glVertex2f(x - 2.0, y + 4.0);
			    glVertex2f(x, y);
			    glVertex2f(x + 2.0, y + 4.0);
			    glVertex2f(x + 4.0, y);
			    glVertex2f(x + 6.0, y + 4.0);
			    glEnd();
			    glBegin(GL_LINE_STRIP);
			    glVertex2f(x - 6.0, y + 6.0);
			    glVertex2f(x - 4.0, y + 10.0);
			    glVertex2f(x - 2.0, y + 6.0);
			    glVertex2f(x, y + 10.0);
			    glVertex2f(x + 2.0, y + 6.0);
			    glVertex2f(x + 4.0, y + 10.0);
			    glVertex2f(x + 6.0, y + 6.0);
			    glEnd();
			    glBegin(GL_LINE_STRIP);
			    glVertex2f(x, y + 10.0);
			    break;
			case -2: //Direction is equal to -2 (Transformer is drawn downwards)
			    glVertex2f(x - 6.0, y - 4.0);
			    glVertex2f(x - 4.0, y);
			    glVertex2f(x - 2.0, y - 4.0);
			    glVertex2f(x, y);
			    glVertex2f(x + 2.0, y - 4.0);
			    glVertex2f(x + 4.0, y);
			    glVertex2f(x + 6.0, y - 4.0);
			    glEnd();
			    glBegin(GL_LINE_STRIP);
			    glVertex2f(x - 6.0, y - 6.0);
			    glVertex2f(x - 4.0, y - 10.0);
			    glVertex2f(x - 2.0, y - 6.0);
			    glVertex2f(x, y - 10.0);
			    glVertex2f(x + 2.0, y - 6.0);
			    glVertex2f(x + 4.0, y - 10.0);
			    glVertex2f(x + 6.0, y - 6.0);
			    glEnd();
			    glBegin(GL_LINE_STRIP);
			    glVertex2f(x, y - 10.0);
			    break;
			case -3: //Direction is equal to -3 (Transformer is drawn towards right)
			    glVertex2f(x + 4.0, y + 6.0);
			    glVertex2f(x, y + 4.0);
			    glVertex2f(x + 4.0, y + 2.0);
			    glVertex2f(x, y);
			    glVertex2f(x + 4.0, y - 2.0);
			    glVertex2f(x, y - 4.0);
			    glVertex2f(x + 4.0, y - 6.0);
			    glEnd();
			    glBegin(GL_LINE_STRIP);
			    glVertex2f(x + 6.0, y + 6.0);
			    glVertex2f(x + 10.0, y + 4.0);
			    glVertex2f(x + 6.0, y + 2.0);
			    glVertex2f(x + 10.0, y);
			    glVertex2f(x + 6.0, y - 2.0);
			    glVertex2f(x + 10.0, y - 4.0);
			    glVertex2f(x + 6.0, y - 6.0);
			    glEnd();
			    glBegin(GL_LINE_STRIP);
			    glVertex2f(x + 10.0, y);
			    break;
			case -4: //Direction is equal to -4 (Transformer is drawn towards left)
			    glVertex2f(x - 4.0, y + 6.0);
			    glVertex2f(x, y + 4.0);
			    glVertex2f(x - 4.0, y + 2.0);
			    glVertex2f(x, y);
			    glVertex2f(x - 4.0, y - 2.0);
			    glVertex2f(x, y - 4.0);
			    glVertex2f(x - 4.0, y - 6.0);
			    glEnd();
			    glBegin(GL_LINE_STRIP);
			    glVertex2f(x - 6.0, y + 6.0);
			    glVertex2f(x - 10.0, y + 4.0);
			    glVertex2f(x - 6.0, y + 2.0);
			    glVertex2f(x - 10.0, y);
			    glVertex2f(x - 6.0, y - 2.0);
			    glVertex2f(x - 10.0, y - 4.0);
			    glVertex2f(x - 6.0, y - 6.0);
			    glEnd();
			    glBegin(GL_LINE_STRIP);
			    glVertex2f(x - 10.0, y);
			    break;
			}
		    }
		}
		glEnd();
		
	    }  
	}
    }
    glPopMatrix();
}



/*==============================*/
/*  PLOTTING MOUSE LINE FOR SUBWINDOW 1  */
/*==============================*/
void Plot_Mouse_Line1(GLfloat x, GLfloat y, char *demanda){
    
    int i, aux;
    char hour_s[3];
    
    aux = horario;
    gcvt(aux, 3, hour_s);
    //Wipes the dot from the string
    for (i=0; i<strlen(hour_s); i++){
	if (hour_s[i] == '.')
	    hour_s[i] = 0;
    }
    strcat(hour_s, " hs");
    
    if ((x >= shift1)&&(x < shift1 + 25*step1)) {
	glColor4f(1.0, 0.0, 0.0, 0.1);
	glBegin(GL_LINES);
	glVertex2f(x, step1+shift1+max_demanda_L);
	glVertex2f(x, shift1);
	glEnd();
	
	if (info1) {
	    OutputString(0.67*max_demanda_L, 1.31*max_demanda_L, "Demanda = ", (void*)fonte1);
	    OutputString(0.95*max_demanda_L, 1.31*max_demanda_L, demanda, (void*)fonte1);
	    OutputString(0.67*max_demanda_L, 1.23*max_demanda_L, "Horario = ", (void*)fonte1);
	    OutputString(0.95*max_demanda_L, 1.23*max_demanda_L, hour_s, (void*)fonte1);
	}
	glutSwapBuffers();
    }
}

/*==============================*/
/*  PLOTTING MOUSE LINE FOR SUBWINDOW 2  */
/*==============================*/
void Plot_Mouse_Line2(GLfloat x, GLfloat y, char *carregamento, char *carregamento_pico){
    
    int i, aux;
    char hour_s[3];
    
    aux = horario;
    gcvt(aux, 3, hour_s);
    //Wipes the dot from the string
    for (i=0; i<strlen(hour_s); i++){
	if (hour_s[i] == '.')
	    hour_s[i] = 0;
    }
    strcat(hour_s, " hs");
    
    if ((x >= shift2)&&(x < shift2 + 25*step2)) {
	glColor4f(1.0, 0.0, 0.0, 0.1);
	glBegin(GL_LINES);
	glVertex2f(x, step2+shift2+100.0);
	glVertex2f(x, shift2);
	glEnd();
	
	if (info2) {
	    OutputString(0.40*100.0, 1.31*100.0, "Carregamento Medio = ", (void*)fonte1);
	    OutputString(1.05*100.0, 1.31*100.0, carregamento, (void*)fonte1);
	    OutputString(0.05*100.0, 1.31*100.0, "Horario:", (void*)fonte1);
	    OutputString(0.10*100.0, 1.23*100.0, hour_s, (void*)fonte1);
	    OutputString(0.40*100.0, 1.23*100.0, "Carregamento Maximo = ", (void*)fonte1);
	    OutputString(1.05*100.0, 1.23*100.0, carregamento_pico, (void*)fonte1);
	}
	glutSwapBuffers();
    }
}



/*==============================*/
/*  PLOTTING MOUSE LINE FOR SUBWINDOW 2  */
/*==============================*/
void Plot_Mouse_Line_Evolution(GLfloat x) {
    
    int i;
    
    step_ev = branch_dsp[selected_branch].max_pot/timeframe;
    shift_ev = 0.18*branch_dsp[selected_branch].max_pot;
    shift_ev2 = shift_ev;
    
    if ((x >= shift_ev) && (x < shift_ev + 25*step_ev)) {
	glColor4f(1.0, 0.0, 0.0, 0.1);
	glBegin(GL_LINES);
	glVertex2f(x, step_ev+shift_ev2+100.0);
	glVertex2f(x, shift_ev2);
	glEnd();
	
	glutSwapBuffers();
    }
}



/*==========================*/
/*  PLOTING AXES FOR BUS LOAD GRAPH  */
/*==========================*/
void Plot_Axes_L(void)
{
    int i;
    double aux1;
    float bitmapHeight = max_demanda_L/15.0;
    
    char demanda_s[9];
    
    glColor3f(axes_color[0], axes_color[1], axes_color[2]);
    
    for (i=0; i<26; i++){
	glBegin(GL_LINES);
	glVertex2f(i*step1 + shift1, shift1);
	glVertex2f(i*step1 + shift1, 25*step1 + shift1); 
	glEnd();
    }
    for (i=0; i<26; i++){
	glBegin(GL_LINES);
	glVertex2f(shift1,            i*step1 + shift1);
	glVertex2f(25*step1 + shift1, i*step1 + shift1); 
	glEnd();
    }  
    
    aux1 = demanda_L[horario];
    gcvt(aux1, 9, demanda_s);
    //Sets 2 digits after the dot
    for (i=0; i<strlen(demanda_s); i++){
	if (demanda_s[i] == '.')
	    demanda_s[i+3] = 0;
    }
    strcat(demanda_s, " MW");
    
    //Plot the red line and the information
    if (line == 1){
	info1 = 1;
	Plot_Mouse_Line1(shift1 + (horario+1)*step1, demanda_L[horario], demanda_s);
    }
    //or the title only
    else {
	glColor3f(title_color[0],title_color[1], title_color[2]);
	OutputString(0.46*max_demanda_L, 1.26*max_demanda_L, "DEMANDA", GLUT_BITMAP_HELVETICA_18);
    }
    
    //Plot text lables
    glColor3f(title_color[0],title_color[1], title_color[2]);
    OutputVerticalString(0.05*max_demanda_L, max_demanda_L, bitmapHeight, "DEMANDA MW", (void*)fonte2);
    OutputString(0.45*max_demanda_L, 0.05*max_demanda_L, "HORA DO DIA", (void*)fonte2);
}

/*====================*/
/*   PLOTING BUS LOAD GRAPH   */
/*====================*/
void Plot_Graphic_L(void)
{
    int i;
    
    glColor3f(graphic_color[0], graphic_color[1], graphic_color[2]);
    
    glBegin(GL_LINE_STRIP);
    for (i=0; i<timeframe; i++){
	glVertex2f(shift1 + step1*(i+1), shift1 + demanda_L[i]);
    }
    glEnd();
    
    glColor3f(bkg2[0],bkg2[1],bkg2[2]);
    glPointSize(2.0);
    glBegin(GL_POINTS);
    for (i=0; i<timeframe; i++){
	glVertex2f(shift1 + step1*(i+1), shift1 + demanda_L[i]);
    }
    glEnd();
    glPointSize(1.0);
}

/*=============================*/
/*  PLOTING AXES FOR BRANCH LOAD GRAPH  */
/*=============================*/
void Plot_Axes_Carregamento(void)
{
    int i;
    double aux;
    float bitmapHeight = 100.0/15.0;
    
    char carregamento_s[9];
    char carregamento_pico_s[9];
    
    glColor3f(axes_color[0], axes_color[1], axes_color[2]);
    
    for (i=0; i<26; i++){
	glBegin(GL_LINES);
	glVertex2f(i*step2 + shift2, shift2);
	glVertex2f(i*step2 + shift2, 25*step2 + shift2); 
	glEnd();
    }
    for (i=0; i<26; i++){
	glBegin(GL_LINES);
	glVertex2f(shift2,           i*step2 + shift2);
	glVertex2f(25*step2 + shift2, i*step2 + shift2); 
	glEnd();
    }
    
    aux = carregamento_perc[horario];
    gcvt(aux, 9, carregamento_s);
    aux = max_carregamento_perc[horario];
    gcvt(aux, 9, carregamento_pico_s);
    
    //Sets 2 digits after the dot
    for (i=0; i<strlen(carregamento_s); i++){
	if (carregamento_s[i] == '.')
	    carregamento_s[i+3] = 0;
    }
    for (i=0; i<strlen(carregamento_pico_s); i++){
	if (carregamento_pico_s[i] == '.')
	    carregamento_pico_s[i+3] = 0;
    }
    
    strcat(carregamento_s, " %");
    strcat(carregamento_pico_s, " %");
    
    //Plot the red line and the information
    if (line == 1){
	info2 = 1;
	Plot_Mouse_Line2(shift2 + (horario+1)*step2, carregamento_perc[horario], carregamento_s,
			 carregamento_pico_s);
    }
    //or the title only
    else {
	glColor3f(title_color[0],title_color[1], title_color[2]);
	OutputString(0.25*100.0, 1.26*100.0, "CARREGAMENTO", GLUT_BITMAP_HELVETICA_18);
    }
    
    //Plot text labels
    glColor3f(title_color[0],title_color[1], title_color[2]);
    OutputVerticalString(0.05*100.0, 1.1*100.0, bitmapHeight, "CARREGAMENTO MW", (void*)fonte2);
    OutputString(0.45*100.0, 0.05*100.0, "HORA DO DIA", (void*)fonte2);
}

/*======================*/
/*  PLOTING BRANCH LOAD GRAPH  */
/*======================*/
void Plot_Graphic_Carregamento(void)
{
    int i;
    
    glColor3f(graphic_color[0], graphic_color[1], graphic_color[2]);
    
    glBegin(GL_LINE_STRIP);
    for (i=0; i<timeframe; i++){
	glVertex2f(shift2 + step2*(i+1), shift2 + carregamento_perc[i]);
    }
    glEnd();
    
    glColor3f(1.0, 0.0, 0.0);
    glLineWidth(2.0);
    glBegin(GL_LINE_STRIP);
    for (i=0; i<timeframe; i++){
	glVertex2f(shift2 + step2*(i+1), shift2 + max_carregamento_perc[i]);
    }
    glEnd();
    glLineWidth(1.0);
    
    glColor3f(bkg2[0],bkg2[1],bkg2[2]);
    glPointSize(2.0);
    glBegin(GL_POINTS);
    for (i=0; i<timeframe; i++){
	glVertex2f(shift2 + step2*(i+1), shift2 + carregamento_perc[i]);
    }
    glEnd();
    glPointSize(1.0);
    
    glColor3f(bkg2[0],bkg2[1],bkg2[2]);
    glPointSize(2.0);
    glBegin(GL_POINTS);
    for (i=0; i<timeframe; i++){
	glVertex2f(shift2 + step2*(i+1), shift2 + max_carregamento_perc[i]);
    }
    glEnd();
    glPointSize(1.0);
}



/*================================*/
/*  PLOTING AXES FOR BRANCH LOAD EVOLUTION  */
/*================================*/
void Plot_Axes_Evolution(int evolubranch)
{
    int i;
    double aux1;
    float bitmapHeight = branch_dsp[evolubranch].max_pot/15.0;
    
    step_ev = branch_dsp[evolubranch].max_pot/timeframe;
    shift_ev = 0.18*branch_dsp[evolubranch].max_pot;
    shift_ev2 = 1.45*shift_ev;
    
    glColor3f(axes_color[0], axes_color[1], axes_color[2]);
    
    //Plot Vertical lines
    for (i=0; i<26; i++){
	glBegin(GL_LINES);
	glVertex2f(i*step_ev + shift_ev, shift_ev2+5*step_ev);
	glVertex2f(i*step_ev + shift_ev, 24*step_ev + shift_ev2); 
	glEnd();
    }
    //Plot Horizontal lines
    for (i=5; i<25; i++){
	glBegin(GL_LINES);
	glVertex2f(shift_ev, i*step_ev + shift_ev2);
	glVertex2f(25*step_ev + shift_ev, i*step_ev + shift_ev2); 
	glEnd();
    }  
    
    if (line == 1) Plot_Mouse_Line_Evolution(shift_ev + (horario+1)*step_ev);
    
    glColor3f(title_color[0],title_color[1], title_color[2]);
    OutputString(0.44*branch_dsp[evolubranch].max_pot, 1.31*branch_dsp[evolubranch].max_pot, "BRANCH LOAD", GLUT_BITMAP_HELVETICA_18);
    
    //Plot text lables
    glColor3f(title_color[0],title_color[1], title_color[2]);
    OutputVerticalString(0.05*branch_dsp[evolubranch].max_pot, branch_dsp[evolubranch].max_pot, bitmapHeight, "LOAD MW", (void*)fonte2);
    OutputString(0.65*branch_dsp[evolubranch].max_pot, 0.42*branch_dsp[evolubranch].max_pot, "HOUR", (void*)fonte2);
}


/*====================*/
/*   PLOTING BUS LOAD GRAPH   */
/*====================*/
void Plot_Graphic_Evolution(int evolubranch)
{
    int i;
    
    step_ev = branch_dsp[evolubranch].max_pot/timeframe;
    shift_ev = 0.18*branch_dsp[evolubranch].max_pot;
    shift_ev2 = 1.45*shift_ev;
    
    glColor3f(graphic_color[0], graphic_color[1], graphic_color[2]);
    
    glBegin(GL_LINE_STRIP);
    for (i=0; i<timeframe; i++){
	glVertex2f(shift_ev + step_ev*(i+1), shift_ev2 + branch_dsp[evolubranch].pot[i]);
    }
    glEnd();
    
    for (i=0; i<timeframe; i++){
	glColor3f(bkg2[0],bkg2[1],bkg2[2]);
	glPointSize(3.0);
	if ((branch_dsp[evolubranch].pot[i]) >= ((carregamento_overload/100)*branch_dsp[evolubranch].max_pot)) {
	    glColor3f(1.0,0.0,0.0);
	    glPointSize(5.0);
	}
	glBegin(GL_POINTS);
	glVertex2f(shift_ev + step_ev*(i+1), shift_ev2  + branch_dsp[evolubranch].pot[i]);
	glEnd();
	glPointSize(1.0);
    }
}


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//==============IMAGE EXHIBITION FUNCTIONS=======================//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*==================*/
/*  MAIN DISPLAY FUNCTION  */
/*==================*/
void display(void)
{
    /* Clears all pixels  */
    glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    
    /* Loads the identity matrix */
    glLoadIdentity();
    
    detail_visible_coords = GetVisibleArea();
    
    /* Plot Branches */
    Plot_Detail(GL_RENDER);
    
    glutSwapBuffers();
}

/*=========================*/
/*   MAIN WINDOW DISPLAY FUNCTION   */
/*=========================*/
void display0(void)
{
    glutSetWindow(MainWindow);
    glClear(GL_COLOR_BUFFER_BIT);
    init1();
    glutSwapBuffers();
}

/*======================*/
/*  WINDOW 1 DISPLAY FUNCTION  */
/*======================*/
void display1(void)
{
    glutSetWindow(SubWindow1);
    glClear(GL_COLOR_BUFFER_BIT);
    Plot_Axes_L();
    Plot_Graphic_L();
    glutSwapBuffers();
}

/*======================*/
/*  WINDOW 2 DISPLAY FUNCTION  */
/*======================*/
void display2(void)
{
    glutSetWindow(SubWindow2);
    glClear(GL_COLOR_BUFFER_BIT);
    Plot_Axes_Carregamento();
    Plot_Graphic_Carregamento();
    glutSwapBuffers();
}

/*==================*/
/*  MAIN DISPLAY FUNCTION  */
/*==================*/
void display3(void)
{
    /* Clears all pixels  */
    glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    
    /* Loads the identity matrix */
    glLoadIdentity();
    
    /* Plot Branches */
    Plot_Main(GL_RENDER);
    
    glutSwapBuffers();
}



/*=================================*/
/*  BRANCH LOAD EVOLUTION DISPLAY FUNCTION  */
/*================================*/
void display4(void)
{
    glutSetWindow(Evolution);
    glClear(GL_COLOR_BUFFER_BIT);
    Plot_Axes_Evolution(selected_branch);
    Plot_Graphic_Evolution(selected_branch);
    glutSwapBuffers();
}

/*=========================*/
/*   MAIN WINDOW DISPLAY FUNCTION   */
/*=========================*/
void displayMainEvolution(void)
{
    glutSetWindow(Evolution);
    glClear(GL_COLOR_BUFFER_BIT);
    glClearColor (bkg2[0], bkg2[1], bkg2[2], bkg2[3]);
    glFlush();
}



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//==========VISUALIZATION VOLUME ADJUSTMENT FUNCTIONS===============//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*===================*/
/*  MAIN RESHAPE FUNCTION  */
/*===================*/

void reshape_main(int w, int h)
{
    GLUI_Master.auto_set_viewport();
}

void reshape (int w, int h)
{
    /* Defines the output window's dimensions */
    glViewport (0, 0, w, h);
    
    /* Switches to the projection matrix */
    glMatrixMode (GL_PROJECTION);
    /* Loads the identity matrix */
    glLoadIdentity ();
    /* Bidimensional Orthographic Projection */
    gluOrtho2D (center[0]-max_coord[0] / (2*zf), center[0]+max_coord[0] / (2*zf),
		center[1]-max_coord[1] / (2*zf), center[1]+max_coord[1] / (2*zf)) ;
    /* Swithches to the geometrical transformations matrix */
    glMatrixMode (GL_MODELVIEW);
}

/*==========================*/
/*   RESHAPE FUNCTION FOR WINDOW 1   */
/*==========================*/
void reshape1 (int w, int h)
{
    glViewport(0, 0, w, h);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluOrtho2D(0.0, 1.4*max_demanda_L, 0.0, 1.4*max_demanda_L);
    glMatrixMode(GL_MODELVIEW);
}

/*==========================*/
/*  RESHAPE FUNCTION FOR WINDOW 2  */
/*==========================*/
void reshape2 (int w, int h)
{
    glViewport(0, 0, w, h);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluOrtho2D(0.0, 1.4*100.0, 0.0, 1.4*100.0);
    glMatrixMode(GL_MODELVIEW);
}

/*==========================*/
/*   RESHAPE FUNCTION FOR WINDOW 3   */
/*==========================*/
void reshape3 (int w, int h)
{
    
    /* Defines the output window's dimensions */
    glViewport (0, 0, w, h);
    /* Switches to the projection matrix */
    glMatrixMode (GL_PROJECTION);
    /* Loads the identity matrix */
    glLoadIdentity ();
    /* Bidimensional Orthographic Projection */
    gluOrtho2D(0.0, max_coord[0],
	       0.0, max_coord[1]);
    /* Swithches to the geometrical transformations matrix */
    glMatrixMode (GL_MODELVIEW);
}

/*==========================*/
/*   RESHAPE FUNCTION FOR WINDOW 4   */
/*==========================*/
void reshape4 (int w, int h)
{
    glViewport(0, 0, w, h);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluOrtho2D(0.0, 1.4*max_demanda_L, 0.0, 1.4*max_demanda_L);
    glMatrixMode(GL_MODELVIEW);
}



/*==========================*/
/*   RESHAPE FUNCTION FOR WINDOW 4   */
/*==========================*/
void reshape_ev (int w, int h)
{
    glViewport(0, 0, w, h);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluOrtho2D(0.0, 1.4*branch_dsp[selected_branch].max_pot, 0.0, 1.4*branch_dsp[selected_branch].max_pot);    
    glMatrixMode(GL_MODELVIEW);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//=============OPENGL'S INITIALIZATION FUNCTIONS=====================//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*===================*/
/*  INITIALIZATION FUNCTION  */
/*===================*/
void init(void)
{
    /* Sets the background color */
    glClearColor (bkg1[0], bkg1[1], bkg1[2], bkg1[3]);
    
    step1 = max_demanda_L/timeframe;
    shift1 = 0.15*max_demanda_L;
    
    step2 = 100.0/timeframe;
    shift2 = 0.15*100.0;    
    
    center[0] = max_coord[0]/2.0;
    center[1] = max_coord[1]/2.0;
    
}

/*====================*/
/*  INITIALIZATION FUNCTION 1  */
/*====================*/
void init1(void)
{
    glClearColor (bkg2[0], bkg2[1], bkg2[2], bkg2[3]);
    principal = 1;
}


void changeSize2(int w1, int h1)
{
    float ratio;
    // Prevent a divide by zero, when window is too short
    // (you can't make a window of zero width).
    ratio = 1.0f * w1 / h1;
    // Reset the coordinate system before modifying
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    
    // Set the viewport to be the entire window
    glViewport(0, 0, w1, h1);
    
    // Set the clipping volume
    gluPerspective(45,ratio,0.1,1000);
    glMatrixMode(GL_MODELVIEW);
}


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//===============EVENT CONTROL FUNCTIONS=========================//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void control_sim( int control )
{
    switch ( control ) {
    case 0:
	//printf("bus %i\n", sim_bus);
	old_gen = bus_dsp[sim_bus-1].pot_G[horario];
	sim_gen = old_gen;
	//printf("Generates %f at %i o'clock\n", old_gen, horario); 
	break;
    case 1:
	bus_dsp[sim_bus-1].pot_G[horario] = sim_gen;
	//printf("Now bus %i generates %f at %i o'clock\n", sim_bus, sim_gen, horario);
	break;
    case 2: 
	sim_state = 0;
	principal = 1;
	glui_sim->hide();
	glutSetWindow(SimWindow);
	glutHideWindow();
	glutSetWindow(MainWindow);
	break;
    case 3:
	simulator();
	break;
    }  
    
    glui_sim->sync_live();
    glutPostWindowRedisplay(SubWindow1);
    glutPostWindowRedisplay(SubWindow2);
    glutPostWindowRedisplay(SubWindow3);
    glutPostRedisplay();
}


/*========================*/
/*          GLUI CONTROL CALLBACK          */
/*========================*/
void control_cb( int control )
{
    switch ( control ) {
    case 0:
	zf = 1.0;
	center[0] = max_coord[0]/2.0;
	center[1] = max_coord[1]/2.0;
	info = 0;
	checkbox->set_int_val(0);
	principal = 1;
	selected_branch = -1;
	glui_detail->hide();
	glutSetWindow(DetailWindow);
	glutHideWindow();
	glutSetWindow(MainWindow);
	glutShowWindow();
	glui_main->show();
	main_circuit_list->set_int_val(current_circuit);
    case 2:
	line = 1;
	break;
    case 3:
	glui_evolution->hide();
	glutSetWindow(Evolution);
	glutHideWindow();
	//glutDestroyWindow ( Evolution );
	glutSetWindow(DetailWindow);
	break;
    case 4:
	if (animation == 0) animation =1;
	else {
	    animation = 0;
	    show_interval = 0;
	    line = 0;
	    horario = -1;
	}
	if (animation == 1) {
	    GLUI_Master.set_glutIdleFunc( idle3 );
	    show_interval = 1;
	    horario = 0;
	    line = 1;
	}
	else
	    GLUI_Master.set_glutIdleFunc( myGlutIdle );
	break;
    case 5:
	if (!sim_state) {
	    sim_state = 1;
	    glutInitWindowSize (260, 132);
	    glutInitWindowPosition (20, windH*0.915);
	    SimWindow = glutCreateWindow ("Simulation");
	    glutDisplayFunc(display0);
	    
	    GLUI_Master.set_glutIdleFunc( NULL );
	    
	    glui_sim = GLUI_Master.create_glui_subwindow ( SimWindow );
	    
	    glui_sim->set_main_gfx_window( SimWindow );
	    
	    /*** Add invisible panel to hold rest of controls ***/
	    GLUI_Panel *painel = glui_sim->add_panel( "", GLUI_PANEL_NONE );
	    
	    GLUI_Panel *painel_sim = glui_sim->add_panel_to_panel( painel, "" );
	    
	    GLUI_Spinner *sim_bus_spinner = glui_sim->add_spinner_to_panel (painel_sim, "Bus:", GLUI_SPINNER_INT, &sim_bus, 0, control_sim);
	    sim_bus_spinner->set_int_limits( 1, bus_num, GLUI_LIMIT_WRAP);
	    sim_bus_spinner->set_speed(0.05);
	    sim_bus_spinner->set_int_val(sim_bus);
	    
	    sim_gen = old_gen;
	    
	    GLUI_Spinner *sim_gen_spinner = glui_sim->add_spinner_to_panel (painel_sim, "Bus Generation:", GLUI_SPINNER_FLOAT, &sim_gen, 1, control_sim);
	    sim_gen_spinner->set_float_limits( -500.00, 1000.00, GLUI_LIMIT_WRAP);
	    sim_gen_spinner->set_speed(0.05);
	    sim_gen_spinner->set_float_val(sim_gen);
	    
	    // Buttons
	    GLUI_Panel *sim_buttons_panel = glui_sim->add_panel_to_panel( painel, "" );
	    GLUI_Button *cancel_sim_button = glui_sim->add_button_to_panel (sim_buttons_panel, "Undo", 1, control_show);
	    glui_main->add_column_to_panel(sim_buttons_panel, false);
	    GLUI_Button *sim_button = glui_sim->add_button_to_panel (sim_buttons_panel, "Simulate", 3, control_sim);
	}
	else {
	    glutSetWindow(SimWindow);
	    glutShowWindow();
	    glui_sim->show();
	}
	control_sim(0);
	break;
    }
    glutPostWindowRedisplay(MainWindow);
    glutPostWindowRedisplay(SubWindow1);
    glutPostWindowRedisplay(SubWindow2);
    glutPostWindowRedisplay(SubWindow3);
    if (principal == 0) {
	reshape(windW, windH);
    }
    glutPostRedisplay();
}



/*========================*/
/*          GLUI CONTROL CALLBACK          */
/*========================*/
void control_show (int control){
    
    switch ( control ) {
	
    case 0:
	if (show_interval) {
	    horario = 0;
	    line = 1;
	    spinner->enable();
	    sim_panel->enable();
	    simula->enable();
	    anim_panel->disable();
	    anima->disable();
	    if (DetailWindow) {
		sim_panel_detail->enable();
		simula_detail->enable();
	    }
	}
	else {
	    horario = -1;
	    line = 0;
	    spinner->disable();
	    anima->enable();
	    anim_panel->enable();
	    simula->disable();
	    sim_panel->disable();
	    if (DetailWindow) {
		simula_detail->disable();
		sim_panel_detail->disable();
	    }
	}
	
	break;    
    case 1: //Undo button
	//glui_sim->hide();
	//glutSetWindow(SimWindow);
	//glutHideWindow();
	//glutSetWindow(MainWindow);
	//principal = 1;
	start_data();
	horario = spinner->get_int_val();
	break;
    }
    
    glui_main->sync_live();    
    glutPostWindowRedisplay(SubWindow1);
    glutPostWindowRedisplay(SubWindow2);
    glutPostWindowRedisplay(SubWindow3);
    glutPostWindowRedisplay(MainWindow);    
    glutPostRedisplay();
}



/*==================================*/
/*   CONTROL KEYBOARD EVENTS ON MAIN WINDOW   */
/*==================================*/
void keyboard(unsigned char key, int x, int y)
{
    GLfloat geracao;
    
    switch (key) {
	/* Exit when <ESC> is pressed */
    case 27:
	glui_detail->hide();
	glutSetWindow(DetailWindow);
	glutHideWindow();
	glutSetWindow(MainWindow);
	glutShowWindow();
	glui_main->show();
	zf = 1.0;
	center[0] = max_coord[0]/2.0;
	center[1] = max_coord[1]/2.0;
	info = 0;
	principal = 1;
	break;
	/* Incremento de 5 graus no angulo de rotacao em torno de x */
    case '=':
	zf += zf_inc;
	if (zf>zf_max)
	    zf = zf_max;
	zoom->set_float_val(zf);
	break;
	/* Decreases the scale factor by 2 units */
    case '-':
	zf -= zf_inc;
	if (zf<zf_min)
	    zf = zf_min;
	zoom->set_float_val(zf);
	break;
	/* Displays or not the information onscreen */
    case 'i':
	if (info==1) info=0; else info=1;
	checkbox->set_int_val(info);
	break;
	
    }
    reshape(windW, windH);
    /* Forcar a atualizacao da area de desenho */
    glutPostRedisplay(); 
    glutSetWindow(SubWindow3);
    reshape3(windW*0.7, windH*0.7);
}

/*=================================*/
/*  CONTROL KEYBOARD EVENTS ON SUBWINDOW 1  */
/*=================================*/
void keyboard1(unsigned char key, int x, int y)
{
    switch (key) {
	/* Exit when <ESC> is pressed */
    case 27:
	exit(0);
	break;
    case 'l':
	if (line==1) line=0; else line=1;
	break;
    }
    glutPostWindowRedisplay(SubWindow1);
}

/*==================================*/
/*   CONTROL KEYBOARD EVENTS ON SUBWINDOW 2   */
/*==================================*/
void keyboard2(unsigned char key, int x, int y)
{
    switch (key) {
	/* Exit when <ESC> is pressed */
    case 27:
	exit(0);
	break;
    case 'l':
	if (line==1) line=0; else line=1;
	break;
    }
}

/*==================================*/
/*   CONTROL KEYBOARD EVENTS ON SUBWINDOW 3   */
/*==================================*/
void keyboard3(unsigned char key, int x, int y)
{
    int n;
    char c;
    
    c = 'y';
    
    switch (key) {
	/* Exit when <ESC> is pressed */
    case 27:
	exit(0);
	break;
    }
}

/*========================================*/
/*  FUNCTION FOR CONTROL OF SPECIAL KEYBOARD EVENTS  */
/*========================================*/
static void SpecialKey(int key, int x, int y)
{
    switch (key) {
    case GLUT_KEY_UP:
	center[1] += 20.0;
	break;
    case GLUT_KEY_DOWN:
	center[1] -= 20.0;
	break;
    case GLUT_KEY_LEFT:
	center[0] -= 20.0;
	break;
    case GLUT_KEY_RIGHT:
	center[0] += 20.0;
	break;
    case GLUT_KEY_END:
	center[0] = max_coord[0]/2.0;
	center[1] = max_coord[1]/2.0;
	break;
	/* Restores the scene to its original state */
    case GLUT_KEY_HOME:
	zf = 1.0; 
	center[0] = max_coord[0]/2.0;
	center[1] = max_coord[1]/2.0;
	break;
    }
    zoom->set_float_val(zf);
    detail_translation->set_x(center[0]);
    detail_translation->set_y(center[1]);
    reshape(windW, windH);
    glutPostRedisplay();
}

/*=====================================================*/
/*  FUNCTION FOR CONTROL OF SPECIAL KEYBOARD EVENTS FOR SUBWINDOW 1  */
/*=====================================================*/
static void SpecialKey1(int key, int x, int y)
{
    
    switch (key) {
    case GLUT_KEY_RIGHT:
	if (show_interval) {
	    line = 1;
	    horario++;
	    if (horario>23) horario = 0;
	}
	break;
    case GLUT_KEY_LEFT:
	if (show_interval) {
	    line = 1;
	    horario--;
	    if (horario<0) horario = 23;
	}
	break;
    case GLUT_KEY_HOME:
	line = 0;
	break;
    }
    glutPostWindowRedisplay(SubWindow1);
    glutPostWindowRedisplay(SubWindow2);
    glutPostWindowRedisplay(SubWindow3);
    glutPostWindowRedisplay(MainWindow);
}

/*=====================================================*/
/*  FUNCTION FOR CONTROL OF SPECIAL KEYBOARD EVENTS FOR SUBWINDOW 3  */
/*=====================================================*/
static void SpecialKey3(int key, int x, int y)
{
    
    switch (key) {
    case GLUT_KEY_UP:
	center[1] -= 20.0;
	break;
    case GLUT_KEY_DOWN:
	center[1] += 20.0;
	break;
    case GLUT_KEY_LEFT:
	center[0] += 20.0;
	break;
    case GLUT_KEY_RIGHT:
	center[0] -= 20.0;
	break;
    case GLUT_KEY_END:
	center[0] = max_coord[0]/2.0;
	center[1] = max_coord[1]/2.0;
	break;
	/* Restores the scene to its original state */
    case GLUT_KEY_HOME:
	zf = 1.0; 
	center[0] = max_coord[0]/2.0;
	center[1] = max_coord[1]/2.0;
	break;
    }
    reshape(windW*0.7, windH*0.7);
    glutPostWindowRedisplay(SubWindow3);
}



/*====================================*/
/*  processHits prints out the contents of the selection array.   */
/*====================================*/
void processHits (GLint hits, GLuint buffer[])
{
    unsigned int i, j;
    GLuint names, *ptr;
    char tmp[15], branch_name_txt[15], tap_z_bus_txt[20], branch_load_txt[15];
    char *aux;
    
    printf ("hits = %d\n", hits);
    ptr = (GLuint *) buffer;
    if (hits == 1) {
	for (i = 0; i < hits; i++) { /*  for each hit  */
	    names = *ptr;
	    //printf (" number of names for this hit = %d\n", names);
	    ptr++;
	    //printf(" z1 is %g;", (float) *ptr/0x7fffffff);
	    ptr++;
	    //printf(" z2 is %g\n", (float) *ptr/0x7fffffff);
	    ptr++;
	    if (names > 1) {
		for (j = 0; j < names; j++) { /*  for each name */
		    selected_branch = (int) *ptr;
		    ptr++;
		}
		printf ("   Hit Branch %i ", selected_branch);
		printf("-- goes from bus %i to %i\n", branch[selected_branch].tap_bus, branch[selected_branch].z_bus);
		
		if (branch_dsp[selected_branch].max_pot > 0.0) {
		    /////////////////////////////////////////////////////////////////////////
		    //Open the Evolution Window for the selected branch
		    glutInitWindowSize (0.3*windW +25, windH*0.7/2.0 + 90);
		    glutInitWindowPosition (800, 130);
		    Evolution = glutCreateWindow ("Branch Load Evolution");
		    
		    /* Sets the background color */
		    glClearColor (bkg1[0], bkg1[1], bkg1[2], bkg1[3]);
		    
		    /* Defines the event handlers */
		    GLUI_Master.set_glutReshapeFunc(reshape_ev);  /* when the window's dimensions are modified */
		    glutDisplayFunc(display4);  /* when the drawing area is modified */
		    glutMouseFunc(processMouse_ev);
		    
		    GLUI_Master.set_glutIdleFunc( NULL );
		    
		    glui_evolution = GLUI_Master.create_glui_subwindow ( Evolution, GLUI_SUBWINDOW_BOTTOM );
		    
		    glui_evolution->set_main_gfx_window( Evolution );
		    
		    /*** Add invisible panel to hold rest of controls ***/
		    GLUI_Panel *panel1 = glui_evolution->add_panel( "", GLUI_PANEL_NONE );
		    
		    gcvt(selected_branch, 4, tmp);
		    aux = "BRANCH: ";
		    for (i=0; i<=strlen(aux); i++)
			branch_name_txt[i] = aux[i];
		    strcat(branch_name_txt, tmp);
		    
		    gcvt(branch[selected_branch].tap_bus, 4, tmp);
		    aux = "From ";
		    for (i=0; i<=strlen(aux); i++)
			tap_z_bus_txt[i] = aux[i];
		    strcat(tap_z_bus_txt, tmp);
		    gcvt(branch[selected_branch].z_bus, 4, tmp);
		    strcat(tap_z_bus_txt, " to ");
		    strcat(tap_z_bus_txt, tmp);
		    
		    gcvt(branch_dsp[selected_branch].pot[horario], 7, tmp);
		    aux = "LOAD: ";
		    for (i=0; i<=strlen(aux); i++)
			branch_load_txt[i] = aux[i];
		    strcat(branch_load_txt, tmp);
		    strcat(branch_load_txt, " MW");
		    
		    glui_branch_name_txt = glui_evolution->add_statictext_to_panel(panel1, branch_name_txt);
		    glui_tap_z_bus_txt = glui_evolution->add_statictext_to_panel(panel1, tap_z_bus_txt);
		    
		    glui_evolution->add_separator_to_panel(panel1);
		    
		    glui_branch_load_txt = glui_evolution->add_statictext_to_panel(panel1, branch_load_txt);
		    
		    /**** Panel to hold Simulation Controls ****/
		    glui_evolution->add_column_to_panel(panel1, true); 
		    
		    hour_spinner_ev = glui_evolution->add_spinner_to_panel(panel1, "Hour", GLUI_SPINNER_INT, &horario, 2, control_cb);
		    hour_spinner_ev->set_int_limits(0, 23);
		    hour_spinner_ev->set_int_val(horario);
		    
		    glui_evolution->add_statictext_to_panel(panel1, "");
		    GLUI_Button *close_evol = glui_evolution->add_button_to_panel( panel1, "Close", 0, (GLUI_Update_CB)exit);
		    
		    glui_evolution->sync_live();
		    
		    GLUI_Master.auto_set_viewport();
		    
		    GLUI_Master.sync_live_all();
		}
	    }
	}
    }
}



/*==================*/
/*  MAIN MOUSE FUNCTION   */
/*==================*/
void processMouse(int button, int state, int x, int y) {
    
    GLint viewport[4];
    GLdouble mvmatrix[16], projmatrix[16];
    GLint realy; /* OpenGL y coordinate position */
    GLdouble wx, wy, wz, wxi, wyi, wzi, wxf, wyf, wzf; /* returned world x, y, z coords */
    GLuint selectBuf [BUFSIZE];
    GLint hits;    
    
    int specialKey;
    
    principal = 0;
    
    glGetIntegerv (GL_VIEWPORT, viewport);
    glGetDoublev (GL_MODELVIEW_MATRIX, mvmatrix);
    glGetDoublev (GL_PROJECTION_MATRIX, projmatrix);
    
    specialKey = glutGetModifiers();
    
    /* viewport[3] is height of window in pixels */
    realy = viewport[3] - (GLint) y - 1;
    
    gluUnProject((GLdouble) x, (GLdouble) realy, 0.0, mvmatrix, projmatrix, viewport, &wx, &wy, &wz);   
    
    detail_visible_coords = GetVisibleArea();
    
    // if a mouse button is pressed along with the shift key then
    if ((state == GLUT_DOWN)&&(specialKey == GLUT_ACTIVE_SHIFT)) {
	// if it is the right mouse button, it decrements the zoom factor and set the viewpoint to current mouse coordinates
	if (button == GLUT_RIGHT_BUTTON){
	    zf -= zf_inc;
	    if (zf < zf_min)
		zf = zf_min;
	    center[0] = wx;
	    center[1] = wy;  
	}
	
	// if it is the left mouse button, the branch timeframe details window is shown
	else if (button == GLUT_LEFT_BUTTON) {
	    
	    glSelectBuffer (BUFSIZE, selectBuf);
	    
	    (void) glRenderMode (GL_SELECT);
	    
	    glInitNames();
	    glPushName(0);
	    
	    glMatrixMode (GL_PROJECTION);
	    glPushMatrix ();
	    glLoadIdentity ();
	    
	    /*  create 5x5 pixel picking region near cursor location */
	    gluPickMatrix ((GLdouble) x, (GLdouble) realy, 5.0, 5.0, viewport);
	    /* Bidimensional Orthographic Projection */
	    gluOrtho2D (center[0]-max_coord[0] / (2*zf), center[0]+max_coord[0] / (2*zf),
			center[1]-max_coord[1] / (2*zf), center[1]+max_coord[1] / (2*zf));
	    
	    Plot_Detail (GL_SELECT);
	    
	    glMatrixMode(GL_PROJECTION);
	    glPopMatrix ();
	    glutSwapBuffers();
	    
	    hits = glRenderMode(GL_RENDER);
	    processHits (hits, selectBuf);
	}
    }
    else if (state == GLUT_DOWN)     {
	// increments the zoom factor and set the viewpoint to current mouse coordinates
	if (button == GLUT_RIGHT_BUTTON) {
	    zf += zf_inc;      
	    if (zf > zf_max)
		zf = zf_max;
	}
	center[0] = wx;
	center[1] = wy;  
    }
    
    zoom->set_float_val(zf);
    detail_translation->set_x(center[0]);
    detail_translation->set_y(center[1]);
    
    reshape(windW, windH);
    
    glutPostRedisplay();
    
}

/*========================*/
/*  MOUSE FUNCTION FOR WINDOW 1  */
/*========================*/
void processMouse1(int button, int state, int x, int y) {
    
    GLint viewport[4];
    GLdouble mvmatrix[16], projmatrix[16];
    GLint realy; /* OpenGL y coordinate position */
    GLdouble wx, wy, wz; /* returned world x, y, z coords */
    int aux;
    
    char demanda_s[9];
    char hour_s[3];
    
    principal = 1;
    
    glGetIntegerv (GL_VIEWPORT, viewport);
    glGetDoublev (GL_MODELVIEW_MATRIX, mvmatrix);
    glGetDoublev (GL_PROJECTION_MATRIX, projmatrix);
    
    /* viewport[3] is height of window in pixels */
    realy = viewport[3] - (GLint) y - 1;
    
    gluUnProject((GLdouble) x, (GLdouble) realy, 0.0, mvmatrix, projmatrix, viewport, &wx, &wy, &wz);
    
    //Calculates the demand and puts it on a string
    aux = wy - shift1;
    gcvt(aux, 7, demanda_s);
    strcat(demanda_s, " MW");
    
    //Calculates the hour and puts it on a string
    aux = (wx - shift1 - step1)/step1;
    gcvt(aux, 3, hour_s);
    strcat(hour_s, " hs");
    
    //Plot the values on the screen
    if ((state==GLUT_DOWN) && (show_interval)) {
	if (button==GLUT_LEFT_BUTTON){
	    line = 1;
	    horario = (wx-shift1-step1)/step1;
	    if (horario<0) horario=0;
	    if (horario>23) horario=23;
	}
	else{
	    line = 0;
	}
	spinner->set_int_val(horario);
	reshape1(0.3*windW-border*1.5, windH*0.7/2.0-border*1.5);
	glutPostWindowRedisplay(SubWindow1);
	glutPostWindowRedisplay(SubWindow2);
	glutPostWindowRedisplay(SubWindow3);
	glutPostWindowRedisplay(MainWindow);
    }
}

/*========================*/
/*  MOUSE FUNCTION FOR WINDOW 2  */
/*========================*/
void processMouse2(int button, int state, int x, int y) {
    
    GLint viewport[4];
    GLdouble mvmatrix[16], projmatrix[16];
    GLint realy; /* OpenGL y coordinate position */
    GLdouble wx, wy, wz; /* returned world x, y, z coords */
    int aux;
    
    char carregamento_s[9];
    char hour_s[3];
    
    principal = 1;
    
    glGetIntegerv (GL_VIEWPORT, viewport);
    glGetDoublev (GL_MODELVIEW_MATRIX, mvmatrix);
    glGetDoublev (GL_PROJECTION_MATRIX, projmatrix);
    
    /* viewport[3] is height of window in pixels */
    realy = viewport[3] - (GLint) y - 1;
    
    gluUnProject((GLdouble) x, (GLdouble) realy, 0.0, mvmatrix, projmatrix, viewport, &wx, &wy, &wz);
    
    //Calculates the demand and puts it on a string
    aux = wy - shift2;
    gcvt(aux, 7, carregamento_s);
    strcat(carregamento_s, " MW");
    
    //Calculates the hour and puts it on a string
    aux = (wx - shift2 - step2)/step1;
    gcvt(aux, 3, hour_s);
    strcat(hour_s, " hs");
    
    //Plot the values on the screen
    if ((state==GLUT_DOWN) && (show_interval)){
	if (button==GLUT_LEFT_BUTTON){
	    line = 1;
	    horario = (wx-shift2-step2)/step2;
	    if (horario<0) horario=0;
	    if (horario>23) horario=23;
	}
	else{
	    line = 0;
	}
	spinner->set_int_val(horario);
	reshape2(0.3*windW-border*1.5, windH*0.7/2.0-border*1.5);
	glutPostWindowRedisplay(SubWindow1);
	glutPostWindowRedisplay(SubWindow2);
	glutPostWindowRedisplay(SubWindow3);
	glutPostWindowRedisplay(MainWindow);
    }
}

/*========================*/
/*  MOUSE FUNCTION FOR WINDOW 3  */
/*========================*/
void processMouse3(int button, int state, int x, int y) {
    
    GLint viewport[4];
    GLdouble mvmatrix[16], projmatrix[16];
    GLint realy; /* OpenGL y coordinate position */
    GLdouble wx, wy, wz; /* returned world x, y, z coords */
    
    int specialKey, i;
    
    glutSetWindow(SubWindow3);
    
    glGetIntegerv (GL_VIEWPORT, viewport);
    glGetDoublev (GL_MODELVIEW_MATRIX, mvmatrix);
    glGetDoublev (GL_PROJECTION_MATRIX, projmatrix);
    
    specialKey = glutGetModifiers();
    
    /* viewport[3] is height of window in pixels */
    realy = viewport[3] - (GLint) y - 1;
    
    gluUnProject((GLdouble) x, (GLdouble) realy, 0.0, mvmatrix, projmatrix, viewport, &wx, &wy, &wz);
    
    // if the left mouse button is pressed, the Detail Window will be opened
    if ((state == GLUT_DOWN) && (button == GLUT_LEFT_BUTTON)) {
	center[0] = wx;
	center[1] = wy;
	principal = 0;
	
	if (detail_state==0){
	    zf *= 2.0;
	    detail_state = 1;
	    glutInitWindowSize (windW, windH);
	    glutInitWindowPosition (100,100);
	    DetailWindow = glutCreateWindow (detail_title);
	    /* Initializes the graphical attributes */
	    init();
	    /* Defines the event handlers */
	    GLUI_Master.set_glutReshapeFunc(reshape);  /* when the window's dimensions are modified */
	    GLUI_Master.set_glutKeyboardFunc(keyboard); /* when a key is pressed */
	    GLUI_Master.set_glutSpecialFunc(SpecialKey);
	    GLUI_Master.set_glutMouseFunc(processMouse);
	    glutDisplayFunc(display);  /* when the drawing area is modified */
	    
	    GLUI_Master.set_glutIdleFunc( NULL );
	    
	    glui_detail = GLUI_Master.create_glui_subwindow ( DetailWindow, GLUI_SUBWINDOW_BOTTOM );
	    
	    glui_detail->set_main_gfx_window( DetailWindow );
	    
	    /*** Add invisible panel to hold rest of controls ***/
	    GLUI_Panel *panel1 = glui_detail->add_panel( "", GLUI_PANEL_NONE );
	    
	    detail_panel = glui_detail->add_panel_to_panel( panel1, "" );
	    detail_panel->set_h(230);
	    
	    /***** Control for showing information *****/
	    checkbox = glui_detail->add_checkbox_to_panel( detail_panel, "Show Info", &info, 1, control_cb );
	    
	    glui_detail->add_column_to_panel( panel1, false);
	    
	    for (i=0; i<4; i++) glui_detail->add_column_to_panel(panel1, false);
	    
	    /***** Navigation Control *****/
	    detail_translation = glui_detail->add_translation_to_panel( panel1, "Navigation", GLUI_TRANSLATION_XY, &center[0], 3, control_cb );
	    detail_translation->set_x(wx);
	    detail_translation->set_y(wy);
	    
	    glui_detail->add_column_to_panel( panel1, false);
	    
	    GLUI_Panel *panel3 = glui_detail->add_panel_to_panel( panel1, "");
	    
	    zoom = glui_detail->add_spinner_to_panel( panel3, "Zoom:", GLUI_SPINNER_FLOAT, &zf, 4, control_cb);
	    zoom->set_float_limits(zf_min, zf_max);
	    zoom->set_float_val(zf);
	    
	    glui_detail->add_column_to_panel( panel3, true);
	    
	    detail_circuit_list = glui_detail->add_listbox_to_panel ( panel3, "Voltage Level:", &current_circuit, 6, control_cb );
	    detail_circuit_list->add_item( 1, "138 KV");
	    detail_circuit_list->add_item( 2, " 69 KV");
	    detail_circuit_list->add_item( 3, " 11 KV");
	    
	    /**** Panel to hold Simulation Controls ****/
	    for (i=0; i<3; i++) glui_detail->add_column_to_panel(panel1, false);
	    /**** Panel to hold Simulation Controls ****/
	    sim_panel_detail = glui_detail->add_panel_to_panel( panel1, "" );
	    /****** Simulate button *****/
	    simula_detail = glui_detail->add_button_to_panel( sim_panel_detail, "Simulate", 5, control_cb );
	    simula_detail->disable();
	    if (show_interval==1) {
		simula_detail->enable();
	    }
	    for (i=0; i<4; i++) glui_detail->add_column_to_panel(panel1, false);
	    
	    /****** A 'close' button *****/
	    glui_main->add_statictext_to_panel(panel1, "");
	    glui_main->add_statictext_to_panel(panel1, "");
	    glui_main->add_statictext_to_panel(panel1, "");
	    GLUI_Button *close = glui_detail->add_button_to_panel( panel1, "Close", 0, control_cb );
	    
	    GLUI_Master.auto_set_viewport();
	    
	    GLUI_Master.sync_live_all();
	}
	else {
	    zf = 2.0;
	    glui_detail->show();
	    glutSetWindow(DetailWindow);
	    glutShowWindow();
	    reshape(windW, windH);
	    glutPostWindowRedisplay(DetailWindow);
	}
	if (principal == 1){
	    reshape3(windW*0.7, windH*0.7);
	    glutPostWindowRedisplay(SubWindow3);
	}
	else { 
	    glutSetWindow(DetailWindow);
	    reshape(windW, windH);
	    glutPostWindowRedisplay(DetailWindow);
	    
	}
	glutPostRedisplay();
    }
    
}

/*========================*/
/*  MOUSE FUNCTION FOR WINDOW 1  */
/*========================*/
void processMouse_ev(int button, int state, int x, int y) {
    
    GLint viewport[4];
    GLdouble mvmatrix[16], projmatrix[16];
    GLint realy; /* OpenGL y coordinate position */
    GLdouble wx, wy, wz; /* returned world x, y, z coords */
    int aux, i;
    
    char tmp[15], branch_load_txt[15];
    char *aux_str;
    
    glGetIntegerv (GL_VIEWPORT, viewport);
    glGetDoublev (GL_MODELVIEW_MATRIX, mvmatrix);
    glGetDoublev (GL_PROJECTION_MATRIX, projmatrix);
    
    step_ev = branch_dsp[selected_branch].max_pot/timeframe;
    shift_ev = 0.18*branch_dsp[selected_branch].max_pot;
    shift_ev2 = 1.45*shift_ev;
    
    /* viewport[3] is height of window in pixels */
    realy = viewport[3] - (GLint) y - 1;
    
    gluUnProject((GLdouble) x, (GLdouble) realy, 0.0, mvmatrix, projmatrix, viewport, &wx, &wy, &wz);
    
    //Plot the values on the screen
    if (state==GLUT_DOWN) {
	if (button==GLUT_LEFT_BUTTON){
	    line = 1;
	    horario = (wx-shift_ev-step_ev)/step_ev;
	    if (horario<0) horario=0;
	    if (horario>23) horario=23;
	    //Plot the mouse line
	    Plot_Mouse_Line_Evolution (wx);
	}
	else {
	    line = 0;
	}
	
	gcvt(branch_dsp[selected_branch].pot[horario], 7, tmp);
	aux_str = "LOAD: ";
	for (i=0; i<=strlen(aux_str); i++)
	    branch_load_txt[i] = aux_str[i];
	strcat(branch_load_txt, tmp);
	strcat(branch_load_txt, " MW");
	
	hour_spinner_ev->set_int_val(horario);
	glui_branch_load_txt->set_name(branch_load_txt);
	glutPostWindowRedisplay(Evolution);
	glutPostRedisplay();
    }
}


/*=========================*/
/*  MOTION FUNCTION FOR WINDOW 2  */
/*=========================*/
void processMotion2(int x, int y) {
    
    int aux;
    GLint viewport[4];
    GLdouble mvmatrix[16], projmatrix[16];
    GLint realy; /* OpenGL y coordinate position */
    GLdouble wx, wy, wz; /* returned world x, y, z coords */
    
    char carregamento_s[9];
    char carregamento_pico_s[9];
    char hour_s[3];
    
    if (show_interval) {
	
	glGetIntegerv (GL_VIEWPORT, viewport);
	glGetDoublev (GL_MODELVIEW_MATRIX, mvmatrix);
	glGetDoublev (GL_PROJECTION_MATRIX, projmatrix);
	
	/* viewport[3] is height of window in pixels */
	realy = viewport[3] - (GLint) y - 1;
	
	gluUnProject((GLdouble) x, (GLdouble) realy, 0.0, mvmatrix, projmatrix, viewport, &wx, &wy, &wz);
	
	//Calculates the demand and puts it on a string
	aux = wy - shift2;
	gcvt(aux, 7, carregamento_s);
	strcat(carregamento_s, " %");
	
	aux = max_carregamento_perc[horario];
	gcvt(aux, 9, carregamento_pico_s);
	strcat(carregamento_pico_s, " %");
	
	//Calculates the hour and puts it on a string
	aux = (wx - shift2 - step2)/step2;
	gcvt(aux, 3, hour_s);
	strcat(hour_s, " hs");
	
	//Plot the mouse line
	info2 = 0;
	Plot_Mouse_Line2(wx, wy, carregamento_s, carregamento_pico_s);
	
	//glutPostRedisplay();
	glutPostWindowRedisplay(SubWindow2);
	glutSetWindow(SubWindow1);
	//processMotion1(x, y);
	glutSetWindow(SubWindow2);
    }
}


/*=========================*/
/*  MOTION FUNCTION FOR WINDOW 1  */
/*=========================*/
void processMotion1(int x, int y) {
    
    GLint viewport[4];
    GLdouble mvmatrix[16], projmatrix[16];
    GLint realy; /* OpenGL y coordinate position */
    GLdouble wx, wy, wz; /* returned world x, y, z coords */
    int aux;
    
    char demanda_s[9];
    char hour_s[3];
    
    if (show_interval) {
	
	glGetIntegerv (GL_VIEWPORT, viewport);
	glGetDoublev (GL_MODELVIEW_MATRIX, mvmatrix);
	glGetDoublev (GL_PROJECTION_MATRIX, projmatrix);
	
	/* viewport[3] is height of window in pixels */
	realy = viewport[3] - (GLint) y - 1;
	
	gluUnProject((GLdouble) x, (GLdouble) realy, 0.0, mvmatrix, projmatrix, viewport, &wx, &wy, &wz);
	
	//Calculates the demand and puts it on a string
	aux = wy - shift1;
	gcvt(aux, 7, demanda_s);
	strcat(demanda_s, " MW");
	
	//Calculates the hour and puts it on a string
	aux = (wx - shift1 - step1)/step1;
	gcvt(aux, 3, hour_s);
	strcat(hour_s, " hs");
	
	//Plot the mouse line
	info1 = 0;
	Plot_Mouse_Line1(wx, wy, demanda_s);
	
	//glutPostRedisplay();
	glutPostWindowRedisplay(SubWindow1);
	glutSetWindow(SubWindow2);
	processMotion2(x, y);
	glutSetWindow(SubWindow1);
    }
}



/*=========================*/
/*  MOTION FUNCTION FOR WINDOW 1  */
/*=========================*/
void processMotionEvolution(int x, int y) {
    
    GLint viewport[4];
    GLdouble mvmatrix[16], projmatrix[16];
    GLint realy; /* OpenGL y coordinate position */
    GLdouble wx, wy, wz; /* returned world x, y, z coords */
    int aux;
    
    glGetIntegerv (GL_VIEWPORT, viewport);
    glGetDoublev (GL_MODELVIEW_MATRIX, mvmatrix);
    glGetDoublev (GL_PROJECTION_MATRIX, projmatrix);
    
    /* viewport[3] is height of window in pixels */
    realy = viewport[3] - (GLint) y - 1;
    
    gluUnProject((GLdouble) x, (GLdouble) realy, 0.0, mvmatrix, projmatrix, viewport, &wx, &wy, &wz);
    
    //Plot the mouse line
    Plot_Mouse_Line_Evolution (wx);
    
    glutPostWindowRedisplay(Evolution);
    
}



/*=================================*/
/*                            GLUT'S IDLE FUNCTION                        */
/*=================================*/
void myGlutIdle(void)
{
    glutSetWindow(MainWindow);
    glutPostRedisplay();
}



/*=================================*/
/*                    IDLE FUNCTION FOR ANIMATION              */
/*=================================*/
void idle3(void)
{
    horario++;
    if (horario>23) horario = 0;
    //glutTimerFunc(2000, NULL, 0);
    sleep(1);
    glutPostWindowRedisplay(SubWindow1);
    glutPostWindowRedisplay(SubWindow2);
    glutPostWindowRedisplay(SubWindow3);
}



/*=================================*/
/*                     PROGRAM'S MAIN FUNCTION                   */
/*=================================*/
int main(int argc, char** argv)
{
    int i;
    
    Database_Read(); //Database Reading Function
    
    start_data();
    
    horario=-1;
    
    main_title = "176 Bus Test Case Archive - MAIN WINDOW";
    detail_title = "176 Bus Test Case Archive - DETAIL WINDOW";
    
    /* glut library initialization */
    glutInit(&argc, argv);
    
    /* Sets exhibition mode */
    glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGBA);
    
    /* Defines the window's dimensions */
    glutInitWindowSize (windW, windH*0.831); //(windW, windH*1.105)
    
    /* Defines the window's position */
    glutInitWindowPosition (20, 20);
    
    /* Creates the main window with the set parameters */
    MainWindow = glutCreateWindow (main_title);
    /* Initializes the graphical attributes */
    init1();
    /* Defines the event handlers */
    glutDisplayFunc(display0);  /* when the drawing area is modified */
    GLUI_Master.set_glutReshapeFunc(reshape_main);  /* when the window's dimensions are modified */
    GLUI_Master.set_glutKeyboardFunc(keyboard); /* when a key is pressed */
    
    SubWindow1 = glutCreateSubWindow(MainWindow, border, border, 0.3*windW-border*1.5, windH*0.7/2.0-border*1.5);
    init();
    /* Defines the event handlers */
    glutReshapeFunc(reshape1);  /* when the window's dimensions are modified */
    glutKeyboardFunc(keyboard1); /* when a key is pressed */
    glutSpecialFunc(SpecialKey1);
    glutMouseFunc(processMouse1);
    glutPassiveMotionFunc(processMotion1);
    glutDisplayFunc(display1);
    
    SubWindow2 = glutCreateSubWindow(MainWindow, border, (windH*0.7+border)/2, 0.3*windW-border*1.5, windH*0.7/2.0-border*1.5);
    init();
    /* Defines the event handlers */
    glutReshapeFunc(reshape2);  /* when the window's dimensions are modified */
    glutKeyboardFunc(keyboard2); /* when a key is pressed */
    glutSpecialFunc(SpecialKey1);
    glutMouseFunc(processMouse2);
    glutPassiveMotionFunc(processMotion2);
    glutDisplayFunc(display2);    
    
    
    SubWindow3 = glutCreateSubWindow(MainWindow, windW*0.3+border*0.5, border, windW*0.7-border*1.5, windH*0.7-border*2.0); //(MainWindow, border, border, windW-border*2.0, windH-border*2.0)
    init();
    /* Defines the event handlers */
    glutReshapeFunc(reshape);  /* when the window's dimensions are modified */
    glutKeyboardFunc(keyboard3); /* when a key is pressed */
    glutMouseFunc(processMouse3);
    glutDisplayFunc(display3);
    
    
    /*****************************************/
    /*                          Here's the GLUI code                         */
    /****************************************/
    /**** We register the idle callback with GLUI, *not* with GLUT ****/
    GLUI_Master.set_glutIdleFunc( myGlutIdle );
    
    glui_main = GLUI_Master.create_glui_subwindow ( MainWindow, GLUI_SUBWINDOW_BOTTOM );
    
    /**** Link windows to GLUI, and register idle callback ******/
    glui_main->set_main_gfx_window( MainWindow );
    
    /*** Add invisible panel to hold rest of controls ***/
    panel1 = glui_main->add_panel( "", GLUI_PANEL_NONE );
    panel1->set_alignment(GLUI_ALIGN_CENTER);
    panel1->set_w(windW);
    
    main_checkbox = glui_main->add_checkbox_to_panel( panel1, "Interval Mode", &show_interval, 0, control_show );
    
    //glui_main->add_column_to_panel(panel1, false);
    
    main_panel = glui_main->add_panel_to_panel( panel1, "" );
    
    /***** Control for object params *****/
    spinner  = glui_main->add_spinner_to_panel( main_panel, "Hour:", GLUI_SPINNER_INT, &horario, 2, control_cb);
    spinner->set_int_limits( 0, 23 );
    spinner->disable();
    for (i=0; i<8; i++) glui_main->add_column_to_panel(panel1, false);
    
    /**** Panel to hold Simulation Controls ****/
    sim_panel = glui_main->add_panel_to_panel( panel1, "" );
    sim_panel->disable();
    
    /****** Simulate button *****/
    simula = glui_main->add_button_to_panel( sim_panel, "Change Constraints", 5, control_cb );
    
    glui_main->add_column_to_panel(panel1, false);
    
    /**** Panel to hold Simulation Controls ****/
    anim_panel = glui_main->add_panel_to_panel( panel1, "" );
    //anim_panel->disable();
    
    /****** Animate button *****/
    anima = glui_main->add_button_to_panel( anim_panel, "Animation", 4, control_cb );
    
    for (i=0; i<3; i++) glui_main->add_column_to_panel(panel1, false);
    
    GLUI_Panel *circuit_panel_main = glui_main->add_panel_to_panel( panel1, "" );
    main_circuit_list = glui_main->add_listbox_to_panel ( circuit_panel_main, "Voltage Level:", &current_circuit, 6, control_cb );
    main_circuit_list->add_item( 1, "138 KV");
    main_circuit_list->add_item( 2, " 69 KV");
    main_circuit_list->add_item( 3, " 11 KV");
    
    for (i=0; i<2; i++) glui_main->add_column_to_panel(panel1, false);
    
    /****** A 'quit' button *****/
    glui_main->add_statictext_to_panel(panel1, "");
    glui_main->add_statictext_to_panel(panel1, "");
    quit = glui_main->add_button_to_panel( panel1, "Quit", 0,(GLUI_Update_CB)exit );
    quit->set_alignment(GLUI_ALIGN_RIGHT);
    
    glui_main->sync_live();
    
    GLUI_Master.auto_set_viewport();
    
    GLUI_Master.sync_live_all();
    
    /* Stays in a loop waiting for events */
    glutMainLoop();
    
    return 0;   /* ANSI C requires the main function to return a int */
}
