////////////////////////////////////////////////////////////////////////////
//            Arquivo Cabeçalho para "tese.c"               //
////////////////////////////////////////////////////////////////////////////
#include "simulator.h"

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//====================DEFINE SECTION============================//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef CALLBACK
#define CALLBACK
#endif

#define MAXLINELENGTH 153
#define TIMEFRAME 24
#define BUFSIZE 1024

#define Abs(x) ((x)<0?-(x):(x))
#define Max(x,y) ((x)<(y)?(y):(x))

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//==================STRUCTURE SECTION===========================//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
typedef struct title TITLE;
typedef struct bus BUS;
//typedef struct branch BRANCH;
typedef struct Gbus GBUS;
typedef struct Gbranch GBRANCH;
//typedef struct bus_dsp BUS_DSP;
//typedef struct branch_dsp BRANCH_DSP;

struct title {
    char date[8];
    char originator[19];
    GLfloat MVA;
    GLint year;
    char season[1];
    char id[30];
};

struct bus {
    GLint number;
    char name[12];
    GLint load_flow_area;
    GLint loss_zone;
    GLint type;
    GLfloat voltage;
    GLfloat angle;
    GLfloat load_MW;
    GLfloat load_MVAR;
    GLfloat gen_MW;
    GLfloat gen_MVAR;
    GLfloat base_KV;
    GLfloat des_volts;
    GLfloat max_voltage;
    GLfloat min_voltage;
    GLfloat conductance;
    GLfloat susceptance;
    GLint remote;
    GLint left;
    GLint right;
    GLint branches;
    GLint buses[BUS_NUM];
};

//struct branch {
//    GLint tap_bus;
//    GLint z_bus;
//    GLint load_flow_area;
//    GLint loss_zone;
//    GLint circuit;
//    GLint type;
//    GLfloat resistance;
//    GLfloat reactance;
//    GLfloat charging;
//    GLint MVA_1;
//    GLint MVA_2;
//    GLint MVA_3;
//    GLint control_bus;
//    GLint side;
//    GLfloat turns_ratio;
//    GLfloat angle;
//    GLfloat min_tap;
//    GLfloat max_tap;
//    GLfloat step;
//    GLfloat min_voltage;
//    GLfloat max_voltage;
//};

//Graphical Information for the Buses
struct Gbus {
    GLfloat xi; //X-coordinate of the Bus initial point
    GLfloat yi; //Y-coordinate of the Bus initial point
    GLfloat xf; //X-coordinate of the Bus final point
    GLfloat yf; //Y-coordinate of the Bus final point
    GLint Gen_dir; //Direction of the Generator
    GLfloat Gen_x; //X-coordinate of the Generator initial point
    GLfloat Gen_y; //Y-coordinate of the Generator initial point
    GLint Load_dir; //Direction of the Load
    GLfloat Load_x; //X-coordinate of the Load initial point
    GLfloat Load_y; //Y-coordinate of the Load initial point
    GLint Suscep_dir; //Direction of the Susceptance
    GLfloat Suscep_x; //X-coordinate of the Susceptance initial point
    GLfloat Suscep_y; //Y-coordinate of the Susceptance initial point
};

//Graphical Information for the Branches
struct Gbranch {
    GLint no_points;
    GLfloat pts_coords[20];
    GLfloat center[2];
};

//Dispatch Information for the Buses
//struct bus_dsp {
//    GLfloat pot_L[24]; // Potência de Carga
//    GLfloat pot_G[24]; // Potência de Geração
//};

//Dispatch Information for the Branches
//struct branch_dsp {
//    GLfloat max_pot;
//    GLfloat pot[24];
//    GLfloat pot_perc[24];
//};




/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//===================CONSTANTS DEFINITION========================//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
GLint windW = 891, windH = 630; /*Window size*/
GLfloat max_coord[2] = {2444.0, 1764.0}; /*Maximum Input Coordinates */
GLfloat center[2]; /* Center of Input Coordinates */

GLfloat border = 2.0;

int MainWindow, OverviewWindow, SubWindow1, SubWindow2, SubWindow3,
DetailWindow, PlotDetailWindow, SimWindow, Evolution, EvolutionSubWindow;

int horario=-1;
int timeframe = 24; 
int info=0, info1=0, info2=0, line = 0, principal = 1, animation = 0;

int detail_state = 0, sim_state = 0,  show_interval=0, evolution_state = 0;
int sim_bus, selected_branch = -1;
float sim_gen, old_gen;
int current_circuit = 1;

GLfloat demanda_hr, carregamento_hr;

GLfloat shift1, shift2, step1, step2, shift_ev, step_ev, shift_ev2; 

GLdouble wc_x, wc_y, wc_z;

GLfloat *detail_visible_coords;

GLfloat d = 6.0;

GLfloat bkg1[4] = {1.0, 1.0, 1.0, 1.0}; /* Background Color 1 */
GLfloat bkg2[4] = {0.0, 0.0, 0.0, 0.0}; /* Background Color 2 */
GLfloat branch_color[3] = {0.0, 0.0, 1.0}; /* Branch Color */
GLfloat problem_branch_color[3] = {1.0, 0.0, 0.0}; /* Problem Branch Color */
GLfloat arrow_color[3] = {0.0, 1.0, 0.0}; /* Bus Color */
GLfloat bus_color[3] = {0.0, 0.0, 1.0}; /* Bus Color */
GLfloat axes_color[3] = {0.8, 0.8, 0.8}; /* Axes Color */
GLfloat graphic_color[3] = {0.0, 0.0, 1.0}; /* Graphic Color */
GLfloat text_color[3] = {0.0, 0.0, 0.0}; /* Text Color */
GLfloat title_color[3] = {0.0, 0.5, 0.7}; /* Title Color */

int fonte1 = (int)GLUT_BITMAP_HELVETICA_10;
int fonte2 = (int)GLUT_BITMAP_HELVETICA_12;

GLint bus_num = BUS_NUM;
GLint branch_num = BRANCH_NUM;

BUS bus[BUS_NUM];
BRANCH branch[BRANCH_NUM];
GBUS Gbus[BUS_NUM];
GBRANCH Gbranch[BRANCH_NUM];
BUS_DSP bus_dsp[BUS_NUM];
BRANCH_DSP branch_dsp[BRANCH_NUM];

//Demanda Total de Carga, a cada hora
GLfloat demanda_L[TIMEFRAME] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
//Carregamento Total das Linhas, a cada hora
GLfloat carregamento[TIMEFRAME] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
//Percentagem maxima do carregamento das linhas, a cada hora
GLfloat carregamento_perc[TIMEFRAME] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
//Percentagem maxima de carregamento (individual) de uma linha, a cada hora
GLfloat max_carregamento_perc[TIMEFRAME] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};

//Matriz Unidimensional de Potência Ativa Total dos Barramentos (Pot = PGeração - Pcarga)
//e matriz B (bus_num X bus_num)
//MAT *B, *Pot_bus, *delta;

GLfloat max_demanda_L, max_carregamento, maior_max_pot;
GLfloat carregamento_overload=70.0, carregamento_secure=60.0;

TITLE titulo;

char *main_title, *detail_title;

GLfloat zf = 1.0; /* Zoom Factor */
GLfloat zf_min = 0.1, zf_max = 30.0; /* Zoom Factor Limits */
GLfloat zf_inc = 0.5; /* Zoom Factor Increment */

GLfloat transX = 0.0, transY = 0.0; /* Translation parameters */
GLfloat rot = 0.0;

/** Pointers to the windows and some of the controls we'll create **/
GLUI *glui, *glui_detail, *glui_main, *glui_sim, *glui_evolution;
GLUI_Checkbox   *main_checkbox, *checkbox;
GLUI_Spinner *sim_bus_spinner,  *sim_gen_spinner,  *spinner, *zoom, *hour_spinner_ev;
GLUI_RadioGroup *radio;
GLUI_Panel *panel1, *main_panel, *detail_panel, *sim_panel, *anim_panel,  *sim_panel_detail,*quit_panel, *painel, *painel_sim, *sim_buttons_pannel;
GLUI_Translation *detail_translation;
GLUI_Button *quit, *simula, *simula_detail, *anima;
GLUI_Listbox *main_circuit_list, *detail_circuit_list;
GLUI_StaticText *glui_branch_load_txt, *glui_branch_name_txt, *glui_tap_z_bus_txt;

//MySQL vars
MYSQL *mysql;
MYSQL_RES *res;
MYSQL_ROW row;




/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//===================FUNCTIONS PROTOTYPES========================//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#ifdef __cplusplus
extern "C" {
#endif
    extern void simulator (void);
#ifdef __cplusplus 
}
#endif

void OutputString ( float x, float y, char *string, void *font );
void OutputVerticalString ( float x, float y, float bitmapHeight, char *string, void *font );
void circunference(double r, double x, double y, int fill);
void Database_Read();
void start_data(void);
void pie_chart(GLfloat center_x, GLfloat center_y, GLfloat radius, GLfloat color_1, GLfloat color_2, GLfloat color_3, GLfloat percentage, GLint num_points);
void Plot_Generator(GLint dir, GLfloat x, GLfloat y, char *gen_MW, char *gen_MVAR);
void Plot_Bus_Generator(int i);
void Plot_Load(GLint dir, GLfloat x, GLfloat y);
void Plot_Bus_Load(int i);
void Plot_Suscep(GLint dir, GLfloat x, GLfloat y);
void Plot_Bus_Suscep(int i);
void Plot_Bus(int k);
void Plot_Bus1(int k);
void Plot_Carregamento_Arrows(void);
void Branch_Color(int branch_number);
void Plot_Branch(void);
void Plot_Detail(GLenum mode);
void Plot_Main(GLenum mode);
void Plot_Mouse_Line1(GLfloat x, GLfloat y, char *demanda);
void Plot_Mouse_Line2(GLfloat x, GLfloat y, char *carregamento, char *carregamento_pico);
void Plot_Mouse_Line_Evolution(GLfloat x);
void Plot_Axes_L(void);
void Plot_Graphic_L(void);
void Plot_Axes_Evolution(int evolubranch);
void Plot_Graphic_Evolution(int evolubranch);
void Plot_Axes_Carregamento(void);
void Plot_Graphic_Carregamento(void);
void display(void);
void display0(void);
void display1(void);
void display2(void);
void display3(void);
void reshape (int w, int h);
void reshape1 (int w, int h);
void reshape2 (int w, int h);
void reshape3 (int w, int h);
void reshape4 (int w, int h);
void init(void);
void init1(void);
void changeSize2(int w1, int h1);
void control_cb( int control );
void control_sim( int control );
void control_show (int control);
void keyboard(unsigned char key, int x, int y);
void keyboard1(unsigned char key, int x, int y);
void keyboard2(unsigned char key, int x, int y);
void keyboard3(unsigned char key, int x, int y);
static void SpecialKey(int key, int x, int y);
static void SpecialKey1(int key, int x, int y);
static void SpecialKey3(int key, int x, int y);
void processMouse(int button, int state, int x, int y);
void processMouse1(int button, int state, int x, int y); 
void processMouse2(int button, int state, int x, int y);
void processMouse3(int button, int state, int x, int y);
void processMouse_ev(int button, int state, int x, int y);
void processMotion1(int x, int y);
void processMotion2(int x, int y);
void processMotionEvolution(int x, int y);
void myGlutIdle(void);
void idle3(void);
GLfloat* GetVisibleArea(void);
int main(int argc, char** argv);
